/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.springboot.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.app.manager.module.DeployedAppInfo;
import com.ibm.ws.app.manager.module.DeployedAppInfoFactory;
import com.ibm.ws.app.manager.module.DeployedAppServices;
import com.ibm.ws.app.manager.module.internal.ModuleHandler;
import com.ibm.ws.app.manager.springboot.internal.LibIndexCache;
import com.ibm.ws.app.manager.springboot.internal.SpringBootApplicationImpl;
import com.ibm.ws.app.manager.springboot.support.ContainerInstanceFactory;
import com.ibm.ws.app.manager.springboot.support.SpringBootSupport;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.application.handler.ApplicationInformation;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={DeployedAppInfoFactory.class}, property={"service.vendor=IBM", "type=spring"})
public class SpringBootApplicationFactory
implements DeployedAppInfoFactory {
    private final AtomicInteger nextAppID = new AtomicInteger(0);
    private final BundleContext bundleContext;
    protected final DeployedAppServices deployedAppServices;
    private final LibIndexCache libIndexCache;
    private final ModuleHandler springModuleHandler;
    private final List<Container> springBootSupportContainers = new CopyOnWriteArrayList<Container>();
    private final Map<ServiceReference<SpringBootSupport>, List<Container>> springBootSupports = new ConcurrentHashMap<ServiceReference<SpringBootSupport>, List<Container>>();
    private final Map<Class<?>, ContainerInstanceFactory<?>> containerInstanceFactories = new ConcurrentHashMap();
    static final long serialVersionUID = -3980660485082907106L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Activate
    public SpringBootApplicationFactory(BundleContext bundleContext, @Reference DeployedAppServices deployedAppServices, @Reference LibIndexCache libIndexCache, @Reference(target="(type=spring)") ModuleHandler springModuleHandler) {
        this.bundleContext = bundleContext;
        this.deployedAppServices = deployedAppServices;
        this.libIndexCache = libIndexCache;
        this.springModuleHandler = springModuleHandler;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeSpringBootSupport")
    protected void addSpringBootSupport(SpringBootSupport support, ServiceReference<SpringBootSupport> ref) {
        List<Container> containers = this.getSpringBootSupportContainers(support, ref);
        this.springBootSupports.put(ref, containers);
        this.springBootSupportContainers.addAll(containers);
    }

    protected void removeSpringBootSupport(SpringBootSupport support, ServiceReference<SpringBootSupport> ref) {
        List<Container> containers = this.springBootSupports.remove(ref);
        if (containers != null) {
            this.springBootSupportContainers.removeAll(containers);
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeContainerInstanceFactory")
    protected void addContainerInstanceFactory(ContainerInstanceFactory factory) {
        this.containerInstanceFactories.put(factory.getType(), factory);
    }

    protected void removeContainerInstanceFactory(ContainerInstanceFactory factory) {
        this.containerInstanceFactories.remove(factory.getType());
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public DeployedAppInfo createDeployedAppInfo(ApplicationInformation<DeployedAppInfo> applicationInformation) throws UnableToAdaptException {
        SpringBootApplicationImpl app = new SpringBootApplicationImpl(applicationInformation, this, this.deployedAppServices, this.nextAppID.getAndIncrement());
        applicationInformation.setHandlerInfo((Object)app);
        return app;
    }

    private List<Container> getSpringBootSupportContainers(SpringBootSupport support, ServiceReference<SpringBootSupport> ref) {
        Bundle supportBundle = ref.getBundle();
        Container bundleContainer = this.getContainerForBundle(supportBundle);
        ArrayList<Container> supportContainers = new ArrayList<Container>();
        for (String path : support.getJarPaths()) {
            Entry entry = bundleContainer.getEntry(path);
            try {
                Container pathContainer = (Container)entry.adapt(Container.class);
                supportContainers.add(pathContainer);
            }
            catch (UnableToAdaptException unableToAdaptException) {
                FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.app.manager.springboot.internal.SpringBootApplicationFactory", (String)"114", (Object)this, (Object[])new Object[]{support, ref});
            }
        }
        return Collections.unmodifiableList(supportContainers);
    }

    private Container getContainerForBundle(Bundle bundle) {
        File cacheDir = SpringBootApplicationFactory.ensureDataFileExists(bundle, "cache");
        File cacheDirAdapt = SpringBootApplicationFactory.ensureDataFileExists(bundle, "cacheAdapt");
        File cacheDirOverlay = SpringBootApplicationFactory.ensureDataFileExists(bundle, "cacheOverlay");
        ArtifactContainer artifactContainer = this.deployedAppServices.getArtifactFactory().getContainer(cacheDir, (Object)bundle);
        Container wabContainer = this.deployedAppServices.getModuleFactory().getContainer(cacheDirAdapt, cacheDirOverlay, artifactContainer);
        return wabContainer;
    }

    List<Container> getSpringBootSupport() {
        return this.springBootSupportContainers;
    }

    File getDataDir(String path) throws IOException {
        return SpringBootApplicationFactory.ensureDataFileExists(this.bundleContext.getBundle(), path);
    }

    static File ensureDataFileExists(Bundle bundle, String path) {
        File dataFile = bundle.getDataFile(path);
        if (!FileUtils.ensureDirExists((File)dataFile)) {
            throw new RuntimeException("Failed to create data directory: " + dataFile.getAbsolutePath());
        }
        return dataFile;
    }

    LibIndexCache getLibIndexCache() {
        return this.libIndexCache;
    }

    ModuleHandler getModuleHandler() {
        return this.springModuleHandler;
    }

    public <T> ContainerInstanceFactory<T> getContainerInstanceFactory(Class<T> type) {
        return this.containerInstanceFactories.get(type);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(SpringBootApplicationFactory.class);
    }
}

