/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.ssl.internal;

import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.channelfw.ChannelFactoryData;
import com.ibm.websphere.channelfw.OutboundChannelDefinition;
import com.ibm.ws.channel.ssl.internal.SSLChannel;
import com.ibm.wsspi.channelfw.Channel;
import com.ibm.wsspi.channelfw.SSLChannelFactory;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import com.ibm.wsspi.tcpchannel.TCPConnectionContext;
import java.util.HashMap;
import java.util.Map;

public class SSLChannelFactoryImpl
implements SSLChannelFactory {
    private Map<String, Channel> existingChannels = new HashMap<String, Channel>();
    private Map<Object, Object> commonProperties = null;

    public Class<?> getApplicationInterface() {
        return TCPConnectionContext.class;
    }

    public final Class<?>[] getDeviceInterface() {
        return new Class[]{TCPConnectionContext.class};
    }

    public void init(ChannelFactoryData data) {
    }

    public void destroy() {
    }

    public synchronized Channel findOrCreateChannel(ChannelData channelData) throws ChannelException {
        String channelName = channelData.getName();
        Object rc = this.existingChannels.get(channelName);
        if (null == rc) {
            rc = new SSLChannel(channelData, this);
            this.existingChannels.put(channelName, (Channel)rc);
        }
        return rc;
    }

    public synchronized void removeChannel(String channelName) {
        this.existingChannels.remove(channelName);
    }

    public Map<Object, Object> getProperties() {
        return this.commonProperties;
    }

    public void updateProperties(Map<Object, Object> props) {
        this.commonProperties = props;
    }

    public OutboundChannelDefinition getOutboundChannelDefinition(Map<Object, Object> props) {
        return new SSLOutboundDefinition(props);
    }

    private static class SSLOutboundDefinition
    implements OutboundChannelDefinition {
        private static final long serialVersionUID = 1555556446109438220L;
        private Map<Object, Object> config = new HashMap<Object, Object>();

        protected SSLOutboundDefinition(Map<Object, Object> props) {
            String repertoire = (String)props.get("alias");
            if (null != repertoire) {
                this.config.put("alias", repertoire);
            }
        }

        public Map<Object, Object> getOutboundChannelProperties() {
            return this.config;
        }

        public Class<?> getOutboundFactory() {
            return SSLChannelFactoryImpl.class;
        }

        public Map<Object, Object> getOutboundFactoryProperties() {
            return null;
        }
    }
}

