/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.quickstart.internal;

import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import java.util.Arrays;
import java.util.HashMap;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class Password {
    protected final SerializableProtectedString pwd;
    private final boolean isEmpty;
    static final long serialVersionUID = 6248194019407010407L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public Password(SerializableProtectedString pwd) {
        this.pwd = pwd;
        this.isEmpty = new String(pwd.getChars()).trim().isEmpty();
    }

    public abstract boolean checkPassword(String var1);

    public final boolean isEmpty() {
        return this.isEmpty;
    }

    public static Password create(SerializableProtectedString pwd) {
        String pwdStr = new String(pwd.getChars());
        if (PasswordUtil.getCryptoAlgorithm((String)pwdStr) == null) {
            return new PlainTextPassword(pwd);
        }
        if (PasswordUtil.isHashed((String)pwdStr)) {
            return new HashedPassword(pwd);
        }
        return new ReversablePassword(pwd);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(Password.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class HashedPassword
    extends Password {
        private String hashAlgorithm;
        static final long serialVersionUID = 536773197937616459L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public HashedPassword(SerializableProtectedString pwd) {
            super(pwd);
            String pwdStr = new String(pwd.getChars());
            this.hashAlgorithm = PasswordUtil.getCryptoAlgorithm((String)pwdStr);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean checkPassword(@Sensitive String password) {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("hash.encoded", new String(this.pwd.getChars()));
            String inPass = null;
            try {
                inPass = PasswordUtil.encode((String)password, (String)this.hashAlgorithm, props);
                return Arrays.equals(this.pwd.getChars(), inPass.toCharArray());
            }
            catch (Exception exception) {
                void e;
                Object[] objectArray = new Object[1];
                objectArray[0] = "<sensitive java.lang.String>";
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.quickstart.internal.Password$HashedPassword", (String)"122", (Object)this, (Object[])objectArray);
                throw new IllegalArgumentException("password encoding failure : " + e.getMessage());
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(HashedPassword.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class ReversablePassword
    extends Password {
        static final long serialVersionUID = 3623932146768407888L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ReversablePassword(SerializableProtectedString pwd) {
            super(pwd);
        }

        @Override
        public boolean checkPassword(@Sensitive String password) {
            if (this.pwd != null) {
                return Arrays.equals(ReversablePassword.decodePassword(this.pwd).getChars(), password.toCharArray());
            }
            return password == null;
        }

        private static SerializableProtectedString decodePassword(SerializableProtectedString pw) {
            if (pw != null) {
                String password = new String(pw.getChars());
                password = PasswordUtil.passwordDecode((String)password.trim());
                char[] passswordArray = new char[password.length()];
                password.getChars(0, password.length(), passswordArray, 0);
                return new SerializableProtectedString(passswordArray);
            }
            return null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ReversablePassword.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class PlainTextPassword
    extends Password {
        static final long serialVersionUID = 5404564159934664171L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public PlainTextPassword(SerializableProtectedString pwd) {
            super(pwd);
        }

        @Override
        public boolean checkPassword(@Sensitive String password) {
            if (this.pwd != null) {
                return Arrays.equals(this.pwd.getChars(), password.toCharArray());
            }
            return password == null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(PlainTextPassword.class);
        }
    }
}

