/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jndi.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jndi.WSName;
import com.ibm.ws.jndi.WSNameUtil;
import com.ibm.ws.jndi.internal.AutoBindNode;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NotContextException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public final class ContextNode {
    final ContextNode root;
    final ContextNode parent;
    final WSName fullName;
    final boolean autoDelete;
    final ConcurrentMap<String, Object> children = new ConcurrentHashMap<String, Object>(1){
        static final long serialVersionUID = 6494670380482911124L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public Object remove(Object key) {
            Object result = super.remove(key);
            if (ContextNode.this.autoDelete && this.isEmpty()) {
                ContextNode.this.autoDelete();
            }
            return result;
        }

        @Override
        public boolean remove(Object key, Object value) {
            boolean result = super.remove(key, value);
            if (ContextNode.this.autoDelete && this.isEmpty()) {
                ContextNode.this.autoDelete();
            }
            return result;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class);
        }
    };
    static final long serialVersionUID = -6490037230828887880L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ContextNode() {
        this.root = this;
        this.parent = null;
        this.fullName = new WSName();
        this.autoDelete = false;
    }

    private void autoDelete() {
        if (this.autoDelete && this.children.isEmpty()) {
            try {
                String key = this.fullName.getLast();
                this.parent.children.remove(key, this);
            }
            catch (InvalidNameException invalidNameException) {
                FFDCFilter.processException((Throwable)invalidNameException, (String)"com.ibm.ws.jndi.internal.ContextNode", (String)"83", (Object)this, (Object[])new Object[0]);
            }
        }
    }

    private ContextNode(ContextNode parent, String name, boolean autoDelete) throws InvalidNameException {
        this.root = parent.root;
        this.parent = parent;
        this.fullName = parent.fullName.plus(name);
        this.autoDelete = autoDelete;
    }

    private ContextNode(ContextNode parent, String name) throws InvalidNameException {
        this(parent, name, false);
    }

    @FFDCIgnore(value={ClassCastException.class, NullPointerException.class})
    private ContextNode getTargetNode(WSName subname) throws InvalidNameException, NotContextException, NameNotFoundException {
        int i;
        ContextNode target = this;
        try {
            for (i = 0; i < subname.size() - 1; ++i) {
                target = (ContextNode)target.children.get(subname.get(i));
            }
            if (target == null) {
                throw new NullPointerException();
            }
        }
        catch (ClassCastException e) {
            throw new NotContextException("Intermediate context name is bound to something other than a context: " + this.fullName.plus((Name)subname.getPrefix(i + 1)));
        }
        catch (NullPointerException e) {
            throw new NameNotFoundException("Intermediate context does not exist: " + this.fullName.plus((Name)subname.getPrefix(i + 1)));
        }
        return target;
    }

    ContextNode createSubcontext(WSName subname) throws InvalidNameException, NameNotFoundException, NameAlreadyBoundException, NotContextException {
        ContextNode branch;
        ContextNode target = this.getTargetNode(subname);
        String branchName = subname.getLast();
        if (target.children.putIfAbsent(branchName, branch = new ContextNode(target, branchName)) != null) {
            throw new NameAlreadyBoundException("" + this.fullName.plus((Name)subname));
        }
        return branch;
    }

    void bind(WSName relativeName, Object o) throws InvalidNameException, NameAlreadyBoundException, NameNotFoundException, NotContextException {
        WSName subname = WSNameUtil.normalize(relativeName);
        ContextNode target = this.getTargetNode(subname);
        String lastName = subname.getLast();
        target.bindImmediate(lastName, o);
    }

    private void bindImmediate(String lastName, Object obj) throws NameAlreadyBoundException, InvalidNameException {
        if (this.children.putIfAbsent(lastName, obj) != null) {
            throw new NameAlreadyBoundException("" + this.fullName.plus(lastName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={ClassCastException.class})
    void autoBind(WSName subname, Object obj) throws InvalidNameException, NotContextException, NameAlreadyBoundException {
        int i;
        ContextNode target = this;
        ContextNode parent = this;
        try {
            for (i = 0; i < subname.size() - 1; ++i) {
                Object existingEntry;
                String elem = subname.get(i);
                target = (ContextNode)target.children.get(elem);
                if (target == null && (existingEntry = parent.children.putIfAbsent(elem, target = new ContextNode(parent, elem, true))) != null) {
                    target = (ContextNode)existingEntry;
                }
                parent = target;
            }
        }
        catch (ClassCastException e) {
            throw new NotContextException("" + this.fullName.plus((Name)subname.getPrefix(i + 1)));
        }
        boolean replaced = false;
        String lastName = subname.getLast();
        AutoBindNode abNode = new AutoBindNode(obj);
        while (!replaced) {
            Object oldObj = target.children.putIfAbsent(lastName, abNode);
            if (oldObj != null) {
                if (oldObj instanceof AutoBindNode) {
                    AutoBindNode autoBindNode = abNode = (AutoBindNode)oldObj;
                    synchronized (autoBindNode) {
                        abNode.addLastEntry(obj);
                        replaced = target.children.replace(lastName, oldObj, abNode);
                        continue;
                    }
                }
                throw new NameAlreadyBoundException("" + this.fullName.plus(lastName));
            }
            replaced = true;
        }
    }

    Object lookup(WSName subname) throws InvalidNameException, NotContextException, NameNotFoundException {
        if (subname.isEmpty()) {
            return this;
        }
        Object result = this.getTargetNode((WSName)subname).children.get(subname.getLast());
        if (result instanceof AutoBindNode) {
            AutoBindNode abNode = (AutoBindNode)result;
            result = abNode.getLastEntry();
        }
        if (result == null) {
            throw new NameNotFoundException(subname.toString());
        }
        return result;
    }

    Object rebind(WSName relativeName, Object o) throws InvalidNameException, NameNotFoundException, NotContextException {
        WSName subname = WSNameUtil.normalize(relativeName);
        ContextNode target = this.getTargetNode(subname);
        String lastName = subname.getLast();
        return target.children.put(lastName, o);
    }

    @FFDCIgnore(value={ClassCastException.class})
    ContextNode destroySubcontext(WSName subname) throws InvalidNameException, NameNotFoundException, ContextNotEmptyException, NotContextException {
        ContextNode target = this.getTargetNode(subname);
        String lastName = subname.getLast();
        Object entry = target.children.get(lastName);
        if (entry == null) {
            return null;
        }
        try {
            ContextNode branch = (ContextNode)entry;
            if (!branch.children.isEmpty()) {
                throw new ContextNotEmptyException("" + this.fullName.plus((Name)subname));
            }
            return target.children.remove(lastName, branch) ? branch : null;
        }
        catch (ClassCastException e) {
            throw new NotContextException("" + this.fullName.plus((Name)subname));
        }
    }

    Object unbind(WSName subname) throws InvalidNameException, NameNotFoundException, NotContextException {
        ContextNode target = this.getTargetNode(subname);
        String lastName = subname.getLast();
        return target.children.remove(lastName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={NamingException.class})
    void ensureNotBound(WSName subname, Object obj) {
        block6: {
            try {
                AutoBindNode abNode;
                Object currObj;
                ContextNode target = this.getTargetNode(subname);
                String lastName = subname.getLast();
                if (target.children.remove(lastName, obj) || !((currObj = target.children.get(lastName)) instanceof AutoBindNode)) break block6;
                AutoBindNode autoBindNode = abNode = (AutoBindNode)currObj;
                synchronized (autoBindNode) {
                    boolean remove = abNode.removeEntry(obj);
                    if (remove) {
                        target.children.remove(lastName, abNode);
                    }
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }

    Map<String, Object> getChildren(WSName subname) throws InvalidNameException, NotContextException, NameNotFoundException {
        Object o = this.lookup(subname);
        if (!(o instanceof ContextNode)) {
            throw new NotContextException("" + this.fullName.plus((Name)subname));
        }
        return Collections.unmodifiableMap(((ContextNode)o).children);
    }

    public String toString() {
        return "" + this.fullName;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ContextNode.class);
    }
}

