/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit.utils;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.servlet.session.UnauthorizedSessionRequestException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.security.audit.AuditService;
import com.ibm.wsspi.security.registry.RegistryHelper;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"}, immediate=true)
public class AuditUtils {
    private static final String AUDIT_SERVICE = "auditService";
    private static AtomicServiceReference<AuditService> auditServiceRef;
    static final long serialVersionUID = 7691934035813669651L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Reference(name="auditService", service=AuditService.class)
    protected void setAuditService(ServiceReference<AuditService> ref) {
        auditServiceRef.setReference(ref);
    }

    protected void unsetAuditService(ServiceReference<AuditService> ref) {
        auditServiceRef.unsetReference(ref);
    }

    @Activate
    protected void activate(ComponentContext cc) {
        auditServiceRef.activate(cc);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        auditServiceRef.deactivate(cc);
    }

    /*
     * WARNING - void declaration
     */
    public static String getSessionID(HttpServletRequest req) {
        String sessionID = null;
        final HttpServletRequest f_req = req;
        try {
            sessionID = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){
                static final long serialVersionUID = 9033550606233591453L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public String run() throws Exception {
                    HttpSession session = f_req.getSession();
                    if (session != null) {
                        return session.getId();
                    }
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.audit.utils.AuditUtils", (String)"93", null, (Object[])new Object[]{req});
            if (e.getException() instanceof UnauthorizedSessionRequestException) {
                sessionID = !req.isRequestedSessionIdFromCookie() ? AccessController.doPrivileged(new PrivilegedAction<String>(){
                    static final long serialVersionUID = -1086129891296371676L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public String run() {
                        return f_req.getSession().getId();
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(2.class);
                    }
                }) : AccessController.doPrivileged(new PrivilegedAction<String>(){
                    static final long serialVersionUID = -684445981737602855L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public String run() {
                        return f_req.getRequestedSessionId();
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(3.class);
                    }
                });
            }
        }
        catch (UnauthorizedSessionRequestException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.utils.AuditUtils", (String)"112", null, (Object[])new Object[]{req});
            try {
                sessionID = !req.isRequestedSessionIdFromCookie() ? AccessController.doPrivileged(new PrivilegedAction<String>(){
                    static final long serialVersionUID = 4020090653849530916L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public String run() {
                        return f_req.getSession().getId();
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(4.class);
                    }
                }) : AccessController.doPrivileged(new PrivilegedAction<String>(){
                    static final long serialVersionUID = 1913369244595379017L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public String run() {
                        return f_req.getRequestedSessionId();
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(5.class);
                    }
                });
            }
            catch (NullPointerException nullPointerException) {
                FFDCFilter.processException((Throwable)nullPointerException, (String)"com.ibm.ws.security.audit.utils.AuditUtils", (String)"130", null, (Object[])new Object[]{req});
                sessionID = "UnauthorizedSessionRequest";
            }
            catch (UnauthorizedSessionRequestException ee) {
                FFDCFilter.processException((Throwable)ee, (String)"com.ibm.ws.security.audit.utils.AuditUtils", (String)"132", null, (Object[])new Object[]{req});
                sessionID = "UnauthorizedSessionRequest";
            }
        }
        return sessionID;
    }

    public static String getRequestScheme(HttpServletRequest req) {
        String scheme = req.getScheme() != null ? req.getScheme().toUpperCase() : "HTTP";
        return scheme;
    }

    public static String getServerID() {
        return ((AuditService)auditServiceRef.getService()).getServerID();
    }

    public static String getRequestMethod(HttpServletRequest req) {
        String method = req.getMethod() != null ? req.getMethod().toUpperCase() : "GET";
        return method;
    }

    public static String hidePassword(@Sensitive String s) {
        String ss;
        block4: {
            int indexUpperCase;
            block3: {
                if (s.indexOf("password") == -1 && s.indexOf("PASSWORD") == -1) {
                    return s;
                }
                ss = "";
                int indexLowerCase = s.indexOf("password");
                indexUpperCase = s.indexOf("PASSWORD");
                if (indexLowerCase == -1) break block3;
                ss = s.substring(0, indexLowerCase + 9);
                for (int index = indexLowerCase + 10; index < s.length(); ++index) {
                    ss = ss.concat("*");
                }
                break block4;
            }
            if (indexUpperCase == -1) break block4;
            ss = s.substring(0, indexUpperCase + 9);
            for (int index = indexUpperCase + 10; index < s.length(); ++index) {
                ss = ss.concat("*");
            }
        }
        return ss;
    }

    public static String getJ2EEComponentName() {
        ComponentMetaData wcmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (wcmd != null) {
            J2EEName j2eename = wcmd.getJ2EEName();
            return j2eename.getComponent();
        }
        return null;
    }

    public static String getRealmName() {
        String realm = "defaultRealm";
        try {
            String r;
            UserRegistry ur = RegistryHelper.getUserRegistry(null);
            if (ur != null && (r = ur.getRealm()) != null) {
                realm = r;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.audit.utils.AuditUtils", (String)"234", null, (Object[])new Object[0]);
        }
        return realm;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(AuditUtils.class);
        auditServiceRef = new AtomicServiceReference(AUDIT_SERVICE);
    }
}

