/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit.logutils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.audit.logutils.FileLogSet;
import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class FileLogUtils {
    private static final TraceComponent tc = Tr.register(FileLogUtils.class);
    public static final SimpleDateFormat FILE_DATE = new SimpleDateFormat("_yy.MM.dd_HH.mm.ss");
    static final long serialVersionUID = 7289882332059611447L;

    static String[] safelyFindFiles(final File directory, final Pattern p) {
        String[] rc = null;
        try {
            rc = AccessController.doPrivileged(new PrivilegedExceptionAction<String[]>(){
                static final long serialVersionUID = 8354486802649178115L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public String[] run() throws Exception {
                    return directory.list(new RegexFilenameFilter(p));
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.audit.logutils.FileLogUtils", (String)"74", null, (Object[])new Object[]{directory, p});
        }
        return rc;
    }

    /*
     * WARNING - void declaration
     */
    static File validateDirectory(final File directory) {
        File newDirectory = null;
        try {
            newDirectory = AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){
                static final long serialVersionUID = 2299430566614264306L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public File run() throws Exception {
                    boolean ok = true;
                    if (!directory.exists()) {
                        boolean bl = ok = directory.mkdirs() || directory.exists();
                    }
                    if (!ok) {
                        Tr.error((TraceComponent)tc, (String)"UNABLE_TO_DELETE_RESOURCE_NOEX", (Object[])new Object[]{directory.getAbsolutePath()});
                        return null;
                    }
                    return directory;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.audit.logutils.FileLogUtils", (String)"108", null, (Object[])new Object[]{directory});
            Tr.error((TraceComponent)tc, (String)"UNABLE_TO_DELETE_RESOURCE", (Object[])new Object[]{directory.getAbsolutePath(), e});
        }
        return newDirectory;
    }

    /*
     * WARNING - void declaration
     */
    static File createNewFile(final FileLogSet fileLogSet) {
        File directory = fileLogSet.getDirectory();
        String fileName = fileLogSet.getFileName();
        String fileExtension = fileLogSet.getFileExtension();
        File f = null;
        try {
            f = AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){
                static final long serialVersionUID = 205041233877515827L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public File run() throws Exception {
                    return fileLogSet.createNewFile();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(3.class);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.audit.logutils.FileLogUtils", (String)"135", null, (Object[])new Object[]{fileLogSet});
            File exf = new File(directory, fileName + fileExtension);
            Tr.error((TraceComponent)tc, (String)"UNABLE_TO_DELETE_RESOURCE", (Object[])new Object[]{exf.getAbsolutePath(), e});
        }
        return f;
    }

    static Pattern compileLogFileRegex(String baseName, String extension) {
        StringBuilder builder = new StringBuilder();
        builder.append(Pattern.quote(baseName));
        builder.append("(_\\d\\d\\.\\d\\d\\.\\d\\d_\\d\\d\\.\\d\\d\\.\\d\\d)");
        builder.append("(?:\\.(\\d+))");
        builder.append(Pattern.quote(extension));
        return Pattern.compile(builder.toString());
    }

    static final void deleteFile(File directory, String name) {
        FileLogUtils.deleteFile(new File(directory, name));
    }

    public static boolean deleteFile(final File f) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            static final long serialVersionUID = -7820539794264639497L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            /*
             * WARNING - void declaration
             */
            @Override
            public Boolean run() {
                try {
                    Files.delete(f.toPath());
                    return true;
                }
                catch (NoSuchFileException noSuchFileException) {
                    void nsfe;
                    FFDCFilter.processException((Throwable)noSuchFileException, (String)"com.ibm.ws.security.audit.logutils.FileLogUtils$4", (String)"192", (Object)this, (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)"no such file", (Object[])new Object[0]);
                    Tr.error((TraceComponent)tc, (String)"UNABLE_TO_DELETE_RESOURCE", (Object[])new Object[]{f, nsfe});
                    return false;
                }
                catch (DirectoryNotEmptyException nsfe) {
                    void dnee;
                    FFDCFilter.processException((Throwable)nsfe, (String)"com.ibm.ws.security.audit.logutils.FileLogUtils$4", (String)"197", (Object)this, (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)"dir not empty", (Object[])new Object[0]);
                    Tr.error((TraceComponent)tc, (String)"UNABLE_TO_DELETE_RESOURCE", (Object[])new Object[]{f, dnee});
                    return false;
                }
                catch (IOException dnee) {
                    void ioe;
                    FFDCFilter.processException((Throwable)dnee, (String)"com.ibm.ws.security.audit.logutils.FileLogUtils$4", (String)"201", (Object)this, (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)"dir not empty", (Object[])new Object[0]);
                    Tr.error((TraceComponent)tc, (String)"UNABLE_TO_DELETE_RESOURCE", (Object[])new Object[]{f, ioe});
                    return false;
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(4.class);
            }
        });
    }

    public static boolean tryToClose(Closeable c) {
        if (c != null) {
            try {
                c.close();
                return true;
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.audit.logutils.FileLogUtils", (String)"224", null, (Object[])new Object[]{c});
            }
        }
        return false;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static class RegexFilenameFilter
    implements FilenameFilter {
        final Pattern p;
        static final long serialVersionUID = 2122372791260300991L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        RegexFilenameFilter(Pattern p) {
            this.p = p;
        }

        @Override
        public boolean accept(File dir, String name) {
            Matcher m = this.p.matcher(name);
            return m.matches();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(RegexFilenameFilter.class);
        }
    }
}

