/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.javaee.common.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.javaee.dd.common.wsclient.Addressing;
import com.ibm.ws.javaee.dd.common.wsclient.RespectBinding;
import com.ibm.ws.javaee.dd.ws.PortComponent;
import com.ibm.ws.javaee.dd.ws.WebserviceDescription;
import com.ibm.ws.jaxws.metadata.AddressingFeatureInfo;
import com.ibm.ws.jaxws.metadata.EndpointInfo;
import com.ibm.ws.jaxws.metadata.MTOMFeatureInfo;
import com.ibm.ws.jaxws.metadata.RespectBindingFeatureInfo;
import com.ibm.ws.jaxws.metadata.builder.AbstractEndpointInfoConfigurator;
import com.ibm.ws.jaxws.metadata.builder.EndpointInfoBuilderContext;
import com.ibm.ws.jaxws.metadata.builder.EndpointInfoConfigurator;
import com.ibm.ws.jaxws.utils.JaxWsUtils;
import com.ibm.ws.jaxws.utils.StringUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webservices.javaee.common.internal.JaxWsDDHelper;
import com.ibm.ws.webservices.javaee.common.internal.JaxWsHandlerInfoMergingHelper;
import com.ibm.wsspi.adaptable.module.Adaptable;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.anno.info.ClassInfo;
import javax.xml.namespace.QName;
import javax.xml.ws.soap.AddressingFeature;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={EndpointInfoConfigurator.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=false, property={"service.vendor=IBM"})
public class WebservicesXMLEndpointInfoConfigurator
extends AbstractEndpointInfoConfigurator {
    private static final TraceComponent tc = Tr.register(WebservicesXMLEndpointInfoConfigurator.class);
    private static final String SERVICE_LINK = "webservicesXMLEndpointInfoConfigurator.merge.service.link";
    private static final String PORT_COMPONENT = "webservicesXMLEndpointInfoConfigurator.merge.port.component";
    static final long serialVersionUID = 5553920154481010360L;

    public WebservicesXMLEndpointInfoConfigurator() {
        super(EndpointInfoConfigurator.Phase.PROCESS_DESCRIPTOR);
    }

    public void prepare(EndpointInfoBuilderContext context, EndpointInfo endpointInfo) throws UnableToAdaptException {
        String serviceLink;
        if (!JaxWsDDHelper.isWebServicesXMLExisting((Adaptable)context.getContainer())) {
            return;
        }
        PortComponent portCmpt = null;
        String beanName = endpointInfo.getBeanName();
        String string = serviceLink = endpointInfo.isConfiguredInWebXml() ? endpointInfo.getServletName() : endpointInfo.getImplBeanClassName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Try to get the Port Component by servlet-link=" + serviceLink), (Object[])new Object[0]);
        }
        if (null == (portCmpt = JaxWsDDHelper.getPortComponentByServletLink(serviceLink, (Adaptable)context.getContainer()))) {
            if (null == beanName) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Could not get PortComponent either by servlet name or bean name.", (Object[])new Object[0]);
                }
                return;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Try to get the Port Component by ejb-link=" + beanName), (Object[])new Object[0]);
            }
            if (null == (portCmpt = JaxWsDDHelper.getPortComponentByEJBLink(beanName, (Adaptable)context.getContainer()))) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Could not get PortComponent either by servlet name or bean name.", (Object[])new Object[0]);
                }
                return;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Successfully get the Port Component by ejb-link=" + beanName), (Object[])new Object[0]);
            }
            serviceLink = beanName;
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Successfully get the Port Component by servlet-link=" + serviceLink), (Object[])new Object[0]);
        }
        context.addContextEnv(SERVICE_LINK, (Object)serviceLink);
        context.addContextEnv(PORT_COMPONENT, (Object)portCmpt);
        String seiClassName = portCmpt.getServiceEndpointInterface();
        if (!StringUtils.isEmpty((String)seiClassName)) {
            if (!StringUtils.isEmpty((String)endpointInfo.getServiceEndpointInterface())) {
                if (!seiClassName.equals(endpointInfo.getServiceEndpointInterface()) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("The <service-endpoint-interface> value: " + seiClassName + " is not equal to @WebService.endpointInterface: " + endpointInfo.getServiceEndpointInterface()), (Object[])new Object[0]);
                }
            } else if (!JaxWsUtils.isProvider((ClassInfo)context.getInfoStore().getDelayableClassInfo(endpointInfo.getImplBeanClassName()))) {
                endpointInfo.setServiceEndpointInterface(seiClassName);
            }
        }
    }

    public void config(EndpointInfoBuilderContext context, EndpointInfo endpointInfo) throws UnableToAdaptException {
        QName portQName;
        QName wsdlport;
        QName wsdlservice;
        if (!JaxWsDDHelper.isWebServicesXMLExisting((Adaptable)context.getContainer())) {
            return;
        }
        String serviceLink = (String)context.getContextEnv(SERVICE_LINK);
        if (serviceLink == null) {
            return;
        }
        PortComponent portCmpt = (PortComponent)context.getContextEnv(PORT_COMPONENT);
        String pcname = portCmpt.getPortComponentName();
        if (pcname != null) {
            endpointInfo.setPortComponentName(pcname);
        } else {
            Tr.warning((TraceComponent)tc, (String)"warn.dd.invalid.portcomponentname", (Object[])new Object[]{serviceLink});
        }
        String wsdlfile = serviceLink.equals(endpointInfo.getBeanName()) ? this.getWsdlFile(JaxWsDDHelper.getWebserviceDescriptionByEJBLink(serviceLink, (Adaptable)context.getContainer())) : this.getWsdlFile(JaxWsDDHelper.getWebserviceDescriptionByServletLink(serviceLink, (Adaptable)context.getContainer()));
        if (wsdlfile != null) {
            endpointInfo.setWsdlLocation(wsdlfile);
        }
        if ((wsdlservice = portCmpt.getWSDLService()) != null) {
            endpointInfo.setWsdlService(wsdlservice);
        }
        endpointInfo.setTargetNamespaceURL(endpointInfo.getWsdlService().getNamespaceURI());
        String seiClassName = endpointInfo.getServiceEndpointInterface();
        if (seiClassName == null || StringUtils.isEmpty((String)seiClassName)) {
            endpointInfo.setInterfaceTragetNameSpaceURL(endpointInfo.getWsdlService().getNamespaceURI());
        }
        if ((wsdlport = portCmpt.getWSDLPort()) != null) {
            endpointInfo.setWsdlPort(wsdlport);
        }
        if (!(portQName = endpointInfo.getWsdlPort()).getNamespaceURI().equals(endpointInfo.getTargetNamespaceURL())) {
            Tr.warning((TraceComponent)tc, (String)"warn.dd.invalid.namespace.of.wsdlport", (Object[])new Object[]{portQName.getNamespaceURI(), portQName, endpointInfo.getPortComponentName()});
            endpointInfo.setWsdlPort(new QName(endpointInfo.getTargetNamespaceURL(), portQName.getLocalPart()));
        }
        this.configMTOM(endpointInfo, portCmpt);
        this.configRespectBinding(endpointInfo, portCmpt);
        this.configAddressing(endpointInfo, portCmpt);
        String protocolBinding_wsXml = portCmpt.getProtocolBinding();
        if (protocolBinding_wsXml != null) {
            if (this.validateProtocolBindingInWebservicesXml(protocolBinding_wsXml)) {
                endpointInfo.setProtocolBinding(JaxWsUtils.getProtocolByToken((String)protocolBinding_wsXml));
            } else {
                Tr.warning((TraceComponent)tc, (String)"warn.dd.invalid.protocolbinding", (Object[])new Object[]{protocolBinding_wsXml, endpointInfo.getPortComponentName()});
            }
        }
        JaxWsHandlerInfoMergingHelper.mergeHandlerChains(portCmpt, endpointInfo);
        if (!endpointInfo.isConfiguredInWebXml()) {
            endpointInfo.clearAddresses();
            endpointInfo.addAddress("/" + endpointInfo.getWsdlService().getLocalPart());
        }
    }

    private String getWsdlFile(WebserviceDescription wsDes) {
        if (null == wsDes) {
            return null;
        }
        return wsDes.getWSDLFile();
    }

    private boolean validateProtocolBindingInWebservicesXml(String protocolBinding_wsXml) {
        return protocolBinding_wsXml.equals("http://schemas.xmlsoap.org/wsdl/soap/http") || protocolBinding_wsXml.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true") || protocolBinding_wsXml.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") || protocolBinding_wsXml.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true") || protocolBinding_wsXml.equals("http://www.w3.org/2004/08/wsdl/http") || protocolBinding_wsXml.equals("##SOAP11_HTTP") || protocolBinding_wsXml.equals("##SOAP12_HTTP") || protocolBinding_wsXml.equals("##SOAP11_HTTP_MTOM") || protocolBinding_wsXml.equals("##SOAP12_HTTP_MTOM") || protocolBinding_wsXml.equals("##XML_HTTP");
    }

    protected void configMTOM(EndpointInfo epi, PortComponent portCmpt) {
        MTOMFeatureInfo mtom_epi = epi.getMTOMFeatureInfo();
        if (null == mtom_epi) {
            mtom_epi = new MTOMFeatureInfo();
        }
        if (portCmpt.isSetEnableMTOM()) {
            mtom_epi.setEnabled(portCmpt.isEnableMTOM());
        }
        if (portCmpt.isSetMTOMThreshold()) {
            mtom_epi.setThreshold(portCmpt.getMTOMThreshold());
        }
        if (portCmpt.isSetEnableMTOM() || portCmpt.isSetMTOMThreshold()) {
            epi.setMTOMFeatureInfo(mtom_epi);
        }
    }

    protected void configRespectBinding(EndpointInfo epi, PortComponent portCmpt) {
        RespectBindingFeatureInfo respectBinding_epi = epi.getRespectBindingFeatureInfo();
        RespectBinding respectBinding_wsXml = portCmpt.getRespectBinding();
        if (respectBinding_wsXml == null) {
            return;
        }
        if (respectBinding_wsXml.isSetEnabled()) {
            if (null == respectBinding_epi) {
                respectBinding_epi = new RespectBindingFeatureInfo();
            }
            respectBinding_epi.setEnabled(respectBinding_wsXml.isEnabled());
            epi.setRespectBindingFeatureInfo(respectBinding_epi);
        }
    }

    protected void configAddressing(EndpointInfo epi, PortComponent portCmpt) {
        int responses;
        Addressing addressing_wsXml = portCmpt.getAddressing();
        if (addressing_wsXml == null) {
            return;
        }
        AddressingFeatureInfo addressing_epi = new AddressingFeatureInfo();
        if (addressing_wsXml.isSetEnabled()) {
            addressing_epi.setEnabled(addressing_wsXml.isEnabled());
        }
        if (addressing_wsXml.isSetRequired()) {
            addressing_epi.setRequired(addressing_wsXml.isRequired());
        }
        if ((responses = addressing_wsXml.getAddressingResponsesTypeValue()) == 0 || responses == 1 || responses == 2) {
            switch (responses) {
                case 0: {
                    addressing_epi.setResponses(AddressingFeature.Responses.ALL);
                    break;
                }
                case 1: {
                    addressing_epi.setResponses(AddressingFeature.Responses.ANONYMOUS);
                    break;
                }
                case 2: {
                    addressing_epi.setResponses(AddressingFeature.Responses.NON_ANONYMOUS);
                    break;
                }
            }
        }
        epi.setAddressingFeatureInfo(addressing_epi);
    }
}

