/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.resolver.internal.kernel;

import com.ibm.ws.kernel.feature.AppForceRestart;
import com.ibm.ws.kernel.feature.ProcessType;
import com.ibm.ws.kernel.feature.Visibility;
import com.ibm.ws.kernel.feature.provisioning.FeatureResource;
import com.ibm.ws.kernel.feature.provisioning.HeaderElementDefinition;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.feature.provisioning.SubsystemContentType;
import com.ibm.ws.repository.common.enums.InstallPolicy;
import com.ibm.ws.repository.resolver.internal.kernel.KernelResolverRequirement;
import com.ibm.ws.repository.resources.EsaResource;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.aries.util.manifest.ManifestHeaderProcessor;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public class KernelResolverEsa
implements ProvisioningFeatureDefinition {
    private final EsaResource esaResource;

    public KernelResolverEsa(EsaResource esaResource) {
        if (esaResource == null) {
            throw new NullPointerException();
        }
        this.esaResource = esaResource;
    }

    public EsaResource getResource() {
        return this.esaResource;
    }

    public String getSymbolicName() {
        return this.esaResource.getProvideFeature();
    }

    public String getFeatureName() {
        String name = this.esaResource.getShortName();
        if (name == null) {
            name = this.esaResource.getProvideFeature();
        }
        return name;
    }

    public EnumSet<ProcessType> getProcessTypes() {
        return EnumSet.of(ProcessType.SERVER);
    }

    public Visibility getVisibility() {
        return Visibility.PUBLIC;
    }

    public String getBundleRepositoryType() {
        return "";
    }

    public Collection<FeatureResource> getConstituents(SubsystemContentType type) {
        if (type != SubsystemContentType.FEATURE_TYPE) {
            return Collections.emptySet();
        }
        if (this.esaResource.getRequireFeatureWithTolerates() == null) {
            return Collections.emptySet();
        }
        ArrayList<FeatureResource> result = new ArrayList<FeatureResource>();
        for (Map.Entry requirement : this.esaResource.getRequireFeatureWithTolerates().entrySet()) {
            String symbolicName = (String)requirement.getKey();
            List<String> tolerates = (List<String>)requirement.getValue();
            if (tolerates == null) {
                tolerates = Collections.emptyList();
            }
            result.add(new KernelResolverRequirement(symbolicName, tolerates));
        }
        return result;
    }

    public String getIbmShortName() {
        return this.esaResource.getShortName();
    }

    public boolean isAutoFeature() {
        return this.esaResource.getInstallPolicy() == InstallPolicy.WHEN_SATISFIED;
    }

    public boolean isCapabilitySatisfied(Collection<ProvisioningFeatureDefinition> features) {
        return this.matchCapability(features).capabilitySatisfied;
    }

    public Version getVersion() {
        try {
            return Version.parseVersion((String)this.esaResource.getVersion());
        }
        catch (IllegalArgumentException ex) {
            return Version.emptyVersion;
        }
    }

    public List<ProvisioningFeatureDefinition> findFeaturesSatisfyingCapability(Collection<? extends ProvisioningFeatureDefinition> features) {
        return this.matchCapability(features).features;
    }

    private CapabilityMatchingResult matchCapability(Collection<? extends ProvisioningFeatureDefinition> features) {
        String capabilityString = this.esaResource.getProvisionCapability();
        if (capabilityString == null) {
            CapabilityMatchingResult result = new CapabilityMatchingResult();
            result.capabilitySatisfied = true;
            result.features = Collections.emptyList();
            return result;
        }
        CapabilityMatchingResult result = new CapabilityMatchingResult();
        result.capabilitySatisfied = true;
        result.features = new ArrayList<ProvisioningFeatureDefinition>();
        List<FeatureCapabilityInfo> capabilityMaps = this.createCapabilityMaps(features);
        for (Filter filter : this.createFilterList()) {
            boolean matched = false;
            for (FeatureCapabilityInfo capabilityInfo : capabilityMaps) {
                if (!filter.matches(capabilityInfo.capabilities)) continue;
                matched = true;
                result.features.add(capabilityInfo.feature);
                break;
            }
            if (matched) continue;
            result.capabilitySatisfied = false;
        }
        return result;
    }

    private List<FeatureCapabilityInfo> createCapabilityMaps(Collection<? extends ProvisioningFeatureDefinition> features) {
        ArrayList<FeatureCapabilityInfo> result = new ArrayList<FeatureCapabilityInfo>();
        for (ProvisioningFeatureDefinition provisioningFeatureDefinition : features) {
            FeatureCapabilityInfo capabilityInfo = new FeatureCapabilityInfo();
            capabilityInfo.feature = provisioningFeatureDefinition;
            capabilityInfo.capabilities = new HashMap<String, String>();
            capabilityInfo.capabilities.put("osgi.identity", provisioningFeatureDefinition.getSymbolicName());
            capabilityInfo.capabilities.put("type", "osgi.subsystem.feature");
            result.add(capabilityInfo);
        }
        return result;
    }

    private List<Filter> createFilterList() {
        List metadatas = ManifestHeaderProcessor.parseCapabilityString((String)this.esaResource.getProvisionCapability());
        ArrayList<Filter> result = new ArrayList<Filter>();
        for (ManifestHeaderProcessor.GenericMetadata metadata : metadatas) {
            String filterString = (String)metadata.getDirectives().get("filter");
            if (!"osgi.identity".equals(metadata.getNamespace()) || filterString == null) continue;
            try {
                result.add(FrameworkUtil.createFilter((String)filterString));
            }
            catch (InvalidSyntaxException e) {
                throw new IllegalArgumentException("Esa " + this.esaResource.getProvideFeature() + " contains invalid provisionCapabiliy requirement: " + filterString, e);
            }
        }
        return result;
    }

    public boolean isSingleton() {
        return this.esaResource.isSingleton();
    }

    public String getApiServices() {
        throw new UnsupportedOperationException();
    }

    public AppForceRestart getAppForceRestart() {
        throw new UnsupportedOperationException();
    }

    public boolean isKernel() {
        return false;
    }

    public File getFeatureChecksumFile() {
        throw new UnsupportedOperationException();
    }

    public File getFeatureDefinitionFile() {
        throw new UnsupportedOperationException();
    }

    public String getHeader(String arg0, Locale arg1) {
        throw new UnsupportedOperationException();
    }

    public String getHeader(String arg0) {
        throw new UnsupportedOperationException();
    }

    public Collection<HeaderElementDefinition> getHeaderElements(String arg0) {
        throw new UnsupportedOperationException();
    }

    public int getIbmFeatureVersion() {
        return 0;
    }

    public Collection<String> getIcons() {
        throw new UnsupportedOperationException();
    }

    public Collection<File> getLocalizationFiles() {
        throw new UnsupportedOperationException();
    }

    public String getSupersededBy() {
        throw new UnsupportedOperationException();
    }

    public boolean isSuperseded() {
        throw new UnsupportedOperationException();
    }

    public boolean isSupportedFeatureVersion() {
        throw new UnsupportedOperationException();
    }

    public static class FeatureCapabilityInfo {
        ProvisioningFeatureDefinition feature;
        Map<String, String> capabilities;
    }

    public static class CapabilityMatchingResult {
        List<ProvisioningFeatureDefinition> features;
        boolean capabilitySatisfied;
    }
}

