/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jwt.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.jwt.Claims;
import com.ibm.websphere.security.jwt.JwtException;
import com.ibm.websphere.security.jwt.JwtToken;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jwt.config.JwtConfig;
import com.ibm.ws.security.jwt.internal.BuilderImpl;
import com.ibm.ws.security.jwt.internal.ClaimsImpl;
import com.ibm.ws.security.jwt.internal.JwtTokenException;
import com.ibm.ws.security.jwt.utils.JwtCreator;
import com.ibm.ws.security.jwt.utils.JwtData;
import com.ibm.ws.security.jwt.utils.JwtUtils;
import java.util.Map;
import org.jose4j.lang.JoseException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TokenImpl
implements JwtToken {
    private static final String KEY_JWT_SERVICE = "jwtConfig";
    Claims claims = new ClaimsImpl();
    String header;
    String payload;
    String compact;
    static final long serialVersionUID = 8073490315262772063L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - void declaration
     */
    public TokenImpl(BuilderImpl jwtBuilder, JwtConfig config) throws JwtException {
        try {
            this.createToken(jwtBuilder, config);
        }
        catch (JwtTokenException jwtTokenException) {
            void e;
            FFDCFilter.processException((Throwable)jwtTokenException, (String)"com.ibm.ws.security.jwt.internal.TokenImpl", (String)"37", (Object)this, (Object[])new Object[]{jwtBuilder, config});
            throw new JwtException(e.getMessage(), (Throwable)e);
        }
    }

    private void createToken(BuilderImpl jwtBuilder, JwtConfig config) throws JwtTokenException {
        JwtConfig jwtConfig = config;
        JwtData jwtData = new JwtData(jwtBuilder, jwtConfig, "Json Web Token");
        this.compact = JwtCreator.createJwtAsString(jwtData, jwtBuilder.getClaims());
        String[] parts = JwtUtils.splitTokenString(this.compact);
        this.header = JwtUtils.fromBase64ToJsonString(parts[0]);
        this.payload = JwtUtils.fromBase64ToJsonString(parts[1]);
        this.setClaims();
    }

    /*
     * WARNING - void declaration
     */
    private void setClaims() throws JwtTokenException {
        Map claimsMap = null;
        try {
            claimsMap = JwtUtils.claimsFromJsonObject(this.payload);
        }
        catch (JoseException joseException) {
            void e;
            FFDCFilter.processException((Throwable)joseException, (String)"com.ibm.ws.security.jwt.internal.TokenImpl", (String)"63", (Object)this, (Object[])new Object[0]);
            throw JwtTokenException.newInstance(true, "JWT_CREATE_FAIL", new Object[]{e.getLocalizedMessage()});
        }
        if (claimsMap != null && !claimsMap.isEmpty()) {
            this.claims.putAll(claimsMap);
        }
    }

    @Override
    public Claims getClaims() {
        return this.claims;
    }

    @Override
    public String getHeader(String name) {
        Map headerMap = null;
        try {
            headerMap = JwtUtils.claimsFromJsonObject(this.header);
        }
        catch (JoseException joseException) {
            FFDCFilter.processException((Throwable)joseException, (String)"com.ibm.ws.security.jwt.internal.TokenImpl", (String)"83", (Object)this, (Object[])new Object[]{name});
        }
        String value = null;
        if (headerMap != null && headerMap.get(name) != null) {
            value = (String)headerMap.get(name);
        }
        return value;
    }

    @Override
    public String compact() {
        return this.compact;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(TokenImpl.class);
    }
}

