/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.security.jwt;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.jwt.Consumer;
import com.ibm.websphere.security.jwt.InvalidConsumerException;
import com.ibm.websphere.security.jwt.InvalidTokenException;
import com.ibm.websphere.security.jwt.JwtToken;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.Map;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={JwtConsumer.class}, name="com.ibm.websphere.security.jwt.JwtConsumer", immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class JwtConsumer {
    public static final String DEFAULT_ID = "defaultJwtConsumer";
    private Consumer consumer;
    private static final String KEY_JWT_CONSUMER_SERVICE = "consumer";
    private static AtomicServiceReference<Consumer> consumerServiceRef;
    static final long serialVersionUID = 2786430319685225477L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Reference(service=Consumer.class, name="consumer", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.RELUCTANT)
    protected void setConsumer(ServiceReference<Consumer> ref) {
        consumerServiceRef.setReference(ref);
    }

    protected void unsetConsumer(ServiceReference<Consumer> ref) {
        consumerServiceRef.unsetReference(ref);
    }

    @Activate
    protected void activate(ComponentContext cc) {
        consumerServiceRef.activate(cc);
    }

    @Modified
    protected void modify(Map<String, Object> properties) {
    }

    @Deactivate
    protected void deactivate(int reason, ComponentContext cc) {
        consumerServiceRef.deactivate(cc);
    }

    public JwtConsumer() {
    }

    public JwtConsumer(String consumerConfigId) throws InvalidConsumerException {
        if (consumerConfigId == null) {
            consumerConfigId = DEFAULT_ID;
        }
        this.consumer = this.getTheService().create(consumerConfigId);
    }

    private Consumer getTheService() {
        return (Consumer)consumerServiceRef.getService();
    }

    public static synchronized JwtConsumer create() throws InvalidConsumerException {
        return JwtConsumer.create(DEFAULT_ID);
    }

    public static synchronized JwtConsumer create(String consumerConfigId) throws InvalidConsumerException {
        return new JwtConsumer(consumerConfigId);
    }

    public JwtToken createJwt(String encodedTokenString) throws InvalidTokenException, InvalidConsumerException {
        return this.consumer.createJwt(encodedTokenString);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(JwtConsumer.class);
        consumerServiceRef = new AtomicServiceReference(KEY_JWT_CONSUMER_SERVICE);
    }
}

