/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.reactive.streams.operators.spi.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.microprofile.reactive.streams.operators.spi.impl.StreamTask;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import com.ibm.wsspi.threadcontext.WSContextService;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class StreamRunner<T> {
    private final ExecutorService executorService;
    private final PrivilegedAction<CompletionStage<T>> action;
    private final WSContextService contextService;
    private final ThreadContextDescriptor context;
    private Runnable contextualProxy;
    private static final Map<String, ?>[] THREAD_CONTEXT_PROVIDERS;
    static final long serialVersionUID = -8374878068376006082L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public StreamRunner(ExecutorService executor, WSContextService contextService, PrivilegedAction<CompletionStage<T>> action) {
        this.executorService = executor;
        this.contextService = contextService;
        this.action = action;
        this.context = contextService != null ? contextService.captureThreadContext(null, (Map[])THREAD_CONTEXT_PROVIDERS) : null;
    }

    public StreamTask startStream() {
        Runnable task;
        StreamTask streamTask = new StreamTask(this.action);
        if (this.contextService != null && this.context != null) {
            this.contextualProxy = task = (Runnable)this.contextService.createContextualProxy(this.context, streamTask, Runnable.class);
        } else {
            task = streamTask;
        }
        this.executorService.execute(task);
        return streamTask;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(StreamRunner.class);
        THREAD_CONTEXT_PROVIDERS = new Map[]{Collections.singletonMap("threadContextProvider", "com.ibm.ws.classloader.context.provider"), Collections.singletonMap("threadContextProvider", "com.ibm.ws.javaee.metadata.context.provider"), Collections.singletonMap("threadContextProvider", "com.ibm.ws.security.context.provider")};
    }
}

