/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.SoapInterceptor;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.PhaseInterceptor;
import org.apache.cxf.resource.ResourceManager;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.handler.WSHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class AbstractWSS4JInterceptor
extends WSHandler
implements SoapInterceptor,
PhaseInterceptor<SoapMessage> {
    private static final Set<QName> HEADERS;
    private Map<String, Object> properties = new ConcurrentHashMap<String, Object>();
    private Map<String, Crypto> cryptoMap = new ConcurrentHashMap<String, Crypto>();
    private Set<String> before = new HashSet<String>();
    private Set<String> after = new HashSet<String>();
    private String phase;
    private String id = ((Object)((Object)this)).getClass().getName();
    static final long serialVersionUID = -8732898494089051098L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public Set<URI> getRoles() {
        return null;
    }

    public void handleFault(SoapMessage message) {
    }

    public void postHandleMessage(SoapMessage message) throws Fault {
    }

    public Collection<PhaseInterceptor<? extends Message>> getAdditionalInterceptors() {
        return null;
    }

    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public Object getOption(String key) {
        return this.properties.get(key);
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public String getPassword(Object msgContext) {
        return (String)((Message)msgContext).getContextualProperty("password");
    }

    public Object getProperty(Object msgContext, String key) {
        Object obj = ((Message)msgContext).getContextualProperty(key);
        if (obj == null) {
            obj = this.getOption(key);
        }
        return obj;
    }

    public void setPassword(Object msgContext, String password) {
        ((Message)msgContext).put((Object)"password", (Object)password);
    }

    public void setProperty(Object msgContext, String key, Object value) {
        ((Message)msgContext).put((Object)key, value);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Set<QName> getUnderstoodHeaders() {
        return HEADERS;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public Set<String> getAfter() {
        return this.after;
    }

    public void setAfter(Set<String> after) {
        this.after = after;
    }

    public Set<String> getBefore() {
        return this.before;
    }

    public void setBefore(Set<String> before) {
        this.before = before;
    }

    protected boolean isRequestor(SoapMessage message) {
        return MessageUtils.isRequestor((Message)message);
    }

    protected void translateProperties(SoapMessage msg) {
        String certConstraints;
        String ttl;
        String futureTTL;
        String bspCompliant = (String)msg.getContextualProperty("ws-security.is-bsp-compliant");
        if (bspCompliant != null) {
            msg.setContextualProperty("isBSPCompliant", (Object)bspCompliant);
        }
        if ((futureTTL = (String)msg.getContextualProperty("ws-security.timestamp.futureTimeToLive")) != null) {
            msg.setContextualProperty("futureTimeToLive", (Object)futureTTL);
        }
        if ((ttl = (String)msg.getContextualProperty("ws-security.timestamp.timeToLive")) != null) {
            msg.setContextualProperty("timeToLive", (Object)ttl);
        }
        if ((certConstraints = (String)msg.getContextualProperty("ws-security.subject.cert.constraints")) != null) {
            msg.setContextualProperty("sigSubjectCertConstraints", (Object)certConstraints);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Crypto loadCryptoFromPropertiesFile(String propFilename, RequestData reqData) throws WSSecurityException {
        Crypto crypto;
        ClassLoaderUtils.ClassLoaderHolder orig = null;
        try {
            URL url = ClassLoaderUtils.getResource((String)propFilename, ((Object)((Object)this)).getClass());
            if (url == null) {
                ResourceManager manager = (ResourceManager)((Message)reqData.getMsgContext()).getExchange().getBus().getExtension(ResourceManager.class);
                ClassLoader loader = (ClassLoader)manager.resolveResource("", ClassLoader.class);
                if (loader != null) {
                    orig = ClassLoaderUtils.setThreadContextClassloader((ClassLoader)loader);
                }
                url = (URL)manager.resolveResource(propFilename, URL.class);
            }
            if (url == null) return CryptoFactory.getInstance((String)propFilename, (ClassLoader)this.getClassLoader(reqData.getMsgContext()));
            Properties props = new Properties();
            InputStream in = url.openStream();
            props.load(in);
            in.close();
            crypto = CryptoFactory.getInstance((Properties)props, (ClassLoader)this.getClassLoader(reqData.getMsgContext()));
            if (orig == null) return crypto;
        }
        catch (Exception url) {
            FFDCFilter.processException((Throwable)url, (String)"org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", (String)"211", (Object)((Object)this), (Object[])new Object[]{propFilename, reqData});
            return CryptoFactory.getInstance((String)propFilename, (ClassLoader)this.getClassLoader(reqData.getMsgContext()));
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        orig.reset();
        return crypto;
    }

    protected Crypto loadCrypto(String cryptoPropertyFile, String cryptoPropertyRefId, RequestData requestData) throws WSSecurityException {
        String propFile;
        Object mc = requestData.getMsgContext();
        Crypto crypto = null;
        String refId = this.getString(cryptoPropertyRefId, mc);
        if (refId != null && (crypto = this.cryptoMap.get(refId)) == null) {
            Object obj = this.getProperty(mc, refId);
            if (obj instanceof Properties) {
                crypto = CryptoFactory.getInstance((Properties)((Properties)obj));
                this.cryptoMap.put(refId, crypto);
            } else if (obj instanceof Crypto) {
                crypto = (Crypto)obj;
                this.cryptoMap.put(refId, crypto);
            }
        }
        if (crypto == null && (propFile = this.getString(cryptoPropertyFile, mc)) != null && (crypto = this.cryptoMap.get(propFile)) == null) {
            crypto = this.loadCryptoFromPropertiesFile(propFile, requestData);
            this.cryptoMap.put(propFile, crypto);
        }
        return crypto;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", AbstractWSS4JInterceptor.class, null, null);
        HEADERS = new HashSet<QName>();
        HEADERS.add(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security"));
        HEADERS.add(new QName("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "Security"));
        HEADERS.add(new QName("http://www.w3.org/2001/04/xmlenc#", "EncryptedData"));
    }
}

