/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.persistent.internal;

import com.ibm.websphere.ras.annotation.Trivial;
import java.util.Dictionary;

@Trivial
class Config {
    final boolean enableTaskExecution;
    final String id;
    final long heartbeatInterval;
    final long initialPollDelay;
    final String jndiName;
    final long missedTaskThreshold;
    final long missedTaskThreshold2;
    final long pollInterval;
    final Integer pollSize;
    final long retryInterval;
    final int retryLimit;
    final String xpathId;

    Config(Dictionary<String, ?> properties) {
        this.jndiName = (String)properties.get("jndiName");
        this.enableTaskExecution = (Boolean)properties.get("enableTaskExecution");
        this.heartbeatInterval = (Long)properties.get("heartbeatInterval");
        this.initialPollDelay = (Long)properties.get("initialPollDelay");
        this.missedTaskThreshold = this.enableTaskExecution ? (Long)properties.get("missedTaskThreshold") : -1L;
        this.missedTaskThreshold2 = (Long)properties.get("missedTaskThreshold2");
        this.pollInterval = this.enableTaskExecution ? (Long)properties.get("pollInterval") : -1L;
        this.pollSize = this.enableTaskExecution ? (Integer)properties.get("pollSize") : null;
        this.retryInterval = (Long)properties.get("retryInterval");
        this.retryLimit = ((Short)properties.get("retryLimit")).shortValue();
        this.xpathId = (String)properties.get("config.displayId");
        String string = this.id = this.xpathId.contains("]/persistentExecutor[") ? null : (String)properties.get("id");
        if (this.heartbeatInterval != -1L && this.heartbeatInterval < 1L) {
            throw new IllegalArgumentException("heartbeatInterval: " + this.heartbeatInterval + "s");
        }
        if (this.missedTaskThreshold != -1L && this.missedTaskThreshold < 1L) {
            throw new IllegalArgumentException("missedTaskThreshold: " + this.missedTaskThreshold + "s");
        }
        if (this.missedTaskThreshold2 != -1L && this.missedTaskThreshold2 < 1L || this.missedTaskThreshold2 > 86400L) {
            throw new IllegalArgumentException("missedTaskThreshold2: " + this.missedTaskThreshold2 + "s");
        }
        if (this.initialPollDelay < -1L) {
            throw new IllegalArgumentException("initialPollDelay: " + this.initialPollDelay + "ms");
        }
        if (this.pollInterval < -1L) {
            throw new IllegalArgumentException("pollInterval: " + this.pollInterval + "ms");
        }
        if (this.retryInterval < 0L) {
            throw new IllegalArgumentException("retryInterval: " + this.retryInterval + "ms");
        }
    }

    public String toString() {
        return new StringBuilder(300).append("instance=").append(Integer.toHexString(System.identityHashCode(this))).append(",jndiName=").append(this.jndiName).append(",enableTaskExecution=").append(this.enableTaskExecution).append(",heartbeatInterval=").append(this.heartbeatInterval).append("s,initialPollDelay=").append(this.initialPollDelay).append("ms,missedTaskThreshold=").append(this.missedTaskThreshold).append("s,missedTaskThreshold2=").append(this.missedTaskThreshold2).append("s,pollInterval=").append(this.pollInterval).append("ms,pollSize=").append(this.pollSize).append(",retryInterval=").append(this.retryInterval).append("ms,retryLimit=").append(this.retryLimit).append(",xpathId=").append(this.xpathId).append(",id=").append(this.id).toString();
    }
}

