/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authentication.jaas.modules;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.auth.InvalidTokenException;
import com.ibm.websphere.security.auth.TokenExpiredException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.callback.WSAuthMechOidCallbackImpl;
import com.ibm.websphere.security.auth.callback.WSCredTokenCallbackImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.AccessIdUtil;
import com.ibm.ws.security.authentication.AuthenticationException;
import com.ibm.ws.security.authentication.internal.jaas.modules.ServerCommonLoginModule;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.ws.security.jaas.common.callback.AuthenticationHelper;
import com.ibm.ws.security.jaas.common.callback.JwtTokenCallback;
import com.ibm.ws.security.jwtsso.token.proxy.JwtSSOTokenHelper;
import com.ibm.ws.security.registry.UserRegistry;
import com.ibm.ws.security.token.TokenManager;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.token.SingleSignonToken;
import java.io.IOException;
import java.security.Principal;
import java.util.Hashtable;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TokenLoginModule
extends ServerCommonLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(TokenLoginModule.class, (String)"Authentication", (String)"com.ibm.ws.security.authentication.internal.resources.AuthenticationMessages");
    private static final String LTPA_OID = "oid:1.3.18.0.2.30.2";
    private static final String JWT_OID = "oid:1.3.18.0.2.30.3";
    private String accessId = null;
    private Token recreatedToken;
    private String customRealm = null;
    private String authProvider = null;
    private final String[] hashtableLoginProperties = new String[]{"com.ibm.wsspi.security.cred.uniqueId", "com.ibm.wsspi.security.cred.userId", "com.ibm.wsspi.security.cred.securityName", "com.ibm.wsspi.security.cred.realm", "com.ibm.wsspi.security.cred.cacheKey", "com.ibm.ws.authentication.internal.assertion", "com.ibm.ws.authentication.internal.json.web.token", "com.ibm.ws.authentication.internal.auth.provider"};
    static final long serialVersionUID = -8443847235269521669L;

    @Override
    @FFDCIgnore(value={InvalidTokenException.class, TokenExpiredException.class, WSLoginFailedException.class})
    public boolean login() throws LoginException {
        if (this.isAlreadyProcessed()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Already processed by other login module, abstaining.", (Object[])new Object[0]);
            }
            return false;
        }
        try {
            Callback[] callbacks = this.getRequiredCallbacks(this.callbackHandler);
            byte[] token = ((WSCredTokenCallbackImpl)callbacks[0]).getCredToken();
            String jwtToken = ((JwtTokenCallback)callbacks[2]).getToken();
            if (token == null && jwtToken == null) {
                return false;
            }
            this.setAlreadyProcessed();
            if (jwtToken != null) {
                this.setUpTemporaryUserSubjectForJsonWebToken(jwtToken);
            } else {
                byte[] credToken = AuthenticationHelper.copyCredToken((byte[])token);
                TokenManager tokenManager = this.getTokenManager();
                this.recreatedToken = tokenManager.recreateTokenFromBytes(credToken);
                this.accessId = this.recreatedToken.getAttributes("u")[0];
                if (AccessIdUtil.isServerAccessId((String)this.accessId)) {
                    this.setUpTemporaryServerSubject();
                } else {
                    this.setUpTemporaryUserSubject();
                }
            }
            this.updateSharedState();
            return true;
        }
        catch (InvalidTokenException e) {
            throw new AuthenticationException(e.getLocalizedMessage(), (Exception)((Object)e));
        }
        catch (TokenExpiredException e) {
            throw new AuthenticationException(e.getLocalizedMessage(), (Exception)((Object)e));
        }
        catch (WSLoginFailedException e) {
            throw new AuthenticationException(e.getLocalizedMessage(), (Exception)((Object)e));
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.authentication.jaas.modules.TokenLoginModule", (String)"116", (Object)this, (Object[])new Object[0]);
            throw new AuthenticationException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public Callback[] getRequiredCallbacks(CallbackHandler callbackHandler) throws IOException, UnsupportedCallbackException {
        Callback[] callbacks = new Callback[]{new WSCredTokenCallbackImpl("Credential Token"), new WSAuthMechOidCallbackImpl("AuthMechOid"), new JwtTokenCallback()};
        callbackHandler.handle(callbacks);
        return callbacks;
    }

    private void setUpTemporaryServerSubject() throws Exception {
        this.temporarySubject = new Subject();
        this.temporarySubject.getPrivateCredentials().add(this.recreatedToken);
        String securityName = AccessIdUtil.getUniqueId((String)this.accessId);
        this.setWSPrincipal(this.temporarySubject, securityName, this.accessId, "token");
        this.setCredentials(this.temporarySubject, securityName, null);
        this.setOtherPrincipals(this.temporarySubject, securityName, this.accessId, "token", null);
    }

    private void setUpTemporaryUserSubject() throws Exception {
        this.temporarySubject = new Subject();
        this.temporarySubject.getPrivateCredentials().add(this.recreatedToken);
        UserRegistry ur = this.getUserRegistry();
        String securityName = ur.getUserSecurityName(AccessIdUtil.getUniqueId((String)this.accessId));
        securityName = this.getSecurityName(securityName, securityName);
        this.setWSPrincipal(this.temporarySubject, securityName, this.accessId, "token");
        this.setCredentials(this.temporarySubject, securityName, null);
        this.setOtherPrincipals(this.temporarySubject, securityName, this.accessId, "token", null);
    }

    private void setUpTemporaryUserSubjectForJsonWebToken(String jwtToken) throws Exception {
        String securityName = null;
        Subject jwtPartialSubject = new Subject();
        jwtPartialSubject = JwtSSOTokenHelper.handleJwtSSOToken((String)jwtToken);
        Set<Principal> jwtPrincipals = jwtPartialSubject.getPrincipals();
        this.temporarySubject = new Subject();
        this.temporarySubject.getPrincipals().addAll(jwtPrincipals);
        SubjectHelper subjectHelper = new SubjectHelper();
        Hashtable customProperties = subjectHelper.getHashtableFromSubject(jwtPartialSubject, this.hashtableLoginProperties);
        this.customPropertiesFromSubject = true;
        String userId = (String)customProperties.get("com.ibm.wsspi.security.cred.userId");
        if (userId != null && this.allowLoginWithIdOnly(customProperties)) {
            securityName = userId;
            UserRegistry userRegistry = this.getUserRegistry();
            String uniqueUserId = userRegistry.getUniqueUserId(securityName);
            this.accessId = AccessIdUtil.createAccessId((String)"user", (String)userRegistry.getRealm(), (String)uniqueUserId);
        } else {
            this.accessId = (String)customProperties.get("com.ibm.wsspi.security.cred.uniqueId");
            securityName = (String)customProperties.get("com.ibm.wsspi.security.cred.securityName");
            this.customRealm = (String)customProperties.get("com.ibm.wsspi.security.cred.realm");
            this.authProvider = (String)customProperties.get("com.ibm.ws.authentication.internal.auth.provider");
        }
        this.setWSPrincipal(this.temporarySubject, securityName, this.accessId, "jwtSSOToken");
        this.setCredentials(this.temporarySubject, securityName, securityName);
        this.setOtherPrincipals(this.temporarySubject, securityName, this.accessId, "jwtSSOToken", customProperties);
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.accessId == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Authentication did not occur for this login module, abstaining.", (Object[])new Object[0]);
            }
            return false;
        }
        this.setUpSubject();
        if (this.customRealm != null || this.authProvider != null && !this.authProvider.endsWith("Form")) {
            this.addCustomAttributesToSSOToken();
        }
        return true;
    }

    private void addCustomAttributesToSSOToken() {
        SingleSignonToken ssoToken = this.getSSOToken(this.subject);
        if (ssoToken != null) {
            if (this.customRealm != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Add custom realm into SSOToken", (Object[])new Object[0]);
                }
                ssoToken.addAttribute("com.ibm.wsspi.security.cred.realm", this.customRealm);
            }
            if (this.authProvider != null && !this.authProvider.endsWith("Form")) {
                ssoToken.addAttribute("com.ibm.ws.authentication.internal.auth.provider", this.authProvider);
            }
        }
    }

    @Override
    public boolean abort() {
        this.cleanUpSubject();
        this.accessId = null;
        return true;
    }

    @Override
    public boolean logout() {
        this.cleanUpSubject();
        this.accessId = null;
        return true;
    }
}

