/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.Bus;
import org.apache.cxf.annotations.SchemaValidation;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.Soap12;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.SoapVersionFactory;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.headers.Header;
import org.apache.cxf.headers.HeaderManager;
import org.apache.cxf.headers.HeaderProcessor;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.ServiceUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.staxutils.PartialXMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class ReadHeadersInterceptor
extends AbstractSoapInterceptor {
    public static final String ENVELOPE_EVENTS = "envelope.events";
    public static final String BODY_EVENTS = "body.events";
    public static final String ENVELOPE_PREFIX = "envelope.prefix";
    public static final String BODY_PREFIX = "body.prefix";
    private static final Logger LOG = LogUtils.getL7dLogger(ReadHeadersInterceptor.class);
    private Bus bus;
    private SoapVersion version;
    static final long serialVersionUID = -6758205324911702078L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ReadHeadersInterceptor(Bus b) {
        super("read");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor", "<init>", new Object[]{b});
        }
        this.bus = b;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ReadHeadersInterceptor(Bus b, SoapVersion v) {
        super("read");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor", "<init>", new Object[]{b, v});
        }
        this.version = v;
        this.bus = b;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ReadHeadersInterceptor(Bus b, String phase) {
        super(phase);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor", "<init>", new Object[]{b, phase});
        }
        this.bus = b;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static SoapVersion readVersion(XMLStreamReader xmlReader, SoapMessage message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor", "readVersion", new Object[]{xmlReader, message});
        }
        String ns = xmlReader.getNamespaceURI();
        String lcname = xmlReader.getLocalName();
        if (ns == null || "".equals(ns)) {
            throw new SoapFault(new org.apache.cxf.common.i18n.Message("NO_NAMESPACE", LOG, new Object[]{lcname}), Soap11.getInstance().getVersionMismatch());
        }
        SoapVersion soapVersion = SoapVersionFactory.getInstance().getSoapVersion(ns);
        if (soapVersion == null) {
            throw new SoapFault(new org.apache.cxf.common.i18n.Message("INVALID_VERSION", LOG, new Object[]{ns, lcname}), Soap11.getInstance().getVersionMismatch());
        }
        if (!"Envelope".equals(lcname)) {
            throw new SoapFault(new org.apache.cxf.common.i18n.Message("INVALID_ENVELOPE", LOG, new Object[]{lcname}), soapVersion.getSender());
        }
        message.setVersion(soapVersion);
        SoapVersion soapVersion2 = soapVersion;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            soapVersion2 = soapVersion2;
            LOG.exiting("org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor", "readVersion", soapVersion2);
        }
        return soapVersion2;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleMessage(SoapMessage message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor", "handleMessage", new Object[]{message});
        }
        if (this.isGET((Message)message)) {
            LOG.fine("ReadHeadersInterceptor skipped in HTTP GET method");
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor", "handleMessage");
            }
            return;
        }
        String verb = (String)message.get("org.apache.cxf.request.method");
        if (verb != null && !"POST".equals(verb)) {
            Fault formula405 = new Fault("HTTP verb was not GET or POST", LOG);
            formula405.setStatusCode(405);
            throw formula405;
        }
        XMLStreamReader xmlReader = (XMLStreamReader)message.getContent(XMLStreamReader.class);
        boolean closeNeeded = false;
        if (xmlReader == null) {
            InputStream in = (InputStream)message.getContent(InputStream.class);
            if (in == null) {
                throw new RuntimeException("Can't find input stream in message");
            }
            xmlReader = StaxUtils.createXMLStreamReader((InputStream)in);
            closeNeeded = true;
        }
        try {
            if (xmlReader.getEventType() == 1 || xmlReader.nextTag() == 1) {
                SoapVersion soapVersion = ReadHeadersInterceptor.readVersion(xmlReader, message);
                if (soapVersion == Soap12.getInstance() && this.version == Soap11.getInstance()) {
                    message.setVersion(this.version);
                    throw new SoapFault(new org.apache.cxf.common.i18n.Message("INVALID_11_VERSION", LOG, new Object[0]), this.version.getVersionMismatch());
                }
                PartialXMLStreamReader filteredReader = new PartialXMLStreamReader(xmlReader, message.getVersion().getBody());
                Node nd = (Node)message.getContent(Node.class);
                W3CDOMStreamWriter writer = (W3CDOMStreamWriter)message.get(W3CDOMStreamWriter.class);
                Document doc = null;
                if (writer != null) {
                    StaxUtils.copy((XMLStreamReader)filteredReader, (XMLStreamWriter)writer);
                    doc = writer.getDocument();
                } else if (nd instanceof Document) {
                    doc = (Document)nd;
                    StaxUtils.readDocElements((Document)doc, (Node)doc, (XMLStreamReader)filteredReader, (boolean)false, (boolean)false);
                } else {
                    doc = StaxUtils.read((XMLStreamReader)filteredReader);
                    message.setContent(Node.class, doc);
                }
                Element element = doc.getDocumentElement();
                QName header = soapVersion.getHeader();
                List elemList = DOMUtils.findAllElementsByTagNameNS((Element)element, (String)header.getNamespaceURI(), (String)header.getLocalPart());
                for (Element elem : elemList) {
                    Element hel = DOMUtils.getFirstElement((Node)elem);
                    hel = (Element)DOMUtils.getDomElement((Node)hel);
                    while (hel != null) {
                        Object obj;
                        if (elem.hasAttributes()) {
                            NamedNodeMap nnp = elem.getAttributes();
                            for (int ct = 0; ct < nnp.getLength(); ++ct) {
                                Node headerAttrNode;
                                Node attr = nnp.item(ct);
                                Node node = headerAttrNode = hel.hasAttributes() ? hel.getAttributes().getNamedItemNS(attr.getNamespaceURI(), attr.getLocalName()) : null;
                                if (headerAttrNode != null) continue;
                                Attr attribute = hel.getOwnerDocument().createAttributeNS(attr.getNamespaceURI(), attr.getNodeName());
                                attribute.setNodeValue(attr.getNodeValue());
                                hel.setAttributeNodeNS(attribute);
                            }
                        }
                        HeaderProcessor p = this.bus == null ? null : ((HeaderManager)this.bus.getExtension(HeaderManager.class)).getHeaderProcessor(hel.getNamespaceURI());
                        DataBinding dataBinding = null;
                        if (p == null || p.getDataBinding() == null) {
                            obj = hel;
                        } else {
                            dataBinding = p.getDataBinding();
                            obj = dataBinding.createReader(Node.class).read((Object)hel);
                        }
                        SoapHeader shead = new SoapHeader(new QName(hel.getNamespaceURI(), hel.getLocalName()), obj, dataBinding);
                        String mu = hel.getAttributeNS(soapVersion.getNamespace(), soapVersion.getAttrNameMustUnderstand());
                        String act = hel.getAttributeNS(soapVersion.getNamespace(), soapVersion.getAttrNameRole());
                        if (!StringUtils.isEmpty((String)act)) {
                            shead.setActor(act);
                        }
                        shead.setMustUnderstand(Boolean.valueOf(mu) != false || "1".equals(mu));
                        shead.setDirection(Header.Direction.DIRECTION_IN);
                        message.getHeaders().add(shead);
                        hel = DOMUtils.getNextElement((Element)hel);
                    }
                }
                if (ServiceUtils.isSchemaValidationEnabled((SchemaValidation.SchemaValidationType)SchemaValidation.SchemaValidationType.IN, (Message)message)) {
                    message.getInterceptorChain().add((Interceptor)new CheckClosingTagsInterceptor());
                }
            }
        }
        catch (XMLStreamException e) {
            throw new SoapFault(new org.apache.cxf.common.i18n.Message("XML_STREAM_EXC", LOG, new Object[0]), (Throwable)e, message.getVersion().getSender());
        }
        finally {
            if (closeNeeded) {
                StaxUtils.close((XMLStreamReader)xmlReader);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor", "handleMessage");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    public static class CheckClosingTagsInterceptor
    extends AbstractSoapInterceptor {
        static final long serialVersionUID = -5875341780111098749L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public CheckClosingTagsInterceptor() {
            super("post-logical");
        }

        public void handleMessage(SoapMessage message) throws Fault {
            XMLStreamReader xmlReader = (XMLStreamReader)message.getContent(XMLStreamReader.class);
            if (xmlReader != null) {
                try {
                    while (xmlReader.hasNext()) {
                        if (xmlReader.next() != 8) continue;
                        return;
                    }
                }
                catch (XMLStreamException e) {
                    throw new SoapFault(e.getMessage(), (Throwable)e, message.getVersion().getSender());
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor$CheckClosingTagsInterceptor", CheckClosingTagsInterceptor.class, null, null);
        }
    }
}

