/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jaxrs20.api.JaxRsFactoryBeanCustomizer;
import com.ibm.ws.jaxrs20.injection.InjectionRuntimeContextHelper;
import com.ibm.ws.jaxrs20.providers.multipart.IBMMultipartProvider;
import com.ibm.ws.jaxrs20.utils.CustomizerUtils;
import com.ibm.ws.jaxrs21.providers.json.JsonBProvider;
import com.ibm.ws.jaxrs21.providers.json.JsonPProvider;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.annotation.Annotation;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.json.bind.spi.JsonbProvider;
import javax.json.spi.JsonProvider;
import javax.ws.rs.Produces;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.apache.cxf.Bus;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.ext.ContextProvider;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.ReaderInterceptorMBR;
import org.apache.cxf.jaxrs.impl.WriterInterceptorMBW;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalProxy;
import org.apache.cxf.jaxrs.model.ApplicationInfo;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.FilterProviderInfo;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.provider.AbstractConfigurableProvider;
import org.apache.cxf.jaxrs.provider.BinaryDataProvider;
import org.apache.cxf.jaxrs.provider.DataSourceProvider;
import org.apache.cxf.jaxrs.provider.FormEncodingProvider;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.apache.cxf.jaxrs.provider.JAXBElementTypedProvider;
import org.apache.cxf.jaxrs.provider.MultipartProvider;
import org.apache.cxf.jaxrs.provider.PrimitiveTextProvider;
import org.apache.cxf.jaxrs.provider.ProviderCache;
import org.apache.cxf.jaxrs.provider.SourceProvider;
import org.apache.cxf.jaxrs.provider.StringTextProvider;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class ProviderFactory {
    private static final TraceComponent tc = Tr.register(ProviderFactory.class, null, null);
    public static final String DEFAULT_FILTER_NAME_BINDING = "org.apache.cxf.filter.binding";
    public static final String PROVIDER_SELECTION_PROPERTY_CHANGED = "provider.selection.property.changed";
    public static final String ACTIVE_JAXRS_PROVIDER_KEY = "active.jaxrs.provider";
    protected static final String SERVER_FACTORY_NAME = "org.apache.cxf.jaxrs.provider.ServerProviderFactory";
    protected static final String CLIENT_FACTORY_NAME = "org.apache.cxf.jaxrs.client.ClientProviderFactory";
    protected static final String IGNORE_TYPE_VARIABLES = "org.apache.cxf.jaxrs.providers.ignore.typevars";
    private static final String JAXB_PROVIDER_NAME = "org.apache.cxf.jaxrs.provider.JAXBElementProvider";
    private static final String JSON_PROVIDER_NAME = "org.apache.cxf.jaxrs.provider.json.JSONProvider";
    private static final String BUS_PROVIDERS_ALL = "org.apache.cxf.jaxrs.bus.providers";
    private static final String PROVIDER_CACHE_ALLOWED = "org.apache.cxf.jaxrs.provider.cache.allowed";
    private static final String PROVIDER_CACHE_CHECK_ALL = "org.apache.cxf.jaxrs.provider.cache.checkAllCandidates";
    protected Map<NameKey, ProviderInfo<ReaderInterceptor>> readerInterceptors = new NameKeyMap<ProviderInfo<ReaderInterceptor>>(true);
    protected Map<NameKey, ProviderInfo<WriterInterceptor>> writerInterceptors = new NameKeyMap<ProviderInfo<WriterInterceptor>>(true);
    private final AtomicReferenceProviderList<MessageBodyReader<?>> messageReaders = new AtomicReferenceProviderList();
    private final AtomicReferenceProviderList<MessageBodyWriter<?>> messageWriters = new AtomicReferenceProviderList();
    private final AtomicReferenceProviderList<ContextResolver<?>> contextResolvers = new AtomicReferenceProviderList();
    private final AtomicReferenceProviderList<ContextProvider<?>> contextProviders = new AtomicReferenceProviderList();
    private final AtomicReferenceProviderList<ParamConverterProvider> paramConverters = new AtomicReferenceProviderList();
    private boolean paramConverterContextsAvailable;
    private Collection<ProviderInfo<?>> injectedProviders = new HashSet();
    private Bus bus;
    private Comparator<?> providerComparator;
    private ProviderCache providerCache;
    private static final ConcurrentHashMap<ClassesKey, Type[]> genericInterfacesCache = new ConcurrentHashMap();
    private static final Type[] emptyType = new Type[0];
    private final Map<MessageBodyReader<?>, List<MediaType>> readerMediaTypesMap = new IdentityHashMap();
    private final Map<MessageBodyWriter<?>, List<MediaType>> writerMediaTypesMap = new IdentityHashMap();
    private static final ReferenceQueue<Class<?>> referenceQueue = new ReferenceQueue();
    static final long serialVersionUID = -906407225588256533L;

    protected ProviderFactory(Bus bus) {
        this.bus = bus;
        this.providerCache = ProviderFactory.initCache(bus);
    }

    public Bus getBus() {
        return this.bus;
    }

    protected static ProviderCache initCache(final Bus theBus) {
        boolean allowed;
        Object allowProp = theBus.getProperty(PROVIDER_CACHE_ALLOWED);
        boolean bl = allowed = allowProp == null || PropertyUtils.isTrue((Object)allowProp);
        if (!allowed) {
            return null;
        }
        boolean checkAll = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            static final long serialVersionUID = -6200548538255785408L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean run() {
                Object o = System.getProperty(ProviderFactory.PROVIDER_CACHE_CHECK_ALL);
                if (o == null) {
                    o = PropertyUtils.isTrue((Object)theBus.getProperty(ProviderFactory.PROVIDER_CACHE_CHECK_ALL));
                }
                return PropertyUtils.isTrue((Object)o);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.provider.ProviderFactory$1", 1.class, null, null);
            }
        });
        return new ProviderCache(checkAll);
    }

    protected static void initFactory(ProviderFactory factory) {
        factory.setProviders(false, false, new BinaryDataProvider(), new SourceProvider(), new DataSourceProvider(), new FormEncodingProvider(), new StringTextProvider(), new PrimitiveTextProvider(), new JAXBElementProvider(), new JAXBElementTypedProvider(), ProviderFactory.createJsonpProvider(), ProviderFactory.createJsonBindingProvider(factory.contextResolvers), new IBMMultipartProvider(), new MultipartProvider());
    }

    /*
     * WARNING - void declaration
     */
    protected static Object tryCreateInstance(String className) {
        try {
            Class cls = ClassLoaderUtils.loadClass((String)className, ProviderFactory.class);
            return cls.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable cls) {
            FFDCFilter.processException((Throwable)cls, (String)"org.apache.cxf.jaxrs.provider.ProviderFactory", (String)"223", null, (Object[])new Object[]{className});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                void ex;
                Tr.debug((TraceComponent)tc, (String)"className not available, skipping", (Object[])new Object[]{ex});
            }
            return null;
        }
    }

    @FFDCIgnore(value={Throwable.class})
    protected static Object createProvider(String className, Bus bus) {
        try {
            Class cls = ClassLoaderUtils.loadClass((String)className, ProviderFactory.class);
            for (Constructor<?> c : cls.getConstructors()) {
                if (c.getParameterTypes().length != 1 || c.getParameterTypes()[0] != Bus.class) continue;
                return c.newInstance(bus);
            }
            return cls.newInstance();
        }
        catch (Throwable ex) {
            String message = "Problem with creating the default provider " + className;
            message = ex.getMessage() != null ? message + ": " + ex.getMessage() : message + ", exception class : " + ex.getClass().getName();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)message, (Object[])new Object[0]);
            }
            return null;
        }
    }

    public static Object createJsonpProvider() {
        JsonProvider jsonProvider = AccessController.doPrivileged(new PrivilegedAction<JsonProvider>(){
            static final long serialVersionUID = 5150799583495127990L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public JsonProvider run() {
                try {
                    Bundle b = FrameworkUtil.getBundle(ProviderFactory.class);
                    if (b != null) {
                        BundleContext bc = b.getBundleContext();
                        ServiceReference sr = bc.getServiceReference(JsonProvider.class);
                        return (JsonProvider)bc.getService(sr);
                    }
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    FFDCFilter.processException((Throwable)noClassDefFoundError, (String)"org.apache.cxf.jaxrs.provider.ProviderFactory$2", (String)"272", (Object)this, (Object[])new Object[0]);
                }
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.provider.ProviderFactory$2", 2.class, null, null);
            }
        });
        return new JsonPProvider(jsonProvider);
    }

    @FFDCIgnore(value={ClassNotFoundException.class})
    public static Class<?> loadClass(ClassLoader cl, String className) {
        if (cl == null) {
            return null;
        }
        Class<?> c = null;
        try {
            c = cl.loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return c;
    }

    public static Object createJsonBindingProvider(Iterable<ProviderInfo<ContextResolver<?>>> contextResolvers) {
        JsonbProvider jsonbProvider = AccessController.doPrivileged(new PrivilegedAction<JsonbProvider>(){
            static final long serialVersionUID = 8456770249893493866L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public JsonbProvider run() {
                try {
                    Bundle b = FrameworkUtil.getBundle(ProviderFactory.class);
                    if (b != null) {
                        BundleContext bc = b.getBundleContext();
                        ServiceReference sr = bc.getServiceReference(JsonbProvider.class);
                        return (JsonbProvider)bc.getService(sr);
                    }
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    FFDCFilter.processException((Throwable)noClassDefFoundError, (String)"org.apache.cxf.jaxrs.provider.ProviderFactory$3", (String)"310", (Object)this, (Object[])new Object[0]);
                }
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.provider.ProviderFactory$3", 3.class, null, null);
            }
        });
        return new JsonBProvider(jsonbProvider, contextResolvers);
    }

    public abstract Configuration getConfiguration(Message var1);

    public <T> ContextResolver<T> createContextResolver(Type contextType, Message m) {
        boolean isRequestor = MessageUtils.isRequestor((Message)m);
        Message requestMessage = isRequestor ? m.getExchange().getOutMessage() : m.getExchange().getInMessage();
        Message responseMessage = isRequestor ? m.getExchange().getInMessage() : m.getExchange().getOutMessage();
        Object ctProperty = null;
        ctProperty = responseMessage != null ? responseMessage.get((Object)"Content-Type") : requestMessage.get((Object)"Content-Type");
        MediaType mt = ctProperty != null ? JAXRSUtils.toMediaType(ctProperty.toString()) : MediaType.WILDCARD_TYPE;
        return this.createContextResolver(contextType, m, mt);
    }

    public <T> ContextResolver<T> createContextResolver(Type contextType, Message m, MediaType type) {
        Class<?> contextCls = InjectionUtils.getActualType(contextType);
        if (contextCls == null) {
            return null;
        }
        LinkedList candidates = new LinkedList();
        for (ProviderInfo<ContextResolver<?>> providerInfo : this.contextResolvers) {
            Type[] types;
            for (Type t : types = providerInfo.getProvider().getClass().getGenericInterfaces()) {
                List<MediaType> mTypes;
                Class<?> argCls;
                ParameterizedType pt;
                Type[] args;
                if (!(t instanceof ParameterizedType) || (args = (pt = (ParameterizedType)t).getActualTypeArguments()).length <= 0 || (argCls = InjectionUtils.getActualType(args[0])) == null || !argCls.isAssignableFrom(contextCls) || !JAXRSUtils.doMimeTypesIntersect(mTypes = JAXRSUtils.getProduceTypes(providerInfo.getProvider().getClass().getAnnotation(Produces.class)), type)) continue;
                this.injectContextValues(providerInfo, m);
                candidates.add(providerInfo.getProvider());
            }
        }
        if (candidates.isEmpty()) {
            return null;
        }
        if (candidates.size() == 1) {
            return (ContextResolver)candidates.get(0);
        }
        Collections.sort(candidates, new PriorityBasedClassComparator());
        return new ContextResolverProxy(candidates);
    }

    public <T> ContextProvider<T> createContextProvider(Type contextType, Message m) {
        Class<?> contextCls = InjectionUtils.getActualType(contextType);
        if (contextCls == null) {
            return null;
        }
        for (ProviderInfo<ContextProvider<?>> providerInfo : this.contextProviders) {
            Type[] types;
            for (Type t : types = providerInfo.getProvider().getClass().getGenericInterfaces()) {
                Class<?> argCls;
                ParameterizedType pt;
                Type[] args;
                if (!(t instanceof ParameterizedType) || (args = (pt = (ParameterizedType)t).getActualTypeArguments()).length <= 0 || (argCls = InjectionUtils.getActualType(args[0])) == null || !argCls.isAssignableFrom(contextCls)) continue;
                return providerInfo.getProvider();
            }
        }
        return null;
    }

    public <T> ParamConverter<T> createParameterHandler(Class<T> paramType, Type genericType, Annotation[] anns, Message m) {
        anns = anns != null ? anns : new Annotation[]{};
        for (ProviderInfo<ParamConverterProvider> providerInfo : this.paramConverters) {
            this.injectContextValues(providerInfo, m);
            ParamConverter converter = providerInfo.getProvider().getConverter(paramType, genericType, anns);
            if (converter != null) {
                return converter;
            }
            providerInfo.clearThreadLocalProxies();
        }
        return null;
    }

    protected <T> boolean handleRWMapper(ProviderInfo<T> em, Class<?> expectedType, Message m, Class<?> providerClass) {
        Class mapperClass = ClassHelper.getRealClass((Bus)this.bus, em.getOldProvider());
        Type[] types = null;
        types = m != null && MessageUtils.getContextualBoolean((Message)m, (String)IGNORE_TYPE_VARIABLES) ? new Type[]{mapperClass} : ProviderFactory.getGenericInterfaces(mapperClass, expectedType);
        for (Type t : types) {
            if (t instanceof ParameterizedType) {
                Type[] args;
                ParameterizedType pt = (ParameterizedType)t;
                for (Type arg : args = pt.getActualTypeArguments()) {
                    if (arg instanceof TypeVariable) {
                        TypeVariable var = (TypeVariable)arg;
                        Type[] bounds = var.getBounds();
                        boolean isResolved = false;
                        for (Type bound : bounds) {
                            Class<?> cls = InjectionUtils.getRawType(bound);
                            if (cls == null || !cls.isAssignableFrom(expectedType)) continue;
                            isResolved = true;
                            break;
                        }
                        return isResolved;
                    }
                    Class<?> actualClass = InjectionUtils.getRawType(arg);
                    if (actualClass == null) continue;
                    if (expectedType.isArray() && !actualClass.isArray()) {
                        expectedType = expectedType.getComponentType();
                    }
                    if (!actualClass.isAssignableFrom(expectedType) && actualClass != Object.class) continue;
                    return true;
                }
                continue;
            }
            if (!(t instanceof Class) || !providerClass.isAssignableFrom((Class)t)) continue;
            return true;
        }
        return false;
    }

    protected <T> boolean handleMapper(ProviderInfo<T> em, Class<?> expectedType, Message m, Class<?> providerClass, boolean injectContext) {
        return this.handleMapper(em, expectedType, m, providerClass, null, injectContext);
    }

    protected <T> boolean handleMapper(ProviderInfo<T> em, Class<?> expectedType, Message m, Class<?> providerClass, Class<?> commonBaseClass, boolean injectContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"handleMapper", (Object[])new Object[]{em, expectedType, m, providerClass, commonBaseClass, injectContext});
        }
        Class mapperClass = ClassHelper.getRealClass((Bus)this.bus, em.getOldProvider());
        Type[] types = null;
        types = m != null && MessageUtils.getContextualBoolean((Message)m, (String)IGNORE_TYPE_VARIABLES) ? new Type[]{mapperClass} : ProviderFactory.getGenericInterfaces(mapperClass, expectedType, commonBaseClass);
        for (Type t : types) {
            if (t instanceof ParameterizedType) {
                Type[] args;
                ParameterizedType pt = (ParameterizedType)t;
                for (Type arg : args = pt.getActualTypeArguments()) {
                    if (arg instanceof TypeVariable) {
                        TypeVariable var = (TypeVariable)arg;
                        Type[] bounds = var.getBounds();
                        boolean isResolved = false;
                        for (Type bound : bounds) {
                            Class<?> cls = InjectionUtils.getRawType(bound);
                            if (cls == null || cls != Object.class && !cls.isAssignableFrom(expectedType)) continue;
                            isResolved = true;
                            break;
                        }
                        if (!isResolved) {
                            return false;
                        }
                        if (injectContext) {
                            this.injectContextValues(em, m);
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"handleMapper return true", (Object[])new Object[0]);
                        }
                        return true;
                    }
                    Class<?> actualClass = InjectionUtils.getRawType(arg);
                    if (actualClass == null) continue;
                    if (expectedType.isArray() && !actualClass.isArray()) {
                        expectedType = expectedType.getComponentType();
                    }
                    if (!actualClass.isAssignableFrom(expectedType) && actualClass != Object.class) continue;
                    if (injectContext) {
                        this.injectContextValues(em, m);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"handleMapper return true", (Object[])new Object[0]);
                    }
                    return true;
                }
                continue;
            }
            if (!(t instanceof Class) || !providerClass.isAssignableFrom((Class)t)) continue;
            if (injectContext) {
                this.injectContextValues(em, m);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"handleMapper return true", (Object[])new Object[0]);
            }
            return true;
        }
        return false;
    }

    public <T> List<ReaderInterceptor> createMessageBodyReaderInterceptor(Class<T> bodyType, Type parameterType, Annotation[] parameterAnnotations, MediaType mediaType, Message m, boolean checkMbrNow, Set<String> names) {
        MessageBodyReader<T> mr = !checkMbrNow ? null : this.createMessageBodyReader(bodyType, parameterType, parameterAnnotations, mediaType, m);
        int size = this.readerInterceptors.size();
        if (mr != null || size > 0) {
            ReaderInterceptorMBR mbrReader = new ReaderInterceptorMBR(mr, m.getExchange().getInMessage());
            List<ReaderInterceptor> interceptors = null;
            if (size > 0) {
                interceptors = new ArrayList<ReaderInterceptor>(size + 1);
                List<ProviderInfo<T>> readers = ProviderFactory.getBoundFilters(this.readerInterceptors, names);
                for (ProviderInfo<T> p : readers) {
                    this.injectContextValues(p, m);
                    interceptors.add((ReaderInterceptor)p.getProvider());
                }
                interceptors.add(mbrReader);
            } else {
                interceptors = Collections.singletonList(mbrReader);
            }
            return interceptors;
        }
        return null;
    }

    public <T> List<WriterInterceptor> createMessageBodyWriterInterceptor(Class<T> bodyType, Type parameterType, Annotation[] parameterAnnotations, MediaType mediaType, Message m, Set<String> names) {
        MessageBodyWriter<T> mw = this.createMessageBodyWriter(bodyType, parameterType, parameterAnnotations, mediaType, m);
        int size = this.writerInterceptors.size();
        if (mw != null || size > 0) {
            WriterInterceptorMBW mbwWriter = new WriterInterceptorMBW(mw, m);
            List<WriterInterceptor> interceptors = null;
            if (size > 0) {
                interceptors = new ArrayList<WriterInterceptor>(size + 1);
                List<ProviderInfo<T>> writers = ProviderFactory.getBoundFilters(this.writerInterceptors, names);
                for (ProviderInfo<T> p : writers) {
                    this.injectContextValues(p, m);
                    interceptors.add((WriterInterceptor)p.getProvider());
                }
                interceptors.add(mbwWriter);
            } else {
                interceptors = Collections.singletonList(mbwWriter);
            }
            return interceptors;
        }
        return null;
    }

    public <T> MessageBodyReader<T> createMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, Message m) {
        if (this.providerCache != null) {
            for (ProviderInfo<MessageBodyReader<?>> ep : this.providerCache.getReaders(type, mediaType)) {
                if (!this.isReadable(ep, type, genericType, annotations, mediaType, m)) continue;
                return ep.getProvider();
            }
        }
        boolean checkAll = this.providerCache != null && this.providerCache.isCheckAllCandidates();
        LinkedList allCandidates = checkAll ? new LinkedList() : null;
        MessageBodyReader<?> selectedReader = null;
        for (ProviderInfo<MessageBodyReader<?>> providerInfo : this.messageReaders) {
            if (!this.matchesReaderMediaTypes(providerInfo, mediaType) || !this.handleMapper(providerInfo, type, m, MessageBodyReader.class, false)) continue;
            if (checkAll) {
                allCandidates.add(providerInfo);
            } else if (this.providerCache != null && this.providerCache.getReaders(type, mediaType).isEmpty()) {
                this.providerCache.putReaders(type, mediaType, Collections.singletonList(providerInfo));
            }
            if (selectedReader != null || !this.isReadable(providerInfo, type, genericType, annotations, mediaType, m)) continue;
            selectedReader = providerInfo.getProvider();
            if (checkAll) continue;
            return selectedReader;
        }
        if (checkAll) {
            this.providerCache.putReaders(type, mediaType, allCandidates);
        }
        return selectedReader;
    }

    public <T> MessageBodyWriter<T> createMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, Message m) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"createMessageBodyWriter ", (Object[])new Object[]{type, genericType, annotations, mediaType, m});
        }
        if (this.providerCache != null) {
            for (ProviderInfo<MessageBodyWriter<?>> ep : this.providerCache.getWriters(type, mediaType)) {
                if (!this.isWriteable(ep, type, genericType, annotations, mediaType, m)) continue;
                return ep.getProvider();
            }
        }
        boolean checkAll = this.providerCache != null && this.providerCache.isCheckAllCandidates();
        LinkedList allCandidates = checkAll ? new LinkedList() : null;
        MessageBodyWriter<?> selectedWriter = null;
        for (ProviderInfo<MessageBodyWriter<?>> providerInfo : this.messageWriters) {
            if (!this.matchesWriterMediaTypes(providerInfo, mediaType) || !this.handleMapper(providerInfo, type, m, MessageBodyWriter.class, false)) continue;
            if (checkAll) {
                allCandidates.add(providerInfo);
            } else if (this.providerCache != null && this.providerCache.getWriters(type, mediaType).isEmpty()) {
                this.providerCache.putWriters(type, mediaType, Collections.singletonList(providerInfo));
            }
            if (selectedWriter != null || !this.isWriteable(providerInfo, type, genericType, annotations, mediaType, m)) continue;
            selectedWriter = providerInfo.getProvider();
            if (checkAll) continue;
            return selectedWriter;
        }
        if (checkAll) {
            this.providerCache.putWriters(type, mediaType, allCandidates);
        }
        return selectedWriter;
    }

    protected void setBusProviders() {
        LinkedList<Object> extensions = new LinkedList<Object>();
        this.addBusExtension(extensions, MessageBodyReader.class, MessageBodyWriter.class, ExceptionMapper.class);
        if (!extensions.isEmpty()) {
            this.setProviders(true, true, extensions.toArray());
        }
    }

    private void addBusExtension(List<Object> extensions, Class<?> ... extClasses) {
        for (Class<?> extClass : extClasses) {
            Object ext = this.bus.getProperty(extClass.getName());
            if (!extClass.isInstance(ext)) continue;
            extensions.add(ext);
        }
        Object allProp = this.bus.getProperty(BUS_PROVIDERS_ALL);
        if (allProp instanceof List) {
            List all = (List)allProp;
            extensions.addAll(all);
        }
    }

    protected abstract void setProviders(boolean var1, boolean var2, Object ... var3);

    protected void setCommonProviders(List<ProviderInfo<? extends Object>> theProviders) {
        ArrayList newReaders = new ArrayList();
        ArrayList newWriters = new ArrayList();
        ArrayList newResolvers = new ArrayList();
        ArrayList newContextProviders = new ArrayList();
        ArrayList<ProviderInfo<ParamConverterProvider>> newParamConverters = new ArrayList<ProviderInfo<ParamConverterProvider>>();
        LinkedList readInts = new LinkedList();
        LinkedList writeInts = new LinkedList();
        for (ProviderInfo<? extends Object> provider : theProviders) {
            Class providerCls;
            if (ProviderFactory.filterContractSupported(provider, providerCls = ClassHelper.getRealClass((Bus)this.bus, (Object)provider.getProvider()), MessageBodyReader.class)) {
                this.addProviderToList(newReaders, provider);
            }
            if (ProviderFactory.filterContractSupported(provider, providerCls, MessageBodyWriter.class)) {
                this.addProviderToList(newWriters, provider);
            }
            if (ProviderFactory.filterContractSupported(provider, providerCls, ContextResolver.class)) {
                this.addProviderToList(newResolvers, provider);
            }
            if (ContextProvider.class.isAssignableFrom(providerCls)) {
                this.addProviderToList(newContextProviders, provider);
            }
            if (ProviderFactory.filterContractSupported(provider, providerCls, ReaderInterceptor.class)) {
                readInts.add(provider);
            }
            if (ProviderFactory.filterContractSupported(provider, providerCls, WriterInterceptor.class)) {
                writeInts.add(provider);
            }
            if (!ProviderFactory.filterContractSupported(provider, providerCls, ParamConverterProvider.class)) continue;
            this.addProviderToList(newParamConverters, provider);
        }
        if (newReaders.size() > 0) {
            this.addAndSortReaders(newReaders, false);
        }
        if (newWriters.size() > 0) {
            this.addAndSortWriters(newWriters, false);
        }
        if (newResolvers.size() > 0) {
            this.contextResolvers.addAndSortProviders(newResolvers, new ContextResolverComparator(), false);
        }
        if (newContextProviders.size() > 0) {
            this.contextProviders.addProviders(newContextProviders);
        }
        if (newParamConverters.size() > 0) {
            this.addAndSortParamConverters(newParamConverters, false);
        }
        ProviderFactory.mapInterceptorFilters(this.readerInterceptors, readInts, ReaderInterceptor.class, true);
        ProviderFactory.mapInterceptorFilters(this.writerInterceptors, writeInts, WriterInterceptor.class, true);
        this.injectContextProxies(this.messageReaders.get(), this.messageWriters.get(), this.contextResolvers.get(), this.paramConverters.get(), this.readerInterceptors.values(), this.writerInterceptors.values());
        this.checkParamConverterContexts();
    }

    private void checkParamConverterContexts() {
        for (ProviderInfo<ParamConverterProvider> providerInfo : this.paramConverters) {
            if (!providerInfo.contextsAvailable()) continue;
            this.paramConverterContextsAvailable = true;
        }
    }

    public boolean isParamConverterContextsAvailable() {
        return this.paramConverterContextsAvailable;
    }

    protected void injectContextValues(ProviderInfo<?> pi, Message m) {
        if (m != null) {
            InjectionUtils.injectContexts(pi.getProvider(), pi, m);
        }
    }

    protected void addProviderToList(List<?> list, ProviderInfo<?> provider) {
        List list2 = CastUtils.cast(list);
        for (ProviderInfo pi : list2) {
            if (pi.getProvider() != provider.getProvider()) continue;
            return;
        }
        list2.add(provider);
    }

    protected void injectContextProxies(Collection<?> ... providerLists) {
        for (Collection<?> list : providerLists) {
            Collection l2 = CastUtils.cast(list);
            for (ProviderInfo pi : l2) {
                this.injectContextProxiesIntoProvider(pi);
            }
        }
    }

    protected void injectContextProxiesIntoProvider(ProviderInfo<?> pi) {
        this.injectContextProxiesIntoProvider(pi, null);
    }

    void injectContextProxiesIntoProvider(ProviderInfo<?> pi, Application app) {
        if (pi.contextsAvailable()) {
            InjectionUtils.injectContextProxiesAndApplication(pi, pi.getProvider(), app, this);
            this.injectedProviders.add(pi);
        }
    }

    private void addAndSortReaders(List<ProviderInfo<MessageBodyReader<?>>> newReaders, boolean forceSort) {
        MessageBodyReaderComparator comparator = null;
        if (!this.customComparatorAvailable(MessageBodyReader.class)) {
            comparator = new MessageBodyReaderComparator(this.readerMediaTypesMap);
        }
        this.messageReaders.addAndSortProviders(newReaders, comparator, forceSort);
    }

    private void addAndSortWriters(List<ProviderInfo<MessageBodyWriter<?>>> newWriters, boolean forceSort) {
        MessageBodyWriterComparator comparator = null;
        if (!this.customComparatorAvailable(MessageBodyWriter.class)) {
            comparator = new MessageBodyWriterComparator(this.writerMediaTypesMap);
        }
        this.messageWriters.addAndSortProviders(newWriters, comparator, forceSort);
    }

    private void addAndSortParamConverters(List<ProviderInfo<ParamConverterProvider>> newParamConverters, boolean forceSort) {
        ParamConverterProviderComparator comparator = null;
        if (!this.customComparatorAvailable(ParamConverter.class)) {
            comparator = new ParamConverterProviderComparator();
        }
        this.paramConverters.addAndSortProviders(newParamConverters, comparator, forceSort);
    }

    private boolean customComparatorAvailable(Class<?> providerClass) {
        Type type2;
        ParameterizedType pt;
        Type type;
        return this.providerComparator != null && ((type = ((ParameterizedType)this.providerComparator.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0]) instanceof ParameterizedType ? (pt = (ParameterizedType)type).getRawType() == ProviderInfo.class && ((type2 = pt.getActualTypeArguments()[0]) == providerClass || type2 instanceof WildcardType || type2 instanceof ParameterizedType && ((ParameterizedType)type2).getRawType() == providerClass) : type == Object.class);
    }

    private <T> void doCustomSort(List<?> listOfProviders) {
        ProviderInfoClassComparator theProviderComparator = this.providerComparator;
        Type type = ((ParameterizedType)this.providerComparator.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0];
        if (type == Object.class) {
            theProviderComparator = new ProviderInfoClassComparator(theProviderComparator);
        }
        List<?> theProviders = listOfProviders;
        ProviderInfoClassComparator theComparator = theProviderComparator;
        theProviders.sort(theComparator);
    }

    static List<MediaType> getSortedProviderConsumeTypes(MessageBodyReader<?> mbr, Map<MessageBodyReader<?>, List<MediaType>> cache) {
        List<MediaType> mediaTypes = cache.get(mbr);
        if (mediaTypes == null) {
            mediaTypes = JAXRSUtils.getProviderConsumeTypes(mbr);
            mediaTypes = JAXRSUtils.sortMediaTypes(mediaTypes, null);
            cache.put(mbr, mediaTypes);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getSortedProviderConsumeTypes - cache miss - caching " + mbr + " = " + mediaTypes), (Object[])new Object[0]);
            }
        }
        return mediaTypes;
    }

    private <T> boolean matchesReaderMediaTypes(ProviderInfo<MessageBodyReader<?>> pi, MediaType mediaType) {
        MessageBodyReader<?> ep = pi.getProvider();
        List<MediaType> supportedMediaTypes = JAXRSUtils.getProviderConsumeTypes(ep);
        return JAXRSUtils.doMimeTypesIntersect(Collections.singletonList(mediaType), supportedMediaTypes);
    }

    private boolean isReadable(ProviderInfo<MessageBodyReader<?>> pi, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, Message m) {
        MessageBodyReader<?> ep = pi.getProvider();
        if (m.get((Object)ACTIVE_JAXRS_PROVIDER_KEY) != ep) {
            this.injectContextValues(pi, m);
            ep = pi.getProvider();
        }
        return ep.isReadable(type, genericType, annotations, mediaType);
    }

    static List<MediaType> getSortedProviderProduceTypes(MessageBodyWriter<?> mbw, Map<MessageBodyWriter<?>, List<MediaType>> cache) {
        List<MediaType> mediaTypes = cache.get(mbw);
        if (mediaTypes == null) {
            mediaTypes = JAXRSUtils.getProviderProduceTypes(mbw);
            mediaTypes = JAXRSUtils.sortMediaTypes(mediaTypes, "qs");
            cache.put(mbw, mediaTypes);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getSortedProviderProduceTypes - cache miss - caching " + mbw + " = " + mediaTypes), (Object[])new Object[0]);
            }
        }
        return mediaTypes;
    }

    private <T> boolean matchesWriterMediaTypes(ProviderInfo<MessageBodyWriter<?>> pi, MediaType mediaType) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"matchesWriterMediaTypes ", (Object[])new Object[]{pi, mediaType});
        }
        MessageBodyWriter<?> ep = pi.getProvider();
        List<MediaType> supportedMediaTypes = JAXRSUtils.getProviderProduceTypes(ep);
        return JAXRSUtils.doMimeTypesIntersect(Collections.singletonList(mediaType), supportedMediaTypes);
    }

    private boolean isWriteable(ProviderInfo<MessageBodyWriter<?>> pi, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, Message m) {
        MessageBodyWriter<?> ep = pi.getProvider();
        if (m.get((Object)ACTIVE_JAXRS_PROVIDER_KEY) != ep) {
            this.injectContextValues(pi, m);
            ep = pi.getProvider();
        }
        return ep.isWriteable(type, genericType, annotations, mediaType);
    }

    List<ProviderInfo<MessageBodyReader<?>>> getMessageReaders() {
        return Collections.unmodifiableList(this.messageReaders.get());
    }

    List<ProviderInfo<MessageBodyWriter<?>>> getMessageWriters() {
        return Collections.unmodifiableList(this.messageWriters.get());
    }

    public List<ProviderInfo<ContextResolver<?>>> getContextResolvers() {
        return Collections.unmodifiableList(this.contextResolvers.get());
    }

    public Iterable<ProviderInfo<ContextResolver<?>>> getContextResolversActual() {
        return this.contextResolvers;
    }

    public void registerUserProvider(Object provider) {
        this.setUserProviders(Collections.singletonList(provider));
    }

    public void setUserProviders(List<?> userProviders) {
        this.setProviders(true, false, userProviders.toArray());
    }

    public static int compareCustomStatus(ProviderInfo<?> p1, ProviderInfo<?> p2) {
        Boolean custom2;
        Boolean custom1 = p1.isCustom();
        int result = custom1.compareTo(custom2 = Boolean.valueOf(p2.isCustom())) * -1;
        if (result == 0 && custom1.booleanValue()) {
            Boolean busGlobal1 = p1.isBusGlobal();
            Boolean busGlobal2 = p2.isBusGlobal();
            result = busGlobal1.compareTo(busGlobal2);
        }
        return result;
    }

    static int comparePriorityStatus(Class<?> cl1, Class<?> cl2) {
        Integer value1 = AnnotationUtils.getBindingPriority(cl1);
        Integer value2 = AnnotationUtils.getBindingPriority(cl2);
        return value1.compareTo(value2);
    }

    public void clearThreadLocalProxies() {
        this.clearProxies(this.injectedProviders);
    }

    void clearProxies(Collection<?> ... lists) {
        for (Collection<?> list : lists) {
            Collection l2 = CastUtils.cast(list);
            for (ProviderInfo pi : l2) {
                pi.clearThreadLocalProxies();
            }
        }
    }

    public void clearProviders() {
        this.messageReaders.clear();
        this.messageWriters.clear();
        this.contextResolvers.clear();
        this.contextProviders.clear();
        this.readerInterceptors.clear();
        this.writerInterceptors.clear();
        this.paramConverters.clear();
    }

    public void setBus(Bus bus) {
        if (bus == null) {
            return;
        }
        for (ProviderInfo<MessageBodyReader<?>> providerInfo : this.messageReaders) {
            this.injectProviderProperty(providerInfo.getProvider(), "setBus", Bus.class, bus);
        }
    }

    @FFDCIgnore(value={Exception.class})
    private boolean injectProviderProperty(Object provider, String mName, Class<?> pClass, Object pValue) {
        try {
            Method m = provider.getClass().getMethod(mName, pClass);
            m.invoke(provider, pValue);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void setSchemaLocations(List<String> schemas) {
        for (ProviderInfo<MessageBodyReader<?>> providerInfo : this.messageReaders) {
            this.injectProviderProperty(providerInfo.getProvider(), "setSchemaLocations", List.class, schemas);
        }
    }

    protected static <T> List<ProviderInfo<T>> getBoundFilters(Map<NameKey, ProviderInfo<T>> boundFilters, Set<String> names) {
        if (boundFilters.isEmpty()) {
            return Collections.emptyList();
        }
        names = names == null ? Collections.emptySet() : names;
        MetadataMap map = new MetadataMap();
        for (Map.Entry<NameKey, ProviderInfo<T>> entry : boundFilters.entrySet()) {
            FilterProviderInfo fpi;
            String entryName = entry.getKey().getName();
            ProviderInfo<T> provider = entry.getValue();
            if (entryName.equals(DEFAULT_FILTER_NAME_BINDING)) {
                map.put(provider, Collections.emptyList());
                continue;
            }
            if (provider instanceof FilterProviderInfo && (fpi = (FilterProviderInfo)provider).isDynamic() && !names.containsAll(fpi.getNameBindings())) continue;
            map.add(provider, entryName);
        }
        LinkedList<ProviderInfo<T>> list = new LinkedList<ProviderInfo<T>>();
        for (Map.Entry entry : map.entrySet()) {
            List values = (List)entry.getValue();
            if (!names.containsAll(values)) continue;
            ProviderInfo provider = (ProviderInfo)entry.getKey();
            list.add(provider);
        }
        return list;
    }

    public void initProviders(List<ClassResourceInfo> cris) {
        Set<Object> set = this.getReadersWriters();
        for (Object o : set) {
            Object provider = ((ProviderInfo)o).getProvider();
            if (!(provider instanceof AbstractConfigurableProvider)) continue;
            ((AbstractConfigurableProvider)provider).init(cris);
        }
    }

    Set<Object> getReadersWriters() {
        HashSet<Object> set = new HashSet<Object>();
        set.addAll(this.messageReaders.get());
        set.addAll(this.messageWriters.get());
        return set;
    }

    public static ProviderFactory getInstance(Message m) {
        Endpoint e = m.getExchange().getEndpoint();
        Message outM = m.getExchange().getOutMessage();
        boolean isClient = outM != null && MessageUtils.isRequestor((Message)outM);
        String name = isClient ? CLIENT_FACTORY_NAME : SERVER_FACTORY_NAME;
        return (ProviderFactory)e.get((Object)name);
    }

    protected static int compareClasses(Object o1, Object o2) {
        return ProviderFactory.compareClasses(null, o1, o2);
    }

    protected static int compareClasses(Class<?> expectedCls, Object o1, Object o2) {
        Class<?> realClass2;
        Class cl1 = ClassHelper.getRealClass((Object)o1);
        Class cl2 = ClassHelper.getRealClass((Object)o2);
        Type[] types1 = ProviderFactory.getGenericInterfaces(cl1, expectedCls);
        Type[] types2 = ProviderFactory.getGenericInterfaces(cl2, expectedCls);
        if (types1.length == 0 && types2.length == 0) {
            return 0;
        }
        if (types1.length == 0 && types2.length > 0) {
            return 1;
        }
        if (types1.length > 0 && types2.length == 0) {
            return -1;
        }
        Class<?> realClass1 = InjectionUtils.getActualType(types1[0]);
        if (realClass1 == (realClass2 = InjectionUtils.getActualType(types2[0]))) {
            return 0;
        }
        if (realClass1.isAssignableFrom(realClass2)) {
            return 1;
        }
        if (realClass2.isAssignableFrom(realClass1)) {
            return -1;
        }
        return 0;
    }

    private static Type[] getGenericInterfaces(Class<?> cls, Class<?> expectedClass) {
        return ProviderFactory.getGenericInterfaces(cls, expectedClass, Object.class);
    }

    private static Type[] getGenericInterfaces(Class<?> cls, Class<?> expectedClass, Class<?> commonBaseCls) {
        Type[] types;
        Type genericSuperType;
        if (Object.class == cls) {
            return emptyType;
        }
        Type[] cachedTypes = ProviderFactory.getTypes(cls, expectedClass, commonBaseCls);
        if (cachedTypes != null) {
            return cachedTypes;
        }
        if (expectedClass != null && (genericSuperType = cls.getGenericSuperclass()) instanceof ParameterizedType) {
            Class<?> actualType = InjectionUtils.getActualType(genericSuperType);
            if (actualType != null && actualType.isAssignableFrom(expectedClass)) {
                Type[] tempTypes = new Type[]{genericSuperType};
                ProviderFactory.putTypes(cls, expectedClass, commonBaseCls, tempTypes);
                return tempTypes;
            }
            if (commonBaseCls != null && commonBaseCls != Object.class && commonBaseCls.isAssignableFrom(expectedClass) && commonBaseCls.isAssignableFrom(actualType) || expectedClass.isAssignableFrom(actualType)) {
                ProviderFactory.putTypes(cls, expectedClass, commonBaseCls, emptyType);
                return emptyType;
            }
        }
        if ((types = cls.getGenericInterfaces()).length > 0) {
            ProviderFactory.putTypes(cls, expectedClass, commonBaseCls, types);
            return types;
        }
        Type[] superGenericTypes = ProviderFactory.getGenericInterfaces(cls.getSuperclass(), expectedClass, commonBaseCls);
        ProviderFactory.putTypes(cls, expectedClass, commonBaseCls, superGenericTypes);
        return superGenericTypes;
    }

    /*
     * WARNING - void declaration
     */
    public static ProviderInfo<? extends Object> createProviderFromConstructor(Constructor<?> c, Map<Class<?>, Object> values, Bus theBus, boolean checkContexts, boolean custom) {
        Map proxiesMap = CastUtils.cast((Map)((Map)theBus.getProperty("jaxrs-constructor-proxy-map")));
        Map existingProxies = null;
        if (proxiesMap != null) {
            existingProxies = (Map)proxiesMap.get(c.getDeclaringClass());
        }
        Class<?>[] paramTypes = c.getParameterTypes();
        Object[] cArgs = ResourceUtils.createConstructorArguments(c, null, false, values);
        if (existingProxies != null && existingProxies.size() <= paramTypes.length) {
            for (int i = 0; i < paramTypes.length; ++i) {
                if (!(cArgs[i] instanceof ThreadLocalProxy)) continue;
                cArgs[i] = existingProxies.get(paramTypes[i]);
            }
        }
        Object instance = null;
        try {
            instance = c.newInstance(cArgs);
        }
        catch (Throwable throwable) {
            void ex;
            FFDCFilter.processException((Throwable)throwable, (String)"org.apache.cxf.jaxrs.provider.ProviderFactory", (String)"1645", null, (Object[])new Object[]{c, values, theBus, checkContexts, custom});
            throw new RuntimeException("Resource or provider class " + c.getDeclaringClass().getName() + " can not be instantiated", (Throwable)ex);
        }
        LinkedHashMap proxies = new LinkedHashMap();
        for (int i = 0; i < paramTypes.length; ++i) {
            if (!(cArgs[i] instanceof ThreadLocalProxy)) continue;
            ThreadLocalProxy proxy = (ThreadLocalProxy)cArgs[i];
            proxies.put(paramTypes[i], proxy);
        }
        boolean isApplication = Application.class.isAssignableFrom(c.getDeclaringClass());
        if (isApplication) {
            return new ApplicationInfo((Application)instance, proxies, theBus);
        }
        return new ProviderInfo<Object>(instance, proxies, theBus, checkContexts, custom);
    }

    protected static <T> void mapInterceptorFilters(Map<NameKey, ProviderInfo<T>> map, List<ProviderInfo<T>> filters, Class<?> providerCls, boolean ascending) {
        for (ProviderInfo<T> p : filters) {
            Set<String> names = ProviderFactory.getFilterNameBindings(p);
            int priority = ProviderFactory.getFilterPriority(p, providerCls);
            for (String name : names) {
                map.put(new NameKey(name, priority, p.getClass(), p), p);
            }
        }
    }

    protected static Set<String> getFilterNameBindings(ProviderInfo<?> p) {
        if (p instanceof FilterProviderInfo) {
            return ((FilterProviderInfo)p).getNameBindings();
        }
        return ProviderFactory.getFilterNameBindings(p.getBus(), p.getProvider());
    }

    protected static Set<String> getFilterNameBindings(Bus bus, Object provider) {
        Class pClass = ClassHelper.getRealClass((Bus)bus, (Object)provider);
        Set<String> names = AnnotationUtils.getNameBindings(pClass.getAnnotations());
        if (names.isEmpty()) {
            names = Collections.singleton(DEFAULT_FILTER_NAME_BINDING);
        }
        return names;
    }

    protected static int getFilterPriority(ProviderInfo<?> p, Class<?> providerCls) {
        return p instanceof FilterProviderInfo ? ((FilterProviderInfo)p).getPriority(providerCls) : AnnotationUtils.getBindingPriority(p.getProvider().getClass());
    }

    protected static boolean filterContractSupported(ProviderInfo<?> provider, Class<?> providerCls, Class<?> contract) {
        boolean result = false;
        if (contract.isAssignableFrom(providerCls)) {
            Set<Class<?>> actualContracts = null;
            if (provider instanceof FilterProviderInfo) {
                actualContracts = ((FilterProviderInfo)provider).getSupportedContracts();
            }
            result = actualContracts != null ? actualContracts.contains(contract) : true;
        }
        return result;
    }

    protected List<ProviderInfo<? extends Object>> prepareProviders(boolean custom, boolean busGlobal, Object[] providers, ProviderInfo<Application> application) {
        ArrayList<ProviderInfo<? extends Object>> theProviders = new ArrayList<ProviderInfo<? extends Object>>(providers.length);
        Map beanCustomizerContexts = (Map)this.getBus().getProperty("ENDPOINT_BEANCUSTOMIZER_CONTEXTOBJ");
        for (Object o : providers) {
            Object newProviderInstance;
            Object proxyObject;
            if (o == null) continue;
            ProviderInfo<Object> pi = null;
            if (o instanceof Constructor) {
                Map values = CastUtils.cast(application == null ? null : Collections.singletonMap(Application.class, application.getProvider()));
                pi = ProviderFactory.createProviderFromConstructor((Constructor)o, values, this.getBus(), true, custom);
            } else if (o instanceof ProviderInfo) {
                pi = (ProviderInfo<Object>)o;
            } else {
                pi = new ProviderInfo<Object>(o, this.getBus(), custom);
                pi.setBusGlobal(busGlobal);
            }
            JaxRsFactoryBeanCustomizer beanCustomizer = InjectionRuntimeContextHelper.findBeanCustomizer(o.getClass(), this.getBus());
            if (!(beanCustomizer == null || (proxyObject = beanCustomizer.onSetupProviderProxy(o, beanCustomizerContexts.get(CustomizerUtils.createCustomizerKey(beanCustomizer)))) == null || proxyObject == o && proxyObject.equals(o))) {
                pi.setProvider(proxyObject);
            }
            if (beanCustomizer != null && DynamicFeature.class.isAssignableFrom(pi.getProvider().getClass()) && (newProviderInstance = beanCustomizer.onSingletonProviderInit(pi.getProvider(), beanCustomizerContexts.get(Integer.toString(beanCustomizer.hashCode())), null)) != null) {
                pi.setProvider(newProviderInstance);
            }
            theProviders.add(pi);
        }
        return theProviders;
    }

    public MessageBodyWriter<?> getDefaultJaxbWriter() {
        for (ProviderInfo<MessageBodyWriter<?>> providerInfo : this.messageWriters) {
            Class<?> cls = providerInfo.getProvider().getClass();
            if (!cls.getName().equals(JAXB_PROVIDER_NAME)) continue;
            return providerInfo.getProvider();
        }
        return null;
    }

    public Comparator<?> getProviderComparator() {
        return this.providerComparator;
    }

    public void setProviderComparator(Comparator<?> providerComparator) {
        this.providerComparator = providerComparator;
        this.addAndSortReaders(null, true);
        this.addAndSortWriters(null, true);
        this.addAndSortParamConverters(null, true);
    }

    private static void poll() {
        ClassWeakReference key;
        while ((key = (ClassWeakReference)referenceQueue.poll()) != null) {
            genericInterfacesCache.remove(key.getOwningKey());
        }
    }

    private static Type[] getTypes(Class<?> cls, Class<?> expectedCls, Class<?> commonBaseCls) {
        ProviderFactory.poll();
        return genericInterfacesCache.get(new ClassesKey(cls, expectedCls, commonBaseCls));
    }

    private static void putTypes(Class<?> cls, Class<?> expectedCls, Class<?> commonBaseCls, Type[] types) {
        ProviderFactory.poll();
        genericInterfacesCache.put(new ClassesKey(referenceQueue, cls, expectedCls, commonBaseCls), types);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ClassWeakReference
    extends WeakReference<Class<?>> {
        private final int hash;
        private final ClassesKey owningKey;
        static final long serialVersionUID = -386411984920827242L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ClassWeakReference(Class<?> referent, ClassesKey owningKey) {
            super(referent);
            this.owningKey = owningKey;
            this.hash = referent.hashCode();
        }

        ClassWeakReference(Class<?> referent, ClassesKey owningKey, ReferenceQueue<Class<?>> referenceQueue) {
            super(referent, referenceQueue);
            this.owningKey = owningKey;
            this.hash = referent.hashCode();
        }

        ClassesKey getOwningKey() {
            return this.owningKey;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ClassWeakReference) {
                return this.get() == ((ClassWeakReference)obj).get();
            }
            return false;
        }

        public String toString() {
            Class referent = (Class)this.get();
            return "ClassWeakReference: " + (referent == null ? null : referent.getName());
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.provider.ProviderFactory$ClassWeakReference", ClassWeakReference.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ClassesKey {
        private final ClassWeakReference[] classes;
        private final int hash;
        static final long serialVersionUID = 5609599373120446619L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ClassesKey(Class<?> ... cl) {
            int length = cl.length;
            this.classes = new ClassWeakReference[length];
            int hashCode = 0;
            for (int i = 0; i < length; ++i) {
                if (cl[i] == null) continue;
                this.classes[i] = new ClassWeakReference(cl[i], this);
                hashCode += cl[i].hashCode();
            }
            this.hash = hashCode;
        }

        ClassesKey(ReferenceQueue<Class<?>> referenceQueue, Class<?> ... cl) {
            int length = cl.length;
            this.classes = new ClassWeakReference[length];
            int hashCode = 0;
            for (int i = 0; i < length; ++i) {
                if (cl[i] == null) continue;
                this.classes[i] = new ClassWeakReference(cl[i], this, referenceQueue);
                hashCode += cl[i].hashCode();
            }
            this.hash = hashCode;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClassesKey other = (ClassesKey)obj;
            return Arrays.equals(this.classes, other.classes);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.provider.ProviderFactory$ClassesKey", ClassesKey.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected static class NameKeyMap<T>
    extends TreeMap<NameKey, T> {
        private static final long serialVersionUID = -4352258671270502204L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public NameKeyMap(Comparator<ProviderInfo<?>> comparator, boolean ascending) {
            super(new NameKeyComparator(comparator, ascending));
        }

        public NameKeyMap(boolean ascending) {
            super(new NameKeyComparator(ascending));
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.provider.ProviderFactory$NameKeyMap", NameKeyMap.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected static class NameKeyComparator
    extends AbstractPriorityComparator
    implements Comparator<NameKey> {
        private final Comparator<ProviderInfo<?>> comparator;
        static final long serialVersionUID = -3179128671039516446L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public NameKeyComparator(boolean ascending) {
            this(null, ascending);
        }

        public NameKeyComparator(Comparator<ProviderInfo<?>> comparator, boolean ascending) {
            super(ascending);
            this.comparator = comparator;
        }

        @Override
        public int compare(NameKey key1, NameKey key2) {
            int result = this.compare(key1.getPriority(), key2.getPriority());
            if (result != 0) {
                return result;
            }
            if (this.comparator != null && (result = this.comparator.compare(key1.getProviderInfo(), key2.getProviderInfo())) != 0) {
                return result;
            }
            return this.compare(key1.hashCode(), key2.hashCode());
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.provider.ProviderFactory$NameKeyComparator", NameKeyComparator.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected static class NameKey {
        private String name;
        private Integer priority;
        private Class<?> providerCls;
        private ProviderInfo<?> providerInfo;
        static final long serialVersionUID = -498958730904903413L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public NameKey(String name, int priority, Class<?> providerCls) {
            this(name, priority, providerCls, null);
        }

        public NameKey(String name, int priority, Class<?> providerCls, ProviderInfo<?> provider) {
            this.name = name;
            this.priority = priority;
            this.providerCls = providerCls;
            this.providerInfo = provider;
        }

        public String getName() {
            return this.name;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public ProviderInfo<?> getProviderInfo() {
            return this.providerInfo;
        }

        public boolean equals(Object o) {
            if (!(o instanceof NameKey)) {
                return false;
            }
            NameKey other = (NameKey)o;
            return this.name.equals(other.name) && this.priority.equals(other.priority) && this.providerCls == other.providerCls;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public String toString() {
            return this.name + ":" + this.priority;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.provider.ProviderFactory$NameKey", NameKey.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class ContextResolverProxy<T>
    implements ContextResolver<T> {
        private List<ContextResolver<T>> candidates;
        static final long serialVersionUID = -2020114646517436559L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ContextResolverProxy(List<ContextResolver<T>> candidates) {
            this.candidates = candidates;
        }

        public T getContext(Class<?> cls) {
            for (ContextResolver<T> resolver : this.candidates) {
                Object context = resolver.getContext(cls);
                if (context == null) continue;
                return (T)context;
            }
            return null;
        }

        public List<ContextResolver<T>> getResolvers() {
            return this.candidates;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.provider.ProviderFactory$ContextResolverProxy", ContextResolverProxy.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected static class BindingPriorityComparator<T>
    extends AbstractPriorityComparator
    implements Comparator<ProviderInfo<T>> {
        private final Class<T> providerCls;
        static final long serialVersionUID = 4133762782533825089L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public BindingPriorityComparator(Class<T> providerCls, boolean ascending) {
            super(ascending);
            this.providerCls = providerCls;
        }

        @Override
        public int compare(ProviderInfo<T> p1, ProviderInfo<T> p2) {
            return this.compare(ProviderFactory.getFilterPriority(p1, this.providerCls), ProviderFactory.getFilterPriority(p2, this.providerCls));
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.provider.ProviderFactory$BindingPriorityComparator", BindingPriorityComparator.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected static class AbstractPriorityComparator {
        private boolean ascending;
        static final long serialVersionUID = -3215202783807796478L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        protected AbstractPriorityComparator(boolean ascending) {
            this.ascending = ascending;
        }

        protected int compare(Integer b1Value, Integer b2Value) {
            int result = b1Value.compareTo(b2Value);
            return this.ascending ? result : result * -1;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.provider.ProviderFactory$AbstractPriorityComparator", AbstractPriorityComparator.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class PriorityBasedClassComparator
    extends ClassComparator {
        static final long serialVersionUID = -7184032540030613352L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        PriorityBasedClassComparator() {
        }

        PriorityBasedClassComparator(Class<?> expectedCls) {
            super(expectedCls);
        }

        @Override
        public int compare(Object em1, Object em2) {
            int result = super.compare(em1, em2);
            if (result == 0) {
                result = ProviderFactory.comparePriorityStatus(em1.getClass(), em2.getClass());
            }
            return result;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.provider.ProviderFactory$PriorityBasedClassComparator", PriorityBasedClassComparator.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class ProviderInfoClassComparator
    implements Comparator<ProviderInfo<?>> {
        Comparator<Object> comp;
        boolean defaultComp;
        static final long serialVersionUID = 8093217235923201103L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ProviderInfoClassComparator(Class<?> expectedCls) {
            this.comp = new ClassComparator(expectedCls);
            this.defaultComp = true;
        }

        public ProviderInfoClassComparator(Comparator<Object> comp) {
            this.comp = comp;
        }

        @Override
        public int compare(ProviderInfo<?> p1, ProviderInfo<?> p2) {
            int result = this.comp.compare(p1.getProvider(), p2.getProvider());
            if (result == 0 && this.defaultComp) {
                result = ProviderFactory.compareCustomStatus(p1, p2);
            }
            return result;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.provider.ProviderFactory$ProviderInfoClassComparator", ProviderInfoClassComparator.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class ClassComparator
    implements Comparator<Object> {
        private Class<?> expectedCls;
        static final long serialVersionUID = -9159606144959439425L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ClassComparator() {
        }

        public ClassComparator(Class<?> expectedCls) {
            this.expectedCls = expectedCls;
        }

        @Override
        public int compare(Object em1, Object em2) {
            return ProviderFactory.compareClasses(this.expectedCls, em1, em2);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.provider.ProviderFactory$ClassComparator", ClassComparator.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ContextResolverComparator
    implements Comparator<ProviderInfo<ContextResolver<?>>> {
        static final long serialVersionUID = 5038808953357812851L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ContextResolverComparator() {
        }

        @Override
        public int compare(ProviderInfo<ContextResolver<?>> p1, ProviderInfo<ContextResolver<?>> p2) {
            ContextResolver<?> e1 = p1.getOldProvider();
            ContextResolver<?> e2 = p2.getOldProvider();
            List<MediaType> types1 = JAXRSUtils.sortMediaTypes(JAXRSUtils.getProduceTypes(e1.getClass().getAnnotation(Produces.class)), "qs");
            List<MediaType> types2 = JAXRSUtils.sortMediaTypes(JAXRSUtils.getProduceTypes(e2.getClass().getAnnotation(Produces.class)), "qs");
            return JAXRSUtils.compareSortedMediaTypes(types1, types2, "qs");
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.provider.ProviderFactory$ContextResolverComparator", ContextResolverComparator.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ParamConverterProviderComparator
    implements Comparator<ProviderInfo<ParamConverterProvider>> {
        static final long serialVersionUID = 3804596292526392520L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ParamConverterProviderComparator() {
        }

        @Override
        public int compare(ProviderInfo<ParamConverterProvider> p1, ProviderInfo<ParamConverterProvider> p2) {
            ParamConverterProvider e2;
            ParamConverterProvider e1 = p1.getOldProvider();
            int result = ProviderFactory.compareClasses(e1, e2 = p2.getOldProvider());
            if (result != 0) {
                return result;
            }
            return ProviderFactory.comparePriorityStatus(p1.getProvider().getClass(), p2.getProvider().getClass());
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.provider.ProviderFactory$ParamConverterProviderComparator", ParamConverterProviderComparator.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class MessageBodyWriterComparator
    implements Comparator<ProviderInfo<MessageBodyWriter<?>>> {
        private final Map<MessageBodyWriter<?>, List<MediaType>> cache;
        static final long serialVersionUID = 6185920671295486424L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private MessageBodyWriterComparator(Map<MessageBodyWriter<?>, List<MediaType>> cache) {
            this.cache = cache;
        }

        @Override
        public int compare(ProviderInfo<MessageBodyWriter<?>> p1, ProviderInfo<MessageBodyWriter<?>> p2) {
            List<MediaType> types2;
            MessageBodyWriter<?> e2;
            MessageBodyWriter<?> e1 = p1.getOldProvider();
            int result = ProviderFactory.compareClasses(e1, e2 = p2.getOldProvider());
            if (result != 0) {
                return result;
            }
            List<MediaType> types1 = ProviderFactory.getSortedProviderProduceTypes(e1, this.cache);
            result = JAXRSUtils.compareSortedMediaTypes(types1, types2 = ProviderFactory.getSortedProviderProduceTypes(e2, this.cache), "qs");
            if (result != 0) {
                return result;
            }
            result = ProviderFactory.compareCustomStatus(p1, p2);
            if (result != 0) {
                return result;
            }
            return ProviderFactory.comparePriorityStatus(p1.getProvider().getClass(), p2.getProvider().getClass());
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.provider.ProviderFactory$MessageBodyWriterComparator", MessageBodyWriterComparator.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class MessageBodyReaderComparator
    implements Comparator<ProviderInfo<MessageBodyReader<?>>> {
        private final Map<MessageBodyReader<?>, List<MediaType>> cache;
        static final long serialVersionUID = 6873204671968171337L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private MessageBodyReaderComparator(Map<MessageBodyReader<?>, List<MediaType>> cache) {
            this.cache = cache;
        }

        @Override
        public int compare(ProviderInfo<MessageBodyReader<?>> p1, ProviderInfo<MessageBodyReader<?>> p2) {
            List<MediaType> types2;
            MessageBodyReader<?> e1 = p1.getOldProvider();
            MessageBodyReader<?> e2 = p2.getOldProvider();
            List<MediaType> types1 = ProviderFactory.getSortedProviderConsumeTypes(e1, this.cache);
            int result = JAXRSUtils.compareSortedMediaTypes(types1, types2 = ProviderFactory.getSortedProviderConsumeTypes(e2, this.cache), null);
            if (result != 0) {
                return result;
            }
            result = ProviderFactory.compareClasses(e1, e2);
            if (result != 0) {
                return result;
            }
            result = ProviderFactory.compareCustomStatus(p1, p2);
            if (result != 0) {
                return result;
            }
            return ProviderFactory.comparePriorityStatus(p1.getProvider().getClass(), p2.getProvider().getClass());
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.provider.ProviderFactory$MessageBodyReaderComparator", MessageBodyReaderComparator.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected class AtomicReferenceProviderList<T>
    implements Iterable<ProviderInfo<T>> {
        private final AtomicReference<List<ProviderInfo<T>>> referent = new AtomicReference(Collections.emptyList());
        static final long serialVersionUID = -1278680460486519436L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public void addAndSortProviders(List<ProviderInfo<T>> providers, Comparator<ProviderInfo<T>> comparator, boolean forceSort) {
            List<ProviderInfo<T>> currentProviders = null;
            List<ProviderInfo<T>> newProviders = null;
            do {
                currentProviders = this.referent.get();
                if (providers == null) {
                    if (currentProviders.size() <= 1) {
                        return;
                    }
                    newProviders = new ArrayList<ProviderInfo<T>>(currentProviders);
                } else if (currentProviders.isEmpty()) {
                    newProviders = providers;
                } else {
                    newProviders = new ArrayList<ProviderInfo<T>>(currentProviders);
                    for (ProviderInfo<T> provider : providers) {
                        ProviderFactory.this.addProviderToList(newProviders, provider);
                    }
                }
                int newSize = newProviders.size();
                if (!forceSort && newSize == currentProviders.size()) {
                    return;
                }
                if (newSize <= 1) continue;
                if (comparator != null) {
                    newProviders.sort(comparator);
                    continue;
                }
                ProviderFactory.this.doCustomSort(newProviders);
            } while (!this.referent.compareAndSet(currentProviders, newProviders));
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                StringBuilder msg = new StringBuilder("sortProviders - sorted list:");
                for (int i = 0; i < newProviders.size(); ++i) {
                    msg.append(" (" + i + ") " + newProviders.get(i).getProvider());
                }
                Tr.debug((TraceComponent)tc, (String)msg.toString(), (Object[])new Object[0]);
            }
        }

        public void addProviders(List<ProviderInfo<T>> providers) {
            List<ProviderInfo<T>> currentProviders = null;
            List<ProviderInfo<T>> newProviders = null;
            do {
                if ((currentProviders = this.referent.get()).isEmpty()) {
                    newProviders = providers;
                    continue;
                }
                newProviders = new ArrayList<ProviderInfo<T>>(currentProviders);
                for (ProviderInfo<T> provider : providers) {
                    ProviderFactory.this.addProviderToList(newProviders, provider);
                }
            } while (!this.referent.compareAndSet(currentProviders, newProviders));
        }

        @Override
        public Iterator<ProviderInfo<T>> iterator() {
            return this.referent.get().iterator();
        }

        public List<ProviderInfo<T>> get() {
            return this.referent.get();
        }

        public void clear() {
            this.referent.set(Collections.emptyList());
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.provider.ProviderFactory$AtomicReferenceProviderList", AtomicReferenceProviderList.class, null, null);
        }
    }
}

