/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.internal;

import com.ibm.websphere.application.ApplicationMBean;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.app.manager.ApplicationManager;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.management.NotificationBroadcasterSupport;

@Trivial
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public final class ApplicationConfig {
    private static final TraceComponent tc = Tr.register(ApplicationConfig.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.internal.ApplicationConfig");
    private final String _configPid;
    private final Dictionary<String, ?> _config;
    private final ApplicationManager _applicationManager;
    private final String _location;
    private final String _type;
    private final String _name;
    private NotificationBroadcasterSupport _notificationBroadcasterSupport;
    private static boolean ONE_TIME_JANDEX_MSGS_DISPLAYED = false;
    static final long serialVersionUID = -4187886726735056001L;

    public ApplicationConfig(String configPid, Dictionary<String, ?> config, ApplicationManager applicationManager) {
        int index;
        this._configPid = configPid;
        this._config = config;
        this._applicationManager = applicationManager;
        this._location = (String)config.get("location");
        String type = (String)config.get("type");
        if (type == null && this._location != null && (index = this._location.lastIndexOf(46)) != -1) {
            type = this._location.substring(index + 1);
        }
        this._type = type;
        String name = (String)config.get("name");
        if ((name == null || "".equals(name)) && this._location != null) {
            int endIndex;
            int startIndex = this._location.lastIndexOf(47);
            if (startIndex == -1) {
                startIndex = this._location.lastIndexOf(92);
            }
            name = (endIndex = this._location.lastIndexOf(46)) > ++startIndex ? this._location.substring(startIndex, endIndex) : this._location.substring(startIndex);
        }
        this._name = name;
        this.displayJandexMessages();
    }

    private void displayJandexMessages() {
        Object application_useJandex;
        boolean appMgr_useJandex = this._applicationManager.getUseJandex();
        if (!ONE_TIME_JANDEX_MSGS_DISPLAYED) {
            if (appMgr_useJandex) {
                Tr.info((TraceComponent)tc, (String)"APPLICATION_JANDEX_ENABLED_ALL", (Object[])new Object[0]);
            }
            ONE_TIME_JANDEX_MSGS_DISPLAYED = true;
        }
        if (this._config != null && (application_useJandex = this._config.get("useJandex")) instanceof Boolean) {
            if (((Boolean)application_useJandex).booleanValue()) {
                Tr.info((TraceComponent)tc, (String)"APPLICATION_JANDEX_ENABLED", (Object[])new Object[]{this._name});
            } else {
                Tr.info((TraceComponent)tc, (String)"APPLICATION_JANDEX_DISABLED", (Object[])new Object[]{this._name});
            }
            return;
        }
        if (appMgr_useJandex) {
            Tr.info((TraceComponent)tc, (String)"APPLICATION_JANDEX_ENABLED", (Object[])new Object[]{this._name});
        }
    }

    public void setMBeanNotifier(NotificationBroadcasterSupport broadcaster) {
        this._notificationBroadcasterSupport = broadcaster;
    }

    public NotificationBroadcasterSupport getMBeanNotifier() {
        return this._notificationBroadcasterSupport;
    }

    public String getLocation() {
        return this._location;
    }

    public String getType() {
        return this._type;
    }

    public String getName() {
        return this._name;
    }

    public String getLabel() {
        return ("rar".equals(this._type) ? "resource adapter" : "app") + " " + this._name;
    }

    public String getConfigPid() {
        return this._configPid;
    }

    public Object getConfigProperty(String propName) {
        return this._config.get(propName);
    }

    public boolean isValid() {
        String location = this.getLocation();
        String type = this.getType();
        String name = this.getName();
        return location != null && type != null && name != null;
    }

    public Hashtable<String, Object> getServiceProperties() {
        Dictionary<String, ?> config = this._config;
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        for (String key : Collections.list(config.keys())) {
            result.put(key, config.get(key));
        }
        result.put("type", this.getType());
        result.put("name", this.getName());
        return result;
    }

    public String getMBeanName() {
        StringBuilder builder = new StringBuilder("WebSphere:service=");
        builder.append(ApplicationMBean.class.getName());
        builder.append(",name=");
        builder.append(this.getName());
        return builder.toString();
    }

    public boolean isAutoStarted() {
        Object result;
        Dictionary<String, ?> config = this._config;
        if (config != null && (result = config.get("autoStart")) instanceof Boolean) {
            return (Boolean)result;
        }
        return true;
    }

    public boolean getUseJandex() {
        Object result;
        if (this._config != null && (result = this._config.get("useJandex")) instanceof Boolean) {
            return (Boolean)result;
        }
        return this._applicationManager.getUseJandex();
    }

    void describe(StringBuilder sb) {
        sb.append("app[" + this.getName() + "," + this.getType() + "]");
    }
}

