/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transaction.services;

import com.ibm.tx.config.ConfigurationProvider;
import com.ibm.tx.config.RuntimeMetaDataProvider;
import com.ibm.tx.jta.config.DefaultConfigurationProvider;
import com.ibm.tx.jta.embeddable.TransactionSettingsProvider;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transaction.services.LibertyRuntimeMetaDataProvider;
import com.ibm.ws.transaction.services.TMRecoveryService;
import com.ibm.ws.transaction.services.TransactionManagerService;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import com.ibm.wsspi.resource.ResourceFactory;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JTMConfigurationProvider
extends DefaultConfigurationProvider
implements ConfigurationProvider {
    private static final TraceComponent tc = Tr.register(JTMConfigurationProvider.class, (String)"transaction", (String)"com.ibm.ws.transaction.services.TransactionMessages");
    private WsLocationAdmin locationService;
    private RuntimeMetaDataProvider _runtimeMetaDataProvider;
    private static Dictionary<String, Object> _props;
    ComponentContext _cc;
    private static String logDir;
    private static final String defaultLogDir = "$(server.output.dir)/tranlog";
    private boolean activateHasBeenCalled = false;
    private final ConcurrentServiceReferenceSet<TransactionSettingsProvider> _transactionSettingsProviders = new ConcurrentServiceReferenceSet("transactionSettingsProvider");
    private static final AtomicServiceReference<ResourceFactory> dataSourceFactoryRef;
    private static boolean _isSQLRecoveryLog;
    private ResourceFactory _theDataSourceFactory = null;
    private String _recoveryIdentity = null;
    private String _recoveryGroup = null;
    private TransactionManagerService tmsRef = null;
    private byte[] _applId;
    static final long serialVersionUID = -9078475044562746093L;

    protected void activate(ComponentContext cc) {
        this._runtimeMetaDataProvider = new LibertyRuntimeMetaDataProvider(this);
        this.activateHasBeenCalled = true;
        this._transactionSettingsProviders.activate(cc);
        this._cc = cc;
        _props = this._cc.getProperties();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("activate  properties set to " + _props), (Object[])new Object[0]);
        }
        this.checkDataSourceRef();
        if (_isSQLRecoveryLog) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"activate  working with Tran Log in an RDBMS", (Object[])new Object[0]);
            }
            ServiceReference serviceRef = dataSourceFactoryRef.getReference();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("pre-activate  datasourceFactory ref " + dataSourceFactoryRef + ", underlying reference: " + serviceRef), (Object[])new Object[0]);
            }
            dataSourceFactoryRef.activate(this._cc);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("post-activate  datasourceFactory ref " + dataSourceFactoryRef), (Object[])new Object[0]);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("retrieved datasourceFactory service ref " + serviceRef), (Object[])new Object[0]);
            }
            if (serviceRef != null && this.tmsRef != null) {
                this.tmsRef.doStartup(this, _isSQLRecoveryLog);
            }
        } else {
            this.getTransactionLogDirectory();
            if (this.tmsRef != null) {
                this.tmsRef.doStartup(this, _isSQLRecoveryLog);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("activate  retrieved datasourceFactory is " + this._theDataSourceFactory), (Object[])new Object[0]);
        }
    }

    protected void deactivate(int reason, ComponentContext cc, Map<String, Object> properties) {
        this._transactionSettingsProviders.deactivate(cc);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"deactivate", (Object[])new Object[0]);
        }
    }

    protected void modified(Map<?, ?> newProperties) {
        _props = newProperties instanceof Dictionary ? (Dictionary<Object, Object>)((Object)newProperties) : new Hashtable(newProperties);
    }

    protected synchronized void setLocationService(WsLocationAdmin locSvc) {
        this.locationService = locSvc;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setLocationService, locSvc " + locSvc), (Object[])new Object[0]);
        }
    }

    protected synchronized void unsetLocationService(WsLocationAdmin locSvc) {
        if (locSvc == this.locationService) {
            this.locationService = null;
        }
    }

    protected void setDataSourceFactory(ServiceReference<ResourceFactory> ref) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("pre-setReference  datasourceFactory ref " + dataSourceFactoryRef), (Object[])new Object[0]);
        }
        dataSourceFactoryRef.setReference(ref);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("post-setReference  datasourceFactory ref " + dataSourceFactoryRef), (Object[])new Object[0]);
        }
        if (!this.activateHasBeenCalled && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setDataSourceFactory has been called before activate", (Object[])new Object[0]);
        }
        if (this._cc != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"setDataSourceFactory and activate have been called, initiate recovery", (Object[])new Object[0]);
            }
            if (this.tmsRef != null) {
                this.tmsRef.doStartup(this, _isSQLRecoveryLog);
            }
        }
    }

    protected void unsetDataSourceFactory(ServiceReference<ResourceFactory> ref) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unsetDataSourceFactory, ref " + ref), (Object[])new Object[0]);
        }
        if (this.tmsRef != null) {
            this.tmsRef.doShutdown(_isSQLRecoveryLog);
        }
        dataSourceFactoryRef.unsetReference(ref);
    }

    public ConcurrentServiceReferenceSet<TransactionSettingsProvider> getTransactionSettingsProviders() {
        return this._transactionSettingsProviders;
    }

    protected void setTransactionSettingsProvider(ServiceReference<TransactionSettingsProvider> ref) {
        this._transactionSettingsProviders.addReference(ref);
    }

    protected void unsetTransactionSettingsProvider(ServiceReference<TransactionSettingsProvider> ref) {
        this._transactionSettingsProviders.removeReference(ref);
    }

    public int getClientInactivityTimeout() {
        Number num = (Number)_props.get("clientInactivityTimeout");
        return num.intValue();
    }

    public int getHeuristicRetryInterval() {
        Number num = (Number)_props.get("heuristicRetryInterval");
        return num.intValue();
    }

    public int getHeuristicRetryLimit() {
        return (Integer)_props.get("heuristicRetryWait");
    }

    public int getMaximumTransactionTimeout() {
        Number num = (Number)_props.get("propogatedOrBMTTranLifetimeTimeout");
        return num.intValue();
    }

    public int getTotalTransactionLifetimeTimeout() {
        Number num = (Number)_props.get("totalTranLifetimeTimeout");
        return num.intValue();
    }

    public Level getTraceLevel() {
        return tc.getLoggerLevel();
    }

    public String getTransactionLogDirectory() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getTransactionLogDirectory working with " + logDir), (Object[])new Object[0]);
        }
        if (logDir == null) {
            logDir = this.parseTransactionLogDirectory();
        }
        return logDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getServerName() {
        String serverName = "";
        JTMConfigurationProvider jTMConfigurationProvider = this;
        synchronized (jTMConfigurationProvider) {
            if (this.locationService != null) {
                serverName = this.locationService.getServerName();
            }
        }
        return serverName;
    }

    public String getHeuristicCompletionDirectionAsString() {
        return (String)_props.get("lpsHeuristicCompletion");
    }

    public int getHeuristicCompletionDirection() {
        String hcd = this.getHeuristicCompletionDirectionAsString();
        if ("COMMIT".equalsIgnoreCase(hcd)) {
            return 0;
        }
        if ("MANUAL".equalsIgnoreCase(hcd)) {
            return 2;
        }
        return 1;
    }

    public int getTransactionLogSize() {
        return (Integer)_props.get("transactionLogSize");
    }

    public int getDefaultMaximumShutdownDelay() {
        Number num = (Number)_props.get("defaultMaxShutdownDelay");
        return num.intValue();
    }

    public boolean isLoggingForHeuristicReportingEnabled() {
        return (Boolean)_props.get("enableLoggingForHeuristicReporting");
    }

    public static void setTotalTransactionLifetimeTimeout(int timeout) {
        _props.put("propogatedOrBMTTranLifetimeTimeout", timeout);
    }

    public boolean isAcceptHeuristicHazard() {
        return (Boolean)_props.get("acceptHeuristicHazard");
    }

    public boolean isRecoverOnStartup() {
        Boolean isRoS = (Boolean)_props.get("recoverOnStartup");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isRecoverOnStartup set to " + isRoS), (Object[])new Object[0]);
        }
        return isRoS;
    }

    public boolean isOnePCOptimization() {
        Boolean is1PC = (Boolean)_props.get("OnePCOptimization");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("OnePCOptimization set to " + is1PC), (Object[])new Object[0]);
        }
        return is1PC;
    }

    public boolean isWaitForRecovery() {
        Boolean isWfR = (Boolean)_props.get("waitForRecovery");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isWaitForRecovery set to " + isWfR), (Object[])new Object[0]);
        }
        return isWfR;
    }

    /*
     * WARNING - void declaration
     */
    public ResourceFactory getResourceFactory() {
        block3: {
            try {
                this._theDataSourceFactory = (ResourceFactory)dataSourceFactoryRef.getServiceWithException();
            }
            catch (Exception exception) {
                void ex;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.transaction.services.JTMConfigurationProvider", (String)"356", (Object)((Object)this), (Object[])new Object[0]);
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("getResourceFactory returned exc - " + ex), (Object[])new Object[0]);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getResourceFactory has factory " + this._theDataSourceFactory), (Object[])new Object[0]);
        }
        return this._theDataSourceFactory;
    }

    public RuntimeMetaDataProvider getRuntimeMetaDataProvider() {
        return this._runtimeMetaDataProvider;
    }

    public String getRecoveryIdentity() {
        this._recoveryIdentity = (String)_props.get("recoveryIdentity");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getRecoveryIdentity " + this._recoveryIdentity), (Object[])new Object[0]);
        }
        return this._recoveryIdentity;
    }

    public String getRecoveryGroup() {
        this._recoveryGroup = (String)_props.get("recoveryGroup");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getRecoveryGroup " + this._recoveryGroup), (Object[])new Object[0]);
        }
        return this._recoveryGroup;
    }

    public void setTMS(TransactionManagerService tms) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setTMS " + tms), (Object[])new Object[0]);
        }
        this.tmsRef = tms;
    }

    public void setTMRecoveryService(TMRecoveryService tmrec) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setTMRecoveryService " + tmrec), (Object[])new Object[0]);
        }
        if (this.tmsRef != null) {
            if (!_isSQLRecoveryLog) {
                if (this._cc != null) {
                    this.tmsRef.doStartup(this, _isSQLRecoveryLog);
                }
            } else {
                ServiceReference serviceRef = dataSourceFactoryRef.getReference();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("retrieved datasourceFactory service ref " + serviceRef), (Object[])new Object[0]);
                }
                if (this._cc != null && serviceRef != null) {
                    this.tmsRef.doStartup(this, _isSQLRecoveryLog);
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"tmsref is null", (Object[])new Object[0]);
        }
    }

    public boolean isSQLRecoveryLog() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isSQLRecoveryLog " + _isSQLRecoveryLog), (Object[])new Object[0]);
        }
        return _isSQLRecoveryLog;
    }

    public boolean needToCoordinateServices() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"needToCoordinateServices", (Object[])new Object[0]);
        }
        return true;
    }

    private void checkDataSourceRef() {
        Object configuredDSR = _props.get("dataSourceRef");
        if (configuredDSR == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"dataSourceRef is not specified, log to filesys", (Object[])new Object[0]);
            }
            _isSQLRecoveryLog = false;
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"dataSourceRef is specified, log to RDBMS", (Object[])new Object[0]);
            }
            String suffixStr = (String)_props.get("transactionLogDBTableSuffix");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("suffixStr is " + suffixStr + ", of length " + suffixStr.length()), (Object[])new Object[0]);
            }
            if (suffixStr != null && !suffixStr.trim().isEmpty()) {
                suffixStr = suffixStr.trim();
                logDir = "custom://com.ibm.rls.jdbc.SQLRecoveryLogFactory?datasource=Liberty,tablesuffix=" + suffixStr;
            } else {
                logDir = "custom://com.ibm.rls.jdbc.SQLRecoveryLogFactory?datasource=Liberty";
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"logDir now set to ", (Object[])new Object[]{logDir});
            }
            _isSQLRecoveryLog = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private String parseTransactionLogDirectory() {
        String configuredLogDir;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("parseTransactionLogDirectory working with " + _props), (Object[])new Object[0]);
        }
        if ((configuredLogDir = (String)_props.get("transactionLogDirectory")) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"using default log dir as config is null", (Object[])new Object[0]);
            }
            configuredLogDir = defaultLogDir;
        } else if (!configuredLogDir.endsWith("/")) {
            configuredLogDir = configuredLogDir + "/";
        }
        WsResource logDirResource = null;
        try {
            JTMConfigurationProvider jTMConfigurationProvider = this;
            synchronized (jTMConfigurationProvider) {
                logDirResource = this.locationService.resolveResource(configuredLogDir);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            void e;
            FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.transaction.services.JTMConfigurationProvider", (String)"521", (Object)((Object)this), (Object[])new Object[0]);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("IllegalArgumentException from location service for dir string: " + configuredLogDir), (Object[])new Object[0]);
            }
            if (!configuredLogDir.equals(defaultLogDir)) {
                configuredLogDir = defaultLogDir;
                try {
                    JTMConfigurationProvider jTMConfigurationProvider = this;
                    synchronized (jTMConfigurationProvider) {
                        logDirResource = this.locationService.resolveResource(configuredLogDir);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    FFDCFilter.processException((Throwable)illegalArgumentException2, (String)"com.ibm.ws.transaction.services.JTMConfigurationProvider", (String)"532", (Object)((Object)this), (Object[])new Object[0]);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        void ex;
                        Tr.debug((TraceComponent)tc, (String)("Secondary IllegalArgumentException " + ex + " from location service for dir string: " + configuredLogDir), (Object[])new Object[0]);
                    }
                    throw e;
                }
            }
            throw e;
        }
        logDir = logDirResource.toExternalURI().getPath();
        return logDir;
    }

    public void setApplId(byte[] name) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setApplId - " + Arrays.toString(name)), (Object[])new Object[0]);
        }
        this._applId = (byte[])name.clone();
    }

    public byte[] getApplId() {
        byte[] result = this._applId;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getApplId - " + Arrays.toString(result)), (Object[])new Object[0]);
        }
        return result;
    }

    public void shutDownFramework() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"JTMConfigurationProvider shutDownFramework has been called", (Object[])new Object[0]);
        }
        if (this.tmsRef != null) {
            this.tmsRef.shutDownFramework();
        }
    }

    public boolean enableHADBPeerLocking() {
        return (Boolean)_props.get("enableHADBPeerLocking");
    }

    public int getTimeBetweenHeartbeats() {
        Number num = (Number)_props.get("timeBetweenHeartbeats");
        return num.intValue();
    }

    public int getPeerTimeBeforeStale() {
        Number num = (Number)_props.get("peerTimeBeforeStale");
        return num.intValue();
    }

    public int getLocalTimeBeforeStale() {
        Number num = (Number)_props.get("localTimeBeforeStale");
        return num.intValue();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        logDir = null;
        dataSourceFactoryRef = new AtomicServiceReference("dataSourceFactory");
        _isSQLRecoveryLog = false;
    }
}

