/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.management;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jpa.JPAProviderIntegration;
import com.ibm.ws.jpa.JPAPuId;
import com.ibm.ws.jpa.management.AbstractJPAComponent;
import com.ibm.ws.jpa.management.CapturingClassTransformer;
import com.ibm.ws.jpa.management.GenericDataSource;
import com.ibm.ws.jpa.management.JPAApplInfo;
import com.ibm.ws.jpa.management.JPACompPUnitInfo;
import com.ibm.ws.jpa.management.JPAEMPool;
import com.ibm.ws.jpa.management.JPAPXml;
import com.ibm.ws.util.ThreadContextAccessor;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;

public abstract class JPAPUnitInfo
implements PersistenceUnitInfo {
    private static final String CLASS_NAME = JPAPUnitInfo.class.getName();
    private static final TraceComponent tc = Tr.register(JPAPUnitInfo.class, (String)"JPA", (String)"com.ibm.ws.jpa.jpa");
    private static final TraceComponent tcTransformer = Tr.register((String)(CLASS_NAME + "_Transformer"), JPAPUnitInfo.class, (String)"JPA.Transformer", (String)"com.ibm.ws.jpa.jpa");
    private static final TraceComponent tcBytecodeCapture = Tr.register((String)(CLASS_NAME + "_BytecodeCapture"), JPAPUnitInfo.class, (String)"JPA.BytecodeCapture", (String)"com.ibm.ws.jpa.jpa");
    private static final ThreadContextAccessor svThreadContextAccessor = (ThreadContextAccessor)AccessController.doPrivileged(ThreadContextAccessor.getPrivilegedAction());
    protected final JPAApplInfo ivApplInfo;
    protected final JPAPuId ivArchivePuId;
    private PersistenceUnitTransactionType ivTxType = null;
    private String ivDesc = null;
    private String ivProviderClassName = null;
    private DataSource ivJtaDataSource = null;
    private DataSource ivNonJtaDataSource = null;
    private List<String> ivMappingFileNames = null;
    private List<URL> ivJarFileURLs = null;
    private List<String> ivManagedClassNames = null;
    private boolean ivExcludeUnlistedClasses = false;
    private Properties ivProperties = null;
    private String ivJtaDataSourceJNDIName = null;
    private String ivNonJtaDataSourceJNDIName = null;
    private URL ivPUnitRootURL = null;
    protected final ClassLoader ivClassLoader;
    private ClassLoader tempClassLoader = null;
    private List<ClassTransformer> ivTransformers = null;
    private String xmlSchemaVersion = null;
    private SharedCacheMode ivCaching = null;
    private ValidationMode ivValidationMode = null;
    private EntityManagerFactory ivEMFactory = null;
    private RuntimeException ivEMFactoryException;
    private boolean ivCreateEMFAllowed = true;
    private Map<J2EEName, EntityManagerFactory> ivEMFMap = null;
    private Map<String, JPAEMPool> ivEMPoolMap = null;
    private int ivEMPoolCapacity = -1;
    private static String[] transformExclusionRegEx = new String[]{".*_(Stub|Tie)$", ".*_(\\p{XDigit}){8}$"};
    private static final Pattern[] transformExclusionPatterns = new Pattern[transformExclusionRegEx.length];

    protected JPAPUnitInfo(JPAApplInfo applInfo, JPAPuId puId, ClassLoader loader) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("<init> : " + puId), (Object[])new Object[0]);
        }
        this.ivApplInfo = applInfo;
        this.ivArchivePuId = puId;
        this.ivTxType = PersistenceUnitTransactionType.JTA;
        this.ivJarFileURLs = new ArrayList<URL>();
        this.ivManagedClassNames = new ArrayList<String>();
        this.ivMappingFileNames = new ArrayList<String>();
        this.ivTransformers = new CopyOnWriteArrayList<ClassTransformer>();
        this.ivClassLoader = loader;
        this.ivEMPoolMap = new HashMap<String, JPAEMPool>();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    protected AbstractJPAComponent getJPAComponent() {
        return this.ivApplInfo.getJPAComponent();
    }

    private final String trim(String str) {
        if (str != null) {
            str = str.trim();
        }
        return str;
    }

    public final String getPersistenceUnitName() {
        return this.ivArchivePuId.getPuName();
    }

    public final PersistenceUnitTransactionType getTransactionType() {
        return this.ivTxType;
    }

    final void setTransactionType(PersistenceUnitTransactionType newValue) {
        boolean serverRT;
        this.ivTxType = newValue == null ? ((serverRT = this.ivApplInfo.getJPAComponent().isServerRuntime()) ? PersistenceUnitTransactionType.JTA : PersistenceUnitTransactionType.RESOURCE_LOCAL) : newValue;
    }

    public final String getPersistenceUnitDescription() {
        return this.ivDesc;
    }

    final void setPersistenceUnitDescription(String newValue) {
        this.ivDesc = newValue == null ? "" : this.trim(newValue);
    }

    public final String getPersistenceProviderClassName() {
        return this.ivProviderClassName;
    }

    final void setPersistenceProviderClassName(String newValue) {
        this.ivProviderClassName = this.trim(newValue == null ? this.getJPAComponent().getDefaultJPAProviderClassName() : newValue);
    }

    private DataSource getJPADataSource(String dsName) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getJPADataSource : " + dsName + ", " + this.ivArchivePuId), (Object[])new Object[0]);
        }
        DataSource ds = null;
        if (dsName != null) {
            try {
                ds = this.ivEMFactory == null && (dsName.startsWith("java:comp/env/") || dsName.startsWith("java:app/env/")) ? new GenericDataSource(this.ivArchivePuId, dsName) : this.lookupDataSource(dsName);
            }
            catch (NamingException ex) {
                if (this.ivEMFactory == null) {
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("getJPADataSource : failed, returning GenericDataSource : " + ex), (Object[])new Object[0]);
                    }
                    ds = new GenericDataSource(this.ivArchivePuId, dsName);
                }
                if (this.getJPAComponent().isIgnoreDataSourceErrors()) {
                    Tr.error((TraceComponent)tc, (String)"UNABLE_TO_GET_DATASOURCE_FOR_PU_CWWJP0013E", (Object[])new Object[]{dsName, this.ivArchivePuId.getPuName(), ex.toString()});
                }
                String message = Tr.formatMessage((TraceComponent)tc, (String)"UNABLE_TO_GET_DATASOURCE_FOR_PU_CWWJP0013E", (Object[])new Object[]{dsName, this.ivArchivePuId.getPuName(), ex.toString()});
                PersistenceException ex2 = new PersistenceException(message, (Throwable)ex);
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getJPADataSource", (Object)ex2);
                }
                throw ex2;
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getJPADataSource : " + ds));
        }
        return ds;
    }

    protected abstract DataSource lookupDataSource(String var1) throws NamingException;

    public final DataSource getJtaDataSource() {
        if (this.ivJtaDataSource == null || this.ivJtaDataSource instanceof GenericDataSource) {
            this.ivJtaDataSource = this.getJPADataSource(this.ivJtaDataSourceJNDIName);
        }
        return this.ivJtaDataSource;
    }

    final void setJtaDataSource(String jndiName) {
        this.ivJtaDataSourceJNDIName = jndiName != null ? jndiName.trim() : null;
    }

    public final DataSource getNonJtaDataSource() {
        if (this.ivNonJtaDataSource == null || this.ivNonJtaDataSource instanceof GenericDataSource) {
            this.ivNonJtaDataSource = this.getJPADataSource(this.ivNonJtaDataSourceJNDIName);
        }
        return this.ivNonJtaDataSource;
    }

    final void setNonJtaDataSource(String jndiName) {
        this.ivNonJtaDataSourceJNDIName = jndiName != null ? jndiName.trim() : null;
    }

    DataSource lookupJtaDataSource() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("lookupJtaDataSource : " + this.ivArchivePuId), (Object[])new Object[0]);
        }
        DataSource jpaDS = this.getJPADataSource(this.ivJtaDataSourceJNDIName);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("lookupJtaDataSource : " + jpaDS));
        }
        return jpaDS;
    }

    DataSource lookupNonJtaDataSource() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("lookupNonJtaDataSource : " + this.ivArchivePuId), (Object[])new Object[0]);
        }
        DataSource jpaDS = this.getJPADataSource(this.ivNonJtaDataSourceJNDIName);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("lookupNonJtaDataSource : " + jpaDS));
        }
        return jpaDS;
    }

    public final List<String> getMappingFileNames() {
        return this.ivMappingFileNames;
    }

    final void setMappingFileNames(List<String> newValues) {
        this.ivMappingFileNames.clear();
        this.addMappingFileNames(newValues);
    }

    private void addMappingFileNames(List<String> newValues) {
        for (String ormFName : newValues) {
            this.ivMappingFileNames.add(this.trim(ormFName));
        }
    }

    public final List<URL> getJarFileUrls() {
        return this.ivJarFileURLs;
    }

    final void setJarFileUrls(List<String> jarFilePaths, JPAPXml pxml) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setJarFileUrls: root=" + this.ivPUnitRootURL.toExternalForm()), (Object[])new Object[0]);
        }
        this.ivJarFileURLs.clear();
        for (String jarFilePath : jarFilePaths) {
            if (this.addJarFileUrls(this.trim(jarFilePath), pxml)) continue;
            Tr.error((TraceComponent)tc, (String)"INCORRECT_PU_JARFILE_URL_SPEC_CWWJP0024E", (Object[])new Object[]{jarFilePath, this.getPersistenceUnitName()});
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Object[] allURLs = this.ivJarFileURLs.toArray(new URL[0]);
            Tr.exit((TraceComponent)tc, (String)("setJarFileUrls : " + Arrays.toString(allURLs)));
        }
    }

    protected abstract boolean addJarFileUrls(String var1, JPAPXml var2);

    protected void addJarFileUrl(URL url) {
        this.ivJarFileURLs.add(url);
    }

    public final List<String> getManagedClassNames() {
        return this.ivManagedClassNames;
    }

    final void setManagedClassNames(List<String> newValues) {
        this.ivManagedClassNames.clear();
        this.addManagedClassNames(newValues);
    }

    void addManagedClassNames(List<String> newValues) {
        for (String className : newValues) {
            this.ivManagedClassNames.add(this.trim(className));
        }
    }

    public final boolean excludeUnlistedClasses() {
        return this.ivExcludeUnlistedClasses;
    }

    final void setExcludeUnlistedClasses(boolean newValue) {
        this.ivExcludeUnlistedClasses = newValue;
    }

    public final Properties getProperties() {
        return this.ivProperties;
    }

    final void setProperties(Properties newValues) {
        this.ivProperties = new Properties();
        if (newValues != null) {
            for (Map.Entry<Object, Object> entry : newValues.entrySet()) {
                this.ivProperties.put(entry.getKey(), this.trim((String)entry.getValue()));
            }
        }
        this.getJPAComponent().getJPAProviderIntegration().updatePersistenceUnitProperties(this.ivProviderClassName, this.ivProperties);
    }

    public final URL getPersistenceUnitRootUrl() {
        return this.ivPUnitRootURL;
    }

    protected void setPersistenceUnitRootUrl(URL newValue) {
        this.ivPUnitRootURL = newValue;
    }

    final JPAPuId getPuId() {
        return this.ivArchivePuId;
    }

    public final String getApplName() {
        return this.ivApplInfo.getApplName();
    }

    public final ClassLoader getClassLoader() {
        return this.ivClassLoader;
    }

    protected abstract boolean registerClassFileTransformer(ClassLoader var1);

    protected abstract void unregisterClassFileTransformer(ClassLoader var1);

    public final synchronized ClassLoader getNewTempClassLoader() {
        if (this.tempClassLoader == null) {
            this.tempClassLoader = this.createTempClassLoader(this.ivClassLoader);
        }
        return this.tempClassLoader;
    }

    protected abstract ClassLoader createTempClassLoader(ClassLoader var1);

    public final void addTransformer(ClassTransformer transformerClass) {
        AbstractJPAComponent jpaComp;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addTransformer: PUID = " + this.ivArchivePuId + ", transformer = " + transformerClass), (Object[])new Object[0]);
        }
        if (transformerClass != null && (jpaComp = this.getJPAComponent()) != null && jpaComp.getCaptureEnhancedEntityClassBytecode()) {
            transformerClass = new CapturingClassTransformer(transformerClass, this.ivApplInfo.getApplName(), jpaComp.getServerLogDirectory());
        }
        this.ivTransformers.add(transformerClass);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("addTransformer : # registered transfromer = " + this.ivTransformers.size()));
        }
    }

    void initialize() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("createEntityManagerFactory : " + this.ivArchivePuId), (Object[])new Object[0]);
        }
        if (this.ivEMFactory != null) {
            throw new IllegalStateException("EntityManagerFactory already created for PU : " + this.ivArchivePuId);
        }
        if (!this.registerClassFileTransformer(this.ivClassLoader)) {
            Tr.warning((TraceComponent)tc, (String)"APPL_CLASSLOADER_USE_HAS_NO_JPA_SUPPORT_CWWJP0005W", (Object[])new Object[]{this.ivArchivePuId.getPuName(), this.ivPUnitRootURL, this.ivClassLoader.getClass().getName()});
            this.tempClassLoader = this.ivClassLoader;
        }
        AbstractJPAComponent jpaComponent = this.getJPAComponent();
        this.ivJtaDataSourceJNDIName = jpaComponent.getDataSourceBindingName(this.ivJtaDataSourceJNDIName, true);
        this.ivNonJtaDataSourceJNDIName = jpaComponent.getDataSourceBindingName(this.ivNonJtaDataSourceJNDIName, false);
        this.ivJtaDataSourceJNDIName = jpaComponent.getJPARuntime().processJEE7JTADataSource(this.ivJtaDataSourceJNDIName, this.ivNonJtaDataSourceJNDIName);
        if (this.ivJtaDataSourceJNDIName != null && this.ivJtaDataSourceJNDIName.startsWith("java:comp/env") || this.ivNonJtaDataSourceJNDIName != null && this.ivNonJtaDataSourceJNDIName.startsWith("java:comp/env")) {
            this.ivEMFMap = new HashMap<J2EEName, EntityManagerFactory>();
        } else if (this.ivJtaDataSourceJNDIName != null && this.getJtaDataSource() instanceof GenericDataSource || this.ivNonJtaDataSourceJNDIName != null && this.getNonJtaDataSource() instanceof GenericDataSource) {
            this.ivEMFMap = new HashMap<J2EEName, EntityManagerFactory>();
        }
        this.ivEMPoolCapacity = jpaComponent.getEntityManagerPoolCapacity();
        if (this.ivEMPoolCapacity < 0 && jpaComponent.getJPAProviderIntegration().supportsEntityManagerPooling()) {
            this.ivEMPoolCapacity = 10;
        }
        try {
            this.ivEMFactory = this.createEMFactory(this, true);
        }
        catch (RuntimeException ex) {
            this.ivEMFactoryException = ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EntityManagerFactory getEntityManagerFactory(J2EEName j2eeName) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getEntityManagerFactory : " + this.ivArchivePuId + ", " + j2eeName), (Object[])new Object[0]);
        }
        if (this.ivEMFactoryException != null) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getEntityManagerFactory : " + this.ivEMFactoryException));
            }
            throw new RuntimeException(this.ivEMFactoryException);
        }
        if (j2eeName == null) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getEntityManagerFactory : IllegalArgumentException");
            }
            throw new IllegalArgumentException("Component identifier must be provided  : " + this.ivArchivePuId);
        }
        EntityManagerFactory emf = this.ivEMFactory;
        if (this.ivEMFMap != null) {
            Map<J2EEName, EntityManagerFactory> map = this.ivEMFMap;
            synchronized (map) {
                emf = this.ivEMFMap.get(j2eeName);
                if (emf == null) {
                    if (this.ivCreateEMFAllowed) {
                        JPACompPUnitInfo puInfo = new JPACompPUnitInfo(this.ivArchivePuId, this, j2eeName);
                        emf = this.createEMFactory(puInfo, false);
                        this.ivEMFMap.put(j2eeName, emf);
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("new emf added to EMF Map for : " + j2eeName), (Object[])new Object[0]);
                        }
                    } else {
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("PU closed; base emf returned for : " + j2eeName), (Object[])new Object[0]);
                        }
                        emf = this.ivEMFactory;
                    }
                } else if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("emf obtained from EMF Map for : " + j2eeName), (Object[])new Object[0]);
                }
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getEntityManagerFactory : " + emf));
        }
        return emf;
    }

    private EntityManagerFactory createEMFactory(PersistenceUnitInfo puInfo, boolean ignoreProviderCNFE) {
        EntityManagerFactory emfactory;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createEMFactory : " + puInfo), (Object[])new Object[0]);
        }
        HashMap<String, Object> integrationProperties = new HashMap<String, Object>();
        JPAProviderIntegration integration = this.getJPAComponent().getJPAProviderIntegration();
        integration.updatePersistenceProviderIntegrationProperties(puInfo, integrationProperties);
        if (this.ivEMFactory == null && this.ivEMFMap != null) {
            integration.disablePersistenceUnitLogging(integrationProperties);
        }
        this.getJPAComponent().addIntegrationProperties(this.xmlSchemaVersion, integrationProperties, this.ivClassLoader);
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("createContainerEMF properties:" + this.toString()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("createContainerEMF integration-properties:" + integrationProperties), (Object[])new Object[0]);
        }
        ClassLoader tcclassloader = this.getJPAComponent().createThreadContextClassLoader(this.ivClassLoader);
        Object oldClassLoader = svThreadContextAccessor.pushContextClassLoaderForUnprivileged(tcclassloader);
        try {
            Class<?> providerClass = this.ivClassLoader.loadClass(this.ivProviderClassName);
            PersistenceProvider provider = (PersistenceProvider)providerClass.newInstance();
            emfactory = provider.createContainerEntityManagerFactory(puInfo, integrationProperties);
        }
        catch (PersistenceException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".createEMFactory"), (String)"759", (Object)this);
            Tr.error((TraceComponent)tc, (String)"CREATE_CONTAINER_ENTITYMANAGER_FACTORY_ERROR_CWWJP0015E", (Object[])new Object[]{this.ivProviderClassName, this.ivArchivePuId.getPuName(), e.getLocalizedMessage()});
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createEMFactory : null", (Object)((Object)e));
            }
            throw e;
        }
        catch (ClassNotFoundException cnfe) {
            if (!ignoreProviderCNFE) {
                FFDCFilter.processException((Throwable)cnfe, (String)(CLASS_NAME + ".createEMFactory"), (String)"1168", (Object)this);
                Tr.error((TraceComponent)tc, (String)"JPA_PROVIDER_NOT_FOUND_CWWJP0050E", (Object[])new Object[]{this.ivProviderClassName});
            }
            String nlsMessage = Tr.formatMessage((TraceComponent)tc, (String)"JPA_PROVIDER_NOT_FOUND_CWWJP0050E", (Object[])new Object[]{this.ivProviderClassName});
            throw new RuntimeException(nlsMessage, cnfe);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".createEMFactory"), (String)"773", (Object)this);
            Tr.error((TraceComponent)tc, (String)"CREATE_CONTAINER_ENTITYMANAGER_FACTORY_ERROR_CWWJP0015E", (Object[])new Object[]{this.ivProviderClassName, this.ivArchivePuId.getPuName(), e});
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createEMFactory", (Object)e);
            }
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
        finally {
            if (isTraceOn && tc.isDebugEnabled() && oldClassLoader != ThreadContextAccessor.UNCHANGED) {
                Tr.debug((TraceComponent)tc, (String)("reverting class loader to " + oldClassLoader), (Object[])new Object[0]);
            }
            svThreadContextAccessor.popContextClassLoaderForUnprivileged(oldClassLoader);
            this.getJPAComponent().destroyThreadContextClassLoader(tcclassloader);
        }
        if (emfactory == null) {
            Tr.error((TraceComponent)tc, (String)"UNABLE_TO_CREATE_ENTITY_MANAGER_FACTORY_CWWJP0009E", (Object[])new Object[]{this.ivArchivePuId.getPuName(), this.ivProviderClassName, this.ivPUnitRootURL});
            String message = "EntityManagerFactory has not been created for PU : " + this.ivArchivePuId;
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createEMFactory : IllegalStateException");
            }
            throw new IllegalStateException(message);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createEMFactory : " + emfactory));
        }
        return emfactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JPAEMPool getEntityManagerPool(J2EEName j2eeName, String refName, Map<?, ?> properties) {
        JPAEMPool emPool = null;
        String poolKey = j2eeName.toString() + "#" + refName;
        Map<String, JPAEMPool> map = this.ivEMPoolMap;
        synchronized (map) {
            emPool = this.ivEMPoolMap.get(poolKey);
            if (emPool == null) {
                EntityManagerFactory emf = this.getEntityManagerFactory(j2eeName);
                emPool = new JPAEMPool(emf, properties, this.ivEMPoolCapacity, this, this.getJPAComponent());
                this.ivEMPoolMap.put(poolKey, emPool);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getEntityManagerPool : " + poolKey + " : " + emPool), (Object[])new Object[0]);
        }
        return emPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void close() {
        Object object;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("close : " + this.ivArchivePuId), (Object[])new Object[]{this});
        }
        if (this.ivEMFMap != null) {
            object = this.ivEMFMap;
            synchronized (object) {
                this.ivCreateEMFAllowed = false;
            }
        }
        object = this.ivEMPoolMap;
        synchronized (object) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("shutting down EM pools : " + this.ivEMPoolMap.size()), (Object[])new Object[0]);
            }
            for (JPAEMPool emPool : this.ivEMPoolMap.values()) {
                emPool.shutdown();
            }
        }
        this.unregisterClassFileTransformer(this.ivClassLoader);
        if (this.ivEMFactory != null) {
            block21: {
                if (this.ivEMFactory.isOpen()) {
                    try {
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"closing base EMF", (Object[])new Object[0]);
                        }
                        this.ivEMFactory.close();
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".close"), (String)"934", (Object)this);
                        if (!isTraceOn || !tc.isDebugEnabled()) break block21;
                        Tr.debug((TraceComponent)tc, (String)("Caught unexpected exception on factory.close():" + e), (Object[])new Object[0]);
                    }
                }
            }
            if (this.ivEMFMap != null) {
                for (EntityManagerFactory emFactory : this.ivEMFMap.values()) {
                    if (!emFactory.isOpen()) continue;
                    try {
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"closing component EMF", (Object[])new Object[0]);
                        }
                        emFactory.close();
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".close"), (String)"934", (Object)this);
                        if (!isTraceOn || !tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Caught unexpected exception on factory.close():" + e), (Object[])new Object[0]);
                    }
                }
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("close : " + this.ivArchivePuId));
        }
    }

    StringBuilder toStringBuilder(StringBuilder sbuf) {
        return sbuf.append(this.ivArchivePuId.getPuName());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.ivArchivePuId + ")@" + Integer.toHexString(this.hashCode());
    }

    String dump() {
        boolean first;
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("\n").append(this.toString());
        sbuf.append("\n PersistenceUnit name : ").append(this.ivArchivePuId.getPuName());
        sbuf.append("\n Schema Version       : ").append(this.xmlSchemaVersion);
        sbuf.append("\t Archive name         : ").append(this.ivArchivePuId.getModJarName());
        sbuf.append("\t Application name     : ").append(this.ivArchivePuId.getApplName());
        sbuf.append("\n Root URL             : ").append(this.ivPUnitRootURL);
        sbuf.append("\n Transaction Type     : ").append(this.ivTxType);
        sbuf.append("\n Description          : ").append(this.ivDesc);
        sbuf.append("\n Provider class name  : ").append(this.ivProviderClassName);
        sbuf.append("\n JTA Data Source      : ").append(this.ivJtaDataSourceJNDIName).append(" | ").append(this.ivJtaDataSource);
        sbuf.append("\n Non JTA Data Source  : ").append(this.ivNonJtaDataSourceJNDIName).append(" | ").append(this.ivNonJtaDataSource);
        sbuf.append("\n ExcludeUnlistedClass : ").append(this.ivExcludeUnlistedClasses);
        sbuf.append("\n SharedCacheMode      : ").append(this.ivCaching);
        sbuf.append("\n ValidationMode       : ").append(this.ivValidationMode);
        sbuf.append("\n Properties           : ").append(this.ivProperties);
        sbuf.append("\n Mapping Files        : [");
        if (this.ivMappingFileNames != null) {
            first = true;
            for (String fname : this.ivMappingFileNames) {
                sbuf.append(first ? "" : ",").append(fname);
                first = false;
            }
        }
        sbuf.append(']');
        sbuf.append("\n Jar Files            : [");
        if (this.ivJarFileURLs != null) {
            first = true;
            for (URL jarUrl : this.ivJarFileURLs) {
                sbuf.append(first ? "" : ",").append(jarUrl);
                first = false;
            }
        }
        sbuf.append(']');
        sbuf.append("\n ManagedClasses       : [");
        if (this.ivManagedClassNames != null) {
            first = true;
            for (String className : this.ivManagedClassNames) {
                sbuf.append(first ? "" : ",").append(className);
                first = false;
            }
        }
        sbuf.append(']');
        sbuf.append("\n ClassLoader          : ").append(this.ivClassLoader);
        sbuf.append("\n Temp ClassLoader     : ").append(this.tempClassLoader);
        sbuf.append("\n Transformer          : [");
        if (this.ivTransformers != null) {
            first = true;
            for (ClassTransformer transformer : this.ivTransformers) {
                sbuf.append(first ? "" : ",").append(transformer);
                first = false;
            }
        }
        sbuf.append(']');
        return sbuf.toString();
    }

    private final boolean classNeedsTransform(String className) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("classNeedsTransform : PUID = " + this.ivArchivePuId + ", class name = " + className), (Object[])new Object[0]);
        }
        boolean rtnVal = true;
        for (Pattern regex : transformExclusionPatterns) {
            if (!regex.matcher(className).matches()) continue;
            rtnVal = false;
            break;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("classNeedsTransform : " + className + (rtnVal ? " needs" : " does not need") + " transform."));
        }
        return rtnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public byte[] transformClass(String className, byte[] classBytes, CodeSource codeSource, ClassLoader classloader) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tcTransformer.isEntryEnabled()) {
            Tr.entry((TraceComponent)tcTransformer, (String)("transformClass: PUID = " + this.ivArchivePuId + ", class name = " + className + ", classBytes.length = " + (classBytes == null ? 0 : classBytes.length)), (Object[])new Object[]{codeSource, classloader});
        }
        int numTransform = 0;
        try {
            block18: {
                if (this.ivTransformers.size() <= 0 || !this.classNeedsTransform(className)) break block18;
                if (isTraceOn && tcBytecodeCapture.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tcBytecodeCapture, (String)("Before Class Transform: Bytecode for class " + className + " (size = " + (classBytes == null ? 0 : classBytes.length) + "):"), (Object[])new Object[]{"Hex:\n" + JPAPUnitInfo.dumpByteCode(classBytes)});
                }
                ProtectionDomain pd = new ProtectionDomain(codeSource, new Permissions(), classloader, null);
                for (ClassTransformer transformer : this.ivTransformers) {
                    if (isTraceOn && tcTransformer.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tcTransformer, (String)("transformer: " + transformer + " , className: " + className), (Object[])new Object[0]);
                    }
                    int oldClassBytesLength = classBytes.length;
                    boolean isTransformed = false;
                    try {
                        byte[] transformedClassBytes = transformer.transform(classloader, className, null, pd, classBytes);
                        if (transformedClassBytes != null) {
                            isTransformed = true;
                            classBytes = transformedClassBytes;
                            ++numTransform;
                        }
                        if (isTraceOn && (tc.isDebugEnabled() && isTransformed || tcTransformer.isDebugEnabled())) {
                            TraceComponent tcActive = tcTransformer.isDebugEnabled() ? tcTransformer : tc;
                            Tr.debug((TraceComponent)tcActive, (String)("transformer:" + transformer + ", " + className + " is " + (isTransformed ? "" : "NOT ") + "transformed. Byte length(old/new)=" + oldClassBytesLength + "/" + classBytes.length), (Object[])new Object[0]);
                        }
                        if (!isTraceOn || !tcBytecodeCapture.isDebugEnabled() || oldClassBytesLength == classBytes.length) continue;
                        Tr.debug((TraceComponent)tcBytecodeCapture, (String)("After Class Transform: Bytecode for class " + className + " (size = " + (classBytes == null ? 0 : classBytes.length) + ")"), (Object[])new Object[]{"Hex:\n" + JPAPUnitInfo.dumpByteCode(classBytes)});
                    }
                    catch (IllegalClassFormatException icfe) {
                        FFDCFilter.processException((Throwable)icfe, (String)(CLASS_NAME + ".transformClass"), (String)"1169", (Object)this);
                        Tr.error((TraceComponent)tc, (String)"ILLEGAL_CLASS_FORMAT_IN_CLASS_TRANSFORMATION_CWWJP0014E", (Object[])new Object[]{className});
                    }
                    catch (RuntimeException t) {
                        block17: {
                            StringBuilder sb = new StringBuilder();
                            try {
                                sb.append("\n----------\n");
                                sb.append("Original Class Byte Code (length = ").append(classBytes == null ? 0 : classBytes.length);
                                sb.append(") for class ").append(className).append(" :\n");
                                sb.append(JPAPUnitInfo.dumpByteCode(classBytes));
                                sb.append("\nRuntime Exception thrown by transformer:\n");
                                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                t.printStackTrace(new PrintStream(baos));
                                sb.append(baos.toString());
                                sb.append("\n----------\n");
                            }
                            catch (Throwable throwable) {
                                Tr.error((TraceComponent)tc, (String)"ERROR_TRANSFORMING_CLASS_CWWJP0055E", (Object[])new Object[]{className, sb.toString()});
                                break block17;
                                catch (Throwable throwable2) {
                                    Tr.error((TraceComponent)tc, (String)"ERROR_TRANSFORMING_CLASS_CWWJP0055E", (Object[])new Object[]{className, sb.toString()});
                                    throw throwable2;
                                }
                            }
                            Tr.error((TraceComponent)tc, (String)"ERROR_TRANSFORMING_CLASS_CWWJP0055E", (Object[])new Object[]{className, sb.toString()});
                        }
                        throw t;
                    }
                }
            }
            byte[] byArray = classBytes;
            return byArray;
        }
        finally {
            if (isTraceOn && tcTransformer.isEntryEnabled()) {
                Tr.exit((TraceComponent)tcTransformer, (String)("transformClass: " + numTransform + "/" + this.ivTransformers.size()));
            }
        }
    }

    private static String dumpByteCode(byte[] byteCode) {
        if (byteCode == null || byteCode.length == 0) {
            return "No bytecode is available.";
        }
        int ROW_SIZE = 30;
        StringBuilder sb = new StringBuilder();
        StringBuilder asciiSB = new StringBuilder();
        int col = 1;
        for (int idx = 0; idx < byteCode.length; ++idx) {
            sb.append(String.format("%02X ", byteCode[idx]));
            if (byteCode[idx] >= 32 && byteCode[idx] < 127) {
                asciiSB.append((char)(byteCode[idx] & 0xFF));
            } else {
                asciiSB.append(".");
            }
            if (col++ % 30 != 0) continue;
            sb.append(" ").append(asciiSB.toString()).append("\n");
            asciiSB.setLength(0);
            col = 1;
        }
        if (byteCode.length % 30 != 0) {
            int diff = (30 - byteCode.length % 30) * 3;
            for (int i = 0; i < diff; ++i) {
                sb.append(" ");
            }
            sb.append(" ").append(asciiSB.toString()).append("\n");
        }
        return sb.toString();
    }

    public final String getPersistenceXMLSchemaVersion() {
        return this.xmlSchemaVersion;
    }

    void setPersistenceXMLSchemaVersion(String version) {
        this.xmlSchemaVersion = version;
    }

    public final SharedCacheMode getSharedCacheMode() {
        return this.ivCaching;
    }

    void setSharedCacheMode(SharedCacheMode value) {
        this.ivCaching = value;
    }

    public final ValidationMode getValidationMode() {
        return this.ivValidationMode;
    }

    void setValidationMode(ValidationMode mode) {
        this.ivValidationMode = mode;
    }

    static {
        for (int i = 0; i < transformExclusionRegEx.length; ++i) {
            JPAPUnitInfo.transformExclusionPatterns[i] = Pattern.compile(transformExclusionRegEx[i]);
        }
    }
}

