/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.webapp;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ExpressionFactory;
import javax.faces.application.Application;
import javax.faces.application.ProjectStage;
import javax.faces.application.ViewVisitOption;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PostConstructApplicationEvent;
import javax.faces.event.PreDestroyApplicationEvent;
import javax.faces.event.SystemEvent;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import javax.websocket.DeploymentException;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpointConfig;
import org.apache.myfaces.cdi.util.BeanEntry;
import org.apache.myfaces.config.FacesConfigValidator;
import org.apache.myfaces.config.FacesConfigurator;
import org.apache.myfaces.config.ManagedBeanBuilder;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.config.element.ManagedBean;
import org.apache.myfaces.context.ReleaseableExternalContext;
import org.apache.myfaces.context.servlet.StartupFacesContextImpl;
import org.apache.myfaces.context.servlet.StartupServletExternalContextImpl;
import org.apache.myfaces.push.EndpointImpl;
import org.apache.myfaces.push.WebsocketConfigurator;
import org.apache.myfaces.push.WebsocketFacesInit;
import org.apache.myfaces.shared.application.FacesServletMappingUtils;
import org.apache.myfaces.shared.context.ExceptionHandlerImpl;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.myfaces.shared.util.StateUtils;
import org.apache.myfaces.shared.util.WebConfigParamUtils;
import org.apache.myfaces.spi.InjectionProvider;
import org.apache.myfaces.spi.InjectionProviderException;
import org.apache.myfaces.spi.InjectionProviderFactory;
import org.apache.myfaces.spi.ServiceProviderFinder;
import org.apache.myfaces.spi.ServiceProviderFinderFactory;
import org.apache.myfaces.spi.ViewScopeProvider;
import org.apache.myfaces.spi.ViewScopeProviderFactory;
import org.apache.myfaces.spi.WebConfigProvider;
import org.apache.myfaces.spi.WebConfigProviderFactory;
import org.apache.myfaces.util.ExternalSpecifications;
import org.apache.myfaces.view.facelets.ViewPoolProcessor;
import org.apache.myfaces.view.facelets.tag.MetaRulesetImpl;
import org.apache.myfaces.webapp.FacesInitializer;
import org.apache.myfaces.webapp.ManagedBeanDestroyerListener;
import org.apache.myfaces.webapp.WebConfigParamsLogger;

public abstract class AbstractFacesInitializer
implements FacesInitializer {
    private static final Logger log = Logger.getLogger(AbstractFacesInitializer.class.getName());
    protected static final String EXPRESSION_FACTORY = "org.apache.myfaces.EXPRESSION_FACTORY";
    protected static final String INITIALIZE_ALWAYS_STANDALONE = "org.apache.myfaces.INITIALIZE_ALWAYS_STANDALONE";
    public static final String INIT_PARAM_LOG_WEB_CONTEXT_PARAMS = "org.apache.myfaces.LOG_WEB_CONTEXT_PARAMS";
    public static final String INIT_PARAM_LOG_WEB_CONTEXT_PARAMS_DEFAULT = "auto";
    public static final String INIT_PARAM_AUTOMATIC_EXTENSIONLESS_MAPPING = "org.apache.myfaces.AUTOMATIC_EXTENSIONLESS_MAPPING";
    public static final boolean INIT_PARAM_AUTOMATIC_EXTENSIONLESS_MAPPING_DEFAULT = false;
    public static final String CDI_BEAN_MANAGER_INSTANCE = "oam.cdi.BEAN_MANAGER_INSTANCE";
    private static final String CDI_SERVLET_CONTEXT_BEAN_MANAGER_ATTRIBUTE = "javax.enterprise.inject.spi.BeanManager";
    private static final String INJECTED_BEAN_STORAGE_KEY = "org.apache.myfaces.spi.BEAN_ENTRY_STORAGE";

    @Override
    public void initFaces(ServletContext servletContext) {
        try {
            String useEncryption;
            Boolean mappingAdded;
            WebConfigProvider webConfigProvider;
            FacesContext facesContext;
            ExternalContext externalContext;
            ServiceProviderFinder spf;
            Map<String, List<String>> spfConfig;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Initializing MyFaces");
            }
            if ((spfConfig = (spf = ServiceProviderFinderFactory.getServiceProviderFinder(externalContext = (facesContext = FacesContext.getCurrentInstance()).getExternalContext())).calculateKnownServiceProviderMapInfo(externalContext, ServiceProviderFinder.KNOWN_SERVICES)) != null) {
                spf.initKnownServiceProviderMapInfo(externalContext, spfConfig);
            }
            if (!(WebConfigParamUtils.getBooleanInitParameter(externalContext, INITIALIZE_ALWAYS_STANDALONE, false) || !(webConfigProvider = WebConfigProviderFactory.getWebConfigProviderFactory(facesContext.getExternalContext()).getWebConfigProvider(facesContext.getExternalContext())).getFacesServletMappings(facesContext.getExternalContext()).isEmpty() || (mappingAdded = (Boolean)servletContext.getAttribute("org.apache.myfaces.FACES_SERVLET_FOUND")) != null && mappingAdded.booleanValue() || (mappingAdded = (Boolean)servletContext.getAttribute("org.apache.myfaces.DYNAMICALLY_ADDED_FACES_SERVLET")) != null && mappingAdded.booleanValue())) {
                if (log.isLoggable(Level.WARNING)) {
                    log.warning("No mappings of FacesServlet found. Abort initializing MyFaces.");
                }
                return;
            }
            this.initCDIIntegration(servletContext, externalContext);
            this.initContainerIntegration(servletContext, externalContext);
            ViewScopeProviderFactory factory = ViewScopeProviderFactory.getViewScopeHandlerFactory(externalContext);
            ViewScopeProvider viewScopeHandler = factory.getViewScopeHandler(externalContext);
            ManagedBeanDestroyerListener listener = (ManagedBeanDestroyerListener)externalContext.getApplicationMap().get(ManagedBeanDestroyerListener.APPLICATION_MAP_KEY);
            if (listener != null) {
                listener.setViewScopeHandler(viewScopeHandler);
            }
            if ("false".equals(useEncryption = servletContext.getInitParameter("org.apache.myfaces.USE_ENCRYPTION"))) {
                log.warning("org.apache.myfaces.USE_ENCRYPTION is set to false. This is unsecure and should only be used for local or intranet applications!");
            } else {
                StateUtils.initSecret(servletContext);
            }
            this._createEagerBeans(facesContext);
            this._dispatchApplicationEvent(servletContext, PostConstructApplicationEvent.class);
            this.initWebsocketIntegration(servletContext, externalContext);
            if ((facesContext.isProjectStage(ProjectStage.Development) || facesContext.isProjectStage(ProjectStage.Production)) && log.isLoggable(Level.INFO)) {
                log.info("ServletContext initialized.");
            }
            WebConfigParamsLogger.logWebContextParams(facesContext);
            this.checkForDeprecatedContextParams(facesContext);
            ExternalSpecifications.isBeanValidationAvailable();
            ViewPoolProcessor.initialize(facesContext);
            Boolean automaticExtensionlessMapping = WebConfigParamUtils.getBooleanInitParameter(externalContext, INIT_PARAM_AUTOMATIC_EXTENSIONLESS_MAPPING, false);
            if (Boolean.TRUE.equals(automaticExtensionlessMapping)) {
                this.initAutomaticExtensionlessMapping(facesContext, servletContext);
            }
            if (!facesContext.isProjectStage(ProjectStage.Production) && !facesContext.isProjectStage(ProjectStage.UnitTest)) {
                int i;
                ProjectStage projectStage = facesContext.getApplication().getProjectStage();
                StringBuilder message = new StringBuilder("\n\n");
                message.append("*******************************************************************\n");
                message.append("*** WARNING: Apache MyFaces-2 is running in ");
                message.append(projectStage.name().toUpperCase());
                message.append(" mode.");
                int length = projectStage.name().length();
                for (i = 0; i < 11 - length; ++i) {
                    message.append(" ");
                }
                message.append("   ***\n");
                message.append("***                                         ");
                for (i = 0; i < length; ++i) {
                    message.append("^");
                }
                for (i = 0; i < 20 - length; ++i) {
                    message.append(" ");
                }
                message.append("***\n");
                message.append("*** Do NOT deploy to your live server(s) without changing this. ***\n");
                message.append("*** See Application#getProjectStage() for more information.     ***\n");
                message.append("*******************************************************************\n");
                log.log(Level.WARNING, message.toString());
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "An error occured while initializing MyFaces: " + ex.getMessage(), ex);
        }
    }

    private void _createEagerBeans(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(externalContext);
        ArrayList<ManagedBean> eagerBeans = new ArrayList<ManagedBean>();
        for (ManagedBean bean : runtimeConfig.getManagedBeans().values()) {
            String eager = bean.getEager();
            if (eager == null || !"true".equals(eager)) continue;
            if ("application".equals(bean.getManagedBeanScope())) {
                eagerBeans.add(bean);
                continue;
            }
            log.log(Level.WARNING, "The managed-bean with name " + bean.getManagedBeanName() + " must be application scoped to support eager=true.");
        }
        if (!eagerBeans.isEmpty()) {
            ManagedBeanBuilder managedBeanBuilder = new ManagedBeanBuilder();
            Map applicationMap = externalContext.getApplicationMap();
            for (ManagedBean bean : eagerBeans) {
                if (applicationMap.containsKey(bean.getManagedBeanName())) continue;
                Object beanInstance = managedBeanBuilder.buildManagedBean(facesContext, bean);
                applicationMap.put(bean.getManagedBeanName(), beanInstance);
            }
        }
    }

    private void _dispatchApplicationEvent(ServletContext servletContext, Class<? extends SystemEvent> eventClass) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        application.publishEvent(facesContext, eventClass, Application.class, (Object)application);
    }

    @Override
    public void destroyFaces(ServletContext servletContext) {
        Boolean mappingAdded;
        WebConfigProvider webConfigProvider;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (!(WebConfigParamUtils.getBooleanInitParameter(facesContext.getExternalContext(), INITIALIZE_ALWAYS_STANDALONE, false) || !(webConfigProvider = WebConfigProviderFactory.getWebConfigProviderFactory(facesContext.getExternalContext()).getWebConfigProvider(facesContext.getExternalContext())).getFacesServletMappings(facesContext.getExternalContext()).isEmpty() || (mappingAdded = (Boolean)servletContext.getAttribute("org.apache.myfaces.FACES_SERVLET_FOUND")) != null && mappingAdded.booleanValue() || (mappingAdded = (Boolean)servletContext.getAttribute("org.apache.myfaces.DYNAMICALLY_ADDED_FACES_SERVLET")) != null && mappingAdded.booleanValue())) {
            if (log.isLoggable(Level.WARNING)) {
                log.warning("No mappings of FacesServlet found. Abort destroy MyFaces.");
            }
            return;
        }
        this._dispatchApplicationEvent(servletContext, PreDestroyApplicationEvent.class);
        this._callPreDestroyOnInjectedJSFArtifacts(facesContext);
        MetaRulesetImpl.clearMetadataTargetCache();
        if (facesContext.getExternalContext().getApplicationMap().containsKey("org.apache.myfaces.push")) {
            WebsocketFacesInit.clearWebsocketSessionLRUCache(facesContext.getExternalContext());
        }
        try {
            Class<?> c = Class.forName("javax.faces.component.UIViewParameter");
            Method m = c.getDeclaredMethod("releaseRenderer", new Class[0]);
            m.setAccessible(true);
            m.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected RuntimeConfig buildConfiguration(ServletContext servletContext, ExternalContext externalContext, ExpressionFactory expressionFactory) {
        RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(externalContext);
        runtimeConfig.setExpressionFactory(expressionFactory);
        new FacesConfigurator(externalContext).configure();
        this.validateFacesConfig(servletContext, externalContext);
        return runtimeConfig;
    }

    protected void validateFacesConfig(ServletContext servletContext, ExternalContext externalContext) {
        String validate = servletContext.getInitParameter("org.apache.myfaces.VALIDATE");
        if ("true".equals(validate) && log.isLoggable(Level.WARNING)) {
            List<String> warnings = FacesConfigValidator.validate(externalContext);
            for (String warning : warnings) {
                log.warning(warning);
            }
        }
    }

    protected static ExpressionFactory getUserDefinedExpressionFactory(ExternalContext externalContext) {
        String expressionFactoryClassName = WebConfigParamUtils.getStringInitParameter(externalContext, EXPRESSION_FACTORY);
        if (expressionFactoryClassName != null && expressionFactoryClassName.trim().length() > 0) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Attempting to load the ExpressionFactory implementation you've specified: '" + expressionFactoryClassName + "'.");
            }
            return AbstractFacesInitializer.loadExpressionFactory(expressionFactoryClassName);
        }
        return null;
    }

    protected static ExpressionFactory loadExpressionFactory(String expressionFactoryClassName) {
        return AbstractFacesInitializer.loadExpressionFactory(expressionFactoryClassName, true);
    }

    protected static ExpressionFactory loadExpressionFactory(String expressionFactoryClassName, boolean logMissing) {
        try {
            ClassLoader cl = ClassUtils.getContextClassLoader();
            if (cl == null) {
                cl = AbstractFacesInitializer.class.getClassLoader();
            }
            Class<?> expressionFactoryClass = cl.loadClass(expressionFactoryClassName);
            return (ExpressionFactory)expressionFactoryClass.newInstance();
        }
        catch (Exception ex) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "An error occured while instantiating a new ExpressionFactory. Attempted to load class '" + expressionFactoryClassName + "'.", ex);
            }
            return null;
        }
    }

    @Override
    public FacesContext initStartupFacesContext(ServletContext servletContext) {
        return this._createFacesContext(servletContext, true);
    }

    @Override
    public void destroyStartupFacesContext(FacesContext facesContext) {
        this._releaseFacesContext(facesContext);
    }

    @Override
    public FacesContext initShutdownFacesContext(ServletContext servletContext) {
        return this._createFacesContext(servletContext, false);
    }

    @Override
    public void destroyShutdownFacesContext(FacesContext facesContext) {
        this._releaseFacesContext(facesContext);
    }

    private FacesContext _createFacesContext(ServletContext servletContext, boolean startup) {
        StartupServletExternalContextImpl externalContext = new StartupServletExternalContextImpl(servletContext, startup);
        ExceptionHandlerImpl exceptionHandler = new ExceptionHandlerImpl();
        StartupFacesContextImpl facesContext = new StartupFacesContextImpl((ExternalContext)externalContext, (ReleaseableExternalContext)externalContext, exceptionHandler, startup);
        UIViewRoot startupViewRoot = new UIViewRoot();
        startupViewRoot.setLocale(Locale.getDefault());
        facesContext.setViewRoot(startupViewRoot);
        return facesContext;
    }

    private void _releaseFacesContext(FacesContext facesContext) {
        if (facesContext != null) {
            facesContext.release();
        }
    }

    protected abstract void initContainerIntegration(ServletContext var1, ExternalContext var2);

    protected void initCDIIntegration(ServletContext servletContext, ExternalContext externalContext) {
        Object beanManager = servletContext.getAttribute(CDI_SERVLET_CONTEXT_BEAN_MANAGER_ATTRIBUTE);
        if (beanManager == null) {
            beanManager = this.lookupBeanManagerFromCDI();
        }
        if (beanManager == null) {
            beanManager = this.lookupBeanManagerFromJndi();
        }
        if (beanManager != null) {
            externalContext.getApplicationMap().put(CDI_BEAN_MANAGER_INSTANCE, beanManager);
        }
    }

    private Object lookupBeanManagerFromCDI() {
        try {
            Class cdiClass = null;
            Method cdiCurrentMethod = null;
            Method cdiGetBeanManagerMethod = null;
            cdiClass = AbstractFacesInitializer.simpleClassForNameNoException("javax.enterprise.inject.spi.CDI");
            if (cdiClass != null) {
                cdiCurrentMethod = cdiClass.getMethod("current", new Class[0]);
                Object cdiInstance = cdiCurrentMethod.invoke(null, new Object[0]);
                cdiGetBeanManagerMethod = cdiClass.getMethod("getBeanManager", new Class[0]);
                return cdiGetBeanManagerMethod.invoke(cdiInstance, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static Class simpleClassForNameNoException(String type) {
        try {
            return ClassUtils.classForName(type);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private Object lookupBeanManagerFromJndi() {
        Object beanManager = null;
        Class icclazz = null;
        Method lookupMethod = null;
        try {
            icclazz = ClassUtils.simpleClassForName("javax.naming.InitialContext");
            if (icclazz != null) {
                lookupMethod = icclazz.getMethod("doLookup", String.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (lookupMethod != null) {
            try {
                beanManager = lookupMethod.invoke((Object)icclazz, "java:comp/BeanManager");
            }
            catch (Exception exception) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            if (beanManager == null) {
                try {
                    beanManager = lookupMethod.invoke((Object)icclazz, "java:comp/env/BeanManager");
                }
                catch (Exception exception) {
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    // empty catch block
                }
            }
        }
        return beanManager;
    }

    public void _callPreDestroyOnInjectedJSFArtifacts(FacesContext facesContext) {
        InjectionProvider injectionProvider = InjectionProviderFactory.getInjectionProviderFactory(facesContext.getExternalContext()).getInjectionProvider(facesContext.getExternalContext());
        List injectedBeanStorage = (List)facesContext.getExternalContext().getApplicationMap().get(INJECTED_BEAN_STORAGE_KEY);
        if (injectedBeanStorage != null) {
            for (BeanEntry entry : injectedBeanStorage) {
                try {
                    injectionProvider.preDestroy(entry.getInstance(), entry.getCreationMetaData());
                }
                catch (InjectionProviderException ex) {
                    log.log(Level.INFO, "Exception on PreDestroy", ex);
                }
            }
            injectedBeanStorage.clear();
        }
    }

    protected void initWebsocketIntegration(ServletContext servletContext, ExternalContext externalContext) {
        Boolean b = WebConfigParamUtils.getBooleanInitParameter(externalContext, "javax.faces.ENABLE_WEBSOCKET_ENDPOINT");
        if (Boolean.TRUE.equals(b)) {
            ServerContainer serverContainer = (ServerContainer)servletContext.getAttribute("javax.websocket.server.ServerContainer");
            if (serverContainer != null) {
                try {
                    serverContainer.addEndpoint(ServerEndpointConfig.Builder.create(EndpointImpl.class, (String)"/javax.faces.push/{channel}").configurator((ServerEndpointConfig.Configurator)new WebsocketConfigurator(externalContext)).build());
                    WebsocketFacesInit.initWebsocketSessionLRUCache(externalContext);
                    externalContext.getApplicationMap().put("org.apache.myfaces.push", "true");
                }
                catch (DeploymentException e) {
                    log.log(Level.INFO, "Exception on Initialize Websocket Endpoint: ", e);
                }
            } else {
                log.log(Level.INFO, "f:websocket support enabled but cannot found websocket ServerContainer instance on current context. If websocket library is available, please include a FakeEndpoint instance into your code to force enable it (Tyrus users).");
            }
        }
    }

    protected void initAutomaticExtensionlessMapping(FacesContext facesContext, ServletContext servletContext) {
        ServletRegistration facesServletRegistration = this.getFacesServletRegistration(facesContext, servletContext);
        if (facesServletRegistration != null) {
            facesContext.getApplication().getViewHandler().getViews(facesContext, "/", new ViewVisitOption[]{ViewVisitOption.RETURN_AS_MINIMAL_IMPLICIT_OUTCOME}).forEach(s -> facesServletRegistration.addMapping(new String[]{s}));
        }
    }

    private ServletRegistration getFacesServletRegistration(FacesContext facesContext, ServletContext servletContext) {
        ServletRegistration facesServletRegistration = null;
        Map map = servletContext.getServletRegistrations();
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                if (!FacesServletMappingUtils.isFacesServlet(facesContext, ((ServletRegistration)entry.getValue()).getClassName())) continue;
                facesServletRegistration = (ServletRegistration)entry.getValue();
                break;
            }
        }
        return facesServletRegistration;
    }

    protected void checkForDeprecatedContextParams(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        String value = externalContext.getInitParameter("org.apache.myfaces.CDI_MANAGED_CONVERTERS_ENABLED");
        if (value != null && !value.isEmpty()) {
            log.severe("'org.apache.myfaces.CDI_MANAGED_CONVERTERS_ENABLED' is not supported anymore since 2.3. Please use @FacesConverter with managed=true.");
        }
        if ((value = externalContext.getInitParameter("org.apache.myfaces.CDI_MANAGED_VALIDATORS_ENABLED")) != null && !value.isEmpty()) {
            log.severe("'org.apache.myfaces.CDI_MANAGED_VALIDATORS_ENABLED' is not supported anymore since 2.3. Please use @FacesValidator with managed=true.");
        }
        if ((value = externalContext.getInitParameter("org.apache.myfaces.SAVE_STATE_WITH_VISIT_TREE_ON_PSS")) != null && !value.isEmpty()) {
            log.severe("'org.apache.myfaces.SAVE_STATE_WITH_VISIT_TREE_ON_PSS' is not supported anymore since 2.3.");
        }
        if ((value = externalContext.getInitParameter("org.apache.myfaces.CACHE_OLD_VIEWS_IN_SESSION_MODE")) != null && !value.isEmpty()) {
            log.severe("'org.apache.myfaces.CACHE_OLD_VIEWS_IN_SESSION_MODE' is not supported anymore since 2.3.");
        }
        if ((value = externalContext.getInitParameter("org.apache.myfaces.HANDLE_STATE_CACHING_MECHANICS")) != null && !value.isEmpty()) {
            log.severe("'org.apache.myfaces.HANDLE_STATE_CACHING_MECHANICS' is not supported anymore since 2.3.");
        }
        if ((value = externalContext.getInitParameter("org.apache.myfaces.ERROR_HANDLER")) != null && !value.isEmpty()) {
            log.severe("'org.apache.myfaces.ERROR_HANDLER' is not supported anymore since 2.3.");
        }
        if ((value = externalContext.getInitParameter("org.apache.myfaces.STRICT_JSF_2_REFRESH_TARGET_AJAX")) != null && !value.isEmpty()) {
            log.severe("'org.apache.myfaces.STRICT_JSF_2_REFRESH_TARGET_AJAX' is not supported anymore since 2.3.");
        }
    }
}

