/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.util;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.validator.Validator;
import org.apache.myfaces.cdi.dependent.AbstractBeanStorage;
import org.apache.myfaces.cdi.dependent.DependentBeanEntry;
import org.apache.myfaces.cdi.dependent.RequestDependentBeanStorage;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.cdi.util.ExternalArtifactResolver;
import org.apache.myfaces.shared.config.MyfacesConfig;
import org.apache.myfaces.util.ExternalSpecifications;

public class CDIExternalArtifactResolver
extends ExternalArtifactResolver {
    public static final String JAVAX_FACES_CONVERT_PACKAGE_NAME = "javax.faces.convert";
    public static final String JAVAX_FACES_VALIDATOR_PACKAGE_NAME = "javax.faces.validator";
    private Boolean managedConvertersEnabled;
    private Boolean managedValidatorsEnabled;

    public CDIExternalArtifactResolver() {
        this.initConverterInjectionEnabled();
        this.initValidatorInjectionEnabled();
    }

    private boolean isManagedConvertersEnabled() {
        if (this.managedConvertersEnabled != null) {
            return this.managedConvertersEnabled;
        }
        return this.managedConvertersEnabled;
    }

    private void initConverterInjectionEnabled() {
        if (this.managedConvertersEnabled != null) {
            return;
        }
        this.managedConvertersEnabled = MyfacesConfig.getCurrentInstance((ExternalContext)FacesContext.getCurrentInstance().getExternalContext()).isCdiManagedConvertersEnabled();
    }

    @Override
    public Converter resolveManagedConverter(Class<? extends Converter> converterClass) {
        if (!this.isManagedConvertersEnabled()) {
            return null;
        }
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        if (!ExternalSpecifications.isCDIAvailable(externalContext) || JAVAX_FACES_CONVERT_PACKAGE_NAME.equals(converterClass.getPackage().getName())) {
            return null;
        }
        BeanManager beanManager = CDIUtils.getBeanManager(externalContext);
        return CDIExternalArtifactResolver.getContextualReference(beanManager, converterClass);
    }

    private boolean isManagedValidatorsEnabled() {
        if (this.managedValidatorsEnabled != null) {
            return this.managedValidatorsEnabled;
        }
        return this.managedValidatorsEnabled;
    }

    private void initValidatorInjectionEnabled() {
        if (this.managedValidatorsEnabled != null) {
            return;
        }
        this.managedValidatorsEnabled = MyfacesConfig.getCurrentInstance((ExternalContext)FacesContext.getCurrentInstance().getExternalContext()).isCdiManagedValidatorsEnabled();
    }

    @Override
    public Validator resolveManagedValidator(Class<? extends Validator> validatorClass) {
        if (!this.isManagedValidatorsEnabled()) {
            return null;
        }
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        if (!ExternalSpecifications.isCDIAvailable(externalContext) || JAVAX_FACES_VALIDATOR_PACKAGE_NAME.equals(validatorClass.getPackage().getName())) {
            return null;
        }
        BeanManager beanManager = CDIUtils.getBeanManager(externalContext);
        return CDIExternalArtifactResolver.getContextualReference(beanManager, validatorClass);
    }

    private static <T> T getContextualReference(BeanManager beanManager, Class<T> type) {
        Set beans = beanManager.getBeans(type, new Annotation[0]);
        if (beans == null || beans.isEmpty()) {
            return null;
        }
        Bean bean = beanManager.resolve(beans);
        CreationalContext creationalContext = beanManager.createCreationalContext((Contextual)bean);
        Object result = beanManager.getReference(bean, type, creationalContext);
        if (bean.getScope().equals(Dependent.class)) {
            AbstractBeanStorage beanStorage = CDIExternalArtifactResolver.getContextualReference(beanManager, RequestDependentBeanStorage.class);
            beanStorage.add(new DependentBeanEntry<Object>(result, bean, creationalContext));
        }
        return (T)result;
    }
}

