/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.tx.util.logging.Tr;
import com.ibm.tx.util.logging.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.Configuration;
import com.ibm.ws.recoverylog.spi.FailureScopeFactory;
import com.ibm.ws.recoverylog.spi.FailureScopeManager;
import com.ibm.ws.recoverylog.spi.FileFailureScope;
import com.ibm.ws.recoverylog.spi.FileFailureScopeFactory;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.RecoveryDirector;
import com.ibm.ws.recoverylog.spi.RecoveryDirectorFactory;
import com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl;
import com.ibm.ws.recoverylog.spi.RecoveryFailedException;
import com.ibm.ws.recoverylog.spi.RecoveryLogAccessControllerImpl;
import com.ibm.ws.recoverylog.spi.RecoveryLogComponentImpl;
import com.ibm.ws.recoverylog.spi.RecoveryLogFactory;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RecLogServiceImpl {
    private static TraceComponent tc;
    private String _recoveryGroup = null;
    private boolean _isPeerRecoverySupported = false;
    private static boolean _readyToStart;
    private static boolean _recoveryLogDSReady;
    static final long serialVersionUID = 1366247435868226080L;
    private static final /* synthetic */ com.ibm.websphere.ras.TraceComponent $$$tc$$$;

    public RecLogServiceImpl() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"RecLogServiceImpl", (Object)this);
        }
    }

    public void initialize(String serverName) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize", (Object)serverName);
        }
        String installDirectory = "dir";
        Configuration.serverName(serverName);
        Configuration.WASInstallDirectory(installDirectory);
        Configuration.localFailureScope(new FileFailureScope());
        Configuration.isZOS(false);
        Configuration.setRecoveryLogComponent(new RecoveryLogComponentImpl());
        Configuration.setAccessController(new RecoveryLogAccessControllerImpl());
        FailureScopeManager.registerFailureScopeFactory(FailureScopeFactory.FILE_FAILURE_SCOPE_ID, FileFailureScope.class, new FileFailureScopeFactory());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    protected void activate(ComponentContext cc) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"activate", (Object)this);
        }
    }

    public void unsetRecoveryLogFactory(RecoveryLogFactory fac) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unsetRecoveryLogFactory, factory: " + fac), (Object)this);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void startRecovery(RecoveryLogFactory fac) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"startRecovery", (Object)fac);
        }
        RecoveryDirector director = null;
        try {
            director = RecoveryDirectorFactory.recoveryDirector();
            director.setRecoveryLogFactory(fac);
            ((RecoveryDirectorImpl)director).driveLocalRecovery();
        }
        catch (RecoveryFailedException recoveryFailedException) {
            void exc;
            FFDCFilter.processException((Throwable)recoveryFailedException, (String)"com.ibm.ws.recoverylog.spi.RecLogServiceImpl", (String)"114", (Object)this, (Object[])new Object[]{fac});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Local recovery failed.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"start", (Object)"RuntimeError");
            }
            throw new RuntimeException("Unable to complete local recovery processing", (Throwable)exc);
        }
        catch (InternalLogException exc) {
            void ile;
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecLogServiceImpl", (String)"120", (Object)this, (Object[])new Object[]{fac});
            com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)ile, (String)"com.ibm.ws.recoverylog.spi.RecLogServiceImpl.startRecovery", (String)"478", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Local recovery not attempted.", (Object)ile);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"start", (Object)"RuntimeError");
            }
            throw new RuntimeException("Unable to complete local recovery processing", (Throwable)ile);
        }
        this.startPeerRecovery(director);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startRecovery");
        }
    }

    @FFDCIgnore(value={RecoveryFailedException.class})
    public void startPeerRecovery(RecoveryDirector director) {
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"startPeerRecovery", (Object)director);
            }
            if (director != null && this._isPeerRecoverySupported && this.checkPeersAtStartup()) {
                try {
                    if (director instanceof RecoveryDirectorImpl) {
                        ((RecoveryDirectorImpl)director).drivePeerRecovery();
                    }
                }
                catch (RecoveryFailedException exc) {
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug((TraceComponent)tc, (String)"Peer recovery failed.");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startPeerRecovery");
        }
    }

    public void stop() {
    }

    public void destroy() {
    }

    public void setPeerRecoverySupported(boolean isPeerRecoverySupported) {
        this._isPeerRecoverySupported = isPeerRecoverySupported;
    }

    public void setRecoveryGroup(String recoveryGroup) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setRecoveryGroup", (Object)new Object[]{recoveryGroup});
        }
        this._recoveryGroup = recoveryGroup;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setRecoveryGroup");
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkPeersAtStartup() {
        boolean checkAtStartup;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkPeersAtStartup");
        }
        try {
            checkAtStartup = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){
                static final long serialVersionUID = -7575411395322914251L;
                private static final /* synthetic */ com.ibm.websphere.ras.TraceComponent $$$tc$$$;

                @Override
                public Boolean run() {
                    return Boolean.getBoolean("com.ibm.ws.recoverylog.spi.CheckPeersAtStartup");
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = com.ibm.websphere.ras.Tr.register((String)"com.ibm.ws.recoverylog.spi.RecLogServiceImpl$1", 1.class, null, null);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.recoverylog.spi.RecLogServiceImpl", (String)"216", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)"checkPeersAtStartup", (Object)e);
            }
            checkAtStartup = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkPeersAtStartup", (Object)checkAtStartup);
        }
        return checkAtStartup;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = com.ibm.websphere.ras.Tr.register((String)"com.ibm.ws.recoverylog.spi.RecLogServiceImpl", RecLogServiceImpl.class, null, null);
        tc = Tr.register(RecLogServiceImpl.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
        _readyToStart = false;
        _recoveryLogDSReady = false;
    }
}

