/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.tx.util.logging.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PeerLeaseData {
    private static final com.ibm.tx.util.logging.TraceComponent tc;
    private final String _recoveryIdentity;
    private final long _leaseTime;
    private final int _leaseTimeout;
    static final long serialVersionUID = 6465566093042642773L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public PeerLeaseData(String recoveryIdentity, long leaseTime, int leaseTimeout) {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"PeerLeaseData", (Object)new Object[]{recoveryIdentity, leaseTime, leaseTimeout});
        }
        this._recoveryIdentity = recoveryIdentity;
        this._leaseTime = leaseTime;
        this._leaseTimeout = leaseTimeout;
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"PeerLeaseData");
        }
    }

    public String getRecoveryIdentity() {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"getRecoveryIdentity");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"getRecoveryIdentity", (Object)this._recoveryIdentity);
        }
        return this._recoveryIdentity;
    }

    public long getLeaseTime() {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"getLeaseTime");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"getLeaseTime", (Object)this._leaseTime);
        }
        return this._leaseTime;
    }

    public boolean isExpired() {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"isExpired");
        }
        boolean expired = false;
        long curTime = System.currentTimeMillis();
        if (curTime - this._leaseTime > (long)(this._leaseTimeout * 1000)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("Lease has EXPIRED for " + this._recoveryIdentity + ", currenttime: " + curTime + ", storedTime: " + this._leaseTime));
            }
            expired = true;
        } else if (tc.isDebugEnabled()) {
            Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("Lease has not expired for " + this._recoveryIdentity + ", currenttime: " + curTime + ", storedTime: " + this._leaseTime));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"isExpired", (Object)expired);
        }
        return expired;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = com.ibm.websphere.ras.Tr.register((String)"com.ibm.ws.recoverylog.spi.PeerLeaseData", PeerLeaseData.class, null, null);
        tc = Tr.register(PeerLeaseData.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    }
}

