/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.ssl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ssl.JSSEProvider;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public class SSLConfig
extends Properties {
    private static final long serialVersionUID = 5592062346302545106L;
    protected static final TraceComponent tc = Tr.register(SSLConfig.class, (String)"SSL", (String)"com.ibm.ws.ssl.resources.ssl");

    public SSLConfig() {
        this.initializeDefaults();
    }

    public SSLConfig(Properties props) {
        if (props != null) {
            super.putAll((Map<?, ?>)props);
        }
        this.initializeDefaults();
    }

    public SSLConfig(String configURL) {
        this.loadPropertiesFile(configURL, false);
        this.initializeDefaults();
    }

    private void initializeDefaults() {
        String keyStoreType = this.getProperty("com.ibm.ssl.keyStoreType");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("keyStoreType: " + keyStoreType), (Object[])new Object[0]);
        }
        if (keyStoreType == null && this.getProperty("javax.net.ssl.keyStoreType") == null) {
            this.setProperty("com.ibm.ssl.keyStoreFileBased", "true");
            this.setProperty("com.ibm.ssl.keyStoreType", "PKCS12");
            keyStoreType = "PKCS12";
        } else if (!(keyStoreType == null || keyStoreType.equals("JKS") || keyStoreType.equals("JCEKS") || keyStoreType.equals("PKCS12"))) {
            this.setProperty("com.ibm.ssl.keyStoreFileBased", "false");
        } else {
            this.setProperty("com.ibm.ssl.keyStoreFileBased", "true");
        }
        String trustStoreType = this.getProperty("com.ibm.ssl.trustStoreType");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("trustStoreType: " + trustStoreType), (Object[])new Object[0]);
        }
        if (trustStoreType == null && this.getProperty("javax.net.ssl.trustStoreType") == null) {
            this.setProperty("com.ibm.ssl.trustStoreFileBased", "true");
            this.setProperty("com.ibm.ssl.trustStoreType", "PKCS12");
            trustStoreType = "PKCS12";
        } else if (!(trustStoreType == null || trustStoreType.equals("JKS") || trustStoreType.equals("JCEKS") || trustStoreType.equals("PKCS12"))) {
            this.setProperty("com.ibm.ssl.trustStoreFileBased", "false");
        } else {
            this.setProperty("com.ibm.ssl.trustStoreFileBased", "true");
        }
        JSSEProvider defaultProvider = JSSEProviderFactory.getInstance();
        if (this.getProperty("com.ibm.ssl.keyManager") == null) {
            this.setProperty("com.ibm.ssl.keyManager", JSSEProviderFactory.getKeyManagerFactoryAlgorithm());
        }
        if (this.getProperty("com.ibm.ssl.keyStoreProvider") == null && null != defaultProvider.getKeyStoreProvider()) {
            this.setProperty("com.ibm.ssl.keyStoreProvider", defaultProvider.getKeyStoreProvider());
        }
        if (this.getProperty("com.ibm.ssl.protocol") == null) {
            this.setProperty("com.ibm.ssl.protocol", defaultProvider.getDefaultProtocol());
        }
        if (this.getProperty("com.ibm.ssl.clientAuthentication") == null) {
            this.setProperty("com.ibm.ssl.clientAuthentication", "false");
        }
        if (this.getProperty("com.ibm.ssl.contextProvider") == null) {
            this.setProperty("com.ibm.ssl.contextProvider", defaultProvider.getContextProvider());
        }
        if (this.getProperty("com.ibm.ssl.securityLevel") == null) {
            this.setProperty("com.ibm.ssl.securityLevel", "HIGH");
        }
        if (this.getProperty("com.ibm.ssl.trustManager") == null) {
            this.setProperty("com.ibm.ssl.trustManager", JSSEProviderFactory.getTrustManagerFactoryAlgorithm());
        }
        if (this.getProperty("com.ibm.ssl.trustStoreProvider") == null && null != defaultProvider.getKeyStoreProvider()) {
            this.setProperty("com.ibm.ssl.trustStoreProvider", defaultProvider.getKeyStoreProvider());
        }
        if (this.getProperty("com.ibm.ssl.validationEnabled") == null) {
            this.setProperty("com.ibm.ssl.validationEnabled", "false");
        }
        if (this.getProperty("com.ibm.ssl.tokenEnabled") == null) {
            this.setProperty("com.ibm.ssl.tokenEnabled", "false");
        }
        String keyStore = this.getProperty("com.ibm.ssl.keyStore");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("keyStore: " + keyStore), (Object[])new Object[0]);
        }
        String keyStoreName = this.getProperty("com.ibm.ssl.keyStoreName");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("keyStoreName: " + keyStoreName), (Object[])new Object[0]);
        }
        String keyStorePassword = this.getProperty("com.ibm.ssl.keyStorePassword");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("keyStorePassword: " + SSLConfigManager.mask(keyStorePassword)), (Object[])new Object[0]);
        }
        String trustStore = this.getProperty("com.ibm.ssl.trustStore");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("trustStore: " + trustStore), (Object[])new Object[0]);
        }
        String trustStoreName = this.getProperty("com.ibm.ssl.trustStoreName");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("trustStoreName: " + trustStoreName), (Object[])new Object[0]);
        }
        String trustStorePassword = this.getProperty("com.ibm.ssl.trustStorePassword");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("trustStorePassword: " + SSLConfigManager.mask(trustStorePassword)), (Object[])new Object[0]);
        }
        if (keyStore == null && trustStore != null && trustStorePassword != null && trustStoreType != null) {
            this.setProperty("com.ibm.ssl.keyStore", trustStore);
            this.setProperty("com.ibm.ssl.keyStoreName", trustStoreName);
            this.setProperty("com.ibm.ssl.keyStorePassword", trustStorePassword);
            this.setProperty("com.ibm.ssl.keyStoreType", trustStoreType);
        } else if (trustStore == null && keyStore != null && keyStorePassword != null && keyStoreType != null) {
            this.setProperty("com.ibm.ssl.trustStore", keyStore);
            this.setProperty("com.ibm.ssl.trustStoreName", keyStoreName);
            this.setProperty("com.ibm.ssl.trustStorePassword", keyStorePassword);
            this.setProperty("com.ibm.ssl.trustStoreType", keyStoreType);
        }
    }

    public void validateSSLConfig() throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validateSSLConfig", (Object[])new Object[0]);
        }
        try {
            if (Boolean.parseBoolean(this.getProperty("com.ibm.ssl.validationEnabled"))) {
                JSSEProviderFactory.getInstance().getSSLContext(null, this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"validateSSLConfig -> true");
                }
                return;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"validateSSLConfig not enabled.");
            }
            return;
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"validateSSLConfig -> false");
            }
            throw e;
        }
    }

    private boolean propertyExists(String key) {
        String value = this.getProperty(key);
        return null != value && 0 < value.length();
    }

    public boolean requiredPropertiesArePresent() {
        boolean valid;
        boolean bl = valid = this.propertyExists("com.ibm.ssl.keyStore") && this.propertyExists("com.ibm.ssl.trustStore");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("requiredPropertiesArePresent -> " + valid), (Object[])new Object[0]);
        }
        return valid;
    }

    @Override
    public String toString() {
        Enumeration<?> e = this.propertyNames();
        StringBuilder buf = new StringBuilder(256);
        buf.append("SSLConfig.toString() {\n");
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = this.getProperty(name);
            if (name.toLowerCase().indexOf("password") != -1) {
                buf.append(name);
                buf.append('=');
                buf.append(SSLConfigManager.mask(value));
                buf.append('\n');
                continue;
            }
            buf.append(name);
            buf.append('=');
            buf.append(value);
            buf.append('\n');
        }
        buf.append('}');
        return buf.toString();
    }

    public SSLConfig[] loadPropertiesFile(final String propertiesURL, final boolean multiConfigURL) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"loadPropertiesFile", (Object[])new Object[]{propertiesURL, multiConfigURL});
        }
        SSLConfig[] sslConfigs = null;
        if (propertiesURL == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"loadPropertiesFile (null props file)");
            }
            return null;
        }
        try {
            sslConfigs = AccessController.doPrivileged(new PrivilegedExceptionAction<SSLConfig[]>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public SSLConfig[] run() throws Exception {
                    block14: {
                        InputStream istream = null;
                        BufferedReader in = null;
                        try {
                            URL url = new URL(propertiesURL);
                            istream = url.openStream();
                            if (!multiConfigURL) {
                                SSLConfig.this.load(istream);
                                break block14;
                            }
                            String s = null;
                            in = new BufferedReader(new InputStreamReader(istream));
                            ArrayList<SSLConfig> sslConfigList = new ArrayList<SSLConfig>();
                            SSLConfig currentSSLConfig = new SSLConfig();
                            currentSSLConfig.clear();
                            while ((s = in.readLine()) != null) {
                                String value;
                                String name;
                                int index;
                                if (s.trim().startsWith("#") || s.trim().length() <= 0) continue;
                                if (s.trim().startsWith("com.ibm.ssl.alias")) {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"Saving SSL configuration...", (Object[])new Object[0]);
                                    }
                                    sslConfigList.add(currentSSLConfig);
                                    currentSSLConfig = new SSLConfig();
                                    index = s.indexOf(61);
                                    name = s.substring(0, index);
                                    value = s.substring(index + 1);
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("Parsing SSL configuration with alias: " + value), (Object[])new Object[0]);
                                    }
                                    currentSSLConfig.setProperty(name, value, true);
                                    continue;
                                }
                                if (s.trim().indexOf(61) == -1) continue;
                                index = s.indexOf(61);
                                name = s.substring(0, index);
                                value = null;
                                if (name != null) {
                                    value = System.getProperty(name);
                                }
                                if (value == null) {
                                    value = s.substring(index + 1);
                                }
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Parsing SSL property: " + name + " = " + value), (Object[])new Object[0]);
                                }
                                currentSSLConfig.setProperty(name, value, true);
                            }
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Saving SSL configuration...", (Object[])new Object[0]);
                            }
                            sslConfigList.add(currentSSLConfig);
                            SSLConfig[] sSLConfigArray = sslConfigList.toArray(new SSLConfig[sslConfigList.size()]);
                            return sSLConfigArray;
                        }
                        finally {
                            if (null != in) {
                                in.close();
                            }
                            if (istream != null) {
                                istream.close();
                            }
                        }
                    }
                    return null;
                }
            });
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"loadPropertiesFile");
            }
            return sslConfigs;
        }
        catch (PrivilegedActionException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("loadPropertiesFile exception; " + e.getException()), (Object[])new Object[0]);
            }
            FFDCFilter.processException((Throwable)e.getException(), (String)this.getClass().getName(), (String)"loadPropertiesFile", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"loadPropertiesFile");
            }
            return null;
        }
    }

    public void decodePasswords() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"decodePasswords", (Object[])new Object[0]);
        }
        Enumeration<?> e = this.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.toLowerCase().indexOf("password") == -1) continue;
            this.setProperty(name, WSKeyStore.decodePassword(this.getProperty(name)));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"decodePasswords");
        }
    }

    public static String validateURL(String propertiesURL) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Existing propertiesURL: " + propertiesURL), (Object[])new Object[0]);
        }
        int end = 0;
        for (int i = propertiesURL.indexOf(58, 0) + 1; i < propertiesURL.length(); ++i) {
            char c = propertiesURL.charAt(i);
            if (c == '/' || c == '\\') continue;
            end = i;
            break;
        }
        String rc = "file:/" + propertiesURL.substring(end);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("New propertiesURL: " + rc), (Object[])new Object[0]);
        }
        return rc;
    }

    public String getDynamicSelectionProperty() {
        return this.getProperty("com.ibm.ssl.dynamicSelectionInfo");
    }

    @Override
    public boolean equals(Object config) {
        if (config instanceof SSLConfig) {
            SSLConfig sslconfig = (SSLConfig)config;
            if (this.size() != sslconfig.size()) {
                return false;
            }
            Enumeration<?> e = this.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = this.getProperty(name);
                String otherValue = sslconfig.getProperty(name);
                if (value == null || otherValue != null && value.equals(otherValue)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Object setProperty(String name, String value, boolean processEscapeSequences) {
        String newVal = value;
        if (newVal != null && processEscapeSequences) {
            int idx = newVal.indexOf("\\u");
            while (idx != -1 && idx < newVal.length()) {
                int idx1 = idx + 2 < newVal.length() ? idx + 2 : newVal.length();
                int idx2 = idx + 6 < newVal.length() ? idx + 6 : newVal.length();
                String digits = newVal.substring(idx1, idx2);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Potential unicode character detected: '\\u" + digits + "'"), (Object[])new Object[0]);
                }
                if (digits != null && digits.length() == 4) {
                    try {
                        char c = (char)Integer.parseInt(digits, 16);
                        newVal = newVal.substring(0, idx) + c + newVal.substring(idx + 6, newVal.length());
                    }
                    catch (Exception e) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Error in unicode format", (Object[])new Object[]{e});
                        }
                        throw new IllegalArgumentException("Malformed \\uxxxx encoding. digits=" + digits);
                    }
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Error in unicode format", (Object[])new Object[0]);
                    }
                    throw new IllegalArgumentException("Malformed \\uxxxx encoding. digits=" + digits);
                }
                idx = newVal.indexOf("\\u", idx + 1);
            }
            idx = newVal.indexOf("\\=");
            while (idx != -1 && idx < newVal.length()) {
                newVal = newVal.substring(0, idx) + "=" + newVal.substring(idx + 2, newVal.length());
                idx = newVal.indexOf("\\=");
            }
            idx = newVal.indexOf("\\:");
            while (idx != -1 && idx < newVal.length()) {
                newVal = newVal.substring(0, idx) + ":" + newVal.substring(idx + 2, newVal.length());
                idx = newVal.indexOf("\\:");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && value != null && !value.equals(newVal)) {
            Tr.debug((TraceComponent)tc, (String)("Property value changed to: " + newVal), (Object[])new Object[0]);
        }
        return super.setProperty(name, newVal);
    }
}

