/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jwtsso.token.proxy.JwtSSOTokenHelper;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import com.ibm.wsspi.security.token.SingleSignonToken;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.http.Cookie;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WebSecurityHelperImpl {
    private static final TraceComponent tc = Tr.register(WebSecurityHelperImpl.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
    private static WebAppSecurityConfig webAppSecConfig = null;
    static final long serialVersionUID = 8478026849650298300L;

    public static void setWebAppSecurityConfig(WebAppSecurityConfig webAppSecConfig) {
        WebSecurityHelperImpl.webAppSecConfig = webAppSecConfig;
    }

    private static Cookie constructLTPACookieObj(SingleSignonToken ssoToken) {
        byte[] ssoTokenBytes = ssoToken.getBytes();
        String ssoCookieString = Base64Coder.base64EncodeToString((byte[])ssoTokenBytes);
        Cookie cookie = new Cookie(webAppSecConfig.getSSOCookieName(), ssoCookieString);
        return cookie;
    }

    static Cookie getLTPACookie(Subject subject) throws Exception {
        Cookie ltpaCookie = null;
        SingleSignonToken ssoToken = null;
        Set<SingleSignonToken> ssoTokens = subject.getPrivateCredentials(SingleSignonToken.class);
        Iterator<SingleSignonToken> ssoTokensIterator = ssoTokens.iterator();
        if (ssoTokensIterator.hasNext()) {
            ssoToken = ssoTokensIterator.next();
            if (ssoTokensIterator.hasNext()) {
                throw new WSSecurityException("More than one ssotoken found in subject");
            }
        }
        if (ssoToken != null) {
            ltpaCookie = WebSecurityHelperImpl.constructLTPACookieObj(ssoToken);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"No ssotoken found for this subject", (Object[])new Object[0]);
        }
        return ltpaCookie;
    }

    /*
     * WARNING - void declaration
     */
    public static Cookie getSSOCookieFromSSOToken() throws Exception {
        Subject subject = null;
        Cookie ltpaCookie = null;
        if (webAppSecConfig == null) {
            return null;
        }
        try {
            subject = WSSubject.getRunAsSubject();
            if (subject == null) {
                subject = WSSubject.getCallerSubject();
            }
            if (subject != null) {
                ltpaCookie = WebSecurityHelperImpl.getLTPACookie(subject);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No subjects on the thread", (Object[])new Object[0]);
            }
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.security.internal.WebSecurityHelperImpl", (String)"106", null, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getSSOCookieFromSSOToken caught exception: " + e.getMessage()), (Object[])new Object[0]);
            }
            throw e;
        }
        return ltpaCookie;
    }

    public static WebAppSecurityConfig getWebAppSecurityConfig() {
        return webAppSecConfig;
    }

    public static String getJwtCookieName() {
        return JwtSSOTokenHelper.getJwtCookieName();
    }
}

