/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.staxutils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.staxutils.AbstractDOMStreamReader;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CNamespaceContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class W3CDOMStreamReader
extends AbstractDOMStreamReader<Node, Node> {
    private static final Logger LOG = LogUtils.getL7dLogger(W3CDOMStreamReader.class);
    private Node content;
    private Document document;
    private W3CNamespaceContext context;
    private String sysId;
    static final long serialVersionUID = 6180052593602840133L;

    @Trivial
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public W3CDOMStreamReader(Element element) {
        super(new AbstractDOMStreamReader.ElementFrame(element, null));
        LOG.entering("W3CDOMStreamReader", "W3CDOMStreamReader");
        this.content = element;
        this.newFrame(this.getCurrentFrame());
        this.document = element.getOwnerDocument();
        LOG.exiting("W3CDOMStreamReader", "W3CDOMStreamReader");
    }

    @Trivial
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public W3CDOMStreamReader(Element element, String systemId) {
        this(element);
        LOG.entering("W3CDOMStreamReader", "W3CDOMStreamReader");
        this.sysId = systemId;
        LOG.exiting("W3CDOMStreamReader", "W3CDOMStreamReader");
    }

    @Trivial
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public W3CDOMStreamReader(Document doc) {
        super(new AbstractDOMStreamReader.ElementFrame<Node, Node>((Node)doc, false){
            static final long serialVersionUID = 4596138045078188876L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public boolean isDocument() {
                return true;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.apache.cxf.staxutils.W3CDOMStreamReader$1", 1.class, null, null);
            }
        });
        LOG.entering("W3CDOMStreamReader", "W3CDOMStreamReader");
        this.document = doc;
        LOG.exiting("W3CDOMStreamReader", "W3CDOMStreamReader");
    }

    @Trivial
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public W3CDOMStreamReader(DocumentFragment docfrag) {
        super(new AbstractDOMStreamReader.ElementFrame<Node, Node>((Node)docfrag, true){
            static final long serialVersionUID = 3813837607186597539L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public boolean isDocumentFragment() {
                return true;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.apache.cxf.staxutils.W3CDOMStreamReader$2", 2.class, null, null);
            }
        });
        LOG.entering("W3CDOMStreamReader", "W3CDOMStreamReader");
        this.document = docfrag.getOwnerDocument();
        LOG.exiting("W3CDOMStreamReader", "W3CDOMStreamReader");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Document getDocument() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CDOMStreamReader", "getDocument", new Object[0]);
        }
        Document document = this.document;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            document = document;
            LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getDocument", document);
        }
        return document;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getSystemId() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CDOMStreamReader", "getSystemId", new Object[0]);
        }
        String string = this.sysId == null ? this.document.getDocumentURI() : this.sysId;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getSystemId", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected final void newFrame(AbstractDOMStreamReader.ElementFrame<Node, Node> frame) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CDOMStreamReader", "newFrame", new Object[]{frame});
        }
        Node element = this.getCurrentNode();
        frame.uris = new ArrayList<String>();
        frame.prefixes = new ArrayList<String>();
        frame.attributes = new ArrayList<Object>();
        if (this.context == null) {
            this.context = new W3CNamespaceContext();
        }
        if (element instanceof Element) {
            this.context.setElement((Element)element);
        }
        NamedNodeMap nodes = element.getAttributes();
        String ePrefix = element.getPrefix();
        if (ePrefix == null) {
            ePrefix = "";
        }
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String prefix = node.getPrefix();
                String localName = node.getLocalName();
                String value = node.getNodeValue();
                String name = node.getNodeName();
                if (prefix == null) {
                    prefix = "";
                }
                if (name != null && "xmlns".equals(name)) {
                    frame.uris.add(value);
                    frame.prefixes.add("");
                    continue;
                }
                if (prefix.length() > 0 && "xmlns".equals(prefix)) {
                    frame.uris.add(value);
                    frame.prefixes.add(localName);
                    continue;
                }
                if (name.startsWith("xmlns:")) {
                    prefix = name.substring(6);
                    frame.uris.add(value);
                    frame.prefixes.add(prefix);
                    continue;
                }
                frame.attributes.add(node);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "newFrame");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void endElement() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CDOMStreamReader", "endElement", new Object[0]);
        }
        super.endElement();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "endElement");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public final Node getCurrentNode() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CDOMStreamReader", "getCurrentNode", new Object[0]);
        }
        Node node = (Node)this.getCurrentFrame().element;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            node = node;
            LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getCurrentNode", node);
        }
        return node;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public final Element getCurrentElement() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CDOMStreamReader", "getCurrentElement", new Object[0]);
        }
        Element element = (Element)this.getCurrentFrame().element;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            element = element;
            LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getCurrentElement", element);
        }
        return element;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected AbstractDOMStreamReader.ElementFrame<Node, Node> getChildFrame() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CDOMStreamReader", "getChildFrame", new Object[0]);
        }
        AbstractDOMStreamReader.ElementFrame<Node, Node> elementFrame = new AbstractDOMStreamReader.ElementFrame<Node, Node>((Node)this.getCurrentFrame().currentChild, this.getCurrentFrame());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            elementFrame = elementFrame;
            LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getChildFrame", elementFrame);
        }
        return elementFrame;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean hasMoreChildren() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CDOMStreamReader", "hasMoreChildren", new Object[0]);
        }
        if (this.getCurrentFrame().currentChild == null) {
            boolean bl = this.getCurrentNode().getFirstChild() != null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "hasMoreChildren", bl);
            }
            return bl;
        }
        boolean bl = ((Node)this.getCurrentFrame().currentChild).getNextSibling() != null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "hasMoreChildren", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected int nextChild() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CDOMStreamReader", "nextChild", new Object[0]);
        }
        AbstractDOMStreamReader.ElementFrame frame = this.getCurrentFrame();
        this.content = frame.currentChild == null ? this.getCurrentNode().getFirstChild() : ((Node)frame.currentChild).getNextSibling();
        frame.currentChild = this.content;
        switch (this.content.getNodeType()) {
            case 1: {
                int n = 1;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    n = n;
                    LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "nextChild", n);
                }
                return n;
            }
            case 3: {
                int n = 4;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    n = n;
                    LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "nextChild", n);
                }
                return n;
            }
            case 8: {
                int n = 5;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    n = n;
                    LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "nextChild", n);
                }
                return n;
            }
            case 4: {
                int n = 12;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    n = n;
                    LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "nextChild", n);
                }
                return n;
            }
            case 5: {
                int n = 9;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    n = n;
                    LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "nextChild", n);
                }
                return n;
            }
        }
        throw new IllegalStateException("Found type: " + this.content.getClass().getName());
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getElementText() throws XMLStreamException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CDOMStreamReader", "getElementText", new Object[0]);
        }
        String result = DOMUtils.getRawContent(this.content);
        AbstractDOMStreamReader.ElementFrame frame = this.getCurrentFrame();
        frame.ended = true;
        this.currentEvent = 2;
        this.endElement();
        String string = result != null ? result : "";
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getElementText", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getNamespaceURI(String prefix) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CDOMStreamReader", "getNamespaceURI", new Object[]{prefix});
        }
        AbstractDOMStreamReader.ElementFrame frame = this.getCurrentFrame();
        while (null != frame) {
            int index = frame.prefixes.indexOf(prefix);
            if (index != -1) {
                String string = frame.uris.get(index);
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    string = string;
                    LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getNamespaceURI", string);
                }
                return string;
            }
            if (frame.parent == null && frame.getElement() instanceof Element) {
                String string = ((Element)frame.getElement()).lookupNamespaceURI(prefix);
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    string = string;
                    LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getNamespaceURI", string);
                }
                return string;
            }
            frame = frame.parent;
        }
        String string = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getNamespaceURI", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getAttributeValue(String ns, String local) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CDOMStreamReader", "getAttributeValue", new Object[]{ns, local});
        }
        Attr at = ns == null || ns.equals("") ? this.getCurrentElement().getAttributeNode(local) : this.getCurrentElement().getAttributeNodeNS(ns, local);
        if (at == null) {
            String string = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getAttributeValue", string);
            }
            return string;
        }
        String string = at.getNodeValue();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getAttributeValue", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getAttributeCount() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CDOMStreamReader", "getAttributeCount", new Object[0]);
        }
        int n = this.getCurrentFrame().attributes.size();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            n = n;
            LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getAttributeCount", n);
        }
        return n;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    Attr getAttribute(int i) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CDOMStreamReader", "getAttribute", new Object[]{i});
        }
        Attr attr = (Attr)this.getCurrentFrame().attributes.get(i);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            attr = attr;
            LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getAttribute", attr);
        }
        return attr;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String getLocalName(Attr attr) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CDOMStreamReader", "getLocalName", new Object[]{attr});
        }
        String name = attr.getLocalName();
        if (name == null) {
            name = attr.getNodeName();
        }
        String string = name;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getLocalName", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public QName getAttributeName(int i) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CDOMStreamReader", "getAttributeName", new Object[]{i});
        }
        Attr at = this.getAttribute(i);
        String prefix = at.getPrefix();
        String ln = this.getLocalName(at);
        String ns = at.getNamespaceURI();
        if (prefix == null) {
            QName qName = new QName(ns, ln);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                qName = qName;
                LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getAttributeName", qName);
            }
            return qName;
        }
        QName qName = new QName(ns, ln, prefix);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            qName = qName;
            LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getAttributeName", qName);
        }
        return qName;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getAttributeNamespace(int i) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CDOMStreamReader", "getAttributeNamespace", new Object[]{i});
        }
        String string = this.getAttribute(i).getNamespaceURI();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getAttributeNamespace", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getAttributeLocalName(int i) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CDOMStreamReader", "getAttributeLocalName", new Object[]{i});
        }
        Attr attr = this.getAttribute(i);
        String string = this.getLocalName(attr);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getAttributeLocalName", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getAttributePrefix(int i) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CDOMStreamReader", "getAttributePrefix", new Object[]{i});
        }
        String string = this.getAttribute(i).getPrefix();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getAttributePrefix", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getAttributeType(int i) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CDOMStreamReader", "getAttributeType", new Object[]{i});
        }
        Attr attr = this.getAttribute(i);
        if (attr.isId()) {
            String string = "ID";
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getAttributeType", string);
            }
            return string;
        }
        TypeInfo schemaType = null;
        try {
            schemaType = attr.getSchemaTypeInfo();
        }
        catch (Throwable t) {
            schemaType = null;
        }
        String string = schemaType == null ? "CDATA" : (schemaType.getTypeName() == null ? "CDATA" : schemaType.getTypeName());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getAttributeType", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getAttributeValue(int i) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CDOMStreamReader", "getAttributeValue", new Object[]{i});
        }
        String string = this.getAttribute(i).getValue();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getAttributeValue", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isAttributeSpecified(int i) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CDOMStreamReader", "isAttributeSpecified", new Object[]{i});
        }
        boolean bl = this.getAttribute(i).getValue() != null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "isAttributeSpecified", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getNamespaceCount() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CDOMStreamReader", "getNamespaceCount", new Object[0]);
        }
        int n = this.getCurrentFrame().prefixes.size();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            n = n;
            LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getNamespaceCount", n);
        }
        return n;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getNamespacePrefix(int i) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CDOMStreamReader", "getNamespacePrefix", new Object[]{i});
        }
        String string = this.getCurrentFrame().prefixes.get(i);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getNamespacePrefix", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getNamespaceURI(int i) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CDOMStreamReader", "getNamespaceURI", new Object[]{i});
        }
        String string = this.getCurrentFrame().uris.get(i);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getNamespaceURI", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public NamespaceContext getNamespaceContext() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CDOMStreamReader", "getNamespaceContext", new Object[0]);
        }
        W3CNamespaceContext w3CNamespaceContext = this.context;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            w3CNamespaceContext = w3CNamespaceContext;
            LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getNamespaceContext", w3CNamespaceContext);
        }
        return w3CNamespaceContext;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getText() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CDOMStreamReader", "getText", new Object[0]);
        }
        if (this.content instanceof Text) {
            String string = ((Text)this.content).getData();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getText", string);
            }
            return string;
        }
        if (this.content instanceof Comment) {
            String string = ((Comment)this.content).getData();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getText", string);
            }
            return string;
        }
        String string = DOMUtils.getRawContent(this.getCurrentNode());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getText", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public char[] getTextCharacters() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CDOMStreamReader", "getTextCharacters", new Object[0]);
        }
        char[] cArray = this.getText().toCharArray();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            cArray = cArray;
            LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getTextCharacters", cArray);
        }
        return cArray;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getTextStart() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CDOMStreamReader", "getTextStart", new Object[0]);
        }
        int n = 0;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            n = n;
            LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getTextStart", n);
        }
        return n;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getTextLength() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CDOMStreamReader", "getTextLength", new Object[0]);
        }
        int n = this.getText().length();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            n = n;
            LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getTextLength", n);
        }
        return n;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getEncoding() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CDOMStreamReader", "getEncoding", new Object[0]);
        }
        String string = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getEncoding", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public QName getName() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CDOMStreamReader", "getName", new Object[0]);
        }
        Node el = this.getCurrentNode();
        String prefix = this.getPrefix();
        String ln = this.getLocalName();
        if (prefix == null) {
            QName qName = new QName(el.getNamespaceURI(), ln);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                qName = qName;
                LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getName", qName);
            }
            return qName;
        }
        QName qName = new QName(el.getNamespaceURI(), ln, prefix);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            qName = qName;
            LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getName", qName);
        }
        return qName;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getLocalName() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CDOMStreamReader", "getLocalName", new Object[0]);
        }
        String ln = this.getCurrentNode().getLocalName();
        if (ln == null && (ln = this.getCurrentNode().getNodeName()).indexOf(":") != -1) {
            ln = ln.substring(ln.indexOf(":") + 1);
        }
        String string = ln;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getLocalName", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getNamespaceURI() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CDOMStreamReader", "getNamespaceURI", new Object[0]);
        }
        String ln = this.getCurrentNode().getLocalName();
        if (ln == null) {
            ln = this.getCurrentNode().getNodeName();
            ln = ln.indexOf(":") == -1 ? this.getNamespaceURI("") : this.getNamespaceURI(ln.substring(0, ln.indexOf(":")));
            String string = ln;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getNamespaceURI", string);
            }
            return string;
        }
        String string = this.getCurrentNode().getNamespaceURI();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getNamespaceURI", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getPrefix() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CDOMStreamReader", "getPrefix", new Object[0]);
        }
        String prefix = this.getCurrentNode().getPrefix();
        if (prefix == null) {
            String nodeName = this.getCurrentNode().getNodeName();
            prefix = nodeName.indexOf(":") != -1 ? nodeName.substring(0, nodeName.indexOf(":")) : "";
        }
        String string = prefix;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getPrefix", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getPITarget() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CDOMStreamReader", "getPITarget", new Object[0]);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getPIData() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CDOMStreamReader", "getPIData", new Object[0]);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Location getLocation() {
        block4: {
            Location location;
            block5: {
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    LOG.entering("org.apache.cxf.staxutils.W3CDOMStreamReader", "getLocation", new Object[0]);
                }
                try {
                    Object o = this.getCurrentNode().getUserData("location");
                    if (!(o instanceof Location)) break block4;
                    location = (Location)o;
                    if (LOG == null || !LOG.isLoggable(Level.FINER)) break block5;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                location = location;
                LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getLocation", location);
            }
            return location;
        }
        Location location = super.getLocation();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            location = location;
            LOG.exiting("org.apache.cxf.staxutils.W3CDOMStreamReader", "getLocation", location);
        }
        return location;
    }

    @Trivial
    @ManualTrace
    public String toString() {
        LOG.entering("W3CDOMStreamReader", "toString");
        if (this.document == null) {
            return "<null>";
        }
        if (this.document.getDocumentElement() == null) {
            return "<null document element>";
        }
        try {
            LOG.exiting("W3CDOMStreamReader", "toString");
            return StaxUtils.toString(this.document);
        }
        catch (XMLStreamException e) {
            LOG.exiting("W3CDOMStreamReader", "toString");
            return super.toString();
        }
        catch (Throwable t) {
            t.printStackTrace();
            LOG.exiting("W3CDOMStreamReader", "toString");
            return super.toString();
        }
    }
}

