/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.phase;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.continuations.SuspendedInvocationException;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.logging.FaultListener;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.Phase;
import org.apache.cxf.phase.PhaseInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.transport.MessageObserver;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class PhaseInterceptorChain
implements InterceptorChain {
    public static final String PREVIOUS_MESSAGE = PhaseInterceptorChain.class.getName() + ".PREVIOUS_MESSAGE";
    private static final Logger LOG = LogUtils.getL7dLogger(PhaseInterceptorChain.class);
    private static final ThreadLocal<Message> CURRENT_MESSAGE = new ThreadLocal();
    private final Map<String, Integer> nameMap;
    private final Phase[] phases;
    private InterceptorHolder[] heads;
    private InterceptorHolder[] tails;
    private boolean[] hasAfters;
    private InterceptorChain.State state;
    private Message pausedMessage;
    private MessageObserver faultObserver;
    private PhaseInterceptorIterator iterator;
    private final boolean isFineLogging;
    private boolean faultOccurred;
    static final long serialVersionUID = -847086506251099279L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private PhaseInterceptorChain(PhaseInterceptorChain src) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.phase.PhaseInterceptorChain", "<init>", new Object[]{src});
        }
        this.isFineLogging = LOG.isLoggable(Level.FINE);
        this.state = InterceptorChain.State.EXECUTING;
        this.nameMap = src.nameMap;
        this.phases = src.phases;
        int length = this.phases.length;
        this.hasAfters = new boolean[length];
        System.arraycopy(src.hasAfters, 0, this.hasAfters, 0, length);
        this.heads = new InterceptorHolder[length];
        this.tails = new InterceptorHolder[length];
        InterceptorHolder last = null;
        for (int x = 0; x < length; ++x) {
            InterceptorHolder ih = src.heads[x];
            while (ih != null && ih.phaseIdx == x) {
                InterceptorHolder ih2 = new InterceptorHolder(ih);
                ih2.prev = last;
                if (last != null) {
                    last.next = ih2;
                }
                if (this.heads[x] == null) {
                    this.heads[x] = ih2;
                }
                this.tails[x] = ih2;
                last = ih2;
                ih = ih.next;
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.phase.PhaseInterceptorChain", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public PhaseInterceptorChain(SortedSet<Phase> ps) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.phase.PhaseInterceptorChain", "<init>", new Object[]{ps});
        }
        this.state = InterceptorChain.State.EXECUTING;
        this.isFineLogging = LOG.isLoggable(Level.FINE);
        int numPhases = ps.size();
        this.phases = new Phase[numPhases];
        this.nameMap = new HashMap<String, Integer>();
        this.heads = new InterceptorHolder[numPhases];
        this.tails = new InterceptorHolder[numPhases];
        this.hasAfters = new boolean[numPhases];
        int idx = 0;
        Iterator iterator = ps.iterator();
        while (iterator.hasNext()) {
            Phase phase;
            this.phases[idx] = phase = (Phase)iterator.next();
            this.nameMap.put(phase.getName(), idx);
            ++idx;
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.phase.PhaseInterceptorChain", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Message getCurrentMessage() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.phase.PhaseInterceptorChain", "getCurrentMessage", new Object[0]);
        }
        Message message = CURRENT_MESSAGE.get();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            message = message;
            LOG.exiting("org.apache.cxf.phase.PhaseInterceptorChain", "getCurrentMessage", message);
        }
        return message;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized InterceptorChain.State getState() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.phase.PhaseInterceptorChain", "getState", new Object[0]);
        }
        InterceptorChain.State state = this.state;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            state = state;
            LOG.exiting("org.apache.cxf.phase.PhaseInterceptorChain", "getState", (Object)state);
        }
        return state;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public PhaseInterceptorChain cloneChain() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.phase.PhaseInterceptorChain", "cloneChain", new Object[0]);
        }
        PhaseInterceptorChain phaseInterceptorChain = new PhaseInterceptorChain(this);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            phaseInterceptorChain = phaseInterceptorChain;
            LOG.exiting("org.apache.cxf.phase.PhaseInterceptorChain", "cloneChain", phaseInterceptorChain);
        }
        return phaseInterceptorChain;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void updateIterator() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.phase.PhaseInterceptorChain", "updateIterator", new Object[0]);
        }
        if (this.iterator == null) {
            this.iterator = new PhaseInterceptorIterator(this.heads);
            this.outputChainToLog(false);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.phase.PhaseInterceptorChain", "updateIterator");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void add(Collection<Interceptor<? extends Message>> newhandlers) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.phase.PhaseInterceptorChain", "add", new Object[]{newhandlers});
        }
        this.add(newhandlers, false);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.phase.PhaseInterceptorChain", "add");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void add(Collection<Interceptor<? extends Message>> newhandlers, boolean force) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.phase.PhaseInterceptorChain", "add", new Object[]{newhandlers, force});
        }
        if (newhandlers == null) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.phase.PhaseInterceptorChain", "add");
            }
            return;
        }
        for (Interceptor<? extends Message> handler : newhandlers) {
            this.add(handler, force);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.phase.PhaseInterceptorChain", "add");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void add(Interceptor<? extends Message> i) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.phase.PhaseInterceptorChain", "add", new Object[]{i});
        }
        this.add(i, false);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.phase.PhaseInterceptorChain", "add");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void add(Interceptor<? extends Message> i, boolean force) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.phase.PhaseInterceptorChain", "add", new Object[]{i, force});
        }
        PhaseInterceptor pi = (PhaseInterceptor)i;
        String phaseName = pi.getPhase();
        Integer phase = this.nameMap.get(phaseName);
        if (phase == null) {
            LOG.warning("Skipping interceptor " + i.getClass().getName() + (phaseName == null ? ": Phase declaration is missing." : ": Phase " + phaseName + " specified does not exist."));
        } else {
            if (this.isFineLogging) {
                LOG.fine("Adding interceptor " + i + " to phase " + phaseName);
            }
            this.insertInterceptor(phase, pi, force);
        }
        Collection<PhaseInterceptor<Message>> extras = pi.getAdditionalInterceptors();
        if (extras != null) {
            for (PhaseInterceptor<Message> p : extras) {
                this.add(p, force);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.phase.PhaseInterceptorChain", "add");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized void pause() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.phase.PhaseInterceptorChain", "pause", new Object[0]);
        }
        this.state = InterceptorChain.State.PAUSED;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.phase.PhaseInterceptorChain", "pause");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized void suspend() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.phase.PhaseInterceptorChain", "suspend", new Object[0]);
        }
        this.state = InterceptorChain.State.SUSPENDED;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.phase.PhaseInterceptorChain", "suspend");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized void resume() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.phase.PhaseInterceptorChain", "resume", new Object[0]);
        }
        if (this.state == InterceptorChain.State.PAUSED || this.state == InterceptorChain.State.SUSPENDED) {
            this.state = InterceptorChain.State.EXECUTING;
            this.doIntercept(this.pausedMessage);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.phase.PhaseInterceptorChain", "resume");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized boolean doIntercept(Message message) {
        boolean bl;
        Message oldMessage;
        block21: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.phase.PhaseInterceptorChain", "doIntercept", new Object[]{message});
            }
            this.updateIterator();
            this.pausedMessage = message;
            oldMessage = CURRENT_MESSAGE.get();
            CURRENT_MESSAGE.set(message);
            if (oldMessage != null && !message.containsKey(PREVIOUS_MESSAGE) && message != oldMessage && message.getExchange() != oldMessage.getExchange()) {
                message.put(PREVIOUS_MESSAGE, new WeakReference<Message>(oldMessage));
            }
            while (this.state == InterceptorChain.State.EXECUTING && this.iterator.hasNext()) {
                try {
                    Object currentInterceptor = this.iterator.next();
                    if (this.isFineLogging) {
                        LOG.fine("Invoking handleMessage on interceptor " + currentInterceptor);
                    }
                    currentInterceptor.handleMessage(message);
                    if (this.state != InterceptorChain.State.SUSPENDED) continue;
                    throw new SuspendedInvocationException();
                }
                catch (SuspendedInvocationException ex) {
                    if (this.iterator.hasPrevious()) {
                        this.iterator.previous();
                    }
                    this.pause();
                    throw ex;
                }
                catch (RuntimeException ex) {
                    if (!this.faultOccurred) {
                        Exchange exchange;
                        Service service;
                        this.faultOccurred = true;
                        StringBuilder description = new StringBuilder();
                        if (message.getExchange() != null && (service = (exchange = message.getExchange()).get(Service.class)) != null) {
                            description.append('\'');
                            description.append(service.getName());
                            OperationInfo opInfo = exchange.get(OperationInfo.class);
                            if (opInfo != null) {
                                description.append("#").append(opInfo.getName());
                            }
                            description.append("' ");
                        }
                        message.setContent(Exception.class, ex);
                        this.unwind(message);
                        Exception ex2 = message.getContent(Exception.class);
                        if (ex2 == null) {
                            ex2 = ex;
                        }
                        FaultListener flogger = (FaultListener)message.getContextualProperty(FaultListener.class.getName());
                        boolean useDefaultLogging = true;
                        if (flogger != null) {
                            useDefaultLogging = flogger.faultOccurred(ex2, description.toString(), message);
                        }
                        if (useDefaultLogging) {
                            this.doDefaultLogging(message, ex2, description);
                        }
                        boolean isOneWay = false;
                        if (message.getExchange() != null) {
                            if (message.getContent(Exception.class) != null) {
                                message.getExchange().put(Exception.class, ex2);
                            }
                            isOneWay = message.getExchange().isOneWay();
                        }
                        if (this.faultObserver != null && !isOneWay) {
                            this.faultObserver.onMessage(message);
                        }
                    }
                    this.state = InterceptorChain.State.ABORTED;
                }
            }
            if (this.state == InterceptorChain.State.EXECUTING) {
                this.state = InterceptorChain.State.COMPLETE;
                this.pausedMessage = null;
            }
            boolean bl2 = this.state == InterceptorChain.State.COMPLETE;
            bl = bl2;
            if (LOG == null || !LOG.isLoggable(Level.FINER)) break block21;
            bl = bl;
            LOG.exiting("org.apache.cxf.phase.PhaseInterceptorChain", "doIntercept", bl);
        }
        return bl;
        finally {
            CURRENT_MESSAGE.set(oldMessage);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void doDefaultLogging(Message message, Exception ex, StringBuilder description) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.phase.PhaseInterceptorChain", "doDefaultLogging", new Object[]{message, ex, description});
        }
        FaultMode mode = message.get(FaultMode.class);
        if (mode == FaultMode.CHECKED_APPLICATION_FAULT) {
            if (this.isFineLogging) {
                Throwable t = ex;
                if (ex instanceof Fault && ex.getCause() != null) {
                    t = ex.getCause();
                }
                LogUtils.log(LOG, Level.FINE, "Application " + description + "has thrown exception, unwinding now: " + t.getClass().getName() + ": " + ex.getMessage());
            }
        } else if (LOG.isLoggable(Level.WARNING)) {
            if (mode == FaultMode.UNCHECKED_APPLICATION_FAULT) {
                LogUtils.log(LOG, Level.WARNING, "Application " + description + "has thrown exception, unwinding now", ex);
            } else {
                LogUtils.log(LOG, Level.WARNING, "Interceptor for " + description + "has thrown exception, unwinding now", ex);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.phase.PhaseInterceptorChain", "doDefaultLogging");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized boolean doInterceptStartingAfter(Message message, String startingAfterInterceptorID) {
        PhaseInterceptor currentInterceptor;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.phase.PhaseInterceptorChain", "doInterceptStartingAfter", new Object[]{message, startingAfterInterceptorID});
        }
        this.updateIterator();
        while (this.state == InterceptorChain.State.EXECUTING && this.iterator.hasNext() && !(currentInterceptor = (PhaseInterceptor)this.iterator.next()).getId().equals(startingAfterInterceptorID)) {
        }
        boolean bl = this.doIntercept(message);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.phase.PhaseInterceptorChain", "doInterceptStartingAfter", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized boolean doInterceptStartingAt(Message message, String startingAtInterceptorID) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.phase.PhaseInterceptorChain", "doInterceptStartingAt", new Object[]{message, startingAtInterceptorID});
        }
        this.updateIterator();
        while (this.state == InterceptorChain.State.EXECUTING && this.iterator.hasNext()) {
            PhaseInterceptor currentInterceptor = (PhaseInterceptor)this.iterator.next();
            if (!currentInterceptor.getId().equals(startingAtInterceptorID)) continue;
            this.iterator.previous();
            break;
        }
        boolean bl = this.doIntercept(message);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.phase.PhaseInterceptorChain", "doInterceptStartingAt", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized void reset() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.phase.PhaseInterceptorChain", "reset", new Object[0]);
        }
        this.updateIterator();
        if (this.state == InterceptorChain.State.COMPLETE) {
            this.state = InterceptorChain.State.EXECUTING;
            this.iterator.reset();
        } else {
            this.iterator.reset();
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.phase.PhaseInterceptorChain", "reset");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void unwind(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.phase.PhaseInterceptorChain", "unwind", new Object[]{message});
        }
        while (this.iterator.hasPrevious()) {
            Object currentInterceptor = this.iterator.previous();
            if (this.isFineLogging) {
                LOG.fine("Invoking handleFault on interceptor " + currentInterceptor);
            }
            try {
                currentInterceptor.handleFault(message);
            }
            catch (RuntimeException e) {
                LOG.log(Level.WARNING, "Exception in handleFault on interceptor " + currentInterceptor, e);
                throw e;
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Exception in handleFault on interceptor " + currentInterceptor, e);
                throw new RuntimeException(e);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.phase.PhaseInterceptorChain", "unwind");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void remove(Interceptor<? extends Message> i) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.phase.PhaseInterceptorChain", "remove", new Object[]{i});
        }
        PhaseInterceptorIterator it = new PhaseInterceptorIterator(this.heads);
        while (it.hasNext()) {
            InterceptorHolder holder = it.nextInterceptorHolder();
            if (holder.interceptor != i) continue;
            this.remove(holder);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.phase.PhaseInterceptorChain", "remove");
            }
            return;
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.phase.PhaseInterceptorChain", "remove");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized void abort() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.phase.PhaseInterceptorChain", "abort", new Object[0]);
        }
        this.state = InterceptorChain.State.ABORTED;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.phase.PhaseInterceptorChain", "abort");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Iterator<Interceptor<? extends Message>> iterator() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.phase.PhaseInterceptorChain", "iterator", new Object[0]);
        }
        ListIterator<Interceptor<? extends Message>> listIterator = this.getIterator();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            listIterator = listIterator;
            LOG.exiting("org.apache.cxf.phase.PhaseInterceptorChain", "iterator", listIterator);
        }
        return listIterator;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ListIterator<Interceptor<? extends Message>> getIterator() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.phase.PhaseInterceptorChain", "getIterator", new Object[0]);
        }
        PhaseInterceptorIterator phaseInterceptorIterator = new PhaseInterceptorIterator(this.heads);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            phaseInterceptorIterator = phaseInterceptorIterator;
            LOG.exiting("org.apache.cxf.phase.PhaseInterceptorChain", "getIterator", phaseInterceptorIterator);
        }
        return phaseInterceptorIterator;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void remove(InterceptorHolder i) {
        int ph;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.phase.PhaseInterceptorChain", "remove", new Object[]{i});
        }
        if (i.prev != null) {
            i.prev.next = i.next;
        }
        if (i.next != null) {
            i.next.prev = i.prev;
        }
        if (this.heads[ph = i.phaseIdx] == i) {
            if (i.next != null && i.next.phaseIdx == ph) {
                this.heads[ph] = i.next;
            } else {
                this.heads[ph] = null;
                this.tails[ph] = null;
            }
        }
        if (this.tails[ph] == i) {
            if (i.prev != null && i.prev.phaseIdx == ph) {
                this.tails[ph] = i.prev;
            } else {
                this.heads[ph] = null;
                this.tails[ph] = null;
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.phase.PhaseInterceptorChain", "remove");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void insertInterceptor(int phase, PhaseInterceptor<? extends Message> interc, boolean force) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.phase.PhaseInterceptorChain", "insertInterceptor", new Object[]{phase, interc, force});
        }
        InterceptorHolder ih = new InterceptorHolder(interc, phase);
        if (this.heads[phase] == null) {
            int idx;
            this.heads[phase] = ih;
            this.tails[phase] = ih;
            this.hasAfters[phase] = !interc.getAfter().isEmpty();
            for (idx = phase - 1; idx >= 0 && this.tails[idx] == null; --idx) {
            }
            if (idx >= 0) {
                ih.prev = this.tails[idx];
                ih.next = this.tails[idx].next;
                if (ih.next != null) {
                    ih.next.prev = ih;
                }
                this.tails[idx].next = ih;
            } else {
                for (idx = phase + 1; idx < this.heads.length && this.heads[idx] == null; ++idx) {
                }
                if (idx != this.heads.length) {
                    ih.next = this.heads[idx];
                    this.heads[idx].prev = ih;
                }
            }
        } else {
            Set<String> beforeList = interc.getBefore();
            Set<String> afterList = interc.getAfter();
            InterceptorHolder firstBefore = null;
            InterceptorHolder lastAfter = null;
            String id = interc.getId();
            if (this.hasAfters[phase] || !beforeList.isEmpty()) {
                InterceptorHolder ih2 = this.heads[phase];
                while (ih2 != this.tails[phase].next) {
                    PhaseInterceptor<? extends Message> cmp = ih2.interceptor;
                    String cmpId = cmp.getId();
                    if (cmpId != null && firstBefore == null && (beforeList.contains(cmpId) || cmp.getAfter().contains(id))) {
                        firstBefore = ih2;
                    }
                    if (cmp.getBefore().contains(id) || cmpId != null && afterList.contains(cmpId)) {
                        lastAfter = ih2;
                    }
                    if (!force && cmpId.equals(id)) {
                        if (LOG != null && LOG.isLoggable(Level.FINER)) {
                            LOG.exiting("org.apache.cxf.phase.PhaseInterceptorChain", "insertInterceptor");
                        }
                        return;
                    }
                    ih2 = ih2.next;
                }
                if (lastAfter == null && beforeList.contains("*")) {
                    firstBefore = this.heads[phase];
                }
            } else if (!force) {
                InterceptorHolder ih2 = this.heads[phase];
                while (ih2 != this.tails[phase].next) {
                    if (ih2.interceptor.getId().equals(id)) {
                        if (LOG != null && LOG.isLoggable(Level.FINER)) {
                            LOG.exiting("org.apache.cxf.phase.PhaseInterceptorChain", "insertInterceptor");
                        }
                        return;
                    }
                    ih2 = ih2.next;
                }
            }
            int n = phase;
            this.hasAfters[n] = this.hasAfters[n] | !afterList.isEmpty();
            if (firstBefore == null && lastAfter == null && !beforeList.isEmpty() && afterList.isEmpty()) {
                firstBefore = this.heads[phase];
            }
            if (firstBefore == null) {
                ih.prev = this.tails[phase];
                ih.next = this.tails[phase].next;
                this.tails[phase].next = ih;
                if (ih.next != null) {
                    ih.next.prev = ih;
                }
                this.tails[phase] = ih;
            } else {
                ih.prev = firstBefore.prev;
                if (ih.prev != null) {
                    ih.prev.next = ih;
                }
                ih.next = firstBefore;
                firstBefore.prev = ih;
                if (this.heads[phase] == firstBefore) {
                    this.heads[phase] = ih;
                }
            }
        }
        if (this.iterator != null) {
            this.outputChainToLog(true);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.phase.PhaseInterceptorChain", "insertInterceptor");
        }
    }

    public String toString() {
        return this.toString("");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String toString(String message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.phase.PhaseInterceptorChain", "toString", new Object[]{message});
        }
        StringBuilder chain = new StringBuilder();
        chain.append("Chain ").append(super.toString()).append(message).append(". Current flow:\n");
        for (int x = 0; x < this.phases.length; ++x) {
            if (this.heads[x] == null) continue;
            chain.append("  ");
            this.printPhase(x, chain);
        }
        String string = chain.toString();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.phase.PhaseInterceptorChain", "toString", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void printPhase(int ph, StringBuilder chain) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.phase.PhaseInterceptorChain", "printPhase", new Object[]{ph, chain});
        }
        chain.append(this.phases[ph].getName()).append(" [");
        InterceptorHolder i = this.heads[ph];
        boolean first = true;
        while (i != this.tails[ph].next) {
            if (first) {
                first = false;
            } else {
                chain.append(", ");
            }
            String nm = i.interceptor.getClass().getSimpleName();
            if (StringUtils.isEmpty(nm)) {
                nm = i.interceptor.getId();
            }
            chain.append(nm);
            i = i.next;
        }
        chain.append("]\n");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.phase.PhaseInterceptorChain", "printPhase");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void outputChainToLog(boolean modified) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.phase.PhaseInterceptorChain", "outputChainToLog", new Object[]{modified});
        }
        if (this.isFineLogging) {
            if (modified) {
                LOG.fine(this.toString(" was modified"));
            } else {
                LOG.fine(this.toString(" was created"));
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.phase.PhaseInterceptorChain", "outputChainToLog");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public MessageObserver getFaultObserver() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.phase.PhaseInterceptorChain", "getFaultObserver", new Object[0]);
        }
        MessageObserver messageObserver = this.faultObserver;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            messageObserver = messageObserver;
            LOG.exiting("org.apache.cxf.phase.PhaseInterceptorChain", "getFaultObserver", messageObserver);
        }
        return messageObserver;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setFaultObserver(MessageObserver faultObserver) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.phase.PhaseInterceptorChain", "setFaultObserver", new Object[]{faultObserver});
        }
        this.faultObserver = faultObserver;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.phase.PhaseInterceptorChain", "setFaultObserver");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    static final class InterceptorHolder {
        PhaseInterceptor<? extends Message> interceptor;
        InterceptorHolder next;
        InterceptorHolder prev;
        int phaseIdx;
        static final long serialVersionUID = -8380994647761867478L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        InterceptorHolder(PhaseInterceptor<? extends Message> i, int p) {
            this.interceptor = i;
            this.phaseIdx = p;
        }

        InterceptorHolder(InterceptorHolder p) {
            this.interceptor = p.interceptor;
            this.phaseIdx = p.phaseIdx;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.phase.PhaseInterceptorChain$InterceptorHolder", InterceptorHolder.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    static final class PhaseInterceptorIterator
    implements ListIterator<Interceptor<? extends Message>> {
        InterceptorHolder[] heads;
        InterceptorHolder prev;
        InterceptorHolder first;
        static final long serialVersionUID = 4358893070825917349L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public PhaseInterceptorIterator(InterceptorHolder[] h) {
            this.heads = h;
            this.first = this.findFirst();
        }

        public void reset() {
            this.prev = null;
            this.first = this.findFirst();
        }

        private InterceptorHolder findFirst() {
            for (int x = 0; x < this.heads.length; ++x) {
                if (this.heads[x] == null) continue;
                return this.heads[x];
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            if (this.prev == null) {
                return this.first != null;
            }
            return this.prev.next != null;
        }

        @Override
        public Interceptor<? extends Message> next() {
            if (this.prev == null) {
                if (this.first == null) {
                    throw new NoSuchElementException();
                }
                this.prev = this.first;
            } else {
                if (this.prev.next == null) {
                    throw new NoSuchElementException();
                }
                this.prev = this.prev.next;
            }
            return this.prev.interceptor;
        }

        public InterceptorHolder nextInterceptorHolder() {
            if (this.prev == null) {
                if (this.first == null) {
                    throw new NoSuchElementException();
                }
                this.prev = this.first;
            } else {
                if (this.prev.next == null) {
                    throw new NoSuchElementException();
                }
                this.prev = this.prev.next;
            }
            return this.prev;
        }

        @Override
        public boolean hasPrevious() {
            return this.prev != null;
        }

        @Override
        public Interceptor<? extends Message> previous() {
            if (this.prev == null) {
                throw new NoSuchElementException();
            }
            InterceptorHolder tmp = this.prev;
            this.prev = this.prev.prev;
            return tmp.interceptor;
        }

        @Override
        public int nextIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int previousIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Interceptor<? extends Message> o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(Interceptor<? extends Message> o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.phase.PhaseInterceptorChain$PhaseInterceptorIterator", PhaseInterceptorIterator.class, null, null);
        }
    }
}

