/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.message;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.message.Message;
import org.w3c.dom.Node;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public final class MessageUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(MessageUtils.class);
    static final long serialVersionUID = 851699597752523801L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private MessageUtils() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.message.MessageUtils", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.message.MessageUtils", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static int getContextualInteger(Message m, String key, int defaultValue) {
        block6: {
            Object o;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.message.MessageUtils", "getContextualInteger", new Object[]{m, key, defaultValue});
            }
            if (m != null && (o = m.getContextualProperty(key)) instanceof String) {
                int n;
                try {
                    int i = Integer.parseInt((String)o);
                    if (i <= 0) break block6;
                    n = i;
                }
                catch (NumberFormatException ex) {
                    LOG.warning("Incorrect integer value of " + o + " specified for: " + key);
                }
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    n = n;
                    LOG.exiting("org.apache.cxf.message.MessageUtils", "getContextualInteger", n);
                }
                return n;
            }
        }
        int n = defaultValue;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            n = n;
            LOG.exiting("org.apache.cxf.message.MessageUtils", "getContextualInteger", n);
        }
        return n;
    }

    @Trivial
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isOutbound(Message message) {
        LOG.entering("MessageUtils", "isOutbound");
        Exchange exchange = message.getExchange();
        LOG.exiting("MessageUtils", "isOutbound");
        return exchange != null && (message == exchange.getOutMessage() || message == exchange.getOutFaultMessage());
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isFault(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.message.MessageUtils", "isFault", new Object[]{message});
        }
        boolean bl = message != null && message.getExchange() != null && (message == message.getExchange().getInFaultMessage() || message == message.getExchange().getOutFaultMessage());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.message.MessageUtils", "isFault", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static FaultMode getFaultMode(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.message.MessageUtils", "getFaultMode", new Object[]{message});
        }
        if (message != null && message.getExchange() != null && message == message.getExchange().getOutFaultMessage()) {
            FaultMode mode = message.get(FaultMode.class);
            if (null != mode) {
                FaultMode faultMode = mode;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    faultMode = faultMode;
                    LOG.exiting("org.apache.cxf.message.MessageUtils", "getFaultMode", (Object)faultMode);
                }
                return faultMode;
            }
            FaultMode faultMode = FaultMode.RUNTIME_FAULT;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                faultMode = faultMode;
                LOG.exiting("org.apache.cxf.message.MessageUtils", "getFaultMode", (Object)faultMode);
            }
            return faultMode;
        }
        FaultMode faultMode = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            faultMode = faultMode;
            LOG.exiting("org.apache.cxf.message.MessageUtils", "getFaultMode", (Object)faultMode);
        }
        return faultMode;
    }

    @Trivial
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isRequestor(Message message) {
        LOG.entering("MessageUtils", "isRequestor");
        Boolean requestor = (Boolean)message.get("org.apache.cxf.client");
        LOG.exiting("MessageUtils", "isRequestor");
        return requestor != null && requestor != false;
    }

    @Trivial
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isPartialResponse(Message message) {
        LOG.entering("MessageUtils", "isPartialResponse");
        LOG.exiting("MessageUtils", "isPartialResponse");
        return Boolean.TRUE.equals(message.get("org.apache.cxf.partial.response"));
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isEmptyPartialResponse(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.message.MessageUtils", "isEmptyPartialResponse", new Object[]{message});
        }
        boolean bl = Boolean.TRUE.equals(message.get("org.apache.cxf.partial.response.empty"));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.message.MessageUtils", "isEmptyPartialResponse", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isTrue(Object value) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.message.MessageUtils", "isTrue", new Object[]{value});
        }
        if (value == null) {
            boolean bl = false;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.message.MessageUtils", "isTrue", bl);
            }
            return bl;
        }
        if (Boolean.TRUE.equals(value) || "true".equalsIgnoreCase(value.toString())) {
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.message.MessageUtils", "isTrue", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.message.MessageUtils", "isTrue", bl);
        }
        return bl;
    }

    @Trivial
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean getContextualBoolean(Message m, String key, boolean defaultValue) {
        LOG.entering("MessageUtils", "getContextualBoolean");
        Object o = m.getContextualProperty(key);
        if (o != null) {
            return MessageUtils.isTrue(o);
        }
        LOG.exiting("MessageUtils", "getContextualBoolean");
        return defaultValue;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isDOMPresent(Message m) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.message.MessageUtils", "isDOMPresent", new Object[]{m});
        }
        boolean bl = m.getContent(Node.class) != null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.message.MessageUtils", "isDOMPresent", bl);
        }
        return bl;
    }
}

