/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.message;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.StringMapImpl;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Destination;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class MessageImpl
extends StringMapImpl
implements Message {
    private static final Logger LOG = LogUtils.getL7dLogger(MessageImpl.class);
    private static final long serialVersionUID = -3020763696429459865L;
    private Exchange exchange;
    private String id;
    private InterceptorChain interceptorChain;
    private Object[] contents;
    private int index;
    private Map<String, Object> contextCache;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public MessageImpl() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.message.MessageImpl", "<init>", new Object[0]);
        }
        this.contents = new Object[20];
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.message.MessageImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public MessageImpl(Message m) {
        super(m);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.message.MessageImpl", "<init>", new Object[]{m});
        }
        this.contents = new Object[20];
        if (!(m instanceof MessageImpl)) {
            throw new RuntimeException("Not a MessageImpl! " + m.getClass());
        }
        MessageImpl impl = (MessageImpl)m;
        this.exchange = impl.getExchange();
        this.id = impl.id;
        this.interceptorChain = impl.interceptorChain;
        this.contents = impl.contents;
        this.index = impl.index;
        this.contextCache = impl.contextCache;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.message.MessageImpl", "<init>", this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Collection<Attachment> getAttachments() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.message.MessageImpl", "getAttachments", new Object[0]);
        }
        Collection<Attachment> collection = CastUtils.cast((Collection)this.get(ATTACHMENTS));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            collection = collection;
            LOG.exiting("org.apache.cxf.message.MessageImpl", "getAttachments", collection);
        }
        return collection;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setAttachments(Collection<Attachment> attachments) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.message.MessageImpl", "setAttachments", new Object[]{attachments});
        }
        this.put(ATTACHMENTS, (Object)attachments);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.message.MessageImpl", "setAttachments");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getAttachmentMimeType() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.message.MessageImpl", "getAttachmentMimeType", new Object[0]);
        }
        String string = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.message.MessageImpl", "getAttachmentMimeType", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Destination getDestination() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.message.MessageImpl", "getDestination", new Object[0]);
        }
        Destination destination = this.get(Destination.class);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            destination = destination;
            LOG.exiting("org.apache.cxf.message.MessageImpl", "getDestination", destination);
        }
        return destination;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Exchange getExchange() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.message.MessageImpl", "getExchange", new Object[0]);
        }
        Exchange exchange = this.exchange;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            exchange = exchange;
            LOG.exiting("org.apache.cxf.message.MessageImpl", "getExchange", exchange);
        }
        return exchange;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getId() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.message.MessageImpl", "getId", new Object[0]);
        }
        String string = this.id;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.message.MessageImpl", "getId", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public InterceptorChain getInterceptorChain() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.message.MessageImpl", "getInterceptorChain", new Object[0]);
        }
        InterceptorChain interceptorChain = this.interceptorChain;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            interceptorChain = interceptorChain;
            LOG.exiting("org.apache.cxf.message.MessageImpl", "getInterceptorChain", interceptorChain);
        }
        return interceptorChain;
    }

    @Override
    @Trivial
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T> T getContent(Class<T> format) {
        LOG.entering("MessageImpl", "getContent");
        for (int x = 0; x < this.index; x += 2) {
            if (this.contents[x] != format) continue;
            LOG.exiting("MessageImpl", "getContent");
            return (T)this.contents[x + 1];
        }
        LOG.exiting("MessageImpl", "getContent");
        return null;
    }

    @Override
    @Trivial
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T> void setContent(Class<T> format, Object content) {
        LOG.entering("MessageImpl", "setContent");
        for (int x = 0; x < this.index; x += 2) {
            if (this.contents[x] != format) continue;
            this.contents[x + 1] = content;
            LOG.exiting("MessageImpl", "setContent");
            return;
        }
        if (this.index >= this.contents.length) {
            Object[] tmp = new Object[this.contents.length + 10];
            System.arraycopy(this.contents, 0, tmp, 0, this.contents.length);
            this.contents = tmp;
        }
        this.contents[this.index] = format;
        this.contents[this.index + 1] = content;
        this.index += 2;
        LOG.exiting("MessageImpl", "setContent");
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T> void removeContent(Class<T> format) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.message.MessageImpl", "removeContent", new Object[]{format});
        }
        for (int x = 0; x < this.index; x += 2) {
            if (this.contents[x] != format) continue;
            this.index -= 2;
            if (x != this.index) {
                this.contents[x] = this.contents[this.index];
                this.contents[x + 1] = this.contents[this.index + 1];
            }
            this.contents[this.index] = null;
            this.contents[this.index + 1] = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.message.MessageImpl", "removeContent");
            }
            return;
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.message.MessageImpl", "removeContent");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<Class<?>> getContentFormats() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.message.MessageImpl", "getContentFormats", new Object[0]);
        }
        HashSet c = new HashSet();
        for (int x = 0; x < this.index; x += 2) {
            c.add((Class)this.contents[x]);
        }
        HashSet hashSet = c;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            hashSet = hashSet;
            LOG.exiting("org.apache.cxf.message.MessageImpl", "getContentFormats", hashSet);
        }
        return hashSet;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setDestination(Destination d) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.message.MessageImpl", "setDestination", new Object[]{d});
        }
        this.put(Destination.class, d);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.message.MessageImpl", "setDestination");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setExchange(Exchange e) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.message.MessageImpl", "setExchange", new Object[]{e});
        }
        this.exchange = e;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.message.MessageImpl", "setExchange");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setId(String i) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.message.MessageImpl", "setId", new Object[]{i});
        }
        this.id = i;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.message.MessageImpl", "setId");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setInterceptorChain(InterceptorChain ic) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.message.MessageImpl", "setInterceptorChain", new Object[]{ic});
        }
        this.interceptorChain = ic;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.message.MessageImpl", "setInterceptorChain");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Object put(String key, Object value) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.message.MessageImpl", "put", new Object[]{key, value});
        }
        if (this.contextCache != null) {
            this.contextCache.put(key, value);
        }
        Object object = super.put(key, value);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.message.MessageImpl", "put", object);
        }
        return object;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Object getContextualProperty(String key) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.message.MessageImpl", "getContextualProperty", new Object[]{key});
        }
        if (this.contextCache == null) {
            this.calcContextCache();
        }
        Object object = this.contextCache.get(key);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.message.MessageImpl", "getContextualProperty", object);
        }
        return object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void calcContextCache() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.message.MessageImpl", "calcContextCache", new Object[0]);
        }
        HashMap<String, Object> o = new HashMap<String, Object>(){
            private static final long serialVersionUID = 7067290677790419348L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void putAll(Map<? extends String, ? extends Object> m) {
                if (m != null) {
                    super.putAll(m);
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.apache.cxf.message.MessageImpl$1", 1.class, null, null);
            }
        };
        Exchange ex = this.getExchange();
        if (ex != null) {
            Endpoint ep;
            Service sv;
            Bus b = ex.getBus();
            if (b != null) {
                o.putAll(b.getProperties());
            }
            if ((sv = ex.getService()) != null) {
                o.putAll(sv);
            }
            if ((ep = ex.getEndpoint()) != null) {
                EndpointInfo ei = ep.getEndpointInfo();
                if (ei != null) {
                    o.putAll(ep.getEndpointInfo().getBinding().getProperties());
                    o.putAll(ep.getEndpointInfo().getProperties());
                }
                o.putAll(ep);
            }
        }
        o.putAll(ex);
        o.putAll(this);
        this.contextCache = o;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.message.MessageImpl", "calcContextCache");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void copyContent(Message m1, Message m2) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.message.MessageImpl", "copyContent", new Object[]{m1, m2});
        }
        for (Class<?> c : m1.getContentFormats()) {
            m2.setContent(c, m1.getContent(c));
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.message.MessageImpl", "copyContent");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void resetContextCache() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.message.MessageImpl", "resetContextCache", new Object[0]);
        }
        if (this.contextCache != null) {
            this.contextCache = null;
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.message.MessageImpl", "resetContextCache");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setContextualProperty(String key, Object v) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.message.MessageImpl", "setContextualProperty", new Object[]{key, v});
        }
        if (this.contextCache != null && !this.containsKey(key)) {
            this.contextCache.put(key, v);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.message.MessageImpl", "setContextualProperty");
        }
    }
}

