/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.CollectionUtils;
import org.apache.cxf.common.util.PrimitiveUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.util.XMLSchemaQNames;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.invoker.MethodDispatcher;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceModelUtil;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class URIMappingInterceptor
extends AbstractInDatabindingInterceptor {
    public static final String URIMAPPING_SKIP = URIMappingInterceptor.class.getName() + ".skip";
    private static final Logger LOG = LogUtils.getL7dLogger(URIMappingInterceptor.class);
    static final long serialVersionUID = 2440120782789920335L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public URIMappingInterceptor() {
        super("unmarshal");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.interceptor.URIMappingInterceptor", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.interceptor.URIMappingInterceptor", "<init>", this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleMessage(Message message) throws Fault {
        BindingOperationInfo op;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.interceptor.URIMappingInterceptor", "handleMessage", new Object[]{message});
        }
        String method = (String)message.get("org.apache.cxf.request.method");
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Invoking HTTP method " + method);
        }
        if (!this.isGET(message)) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "URIMappingInterceptor can only handle HTTP GET, not HTTP " + method);
            }
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.interceptor.URIMappingInterceptor", "handleMessage");
            }
            return;
        }
        if (MessageUtils.getContextualBoolean(message, URIMAPPING_SKIP, false)) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.interceptor.URIMappingInterceptor", "handleMessage");
            }
            return;
        }
        String opName = this.getOperationName(message);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("URIMappingInterceptor get operation: " + opName);
        }
        if ((op = ServiceModelUtil.getOperation(message.getExchange(), opName)) == null || opName == null || op.getName() == null || StringUtils.isEmpty(op.getName().getLocalPart()) || !opName.equals(op.getName().getLocalPart())) {
            if (!Boolean.TRUE.equals(message.getContextualProperty(NO_VALIDATE_PARTS))) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("NO_OPERATION_PATH", LOG, opName, message.get(Message.PATH_INFO)));
            }
            MessageContentsList params = new MessageContentsList();
            params.add(null);
            message.setContent(List.class, params);
            if (op == null) {
                op = this.findAnyOp(message.getExchange());
            }
            if (op != null) {
                message.getExchange().put(BindingOperationInfo.class, op);
            }
        } else {
            message.getExchange().put(BindingOperationInfo.class, op);
            MessageContentsList params = this.getParameters(message, op);
            message.setContent(List.class, params);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.interceptor.URIMappingInterceptor", "handleMessage");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private BindingOperationInfo findAnyOp(Exchange exchange) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.interceptor.URIMappingInterceptor", "findAnyOp", new Object[]{exchange});
        }
        Endpoint ep = exchange.get(Endpoint.class);
        BindingInfo service = ep.getEndpointInfo().getBinding();
        for (BindingOperationInfo b : service.getOperations()) {
            MessagePartInfo inf;
            if (b.getInput() == null || b.getInput().getMessageInfo().getMessageParts().isEmpty() || !XMLSchemaQNames.XSD_ANY.equals((inf = b.getInput().getMessageInfo().getMessagePart(0)).getTypeQName())) continue;
            BindingOperationInfo bindingOperationInfo = b;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bindingOperationInfo = bindingOperationInfo;
                LOG.exiting("org.apache.cxf.interceptor.URIMappingInterceptor", "findAnyOp", bindingOperationInfo);
            }
            return bindingOperationInfo;
        }
        BindingOperationInfo bindingOperationInfo = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bindingOperationInfo = bindingOperationInfo;
            LOG.exiting("org.apache.cxf.interceptor.URIMappingInterceptor", "findAnyOp", bindingOperationInfo);
        }
        return bindingOperationInfo;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Method getMethod(Message message, BindingOperationInfo operation) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.interceptor.URIMappingInterceptor", "getMethod", new Object[]{message, operation});
        }
        MethodDispatcher md = (MethodDispatcher)message.getExchange().get(Service.class).get(MethodDispatcher.class.getName());
        Method method = md.getMethod(operation);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            method = method;
            LOG.exiting("org.apache.cxf.interceptor.URIMappingInterceptor", "getMethod", method);
        }
        return method;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isFixedParameterOrder(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.interceptor.URIMappingInterceptor", "isFixedParameterOrder", new Object[]{message});
        }
        Boolean order = (Boolean)message.get(Message.FIXED_PARAMETER_ORDER);
        boolean bl = order != null && order != false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.interceptor.URIMappingInterceptor", "isFixedParameterOrder", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Map<String, String> keepInOrder(Map<String, String> params, OperationInfo operation, List<String> order) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.interceptor.URIMappingInterceptor", "keepInOrder", new Object[]{params, operation, order});
        }
        if (params == null || order == null) {
            Map<String, String> map = params;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                map = map;
                LOG.exiting("org.apache.cxf.interceptor.URIMappingInterceptor", "keepInOrder", map);
            }
            return map;
        }
        LinkedHashMap<String, String> orderedParameters = new LinkedHashMap<String, String>();
        for (String name : order) {
            orderedParameters.put(name, params.get(name));
        }
        if (order.size() != params.size()) {
            LOG.fine(order.size() + " parameters definded in WSDL but found " + params.size() + " in request!");
            Collection<String> rest = CollectionUtils.diff(order, params.keySet());
            if (rest != null && rest.size() > 0) {
                LOG.fine("Set the following parameters to null: " + rest);
                for (String key : rest) {
                    orderedParameters.put(key, null);
                }
            }
        }
        LinkedHashMap<String, String> linkedHashMap = orderedParameters;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            linkedHashMap = linkedHashMap;
            LOG.exiting("org.apache.cxf.interceptor.URIMappingInterceptor", "keepInOrder", linkedHashMap);
        }
        return linkedHashMap;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected MessageContentsList getParameters(Message message, BindingOperationInfo operation) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.interceptor.URIMappingInterceptor", "getParameters", new Object[]{message, operation});
        }
        MessageContentsList parameters = new MessageContentsList();
        Map<String, String> queries = this.getQueries(message);
        if (!this.isFixedParameterOrder(message)) {
            boolean emptyQueries = CollectionUtils.isEmpty(queries.values());
            List<String> names = ServiceModelUtil.getOperationInputPartNames(operation.getOperationInfo());
            queries = this.keepInOrder(queries, operation.getOperationInfo(), names);
            if (!emptyQueries && CollectionUtils.isEmpty(queries.values())) {
                if (operation.isUnwrappedCapable()) {
                    MessageContentsList messageContentsList = this.getParameters(message, operation.getUnwrappedOperation());
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        messageContentsList = messageContentsList;
                        LOG.exiting("org.apache.cxf.interceptor.URIMappingInterceptor", "getParameters", messageContentsList);
                    }
                    return messageContentsList;
                }
                throw new Fault(new org.apache.cxf.common.i18n.Message("ORDERED_PARAM_REQUIRED", LOG, names.toString()));
            }
        }
        Method method = this.getMethod(message, operation);
        Class<?>[] types = method.getParameterTypes();
        for (String key : queries.keySet()) {
            Class<?> type;
            MessagePartInfo inf = null;
            for (MessagePartInfo p : operation.getOperationInfo().getInput().getMessageParts()) {
                if (!p.getConcreteName().getLocalPart().equals(key)) continue;
                inf = p;
                break;
            }
            if (inf == null && operation.isUnwrappedCapable()) {
                for (MessagePartInfo p : operation.getUnwrappedOperation().getOperationInfo().getInput().getMessageParts()) {
                    if (!p.getConcreteName().getLocalPart().equals(key)) continue;
                    inf = p;
                    break;
                }
            }
            int idx = 0;
            if (inf != null) {
                idx = inf.getIndex();
            }
            if ((type = types[idx]) == null) {
                LOG.warning("URIMappingInterceptor MessagePartInfo NULL ");
                throw new Fault(new org.apache.cxf.common.i18n.Message("NO_PART_FOUND", LOG, "index: " + idx + " on key " + key));
            }
            Object param = null;
            param = type.isPrimitive() && queries.get(key) != null ? PrimitiveUtils.read(queries.get(key), type) : this.readType(queries.get(key), type);
            parameters.set(idx, param);
            idx = parameters.size();
        }
        MessageContentsList messageContentsList = parameters;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            messageContentsList = messageContentsList;
            LOG.exiting("org.apache.cxf.interceptor.URIMappingInterceptor", "getParameters", messageContentsList);
        }
        return messageContentsList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Date parseDate(String value, Class<?> type) {
        Date date;
        block13: {
            SimpleDateFormat sdf;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.interceptor.URIMappingInterceptor", "parseDate", new Object[]{value, type});
            }
            if (value.length() == 10) {
                sdf = new SimpleDateFormat("yyyy-MM-dd");
            } else if (value.length() == 19) {
                sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            } else if (value.length() == 23) {
                sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
            } else if (value.length() == 25) {
                value = value.substring(0, value.length() - 3) + value.substring(value.length() - 2, value.length());
                sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZZZZZ");
            } else if (value.length() == 29) {
                value = value.substring(0, value.length() - 3) + value.substring(value.length() - 2, value.length());
                sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZZZZZ");
            } else {
                throw new RuntimeException("Unable to create " + type + " out of '" + value + "'");
            }
            try {
                date = sdf.parse(value);
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block13;
            }
            catch (ParseException e) {
                throw new RuntimeException("Unable to create " + type + " out of '" + value + "'");
            }
            date = date;
            LOG.exiting("org.apache.cxf.interceptor.URIMappingInterceptor", "parseDate", date);
        }
        return date;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Object readType(String value, Class<?> type) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.interceptor.URIMappingInterceptor", "readType", new Object[]{value, type});
        }
        Object ret = value;
        if (value != null) {
            if (Integer.class == type) {
                ret = Integer.valueOf(value);
            } else if (Byte.class == type) {
                ret = Byte.valueOf(value);
            } else if (Short.class == type) {
                ret = Short.valueOf(value);
            } else if (Long.class == type) {
                ret = Long.valueOf(value);
            } else if (Float.class == type) {
                ret = Float.valueOf(value);
            } else if (Double.class == type) {
                ret = Double.valueOf(value);
            } else if (Boolean.class == type) {
                ret = Boolean.valueOf(value);
            } else if (Character.class == type) {
                ret = Character.valueOf(value.charAt(0));
            } else if (type != null && type.isEnum()) {
                try {
                    ret = type.getMethod("valueOf", String.class).invoke(null, value);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Unable to create " + type + " out of '" + value + "'");
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException("Unable to create " + type + " out of '" + value + "'");
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException("Unable to create " + type + " out of '" + value + "'");
                }
            } else if (Date.class == type) {
                ret = this.parseDate(value, type);
            } else if (Calendar.class == type) {
                ret = Calendar.getInstance();
                ((Calendar)ret).setTime(this.parseDate(value, type));
            }
        }
        String string = ret;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.interceptor.URIMappingInterceptor", "readType", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String uriDecode(String query) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.interceptor.URIMappingInterceptor", "uriDecode", new Object[]{query});
        }
        try {
            query = URLDecoder.decode(query, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.warning(query + " can not be decoded: " + e.getMessage());
        }
        String string = query;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.interceptor.URIMappingInterceptor", "uriDecode", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Map<String, String> getQueries(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.interceptor.URIMappingInterceptor", "getQueries", new Object[]{message});
        }
        LinkedHashMap<String, String> queries = new LinkedHashMap<String, String>();
        String query = (String)message.get(Message.QUERY_STRING);
        if (!StringUtils.isEmpty(query)) {
            List<String> parts = Arrays.asList(query.split("&"));
            for (String part : parts) {
                String[] keyValue;
                if (!part.contains("=") || (keyValue = part.split("=")).length < 2) continue;
                queries.put(keyValue[0], this.uriDecode(keyValue[1]));
            }
            LinkedHashMap<String, String> linkedHashMap = queries;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                linkedHashMap = linkedHashMap;
                LOG.exiting("org.apache.cxf.interceptor.URIMappingInterceptor", "getQueries", linkedHashMap);
            }
            return linkedHashMap;
        }
        String rest = this.getRest(message);
        List<String> parts = StringUtils.getParts(rest, "/");
        for (int i = 1; i < parts.size(); i += 2) {
            if (i + 1 > parts.size()) {
                queries.put(parts.get(i), null);
                continue;
            }
            queries.put(parts.get(i), this.uriDecode(parts.get(i + 1)));
        }
        LinkedHashMap<String, String> linkedHashMap = queries;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            linkedHashMap = linkedHashMap;
            LOG.exiting("org.apache.cxf.interceptor.URIMappingInterceptor", "getQueries", linkedHashMap);
        }
        return linkedHashMap;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String getRest(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.interceptor.URIMappingInterceptor", "getRest", new Object[]{message});
        }
        String path = (String)message.get(Message.PATH_INFO);
        String basePath = (String)message.get(Message.BASE_PATH);
        if (basePath == null) {
            basePath = "/";
        }
        String string = StringUtils.diff(path, basePath);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.interceptor.URIMappingInterceptor", "getRest", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String getOperationName(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.interceptor.URIMappingInterceptor", "getOperationName", new Object[]{message});
        }
        String rest = this.getRest(message);
        String opName = StringUtils.getFirstNotEmpty(rest, "/");
        if (opName.indexOf("?") != -1) {
            opName = opName.split("\\?")[0];
        }
        String string = opName;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.interceptor.URIMappingInterceptor", "getOperationName", string);
        }
        return string;
    }
}

