/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.interceptor.AttachmentOutInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.staxutils.StaxUtils;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class StaxOutEndingInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final ResourceBundle BUNDLE;
    private String outStreamHolder;
    private String writerHolder;
    static final long serialVersionUID = 6896016573927392225L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public StaxOutEndingInterceptor(String outStreamHolder) {
        this(outStreamHolder, null);
    }

    public StaxOutEndingInterceptor(String outStreamHolder, String writerHolder) {
        super("pre-stream-ending");
        this.getAfter().add(AttachmentOutInterceptor.AttachmentOutEndingInterceptor.class.getName());
        this.outStreamHolder = outStreamHolder;
        this.writerHolder = writerHolder;
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        try {
            Writer w;
            OutputStream os;
            XMLStreamWriter xtw = message.getContent(XMLStreamWriter.class);
            if (xtw != null) {
                try {
                    xtw.writeEndDocument();
                    xtw.flush();
                }
                finally {
                    StaxUtils.close(xtw);
                }
            }
            if ((os = (OutputStream)message.get(this.outStreamHolder)) != null) {
                message.setContent(OutputStream.class, os);
            }
            if (this.writerHolder != null && (w = (Writer)message.get(this.writerHolder)) != null) {
                message.setContent(Writer.class, w);
            }
            message.removeContent(XMLStreamWriter.class);
        }
        catch (XMLStreamException e) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("STAX_WRITE_EXC", BUNDLE, new Object[0]), (Throwable)e);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.apache.cxf.interceptor.StaxOutEndingInterceptor", StaxOutEndingInterceptor.class, null, null);
        BUNDLE = BundleUtils.getBundle(StaxOutEndingInterceptor.class);
    }
}

