/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.ws.http.channel.h2internal.Constants;
import com.ibm.ws.http.channel.h2internal.FrameState;
import com.ibm.ws.http.channel.h2internal.FrameTypes;
import com.ibm.ws.http.channel.h2internal.H2InboundLink;
import com.ibm.ws.http.channel.h2internal.H2StreamProcessor;
import com.ibm.ws.http.channel.h2internal.exceptions.FrameSizeException;
import com.ibm.ws.http.channel.h2internal.exceptions.Http2Exception;
import com.ibm.ws.http.channel.h2internal.exceptions.ProtocolException;
import com.ibm.ws.http.channel.h2internal.frames.Frame;
import com.ibm.ws.http.channel.h2internal.frames.FrameFactory;
import com.ibm.ws.http.channel.h2internal.frames.FrameRstStream;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import java.util.Arrays;

public class FrameReadProcessor {
    private static final TraceComponent tc = Tr.register(FrameReadProcessor.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private static final int BUFFER_ARRAY_INITIAL_SIZE = 10;
    private static final int BUFFER_ARRAY_GROWTH_SIZE = 10;
    private FrameTypes enumFrameType = FrameTypes.NOT_SET;
    private byte byteFrameType;
    private Frame currentFrame;
    FrameState frameState = FrameState.INIT;
    int currentBufferArrayIndex = -1;
    int countOfBuffers = 0;
    private WsByteBuffer[] frameBuffers = new WsByteBuffer[10];
    H2InboundLink muxLink = null;

    public FrameReadProcessor(H2InboundLink m) {
        this.muxLink = m;
    }

    public void processCompleteFrame() throws Http2Exception {
        Frame currentFrame = this.getCurrentFrame();
        boolean frameSizeError = false;
        try {
            currentFrame.processPayload(this);
        }
        catch (Http2Exception e) {
            if (!e.isConnectionError()) {
                frameSizeError = true;
            }
            throw e;
        }
        catch (Exception e) {
            throw new ProtocolException("Error processing the payload for " + (Object)((Object)currentFrame.getFrameType()) + " frame on stream " + currentFrame.getStreamId());
        }
        int streamId = currentFrame.getStreamId();
        H2StreamProcessor stream = this.muxLink.getStream(streamId);
        if (stream == null) {
            if (streamId != 0 && streamId % 2 == 0) {
                if (currentFrame.getFrameType().equals((Object)FrameTypes.PRIORITY)) {
                    return;
                }
                if (currentFrame.getFrameType().equals((Object)FrameTypes.RST_STREAM) && streamId < this.muxLink.getHighestClientStreamId()) {
                    return;
                }
                throw new ProtocolException("Cannot start a stream from the client with an even numbered ID. stream-id: " + streamId);
            }
            stream = this.startNewInboundSession(streamId);
        }
        if (frameSizeError) {
            currentFrame = new FrameRstStream(streamId, 4, 0, false, Frame.FrameDirection.READ);
            ((FrameRstStream)currentFrame).setErrorCode(Constants.FRAME_SIZE_ERROR);
        }
        stream.processNextFrame(currentFrame, Constants.Direction.READ_IN);
    }

    public H2StreamProcessor startNewInboundSession(Integer streamID) {
        H2StreamProcessor h2s = null;
        h2s = this.muxLink.createNewInboundLink(streamID);
        return h2s;
    }

    public void reset(boolean releaseBuffers) {
        if (releaseBuffers) {
            this.releaseBuffers();
        }
        this.frameState = FrameState.INIT;
        this.currentBufferArrayIndex = -1;
        this.countOfBuffers = 0;
        this.frameBuffers = new WsByteBuffer[10];
        this.enumFrameType = FrameTypes.NOT_SET;
        this.currentFrame = null;
    }

    public synchronized void releaseBuffers() {
        for (int i = 0; i < this.countOfBuffers; ++i) {
            if (this.frameBuffers[i] == null) continue;
            this.frameBuffers[i].release();
            this.frameBuffers[i] = null;
        }
        this.countOfBuffers = 0;
    }

    public int processNextBuffer(@Sensitive WsByteBuffer buf) throws ProtocolException, FrameSizeException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Entered processNextBuffer with frameState of:  " + (Object)((Object)this.frameState)), (Object[])new Object[0]);
        }
        if (this.frameState == FrameState.PAYLOAD_COMPLETE) {
            return -3;
        }
        if (this.countOfBuffers >= this.frameBuffers.length) {
            int originalSize = this.frameBuffers.length;
            WsByteBuffer[] temp = new WsByteBuffer[originalSize + 10];
            System.arraycopy(this.frameBuffers, 0, temp, 0, originalSize);
            this.frameBuffers = temp;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("adding buf at index:  " + this.countOfBuffers), (Object[])new Object[0]);
        }
        this.frameBuffers[this.countOfBuffers] = buf;
        ++this.countOfBuffers;
        if (this.muxLink != null && !this.muxLink.connection_preface_string_rcvd) {
            long bytesToProcess = this.bytesRemaining();
            if (bytesToProcess < 24L) {
                return -2;
            }
            this.currentBufferArrayIndex = 0;
            try {
                if (!this.checkConnectionPreface()) {
                    throw new ProtocolException("Connection preface/magic was invalid");
                }
                this.frameState = FrameState.INIT;
                this.muxLink.processConnectionPrefaceMagic();
            }
            catch (Http2Exception e) {
                throw new ProtocolException("Failed to complete the connection preface");
            }
        }
        if (this.frameState == FrameState.INIT) {
            long bytesToProcess = this.bytesRemaining();
            if (bytesToProcess < 9L) {
                return -2;
            }
            this.currentBufferArrayIndex = 0;
            int payloadLength = this.grabNext24BitInt();
            this.byteFrameType = this.grabNextByte();
            byte flags = this.grabNextByte();
            byte frameSixthByte = this.grabNextByte();
            byte frameReserveBit = (byte)(frameSixthByte & 0xFFFFFF80);
            if (frameReserveBit != 0) {
                frameReserveBit = 1;
            }
            frameSixthByte = (byte)(frameSixthByte & 0x7F);
            int streamId = new Integer(this.grabNext24BitInt(frameSixthByte));
            this.currentFrame = FrameFactory.getFrame(this.byteFrameType, streamId, payloadLength, flags, frameReserveBit == 1, Frame.FrameDirection.READ);
            if (this.currentFrame.getFrameType() == FrameTypes.UNKNOWN && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ignoring a frame of unknown type", (Object[])new Object[0]);
            }
            this.frameState = FrameState.FIND_PAYLOAD;
        }
        if (this.currentFrame != null && this.frameState == FrameState.FIND_PAYLOAD) {
            int returnValue = -2;
            long count = 0L;
            int remaining = 0;
            for (int i = 0; i < this.countOfBuffers; ++i) {
                remaining = this.frameBuffers[i].remaining();
                if (count + (long)remaining <= (long)this.currentFrame.getPayloadLength()) {
                    if ((count += (long)remaining) != (long)this.currentFrame.getPayloadLength()) continue;
                    this.frameState = FrameState.PAYLOAD_COMPLETE;
                    returnValue = -1;
                    continue;
                }
                int nextPosition = this.frameBuffers[i].position() + (int)((long)this.currentFrame.getPayloadLength() - count);
                this.frameState = FrameState.PAYLOAD_COMPLETE;
                returnValue = nextPosition;
            }
            return returnValue;
        }
        ProtocolException e = new ProtocolException("Frame was not processed correctly");
        throw e;
    }

    @Sensitive
    public WsByteBuffer[] getFrameBuffers() {
        return this.frameBuffers;
    }

    public int getFrameBufferListSize() {
        return this.countOfBuffers;
    }

    @Sensitive
    public WsByteBuffer getBufferAtIndex(int index) {
        return this.frameBuffers[index];
    }

    public void setFrameState(FrameState state) {
        this.frameState = state;
    }

    public FrameState getFrameState() {
        return this.frameState;
    }

    public Constants.Direction getFrameDirection() {
        return Constants.Direction.READ_IN;
    }

    public long bytesRemaining() {
        long count = 0L;
        for (int i = 0; i < this.countOfBuffers; ++i) {
            if (this.frameBuffers[i] == null) continue;
            count += (long)this.frameBuffers[i].remaining();
        }
        return count;
    }

    private int grabNext24BitInt() throws FrameSizeException {
        int value = 0;
        for (int i = 2; i >= 0; --i) {
            byte b = this.grabNextByte();
            value |= (b & 0xFF) << i * 8;
        }
        return value;
    }

    public int grabNext16BitInt() throws FrameSizeException {
        int value = 0;
        for (int i = 1; i >= 0; --i) {
            byte b = this.grabNextByte();
            value |= (b & 0xFF) << i * 8;
        }
        return value;
    }

    public int grabNext24BitInt(byte firstValue) throws FrameSizeException {
        int value = 0;
        int firstShift = 3;
        value |= (firstValue & 0xFF) << firstShift * 8;
        for (int i = 2; i >= 0; --i) {
            byte b = this.grabNextByte();
            value |= (b & 0xFF) << i * 8;
        }
        return value;
    }

    public int grabNext32BitInt() throws FrameSizeException {
        int value = 0;
        for (int i = 3; i >= 0; --i) {
            byte b = this.grabNextByte();
            value |= (b & 0xFF) << i * 8;
        }
        return value;
    }

    public byte[] grabNextBytes(int numBytes) throws FrameSizeException {
        byte[] value = new byte[numBytes];
        if (this.bytesRemaining() >= (long)numBytes) {
            int j = 0;
            for (int i = numBytes - 1; i >= 0; --i) {
                byte b = this.grabNextByte();
                value[j++] = b;
            }
        }
        return value;
    }

    public boolean checkConnectionPreface() throws FrameSizeException {
        byte[] value = this.grabNextBytes(24);
        String valueString = new String(value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("checkConnectionPreface: processNextFrame-:  stream: 0 frame type: Magic Preface  direction: " + (Object)((Object)Constants.Direction.READ_IN) + " H2InboundLink hc: " + ((Object)((Object)this.muxLink)).hashCode()), (Object[])new Object[0]);
            if (value != null) {
                Tr.debug((TraceComponent)tc, (String)("checkConnectionPreface: Preface String: " + Arrays.toString(valueString.getBytes())), (Object[])new Object[0]);
            }
        }
        return valueString.equals("PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n");
    }

    public byte grabNextByte() throws FrameSizeException {
        int startArrayIndex;
        int i;
        if (this.frameBuffers[this.currentBufferArrayIndex].hasRemaining()) {
            return this.frameBuffers[this.currentBufferArrayIndex].get();
        }
        for (i = startArrayIndex = this.currentBufferArrayIndex + 1; i < this.countOfBuffers; ++i) {
            if (!this.frameBuffers[i].hasRemaining()) continue;
            byte b = this.frameBuffers[i].get();
            this.currentBufferArrayIndex = i;
            return b;
        }
        this.currentBufferArrayIndex = i;
        String msg = Tr.formatMessage((TraceComponent)tc, (String)"bytes.notavailable", (Object[])null);
        FrameSizeException e = new FrameSizeException(msg);
        throw e;
    }

    public Frame getCurrentFrame() {
        return this.currentFrame;
    }
}

