/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.metadata.ejb;

import com.ibm.ejs.container.ContainerProperties;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.ScheduleExpression;

public class TimerMethodData
implements Comparable<TimerMethodData> {
    private static final TraceComponent tc = Tr.register(TimerMethodData.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private final Method ivMethod;
    private final int ivDepth;
    int ivMethodId = -1;
    private final List<AutomaticTimer> ivAutomaticTimers = new ArrayList<AutomaticTimer>();
    private final boolean ivMethodHas1Parm;

    public TimerMethodData(Method method, int depth, boolean methodHas1Parm) {
        this.ivMethod = method;
        this.ivDepth = depth;
        this.ivMethodHas1Parm = methodHas1Parm;
    }

    @Override
    public int compareTo(TimerMethodData timer) {
        if (this.ivDepth != timer.ivDepth) {
            return this.ivDepth < timer.ivDepth ? -1 : 1;
        }
        int nameCompare = this.ivMethod.getName().compareTo(timer.ivMethod.getName());
        if (nameCompare != 0) {
            return nameCompare;
        }
        if (this.ivMethodHas1Parm != timer.ivMethodHas1Parm) {
            return this.ivMethodHas1Parm ? 1 : -1;
        }
        return 0;
    }

    void addAutomaticTimer(AutomaticTimer timer) {
        timer.ivMethod = this;
        this.ivAutomaticTimers.add(timer);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("added automatic timer: " + timer), (Object[])new Object[0]);
        }
    }

    public Method getMethod() {
        return this.ivMethod;
    }

    public int getMethodId() {
        return this.ivMethodId;
    }

    public List<AutomaticTimer> getAutomaticTimers() {
        return this.ivAutomaticTimers;
    }

    public static class AutomaticTimer {
        private final boolean ivXML;
        TimerMethodData ivMethod;
        private final boolean ivPersistent;
        private final ScheduleExpression ivSchedule;
        private final String ivStart;
        private final String ivEnd;
        private final Serializable ivInfo;

        public AutomaticTimer(boolean xml, boolean persistent, ScheduleExpression schedule, String start, String end, Serializable info) {
            this.ivXML = xml;
            this.ivPersistent = persistent;
            this.ivSchedule = schedule;
            this.ivStart = start;
            this.ivEnd = end;
            this.ivInfo = info;
        }

        public String toString() {
            String nl = ContainerProperties.LineSeparator;
            return super.toString() + nl + "     Method     = " + (this.ivMethod == null ? null : this.ivMethod.getMethodId() + " : " + this.ivMethod.getMethod()) + nl + "     Start      = " + this.ivStart + nl + "     End        = " + this.ivEnd + nl + "     Persistent = " + this.ivPersistent + nl + "     Info       = " + this.ivInfo + nl;
        }

        public boolean isXML() {
            return this.ivXML;
        }

        public TimerMethodData getMethod() {
            return this.ivMethod;
        }

        public boolean isPersistent() {
            return this.ivPersistent;
        }

        public ScheduleExpression getSchedule() {
            return this.ivSchedule;
        }

        public String getStart() {
            return this.ivStart;
        }

        public String getEnd() {
            return this.ivEnd;
        }

        public Serializable getInfo() {
            return this.ivInfo;
        }
    }
}

