/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.jitdeploy;

import com.ibm.ejs.container.ContainerEJBException;
import com.ibm.ejs.container.ContainerProperties;
import com.ibm.ejs.container.EJBConfigurationException;
import com.ibm.ejs.container.EJBMethodInfoImpl;
import com.ibm.ejs.container.util.DeploymentUtil;
import com.ibm.ejs.container.util.MethodAttribUtils;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.jitdeploy.EJBUtils;
import com.ibm.ws.ejbcontainer.jitdeploy.EJBWrapperType;
import com.ibm.ws.ejbcontainer.jitdeploy.JITUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public final class EJBWrapper {
    private static final TraceComponent tc = Tr.register(EJBWrapper.class, (String)"JITDeploy", (String)"com.ibm.ejs.container.container");
    static final Type TYPE_EJSDeployedSupport = Type.getType((String)"Lcom/ibm/ejs/container/EJSDeployedSupport;");
    static final Type TYPE_RemoteException = Type.getType((String)"Ljava/rmi/RemoteException;");
    static final String EJS_CONTAINER_FIELD_TYPE = "Lcom/ibm/ejs/container/EJSContainer;";
    public static final String LOCAL_BEAN_WRAPPER_FIELD = "ivWrapperBase";
    static final String LOCAL_BEAN_WRAPPER_FIELD_TYPE = "Lcom/ibm/ejs/container/BusinessLocalWrapper;";
    public static final String MESSAGE_ENDPOINT_BASE_FIELD = "ivMessageEndpointBase";
    static final String MESSAGE_ENDPOINT_BASE_FIELD_TYPE = "Lcom/ibm/ws/ejbcontainer/mdb/MessageEndpointBase;";
    static final String MESSAGE_ENDPOINT_BASE_STRING = "com/ibm/ws/ejbcontainer/mdb/MessageEndpointBase";
    public static final String MANAGED_BEAN_BEANO_FIELD = "ivBeanO";
    static final String MANAGED_BEAN_BEANO_FIELD_TYPE = "Lcom/ibm/ejs/container/BeanO;";

    static byte[] generateClassBytes(String wrapperClassName, Class<?>[] wrapperInterfaces, EJBWrapperType wrapperType, java.lang.reflect.Method[] allMethods, EJBMethodInfoImpl[] methodInfos, String ejbClassName, String beanName) throws EJBConfigurationException {
        boolean isLocalBean;
        boolean isAggregateWrapper;
        boolean isNoMethodInterfaceMDB;
        Class<?> mdbEnterpriseClass = null;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        boolean bl = isNoMethodInterfaceMDB = wrapperType == EJBWrapperType.MDB_NO_METHOD_INTERFACE_PROXY;
        if (wrapperType == EJBWrapperType.MDB_PROXY || wrapperType == EJBWrapperType.MDB_NO_METHOD_INTERFACE_PROXY) {
            mdbEnterpriseClass = wrapperInterfaces[1];
            wrapperInterfaces = new Class[]{wrapperInterfaces[0]};
        }
        boolean bl2 = isAggregateWrapper = wrapperInterfaces.length > 1;
        if (isAggregateWrapper && wrapperType != EJBWrapperType.LOCAL_BEAN && wrapperType != EJBWrapperType.BUSINESS_LOCAL) {
            throw new IllegalArgumentException("wrapper type = " + (Object)((Object)wrapperType));
        }
        boolean isHomeWrapper = wrapperType == EJBWrapperType.REMOTE_HOME || wrapperType == EJBWrapperType.LOCAL_HOME;
        Class<?> wrapperInterface = wrapperInterfaces[0];
        String internalClassName = JITUtils.convertClassName(wrapperClassName);
        String internalEJBClassName = JITUtils.convertClassName(ejbClassName);
        Object[] internalInterfaceNames = new String[wrapperInterfaces.length];
        for (int i = 0; i < wrapperInterfaces.length; ++i) {
            String wrapperInterfaceName = wrapperInterfaces[i].getName();
            internalInterfaceNames[i] = JITUtils.convertClassName(wrapperInterfaceName);
        }
        if (isNoMethodInterfaceMDB) {
            internalInterfaceNames[0] = "javax/resource/spi/endpoint/MessageEndpoint";
        }
        String internalParentName = EJBWrapper.getParentClassName(wrapperType, internalEJBClassName);
        boolean isRmiRemote = Remote.class.isAssignableFrom(wrapperInterface);
        boolean bl3 = isLocalBean = wrapperType == EJBWrapperType.LOCAL_BEAN || wrapperType == EJBWrapperType.MANAGED_BEAN;
        if (isLocalBean) {
            String tempName = internalInterfaceNames[0];
            internalInterfaceNames[0] = internalParentName;
            internalParentName = tempName;
        }
        if (isTraceOn) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"generateClassBytes", (Object[])new Object[0]);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("     className = " + internalClassName), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("     interface = " + Arrays.toString(internalInterfaceNames)), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("     parent    = " + internalParentName), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("     ejb       = " + internalEJBClassName), (Object[])new Object[0]);
                if (isRmiRemote) {
                    Tr.debug((TraceComponent)tc, (String)"     implements java.rmi.Remote", (Object[])new Object[0]);
                }
            }
        }
        if (!isAggregateWrapper) {
            EJBWrapper.validateInterfaceBasics(wrapperInterface, wrapperType, ejbClassName);
        }
        ClassWriter cw = new ClassWriter(1);
        cw.visit(46, 33, internalClassName, null, internalParentName, (String[])internalInterfaceNames);
        String sourceFileName = wrapperClassName.substring(wrapperClassName.lastIndexOf(".") + 1) + ".java";
        cw.visitSource(sourceFileName, null);
        EJBWrapper.addFields(cw, wrapperType);
        EJBWrapper.addCtor(cw, internalParentName);
        if (isNoMethodInterfaceMDB) {
            EJBWrapper.addBeforeDeliveryMethod(cw, internalClassName);
            EJBWrapper.addAfterDeliveryMethod(cw, internalClassName);
            EJBWrapper.addReleaseMethod(cw, internalClassName);
        }
        if (wrapperType == EJBWrapperType.LOCAL_BEAN) {
            EJBWrapper.addNoInterfaceEqualsMethod(cw, internalClassName);
            EJBWrapper.addNoInterfaceHashCodeMethod(cw, internalClassName);
        }
        if (wrapperType == EJBWrapperType.MDB_PROXY || wrapperType == EJBWrapperType.MDB_NO_METHOD_INTERFACE_PROXY) {
            EJBWrapper.addDefaultEqualsMethod(cw, internalClassName);
            EJBWrapper.addDefaultHashCodeMethod(cw, internalClassName);
        }
        java.lang.reflect.Method[] methods = isHomeWrapper || wrapperType == EJBWrapperType.MDB_PROXY || wrapperType == EJBWrapperType.MDB_NO_METHOD_INTERFACE_PROXY ? allMethods : (wrapperType == EJBWrapperType.BUSINESS_LOCAL || wrapperType == EJBWrapperType.BUSINESS_REMOTE || wrapperType == EJBWrapperType.LOCAL_BEAN || wrapperType == EJBWrapperType.MANAGED_BEAN ? DeploymentUtil.getMethods(null, wrapperInterfaces) : DeploymentUtil.getMethods(wrapperInterface, null));
        int methodId = -1;
        for (int i = 0; i < methods.length; ++i) {
            boolean isStatelessCreate;
            java.lang.reflect.Method method = methods[i];
            String implMethodName = method.getName();
            if (!isAggregateWrapper) {
                if (isHomeWrapper && !isRmiRemote && (implMethodName.startsWith("create") || implMethodName.startsWith("find"))) {
                    implMethodName = implMethodName + "_Local";
                }
                if (!isHomeWrapper && wrapperType != EJBWrapperType.MANAGED_BEAN && implMethodName.startsWith("ejb")) {
                    Tr.error((TraceComponent)tc, (String)"JIT_INVALID_MTHD_PREFIX_CNTR5010E", (Object[])new Object[]{beanName, wrapperInterface.getName(), implMethodName});
                    throw new EJBConfigurationException("EJB business method " + implMethodName + " on interface " + wrapperInterface.getName() + " must not start with 'ejb'.");
                }
                if (isLocalBean) {
                    EJBWrapper.validateLocalBeanMethod(method, beanName);
                }
            }
            ++methodId;
            EJBMethodInfoImpl methodInfo = methodInfos[methodId = EJBUtils.getMethodId(method, allMethods, methodId)];
            boolean aroundInvoke = methodInfo.getAroundInterceptorProxies() != null;
            boolean bl4 = isStatelessCreate = methodInfo.isHomeCreate() && methodInfo.isStatelessSessionBean();
            if (isAggregateWrapper) {
                java.lang.reflect.Method previousMethod = null;
                java.lang.reflect.Method currentMethod = null;
                for (Class<?> curInterface : wrapperInterfaces) {
                    Object[] currentEx;
                    try {
                        currentMethod = curInterface.getMethod(implMethodName, method.getParameterTypes());
                    }
                    catch (NoSuchMethodException ex) {
                        continue;
                    }
                    if (previousMethod == null) {
                        previousMethod = currentMethod;
                        continue;
                    }
                    Object[] previousEx = previousMethod.getExceptionTypes();
                    if (Arrays.equals(previousEx, currentEx = currentMethod.getExceptionTypes())) continue;
                    method = methodInfo.getMethod();
                    Tr.warning((TraceComponent)tc, (String)"JIT_THROWS_CLAUSE_MISMATCH_CNTR5035W", (Object[])new Object[]{beanName, method});
                }
            }
            if (wrapperType == EJBWrapperType.MANAGED_BEAN) {
                EJBWrapper.addManagedBeanMethod(cw, internalClassName, internalEJBClassName, method, implMethodName, methodId, aroundInvoke);
                continue;
            }
            if (!methodInfo.isAsynchMethod()) {
                EJBWrapper.addEJBMethod(cw, internalClassName, internalEJBClassName, wrapperType, method, implMethodName, methodId, isRmiRemote, aroundInvoke, isStatelessCreate);
                continue;
            }
            EJBWrapper.addEJBAsynchMethod(cw, internalClassName, method, methodId, isRmiRemote, wrapperType);
        }
        if (isLocalBean || isNoMethodInterfaceMDB) {
            Class<?> ejbClass = isNoMethodInterfaceMDB ? mdbEnterpriseClass : wrapperInterface;
            ArrayList<java.lang.reflect.Method> nonPublicMethods = DeploymentUtil.getNonPublicMethods(ejbClass, methods);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("     Non-public methods : " + nonPublicMethods.size()), (Object[])new Object[0]);
            }
            for (java.lang.reflect.Method method : nonPublicMethods) {
                if (!isAggregateWrapper) {
                    EJBWrapper.validateLocalBeanMethod(method, beanName);
                }
                EJBWrapper.addNonPublicMethod(cw, method);
            }
        }
        cw.visitEnd();
        byte[] classBytes = cw.toByteArray();
        if (isTraceOn) {
            if (tc.isDebugEnabled()) {
                JITUtils.writeToClassFile(internalClassName, classBytes);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("generateClassBytes: " + classBytes.length + " bytes"));
            }
        }
        return classBytes;
    }

    private static void addFields(ClassWriter cw, EJBWrapperType wrapperType) {
        FieldVisitor fv;
        if (wrapperType == EJBWrapperType.LOCAL_BEAN || wrapperType == EJBWrapperType.MANAGED_BEAN) {
            boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"     adding field : ivWrapperBase Lcom/ibm/ejs/container/BusinessLocalWrapper;", (Object[])new Object[0]);
            }
            fv = cw.visitField(2, LOCAL_BEAN_WRAPPER_FIELD, LOCAL_BEAN_WRAPPER_FIELD_TYPE, null, null);
            fv.visitEnd();
            if (wrapperType == EJBWrapperType.MANAGED_BEAN) {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"     adding field : ivBeanO Lcom/ibm/ejs/container/BeanO;", (Object[])new Object[0]);
                }
                fv = cw.visitField(2, MANAGED_BEAN_BEANO_FIELD, MANAGED_BEAN_BEANO_FIELD_TYPE, null, null);
                fv.visitEnd();
            }
        }
        if (wrapperType == EJBWrapperType.MDB_NO_METHOD_INTERFACE_PROXY) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"     adding field : ivMessageEndpointBase Lcom/ibm/ws/ejbcontainer/mdb/MessageEndpointBase;", (Object[])new Object[0]);
            }
            fv = cw.visitField(2, MESSAGE_ENDPOINT_BASE_FIELD, MESSAGE_ENDPOINT_BASE_FIELD_TYPE, null, null);
            fv.visitEnd();
        }
    }

    private static void addCtor(ClassWriter cw, String parent) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"     adding method : <init> ()V", (Object[])new Object[0]);
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, parent, "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private static void addDefaultEqualsMethod(ClassWriter cw, String implClassName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"     adding method : equals (Ljava/lang/Object;)Z", (Object[])new Object[0]);
        }
        String desc = "(Ljava/lang/Object;)Z";
        MethodVisitor mv = cw.visitMethod(1, "equals", "(Ljava/lang/Object;)Z", null, null);
        GeneratorAdapter mg = new GeneratorAdapter(mv, 1, "equals", "(Ljava/lang/Object;)Z");
        mg.visitCode();
        mg.loadThis();
        mg.loadArg(0);
        Label not_equal = new Label();
        mv.visitJumpInsn(166, not_equal);
        mg.visitInsn(4);
        mg.returnValue();
        mg.visitLabel(not_equal);
        mg.visitInsn(3);
        mg.returnValue();
        mg.endMethod();
        mg.visitEnd();
    }

    private static void addDefaultHashCodeMethod(ClassWriter cw, String implClassName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"     adding method : hashCode ()I", (Object[])new Object[0]);
        }
        String desc = "()I";
        MethodVisitor mv = cw.visitMethod(1, "hashCode", "()I", null, null);
        GeneratorAdapter mg = new GeneratorAdapter(mv, 1, "hashCode", "()I");
        mg.visitCode();
        mg.loadThis();
        mg.visitMethodInsn(184, "java/lang/System", "identityHashCode", "(Ljava/lang/Object;)I");
        mg.returnValue();
        mg.endMethod();
        mg.visitEnd();
    }

    private static void addNoInterfaceEqualsMethod(ClassWriter cw, String implClassName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"     adding method : equals (Ljava/lang/Object;)Z", (Object[])new Object[0]);
        }
        String desc = "(Ljava/lang/Object;)Z";
        MethodVisitor mv = cw.visitMethod(1, "equals", "(Ljava/lang/Object;)Z", null, null);
        GeneratorAdapter mg = new GeneratorAdapter(mv, 1, "equals", "(Ljava/lang/Object;)Z");
        mg.visitCode();
        mg.loadArg(0);
        mg.visitTypeInsn(193, implClassName);
        Label if_instanceofType_End = new Label();
        mg.visitJumpInsn(153, if_instanceofType_End);
        EJBWrapper.loadWrapperBase(mg, implClassName, EJBWrapperType.LOCAL_BEAN);
        mg.loadArg(0);
        mg.visitTypeInsn(192, implClassName);
        mv.visitFieldInsn(180, implClassName, LOCAL_BEAN_WRAPPER_FIELD, LOCAL_BEAN_WRAPPER_FIELD_TYPE);
        mg.visitMethodInsn(182, "java/lang/Object", "equals", "(Ljava/lang/Object;)Z");
        mg.returnValue();
        mg.visitLabel(if_instanceofType_End);
        mg.push(false);
        mg.returnValue();
        mg.endMethod();
        mg.visitEnd();
    }

    private static void addNoInterfaceHashCodeMethod(ClassWriter cw, String implClassName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"     adding method : hashCode ()I", (Object[])new Object[0]);
        }
        String desc = "()I";
        MethodVisitor mv = cw.visitMethod(1, "hashCode", "()I", null, null);
        GeneratorAdapter mg = new GeneratorAdapter(mv, 1, "hashCode", "()I");
        mg.visitCode();
        EJBWrapper.loadWrapperBase(mg, implClassName, EJBWrapperType.LOCAL_BEAN);
        mg.visitMethodInsn(182, "java/lang/Object", "hashCode", "()I");
        mg.returnValue();
        mg.endMethod();
        mg.visitEnd();
    }

    private static void addAfterDeliveryMethod(ClassWriter cw, String implClassName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"     adding method : afterDelivery ()V", (Object[])new Object[0]);
        }
        String desc = "()V";
        MethodVisitor mv = cw.visitMethod(1, "afterDelivery", "()V", null, new String[]{"javax/resource/ResourceException"});
        GeneratorAdapter mg = new GeneratorAdapter(mv, 1, "afterDelivery", "()V");
        mg.visitCode();
        mg.loadThis();
        mg.visitFieldInsn(180, implClassName, MESSAGE_ENDPOINT_BASE_FIELD, MESSAGE_ENDPOINT_BASE_FIELD_TYPE);
        mg.visitMethodInsn(182, MESSAGE_ENDPOINT_BASE_STRING, "afterDelivery", "()V");
        mg.returnValue();
        mg.endMethod();
        mg.visitEnd();
    }

    private static void addBeforeDeliveryMethod(ClassWriter cw, String implClassName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"     adding method : beforeDelivery (Method)V", (Object[])new Object[0]);
        }
        String desc = "(Ljava/lang/reflect/Method;)V";
        MethodVisitor mv = cw.visitMethod(1, "beforeDelivery", "(Ljava/lang/reflect/Method;)V", null, new String[]{"java/lang/NoSuchMethodException", "javax/resource/ResourceException"});
        GeneratorAdapter mg = new GeneratorAdapter(mv, 1, "beforeDelivery", "(Ljava/lang/reflect/Method;)V");
        mg.visitCode();
        mg.loadThis();
        mg.visitFieldInsn(180, implClassName, MESSAGE_ENDPOINT_BASE_FIELD, MESSAGE_ENDPOINT_BASE_FIELD_TYPE);
        mg.loadArg(0);
        mg.visitMethodInsn(182, MESSAGE_ENDPOINT_BASE_STRING, "beforeDelivery", "(Ljava/lang/reflect/Method;)V");
        mg.returnValue();
        mg.endMethod();
        mg.visitEnd();
    }

    private static void addReleaseMethod(ClassWriter cw, String implClassName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"     adding method : release ()V", (Object[])new Object[0]);
        }
        String desc = "()V";
        MethodVisitor mv = cw.visitMethod(1, "release", "()V", null, null);
        GeneratorAdapter mg = new GeneratorAdapter(mv, 1, "release", "()V");
        mg.visitCode();
        mg.loadThis();
        mg.visitFieldInsn(180, implClassName, MESSAGE_ENDPOINT_BASE_FIELD, MESSAGE_ENDPOINT_BASE_FIELD_TYPE);
        mg.visitMethodInsn(182, MESSAGE_ENDPOINT_BASE_STRING, "release", "()V");
        mg.returnValue();
        mg.endMethod();
        mg.visitEnd();
    }

    private static void addEJBMethod(ClassWriter cw, String className, String implClassName, EJBWrapperType wrapperType, java.lang.reflect.Method method, String implMethodName, int methodId, boolean isRmiRemote, boolean aroundInvoke, boolean isStatelessCreate) throws EJBConfigurationException {
        String setUncheckedException;
        String methodName = method.getName();
        String methodSignature = MethodAttribUtils.jdiMethodSignature(method);
        String EjbPreInvoke = isStatelessCreate ? "EjbPreInvokeForStatelessCreate" : "EjbPreInvoke";
        String EjbPostInvoke = isStatelessCreate ? "EjbPostInvokeForStatelessCreate" : "postInvoke";
        String string = setUncheckedException = isRmiRemote ? "setUncheckedException" : "setUncheckedLocalException";
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("     adding method : " + methodName + " " + methodSignature + " : aroundInvoke = " + aroundInvoke), (Object[])new Object[0]);
        }
        Class<?>[] methodExceptions = method.getExceptionTypes();
        Class<?>[] checkedExceptions = DeploymentUtil.getCheckedExceptions(method, isRmiRemote, DeploymentUtil.DeploymentTarget.WRAPPER, wrapperType);
        Type returnType = Type.getType(method.getReturnType());
        Type[] argTypes = JITUtils.getTypes(method.getParameterTypes());
        Type[] exceptionTypes = JITUtils.getTypes(methodExceptions);
        Method m = new Method(methodName, returnType, argTypes);
        GeneratorAdapter mg = new GeneratorAdapter(1, m, null, exceptionTypes, (ClassVisitor)cw);
        mg.visitCode();
        int returnValue = -1;
        if (returnType != Type.VOID_TYPE) {
            returnValue = mg.newLocal(returnType);
            switch (returnType.getSort()) {
                case 1: {
                    mg.push(false);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    mg.push(0);
                    break;
                }
                case 6: {
                    mg.push(0.0f);
                    break;
                }
                case 7: {
                    mg.push(0L);
                    break;
                }
                case 8: {
                    mg.push(0.0);
                    break;
                }
                default: {
                    mg.visitInsn(1);
                }
            }
            mg.storeLocal(returnValue);
        }
        int s = -1;
        if (wrapperType != EJBWrapperType.MDB_PROXY && wrapperType != EJBWrapperType.MDB_NO_METHOD_INTERFACE_PROXY) {
            s = mg.newLocal(TYPE_EJSDeployedSupport);
            mg.newInstance(TYPE_EJSDeployedSupport);
            mg.dup();
            mg.visitMethodInsn(183, "com/ibm/ejs/container/EJSDeployedSupport", "<init>", "()V");
            mg.storeLocal(s);
        } else {
            EJBWrapper.loadWrapperBase(mg, className, wrapperType);
            mg.push(methodId);
            mg.visitInsn(1);
            mg.push(3);
            mg.visitMethodInsn(wrapperType == EJBWrapperType.MDB_NO_METHOD_INTERFACE_PROXY ? 182 : 183, MESSAGE_ENDPOINT_BASE_STRING, "checkState", "(ILjava/lang/reflect/Method;B)V");
        }
        Label main_try_begin = new Label();
        mg.visitLabel(main_try_begin);
        Label if_JaccArgs_End = null;
        int args = mg.newLocal(JITUtils.TYPE_Object_ARRAY);
        if (!aroundInvoke) {
            mg.visitInsn(1);
            mg.storeLocal(args);
            EJBWrapper.loadContainer(mg, className, wrapperType);
            EJBWrapper.loadWrapperBase(mg, className, wrapperType);
            mg.visitMethodInsn(182, "com/ibm/ejs/container/EJSContainer", "doesJaccNeedsEJBArguments", "(Lcom/ibm/ejs/container/EJSWrapperBase;)Z");
            if_JaccArgs_End = new Label();
            mg.visitJumpInsn(153, if_JaccArgs_End);
        }
        mg.push(argTypes.length);
        mg.visitTypeInsn(189, "java/lang/Object");
        mg.storeLocal(args);
        for (int i = 0; i < argTypes.length; ++i) {
            mg.loadLocal(args);
            mg.push(i);
            switch (argTypes[i].getSort()) {
                case 1: {
                    mg.visitTypeInsn(187, "java/lang/Boolean");
                    mg.visitInsn(89);
                    mg.loadArg(i);
                    mg.visitMethodInsn(183, "java/lang/Boolean", "<init>", "(Z)V");
                    break;
                }
                case 2: {
                    mg.visitTypeInsn(187, "java/lang/Character");
                    mg.visitInsn(89);
                    mg.loadArg(i);
                    mg.visitMethodInsn(183, "java/lang/Character", "<init>", "(C)V");
                    break;
                }
                case 3: {
                    mg.visitTypeInsn(187, "java/lang/Byte");
                    mg.visitInsn(89);
                    mg.loadArg(i);
                    mg.visitMethodInsn(183, "java/lang/Byte", "<init>", "(B)V");
                    break;
                }
                case 4: {
                    mg.visitTypeInsn(187, "java/lang/Short");
                    mg.visitInsn(89);
                    mg.loadArg(i);
                    mg.visitMethodInsn(183, "java/lang/Short", "<init>", "(S)V");
                    break;
                }
                case 5: {
                    mg.visitTypeInsn(187, "java/lang/Integer");
                    mg.visitInsn(89);
                    mg.loadArg(i);
                    mg.visitMethodInsn(183, "java/lang/Integer", "<init>", "(I)V");
                    break;
                }
                case 6: {
                    mg.visitTypeInsn(187, "java/lang/Float");
                    mg.visitInsn(89);
                    mg.loadArg(i);
                    mg.visitMethodInsn(183, "java/lang/Float", "<init>", "(F)V");
                    break;
                }
                case 7: {
                    mg.visitTypeInsn(187, "java/lang/Long");
                    mg.visitInsn(89);
                    mg.loadArg(i);
                    mg.visitMethodInsn(183, "java/lang/Long", "<init>", "(J)V");
                    break;
                }
                case 8: {
                    mg.visitTypeInsn(187, "java/lang/Double");
                    mg.visitInsn(89);
                    mg.loadArg(i);
                    mg.visitMethodInsn(183, "java/lang/Double", "<init>", "(D)V");
                    break;
                }
                default: {
                    mg.loadArg(i);
                }
            }
            mg.visitInsn(83);
        }
        if (!aroundInvoke) {
            mg.visitLabel(if_JaccArgs_End);
        }
        Type implType = Type.getType((String)("L" + implClassName + ";"));
        int bean = mg.newLocal(implType);
        if (wrapperType != EJBWrapperType.MDB_PROXY && wrapperType != EJBWrapperType.MDB_NO_METHOD_INTERFACE_PROXY) {
            EJBWrapper.loadContainer(mg, className, wrapperType);
            EJBWrapper.loadWrapperBase(mg, className, wrapperType);
            mg.push(methodId);
            mg.loadLocal(s);
            mg.loadLocal(args);
            mg.visitMethodInsn(182, "com/ibm/ejs/container/EJSContainer", EjbPreInvoke, "(Lcom/ibm/ejs/container/EJSWrapperBase;ILcom/ibm/ejs/container/EJSDeployedSupport;[Ljava/lang/Object;)Ljava/lang/Object;");
        } else {
            EJBWrapper.loadWrapperBase(mg, className, wrapperType);
            mg.push(methodId);
            mg.loadLocal(args);
            mg.visitMethodInsn(wrapperType == EJBWrapperType.MDB_NO_METHOD_INTERFACE_PROXY ? 182 : 183, MESSAGE_ENDPOINT_BASE_STRING, "mdbMethodPreInvoke", "(I[Ljava/lang/Object;)Ljava/lang/Object;");
        }
        mg.checkCast(implType);
        mg.storeLocal(bean);
        if (aroundInvoke) {
            EJBWrapper.loadContainer(mg, className, wrapperType);
            EJBWrapper.loadEJSDeployedSupport(mg, className, wrapperType, s);
            mg.visitInsn(1);
            mg.visitMethodInsn(182, "com/ibm/ejs/container/EJSContainer", "invoke", "(Lcom/ibm/ejs/container/EJSDeployedSupport;Ljavax/ejb/Timer;)Ljava/lang/Object;");
            if (returnType == Type.VOID_TYPE) {
                mg.pop();
            } else {
                JITUtils.unbox(mg, returnType);
                mg.storeLocal(returnValue);
            }
        } else {
            mg.loadLocal(bean);
            mg.loadArgs(0, argTypes.length);
            mg.visitMethodInsn(182, implClassName, implMethodName, m.getDescriptor());
            if (returnType != Type.VOID_TYPE) {
                mg.storeLocal(returnValue);
            }
        }
        Label main_try_end = new Label();
        mg.visitLabel(main_try_end);
        Label main_finally_begin = new Label();
        mg.visitJumpInsn(168, main_finally_begin);
        Label main_tcf_exit = new Label();
        mg.visitJumpInsn(167, main_tcf_exit);
        boolean hasThrowsException = false;
        if (ContainerProperties.DeclaredUncheckedAreSystemExceptions) {
            for (Class<?> checkedException : checkedExceptions) {
                hasThrowsException |= checkedException == Exception.class;
            }
        }
        Label main_catch_runtime_exception = null;
        if (hasThrowsException) {
            main_catch_runtime_exception = new Label();
            mg.visitLabel(main_catch_runtime_exception);
            int main_th = mg.newLocal(JITUtils.TYPE_RuntimeException);
            mg.storeLocal(main_th);
            EJBWrapper.loadEJSDeployedSupport(mg, className, wrapperType, s);
            mg.loadLocal(main_th);
            mg.visitMethodInsn(182, "com/ibm/ejs/container/EJSDeployedSupport", setUncheckedException, "(Ljava/lang/Throwable;)V");
            mg.visitJumpInsn(168, main_finally_begin);
            mg.visitJumpInsn(167, main_tcf_exit);
        }
        boolean catchRemoteException = false;
        if (isRmiRemote && !ContainerProperties.DeclaredRemoteAreApplicationExceptions) {
            for (Class<?> checkedException : checkedExceptions) {
                catchRemoteException |= checkedException == Exception.class;
            }
            if (catchRemoteException) {
                for (Class<?> methodException : methodExceptions) {
                    if (methodException != RemoteException.class) continue;
                    catchRemoteException = false;
                    break;
                }
            }
        }
        Label main_catch_remote_exception = null;
        if (catchRemoteException) {
            main_catch_remote_exception = new Label();
            mg.visitLabel(main_catch_remote_exception);
            int remote_th = mg.newLocal(TYPE_RemoteException);
            mg.storeLocal(remote_th);
            EJBWrapper.loadEJSDeployedSupport(mg, className, wrapperType, s);
            mg.loadLocal(remote_th);
            mg.visitMethodInsn(182, "com/ibm/ejs/container/EJSDeployedSupport", setUncheckedException, "(Ljava/lang/Throwable;)V");
            mg.visitJumpInsn(168, main_finally_begin);
            mg.visitJumpInsn(167, main_tcf_exit);
        }
        Label[] main_catch_label = new Label[checkedExceptions.length];
        int caught_ex = mg.newLocal(JITUtils.TYPE_Exception);
        for (int i = 0; i < checkedExceptions.length; ++i) {
            main_catch_label[i] = new Label();
            mg.visitLabel(main_catch_label[i]);
            mg.storeLocal(caught_ex);
            EJBWrapper.loadEJSDeployedSupport(mg, className, wrapperType, s);
            mg.loadLocal(caught_ex);
            mg.visitMethodInsn(182, "com/ibm/ejs/container/EJSDeployedSupport", "setCheckedException", "(Ljava/lang/Exception;)V");
            mg.loadLocal(caught_ex);
            mg.visitInsn(191);
        }
        Label main_catch_throwable = new Label();
        mg.visitLabel(main_catch_throwable);
        int main_th = mg.newLocal(JITUtils.TYPE_Throwable);
        mg.storeLocal(main_th);
        EJBWrapper.loadEJSDeployedSupport(mg, className, wrapperType, s);
        mg.loadLocal(main_th);
        mg.visitMethodInsn(182, "com/ibm/ejs/container/EJSDeployedSupport", setUncheckedException, "(Ljava/lang/Throwable;)V");
        mg.visitJumpInsn(168, main_finally_begin);
        mg.visitJumpInsn(167, main_tcf_exit);
        Label main_finally_ex = new Label();
        mg.visitLabel(main_finally_ex);
        int main_finally_th = mg.newLocal(JITUtils.TYPE_Throwable);
        mg.storeLocal(main_finally_th);
        mg.visitJumpInsn(168, main_finally_begin);
        mg.loadLocal(main_finally_th);
        mg.visitInsn(191);
        mg.visitLabel(main_finally_begin);
        int main_finally_return = mg.newLocal(JITUtils.TYPE_Object);
        mg.storeLocal(main_finally_return);
        Label finally_try_begin = new Label();
        mg.visitLabel(finally_try_begin);
        if (wrapperType != EJBWrapperType.MDB_PROXY && wrapperType != EJBWrapperType.MDB_NO_METHOD_INTERFACE_PROXY) {
            EJBWrapper.loadContainer(mg, className, wrapperType);
            EJBWrapper.loadWrapperBase(mg, className, wrapperType);
            mg.push(methodId);
            mg.loadLocal(s);
            mg.visitMethodInsn(182, "com/ibm/ejs/container/EJSContainer", EjbPostInvoke, "(Lcom/ibm/ejs/container/EJSWrapperBase;ILcom/ibm/ejs/container/EJSDeployedSupport;)V");
        } else {
            EJBWrapper.loadWrapperBase(mg, className, wrapperType);
            mg.visitMethodInsn(wrapperType == EJBWrapperType.MDB_NO_METHOD_INTERFACE_PROXY ? 182 : 183, MESSAGE_ENDPOINT_BASE_STRING, "mdbMethodPostInvoke", "()V");
        }
        Label finally_try_end = new Label();
        mg.visitLabel(finally_try_end);
        Label finally_tcf_exit = new Label();
        mg.visitJumpInsn(167, finally_tcf_exit);
        Label finally_catch_remote = new Label();
        if (!isRmiRemote && wrapperType != EJBWrapperType.MDB_PROXY && wrapperType != EJBWrapperType.MDB_NO_METHOD_INTERFACE_PROXY) {
            mg.visitLabel(finally_catch_remote);
            int finally_remote = mg.newLocal(TYPE_RemoteException);
            mg.storeLocal(finally_remote);
            EJBWrapper.loadEJSDeployedSupport(mg, className, wrapperType, s);
            mg.loadLocal(finally_remote);
            mg.visitMethodInsn(182, "com/ibm/ejs/container/EJSDeployedSupport", "setUncheckedLocalException", "(Ljava/lang/Throwable;)V");
            mg.visitJumpInsn(167, finally_tcf_exit);
        }
        mg.visitLabel(finally_tcf_exit);
        mg.ret(main_finally_return);
        mg.visitLabel(main_tcf_exit);
        if (returnType != Type.VOID_TYPE) {
            mg.loadLocal(returnValue);
        }
        mg.returnValue();
        if (main_catch_runtime_exception != null) {
            mg.visitTryCatchBlock(main_try_begin, main_try_end, main_catch_runtime_exception, "java/lang/RuntimeException");
        }
        if (main_catch_remote_exception != null) {
            mg.visitTryCatchBlock(main_try_begin, main_try_end, main_catch_remote_exception, "java/rmi/RemoteException");
        }
        for (int i = 0; i < checkedExceptions.length; ++i) {
            mg.visitTryCatchBlock(main_try_begin, main_try_end, main_catch_label[i], JITUtils.convertClassName(checkedExceptions[i].getName()));
        }
        mg.visitTryCatchBlock(main_try_begin, main_try_end, main_catch_throwable, "java/lang/Throwable");
        mg.visitTryCatchBlock(main_try_begin, main_finally_ex, main_finally_ex, null);
        if (!isRmiRemote && wrapperType != EJBWrapperType.MDB_PROXY && wrapperType != EJBWrapperType.MDB_NO_METHOD_INTERFACE_PROXY) {
            mg.visitTryCatchBlock(finally_try_begin, finally_try_end, finally_catch_remote, "java/rmi/RemoteException");
        }
        mg.endMethod();
        mg.visitEnd();
    }

    private static void addEJBAsynchMethod(ClassWriter cw, String className, java.lang.reflect.Method method, int methodId, boolean isRmiRemote, EJBWrapperType wrapperType) {
        String methodName = method.getName();
        String methodSignature = MethodAttribUtils.jdiMethodSignature(method);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("     adding asynch method : " + methodName + " " + methodSignature), (Object[])new Object[0]);
        }
        Class<?>[] methodExceptions = method.getExceptionTypes();
        Type returnType = Type.getType(method.getReturnType());
        Type[] argTypes = JITUtils.getTypes(method.getParameterTypes());
        Type[] exceptionTypes = JITUtils.getTypes(methodExceptions);
        Method m = new Method(methodName, returnType, argTypes);
        GeneratorAdapter mg = new GeneratorAdapter(1, m, null, exceptionTypes, (ClassVisitor)cw);
        mg.visitCode();
        int s = mg.newLocal(TYPE_EJSDeployedSupport);
        mg.newInstance(TYPE_EJSDeployedSupport);
        mg.dup();
        mg.visitMethodInsn(183, "com/ibm/ejs/container/EJSDeployedSupport", "<init>", "()V");
        mg.storeLocal(s);
        int returnValue = -1;
        if (returnType != Type.VOID_TYPE) {
            returnValue = mg.newLocal(returnType);
            mg.visitInsn(1);
            mg.storeLocal(returnValue);
        }
        int args = mg.newLocal(JITUtils.TYPE_Object_ARRAY);
        mg.visitInsn(1);
        mg.storeLocal(args);
        mg.push(argTypes.length);
        mg.visitTypeInsn(189, "java/lang/Object");
        mg.storeLocal(args);
        for (int i = 0; i < argTypes.length; ++i) {
            mg.loadLocal(args);
            mg.push(i);
            switch (argTypes[i].getSort()) {
                case 1: {
                    mg.visitTypeInsn(187, "java/lang/Boolean");
                    mg.visitInsn(89);
                    mg.loadArg(i);
                    mg.visitMethodInsn(183, "java/lang/Boolean", "<init>", "(Z)V");
                    break;
                }
                case 2: {
                    mg.visitTypeInsn(187, "java/lang/Character");
                    mg.visitInsn(89);
                    mg.loadArg(i);
                    mg.visitMethodInsn(183, "java/lang/Character", "<init>", "(C)V");
                    break;
                }
                case 3: {
                    mg.visitTypeInsn(187, "java/lang/Byte");
                    mg.visitInsn(89);
                    mg.loadArg(i);
                    mg.visitMethodInsn(183, "java/lang/Byte", "<init>", "(B)V");
                    break;
                }
                case 4: {
                    mg.visitTypeInsn(187, "java/lang/Short");
                    mg.visitInsn(89);
                    mg.loadArg(i);
                    mg.visitMethodInsn(183, "java/lang/Short", "<init>", "(S)V");
                    break;
                }
                case 5: {
                    mg.visitTypeInsn(187, "java/lang/Integer");
                    mg.visitInsn(89);
                    mg.loadArg(i);
                    mg.visitMethodInsn(183, "java/lang/Integer", "<init>", "(I)V");
                    break;
                }
                case 6: {
                    mg.visitTypeInsn(187, "java/lang/Float");
                    mg.visitInsn(89);
                    mg.loadArg(i);
                    mg.visitMethodInsn(183, "java/lang/Float", "<init>", "(F)V");
                    break;
                }
                case 7: {
                    mg.visitTypeInsn(187, "java/lang/Long");
                    mg.visitInsn(89);
                    mg.loadArg(i);
                    mg.visitMethodInsn(183, "java/lang/Long", "<init>", "(J)V");
                    break;
                }
                case 8: {
                    mg.visitTypeInsn(187, "java/lang/Double");
                    mg.visitInsn(89);
                    mg.loadArg(i);
                    mg.visitMethodInsn(183, "java/lang/Double", "<init>", "(D)V");
                    break;
                }
                default: {
                    mg.loadArg(i);
                }
            }
            mg.visitInsn(83);
        }
        EJBWrapper.loadContainer(mg, className, wrapperType);
        EJBWrapper.loadWrapperBase(mg, className, wrapperType);
        mg.push(methodId);
        mg.loadLocal(args);
        mg.visitMethodInsn(182, "com/ibm/ejs/container/EJSContainer", "scheduleAsynchMethod", "(Lcom/ibm/ejs/container/EJSWrapperBase;I[Ljava/lang/Object;)Ljava/util/concurrent/Future;");
        if (returnType != Type.VOID_TYPE) {
            mg.storeLocal(returnValue);
        } else {
            mg.pop();
        }
        if (returnType != Type.VOID_TYPE) {
            mg.loadLocal(returnValue);
        }
        mg.returnValue();
        mg.endMethod();
        mg.visitEnd();
    }

    private static void addManagedBeanMethod(ClassWriter cw, String className, String implClassName, java.lang.reflect.Method method, String implMethodName, int methodId, boolean aroundInvoke) {
        String methodName = method.getName();
        String methodSignature = MethodAttribUtils.jdiMethodSignature(method);
        String EjbPreInvoke = "EjbPreInvokeForManagedBean";
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("     adding method : " + methodName + " " + methodSignature + " : aroundInvoke = " + aroundInvoke), (Object[])new Object[0]);
        }
        Class<?>[] methodExceptions = method.getExceptionTypes();
        Type returnType = Type.getType(method.getReturnType());
        Type[] argTypes = JITUtils.getTypes(method.getParameterTypes());
        Type[] exceptionTypes = JITUtils.getTypes(methodExceptions);
        Method m = new Method(methodName, returnType, argTypes);
        GeneratorAdapter mg = new GeneratorAdapter(1, m, null, exceptionTypes, (ClassVisitor)cw);
        mg.visitCode();
        if (!aroundInvoke) {
            Type implType = Type.getType((String)("L" + implClassName + ";"));
            int bean = mg.newLocal(implType);
            mg.loadThis();
            mg.visitFieldInsn(180, className, MANAGED_BEAN_BEANO_FIELD, MANAGED_BEAN_BEANO_FIELD_TYPE);
            mg.visitMethodInsn(182, "com/ibm/ejs/container/BeanO", "getBeanInstance", "()Ljava/lang/Object;");
            mg.checkCast(implType);
            mg.storeLocal(bean);
            mg.loadLocal(bean);
            mg.loadArgs(0, argTypes.length);
            mg.visitMethodInsn(182, implClassName, implMethodName, m.getDescriptor());
            mg.returnValue();
            mg.endMethod();
            mg.visitEnd();
            return;
        }
        int s = mg.newLocal(TYPE_EJSDeployedSupport);
        mg.newInstance(TYPE_EJSDeployedSupport);
        mg.dup();
        mg.visitMethodInsn(183, "com/ibm/ejs/container/EJSDeployedSupport", "<init>", "()V");
        mg.storeLocal(s);
        int returnValue = -1;
        if (returnType != Type.VOID_TYPE) {
            returnValue = mg.newLocal(returnType);
            switch (returnType.getSort()) {
                case 1: {
                    mg.push(false);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    mg.push(0);
                    break;
                }
                case 6: {
                    mg.push(0.0f);
                    break;
                }
                case 7: {
                    mg.push(0L);
                    break;
                }
                case 8: {
                    mg.push(0.0);
                    break;
                }
                default: {
                    mg.visitInsn(1);
                }
            }
            mg.storeLocal(returnValue);
        }
        int args = mg.newLocal(JITUtils.TYPE_Object_ARRAY);
        mg.push(argTypes.length);
        mg.visitTypeInsn(189, "java/lang/Object");
        mg.storeLocal(args);
        for (int i = 0; i < argTypes.length; ++i) {
            mg.loadLocal(args);
            mg.push(i);
            switch (argTypes[i].getSort()) {
                case 1: {
                    mg.visitTypeInsn(187, "java/lang/Boolean");
                    mg.visitInsn(89);
                    mg.loadArg(i);
                    mg.visitMethodInsn(183, "java/lang/Boolean", "<init>", "(Z)V");
                    break;
                }
                case 2: {
                    mg.visitTypeInsn(187, "java/lang/Character");
                    mg.visitInsn(89);
                    mg.loadArg(i);
                    mg.visitMethodInsn(183, "java/lang/Character", "<init>", "(C)V");
                    break;
                }
                case 3: {
                    mg.visitTypeInsn(187, "java/lang/Byte");
                    mg.visitInsn(89);
                    mg.loadArg(i);
                    mg.visitMethodInsn(183, "java/lang/Byte", "<init>", "(B)V");
                    break;
                }
                case 4: {
                    mg.visitTypeInsn(187, "java/lang/Short");
                    mg.visitInsn(89);
                    mg.loadArg(i);
                    mg.visitMethodInsn(183, "java/lang/Short", "<init>", "(S)V");
                    break;
                }
                case 5: {
                    mg.visitTypeInsn(187, "java/lang/Integer");
                    mg.visitInsn(89);
                    mg.loadArg(i);
                    mg.visitMethodInsn(183, "java/lang/Integer", "<init>", "(I)V");
                    break;
                }
                case 6: {
                    mg.visitTypeInsn(187, "java/lang/Float");
                    mg.visitInsn(89);
                    mg.loadArg(i);
                    mg.visitMethodInsn(183, "java/lang/Float", "<init>", "(F)V");
                    break;
                }
                case 7: {
                    mg.visitTypeInsn(187, "java/lang/Long");
                    mg.visitInsn(89);
                    mg.loadArg(i);
                    mg.visitMethodInsn(183, "java/lang/Long", "<init>", "(J)V");
                    break;
                }
                case 8: {
                    mg.visitTypeInsn(187, "java/lang/Double");
                    mg.visitInsn(89);
                    mg.loadArg(i);
                    mg.visitMethodInsn(183, "java/lang/Double", "<init>", "(D)V");
                    break;
                }
                default: {
                    mg.loadArg(i);
                }
            }
            mg.visitInsn(83);
        }
        Type implType = Type.getType((String)("L" + implClassName + ";"));
        int bean = mg.newLocal(implType);
        EJBWrapper.loadContainer(mg, className, EJBWrapperType.MANAGED_BEAN);
        EJBWrapper.loadWrapperBase(mg, className, EJBWrapperType.MANAGED_BEAN);
        mg.push(methodId);
        mg.loadLocal(s);
        mg.loadThis();
        mg.visitFieldInsn(180, className, MANAGED_BEAN_BEANO_FIELD, MANAGED_BEAN_BEANO_FIELD_TYPE);
        mg.loadLocal(args);
        mg.visitMethodInsn(182, "com/ibm/ejs/container/EJSContainer", EjbPreInvoke, "(Lcom/ibm/ejs/container/EJSWrapperBase;ILcom/ibm/ejs/container/EJSDeployedSupport;Lcom/ibm/ejs/container/BeanO;[Ljava/lang/Object;)Ljava/lang/Object;");
        mg.checkCast(implType);
        mg.storeLocal(bean);
        EJBWrapper.loadContainer(mg, className, EJBWrapperType.MANAGED_BEAN);
        mg.loadLocal(s);
        mg.visitInsn(1);
        mg.visitMethodInsn(182, "com/ibm/ejs/container/EJSContainer", "invoke", "(Lcom/ibm/ejs/container/EJSDeployedSupport;Ljavax/ejb/Timer;)Ljava/lang/Object;");
        if (returnType == Type.VOID_TYPE) {
            mg.pop();
        } else {
            JITUtils.unbox(mg, returnType);
            mg.storeLocal(returnValue);
        }
        if (returnType != Type.VOID_TYPE) {
            mg.loadLocal(returnValue);
        }
        mg.returnValue();
        mg.endMethod();
        mg.visitEnd();
    }

    private static void addNonPublicMethod(ClassWriter cw, java.lang.reflect.Method method) {
        String methodName = method.getName();
        String methodSignature = MethodAttribUtils.jdiMethodSignature(method);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("     adding method : " + methodName + " " + methodSignature + " : Non-Public"), (Object[])new Object[0]);
        }
        Class<?>[] methodExceptions = method.getExceptionTypes();
        Type returnType = Type.getType(method.getReturnType());
        Type[] argTypes = JITUtils.getTypes(method.getParameterTypes());
        Type[] exceptionTypes = JITUtils.getTypes(methodExceptions);
        Method m = new Method(methodName, returnType, argTypes);
        GeneratorAdapter mg = new GeneratorAdapter(1, m, null, exceptionTypes, (ClassVisitor)cw);
        mg.visitCode();
        mg.visitTypeInsn(187, "javax/ejb/EJBException");
        mg.visitInsn(89);
        mg.visitLdcInsn((Object)"Only public methods of the bean class may be invoked through the no-interface or no-method-interface view.");
        mg.visitMethodInsn(183, "javax/ejb/EJBException", "<init>", "(Ljava/lang/String;)V");
        mg.visitInsn(191);
        mg.endMethod();
        mg.visitEnd();
    }

    private static String getParentClassName(EJBWrapperType wrapperType, String internalEJBClassName) {
        String internalParentName = null;
        if (wrapperType == EJBWrapperType.REMOTE || wrapperType == EJBWrapperType.REMOTE_HOME) {
            internalParentName = "com/ibm/ejs/container/EJSWrapper";
        } else if (wrapperType == EJBWrapperType.LOCAL || wrapperType == EJBWrapperType.LOCAL_HOME) {
            internalParentName = "com/ibm/ejs/container/EJSLocalWrapper";
        } else if (wrapperType == EJBWrapperType.BUSINESS_LOCAL) {
            internalParentName = "com/ibm/ejs/container/BusinessLocalWrapper";
        } else if (wrapperType == EJBWrapperType.BUSINESS_REMOTE) {
            internalParentName = "com/ibm/ejs/container/BusinessRemoteWrapper";
        } else if (wrapperType == EJBWrapperType.LOCAL_BEAN || wrapperType == EJBWrapperType.MANAGED_BEAN) {
            internalParentName = "com/ibm/ejs/container/LocalBeanWrapper";
        } else if (wrapperType == EJBWrapperType.MDB_PROXY) {
            internalParentName = MESSAGE_ENDPOINT_BASE_STRING;
        } else if (wrapperType == EJBWrapperType.MDB_NO_METHOD_INTERFACE_PROXY) {
            internalParentName = internalEJBClassName;
        } else {
            throw new ContainerEJBException("EJBContainer internal error: Wrapper Type not supported: " + (Object)((Object)wrapperType));
        }
        return internalParentName;
    }

    private static void loadWrapperBase(GeneratorAdapter mg, String className, EJBWrapperType wrapperType) {
        mg.loadThis();
        if (wrapperType == EJBWrapperType.LOCAL_BEAN || wrapperType == EJBWrapperType.MANAGED_BEAN) {
            mg.visitFieldInsn(180, className, LOCAL_BEAN_WRAPPER_FIELD, LOCAL_BEAN_WRAPPER_FIELD_TYPE);
        } else if (wrapperType == EJBWrapperType.MDB_NO_METHOD_INTERFACE_PROXY) {
            mg.visitFieldInsn(180, className, MESSAGE_ENDPOINT_BASE_FIELD, MESSAGE_ENDPOINT_BASE_FIELD_TYPE);
        }
    }

    private static void loadContainer(GeneratorAdapter mg, String className, EJBWrapperType wrapperType) {
        EJBWrapper.loadWrapperBase(mg, className, wrapperType);
        mg.visitFieldInsn(180, "com/ibm/ejs/container/EJSWrapperBase", "container", EJS_CONTAINER_FIELD_TYPE);
    }

    private static void loadEJSDeployedSupport(GeneratorAdapter mg, String className, EJBWrapperType wrapperType, int s) {
        if (wrapperType != EJBWrapperType.MDB_PROXY && wrapperType != EJBWrapperType.MDB_NO_METHOD_INTERFACE_PROXY) {
            mg.loadLocal(s);
        } else {
            EJBWrapper.loadWrapperBase(mg, className, wrapperType);
            mg.visitFieldInsn(180, MESSAGE_ENDPOINT_BASE_STRING, "ivEJSDeployedSupport", "Lcom/ibm/ejs/container/EJSDeployedSupport;");
        }
    }

    static void validateInterfaceBasics(Class<?> wrapperInterface, EJBWrapperType wrapperType, String beanName) throws EJBConfigurationException {
        if (wrapperType != EJBWrapperType.LOCAL_BEAN && wrapperType != EJBWrapperType.MANAGED_BEAN && !Modifier.isInterface(wrapperInterface.getModifiers())) {
            Tr.error((TraceComponent)tc, (String)"JIT_INTERFACE_NOT_INTERFACE_CNTR5011E", (Object[])new Object[]{beanName, wrapperInterface.getName()});
            throw new EJBConfigurationException("Configured " + (Object)((Object)wrapperType) + " interface is not an interface : " + wrapperInterface.getName() + " of bean " + beanName);
        }
        if (wrapperType == EJBWrapperType.BUSINESS_LOCAL || wrapperType == EJBWrapperType.BUSINESS_REMOTE) {
            Class<?> invalidExtends = EJBWrapper.getInvalidBusinessExtends(wrapperInterface);
            if (invalidExtends != null) {
                Tr.error((TraceComponent)tc, (String)"JIT_INVALID_EXTENDS_JAVAX_EJB_CNTR5012E", (Object[])new Object[]{beanName, wrapperInterface.getName(), invalidExtends.getName()});
                throw new EJBConfigurationException("Configured " + (Object)((Object)wrapperType) + " interface extends " + invalidExtends.getName() + " : " + wrapperInterface.getName() + " of bean " + beanName);
            }
            if (wrapperType == EJBWrapperType.BUSINESS_LOCAL && Remote.class.isAssignableFrom(wrapperInterface)) {
                Tr.error((TraceComponent)tc, (String)"JIT_INVALID_EXTENDS_REMOTE_CNTR5013E", (Object[])new Object[]{beanName, wrapperInterface.getName()});
                throw new EJBConfigurationException("Configured " + (Object)((Object)wrapperType) + " interface extends javax.rmi.Remote : " + wrapperInterface.getName() + " of bean " + beanName);
            }
        } else if (wrapperType == EJBWrapperType.LOCAL) {
            if (!EJBLocalObject.class.isAssignableFrom(wrapperInterface)) {
                Tr.error((TraceComponent)tc, (String)"JIT_MUST_EXTEND_EJBLOCAL_CNTR5014E", (Object[])new Object[]{beanName, wrapperInterface.getName()});
                throw new EJBConfigurationException("Configured " + (Object)((Object)wrapperType) + " interface does not extend " + EJBLocalObject.class.getName() + " : " + wrapperInterface.getName() + " of bean " + beanName);
            }
        } else if (wrapperType == EJBWrapperType.REMOTE) {
            if (!EJBObject.class.isAssignableFrom(wrapperInterface)) {
                Tr.error((TraceComponent)tc, (String)"JIT_MUST_EXTEND_EJBOBJECT_CNTR5015E", (Object[])new Object[]{beanName, wrapperInterface.getName()});
                throw new EJBConfigurationException("Configured " + (Object)((Object)wrapperType) + " interface does not extend " + EJBObject.class.getName() + " : " + wrapperInterface.getName() + " of bean " + beanName);
            }
        } else if (wrapperType == EJBWrapperType.SERVICE_ENDPOINT) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Field[] fields;
                if (!Remote.class.isAssignableFrom(wrapperInterface)) {
                    Tr.debug((TraceComponent)tc, (String)("Configured " + (Object)((Object)wrapperType) + " interface does not         extend " + Remote.class.getName() + " : " + wrapperInterface.getName() + " of bean " + beanName), (Object[])new Object[0]);
                }
                for (Field field : fields = wrapperInterface.getFields()) {
                    int modifier = field.getModifiers();
                    if (!Modifier.isStatic(modifier) || !Modifier.isFinal(modifier)) continue;
                    Tr.debug((TraceComponent)tc, (String)("Configured " + (Object)((Object)wrapperType) + " interface declares a constant : " + field.getName() + " on " + wrapperInterface.getName() + " of bean " + beanName), (Object[])new Object[0]);
                }
            }
        } else if (wrapperType == EJBWrapperType.LOCAL_BEAN) {
            // empty if block
        }
    }

    private static Class<?> getInvalidBusinessExtends(Class<?> wrapperInterface) {
        if (EJBLocalObject.class.isAssignableFrom(wrapperInterface)) {
            return EJBLocalObject.class;
        }
        if (EJBLocalHome.class.isAssignableFrom(wrapperInterface)) {
            return EJBLocalHome.class;
        }
        if (EJBObject.class.isAssignableFrom(wrapperInterface)) {
            return EJBObject.class;
        }
        if (EJBHome.class.isAssignableFrom(wrapperInterface)) {
            return EJBHome.class;
        }
        return null;
    }

    private static void validateLocalBeanMethod(java.lang.reflect.Method method, String beanName) throws EJBConfigurationException {
        int modifiers = method.getModifiers();
        if (Modifier.isFinal(modifiers)) {
            String className = method.getDeclaringClass().getName();
            Tr.error((TraceComponent)tc, (String)"JIT_INVALID_FINAL_METHOD_CNTR5106E", (Object[])new Object[]{method.getName(), className, beanName});
            throw new EJBConfigurationException("Method " + method.getName() + " on class " + className + " must not be declared as final for the no-interface local view of bean " + beanName + ".");
        }
        if (Modifier.isPublic(modifiers)) {
            Class<?>[] exceptions;
            for (Class<?> exception : exceptions = method.getExceptionTypes()) {
                if (!RemoteException.class.isAssignableFrom(exception)) continue;
                String className = method.getDeclaringClass().getName();
                Tr.error((TraceComponent)tc, (String)"JIT_INVALID_THROW_REMOTE_CNTR5101W", (Object[])new Object[]{method.getName(), className});
                throw new EJBConfigurationException("Method " + method.getName() + " on class " + className + " must not define the java.rmi.RemoteException exception on the throws clause for the no-interface local view of bean " + beanName + ".");
            }
        }
    }
}

