/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.expiry;

import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.msgstore.MessageStoreRuntimeException;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.XmlConstants;
import com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink;
import com.ibm.ws.sib.msgstore.cache.links.LinkOwner;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.persistence.PersistentMessageStore;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;

public class CacheLoader
implements AlarmListener,
XmlConstants {
    private static TraceComponent tc = SibTr.register(CacheLoader.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private static final int MAX_DIAG_LOG = 10;
    private Alarm loaderAlarm = null;
    private long interval = 0L;
    private boolean enabled = false;
    private boolean shutdown = false;
    private MessageStoreImpl messageStore = null;
    private final AlarmLock alarmLock = new AlarmLock();
    private JsMessagingEngine messagingEngine = null;
    private Set results = null;
    private Iterator iter = null;
    private long loaderStartTime = 0L;
    private long loaderStopTime = 0L;
    private Throwable lastException = null;
    private long lastExceptionTime = 0L;
    private int maxStreamsPerCycle = 0;
    private long totalStreams = 0L;
    private int diagIndex = 0;
    private long[] cycleTime = new long[10];
    private long[] logStreamsLoaded = new long[10];
    private long[] logDuration = new long[10];

    public CacheLoader(MessageStoreImpl ms) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)((Object)ms));
        }
        this.messageStore = ms;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public final void start(long loaderInterval, JsMessagingEngine jsme) throws MessageStoreRuntimeException {
        String value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"start", (Object)loaderInterval);
        }
        this.messagingEngine = jsme;
        if (loaderInterval >= 0L) {
            this.interval = loaderInterval * 1000L;
        } else {
            value = this.messageStore.getProperty("cacheLoaderInterval", "60");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"start", (Object)("Interval from system prop=<" + value + ">"));
            }
            try {
                this.interval = Long.parseLong(value.trim()) * 1000L;
            }
            catch (NumberFormatException e) {
                this.lastException = e;
                this.lastExceptionTime = CacheLoader.timeNow();
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"start", (Object)("Unable to parse cacheLoaderInterval property: " + e));
                this.interval = 60000L;
            }
        }
        value = this.messageStore.getProperty("maxStreamsPerCycle", "10");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"start", (Object)("maxStreamsPerCycle from system prop=<" + value + ">"));
        }
        try {
            this.maxStreamsPerCycle = Integer.parseInt(value.trim());
        }
        catch (NumberFormatException e) {
            this.lastException = e;
            this.lastExceptionTime = CacheLoader.timeNow();
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"start", (Object)("Unable to parse maxStreamsPerCycle property: " + e));
            this.maxStreamsPerCycle = 10;
        }
        PersistentMessageStore pm = this.messageStore.getPersistentMessageStore();
        try {
            this.results = pm.identifyStreamsWithExpirableItems();
            this.totalStreams = this.results.size();
            this.iter = this.results.iterator();
            if (this.interval < 1L) {
                this.enabled = false;
            } else if (this.loaderAlarm == null) {
                this.enabled = true;
                this.shutdown = false;
                this.loaderStartTime = CacheLoader.timeNow();
                this.loaderAlarm = this.scheduleAlarm(this.interval);
            }
        }
        catch (PersistenceException pe) {
            FFDCFilter.processException((Throwable)pe, (String)"com.ibm.ws.sib.msgstore.expiry.CacheLoader.run", (String)"191", (Object)this);
            this.lastException = pe;
            this.lastExceptionTime = CacheLoader.timeNow();
            this.enabled = false;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"run", (Object)("CacheLoader stopping - interrupted: " + (Object)((Object)pe)));
            }
            throw new MessageStoreRuntimeException("CACHE_LOADER_TERMINATED_SIMS2003", new Object[]{pe}, (Throwable)pe);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"start", (Object)("enabled=" + this.enabled + " interval=" + this.interval));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stop");
        }
        AlarmLock alarmLock = this.alarmLock;
        synchronized (alarmLock) {
            if (this.enabled) {
                this.loaderStopTime = CacheLoader.timeNow();
                this.enabled = false;
                this.shutdown = true;
            }
            if (this.loaderAlarm != null) {
                this.loaderAlarm.cancel();
                this.loaderAlarm = null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void alarm(Object obj) {
        if (this.messagingEngine != null) {
            SibTr.push((Object)this.messagingEngine);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"alarm");
        }
        int indexUsed = 0;
        long streamsLoaded = 0L;
        long startTime = 0L;
        String str = "";
        AlarmLock alarmLock = this.alarmLock;
        synchronized (alarmLock) {
            block20: {
                try {
                    if (this.enabled) {
                        long duration;
                        startTime = CacheLoader.timeNow();
                        indexUsed = this.saveStartTime(startTime);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"CacheLoader cycle starting");
                        }
                        streamsLoaded = 0L;
                        while (this.enabled && this.iter.hasNext() && streamsLoaded < (long)this.maxStreamsPerCycle) {
                            AbstractItemLink link;
                            long key = (Long)this.iter.next();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Reloading stream ID=" + key));
                            }
                            if ((link = this.messageStore.getLink(key)) != null) {
                                boolean loaded = ((LinkOwner)link).loadOwnedLinks();
                                if (!loaded) continue;
                                ++streamsLoaded;
                                continue;
                            }
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"ID returned from persistence gave null link?");
                        }
                        this.logDuration[indexUsed] = duration = CacheLoader.timeNow() - startTime;
                        this.logStreamsLoaded[indexUsed] = streamsLoaded;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("End of CacheLoader cycle. " + streamsLoaded + " stream(s) loaded in " + duration + "ms"));
                        }
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.msgstore.expiry.CacheLoader.run", (String)"301", (Object)this);
                    this.lastException = e;
                    this.lastExceptionTime = CacheLoader.timeNow();
                    this.enabled = false;
                    if (this.shutdown && e instanceof InterruptedException) break block20;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"run", (Object)("CacheLoader stopping - interrupted: " + e));
                    }
                    throw new MessageStoreRuntimeException("CACHE_LOADER_TERMINATED_SIMS2003", new Object[]{e}, (Throwable)e);
                }
            }
            if (this.enabled) {
                if (this.iter.hasNext()) {
                    this.loaderAlarm = this.scheduleAlarm(this.interval);
                    str = "More";
                } else {
                    this.loaderAlarm = null;
                    this.loaderStopTime = CacheLoader.timeNow();
                    str = "Finished";
                }
            } else {
                this.loaderAlarm = null;
                this.loaderStopTime = CacheLoader.timeNow();
                str = "Ended";
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"alarm", (Object)str);
        }
        if (this.messagingEngine != null) {
            SibTr.pop();
        }
    }

    private int saveStartTime(long time) {
        int indexUsed = this.diagIndex;
        this.cycleTime[this.diagIndex++] = time;
        if (this.diagIndex >= 10) {
            this.diagIndex = 0;
        }
        return indexUsed;
    }

    private Alarm scheduleAlarm(long timeOut) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)("scheduleAlarm timeOut=" + timeOut));
        }
        Alarm alarm = AlarmManager.createNonDeferrable((long)timeOut, (AlarmListener)this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"scheduleAlarm");
        }
        return alarm;
    }

    public static long timeNow() {
        return System.currentTimeMillis();
    }

    public void xmlWriteOn(FormattedWriter writer) throws IOException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd @ HH:mm:ss.SSS");
        String timeNow = dateFormat.format(new Date());
        writer.newLine();
        writer.startTag("cacheLoader");
        writer.indent();
        writer.newLine();
        writer.taggedValue("timeNow", (Object)timeNow);
        writer.newLine();
        writer.taggedValue("interval", this.interval);
        writer.newLine();
        writer.taggedValue("enabled", (Object)this.enabled);
        writer.newLine();
        writer.taggedValue("maxStreamsPerCycle", (long)this.maxStreamsPerCycle);
        writer.newLine();
        writer.taggedValue("loaderStartTime", (Object)dateFormat.format(new Date(this.loaderStartTime)));
        writer.newLine();
        writer.taggedValue("loaderStopTime", (Object)dateFormat.format(new Date(this.loaderStopTime)));
        writer.newLine();
        writer.taggedValue("totalStreams", this.totalStreams);
        writer.newLine();
        for (int i = 0; i < 10; ++i) {
            String str = "Cycle=" + i + (this.diagIndex == i ? ":*" : ": ") + dateFormat.format(new Date(this.cycleTime[i])) + " streamsLoaded=" + this.logStreamsLoaded[i] + " duration=" + this.logDuration[i];
            writer.taggedValue("info", (Object)str);
            writer.newLine();
        }
        writer.startTag("storedException");
        if (this.lastException == null) {
            writer.write("No exceptions recorded");
        } else {
            writer.indent();
            writer.newLine();
            writer.taggedValue("time", (Object)new Date(this.lastExceptionTime));
            writer.outdent();
            writer.write(this.lastException);
            writer.newLine();
        }
        writer.endTag("storedException");
        writer.outdent();
        writer.newLine();
        writer.endTag("cacheLoader");
    }

    private static final class AlarmLock {
        private AlarmLock() {
        }
    }
}

