/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.tools;

import com.sun.tools.ws.wscompile.WsgenTool;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Arrays;

public class WsGen {
    public static void main(String[] args) {
        if (WsGen.getMajorJavaVersion() > 8) {
            String classpathValue = null;
            Class<?> JAXB2 = null;
            Class<?> WebService = null;
            try {
                JAXB2 = Thread.currentThread().getContextClassLoader().loadClass("javax.xml.bind.JAXB");
                WebService = Thread.currentThread().getContextClassLoader().loadClass("javax.jws.WebService");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                System.exit(2);
            }
            classpathValue = WsGen.getJarFileOfClass(JAXB2);
            classpathValue = classpathValue + File.pathSeparator + WsGen.getJarFileOfClass(WebService);
            if (classpathValue != null) {
                boolean classpathSet = false;
                for (int i = 0; i < args.length; ++i) {
                    if (!args[i].equals("-cp") && !args[i].equals("-classpath")) continue;
                    args[i + 1] = args[i + 1] + File.pathSeparator + classpathValue;
                    classpathSet = true;
                }
                if (!classpathSet && args.length > 0) {
                    args = Arrays.copyOf(args, args.length + 2);
                    args[args.length - 1] = args[args.length - 3];
                    args[args.length - 2] = classpathValue;
                    args[args.length - 3] = "-classpath";
                }
            }
        }
        System.exit(new WsgenTool(System.out).run(args) ? 0 : 1);
    }

    private static String getJarFileOfClass(final Class<?> javaClass) {
        ProtectionDomain protectionDomain = AccessController.doPrivileged(new PrivilegedAction<ProtectionDomain>(){

            @Override
            public ProtectionDomain run() {
                return javaClass.getProtectionDomain();
            }
        });
        return protectionDomain.getCodeSource().getLocation().getPath();
    }

    private static int getMajorJavaVersion() {
        String version = System.getProperty("java.version");
        String[] versionElements = version.split("\\D");
        int i = Integer.valueOf(versionElements[0]) == 1 ? 1 : 0;
        return Integer.valueOf(versionElements[i]);
    }
}

