/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authorization.jacc.web.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authorization.jacc.web.impl.ActionString;
import com.ibm.ws.security.authorization.jacc.web.impl.MethodConstraint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class URLMap {
    private static TraceComponent tc = Tr.register(URLMap.class, (String)"Security.Authorization", (String)"com.ibm.ws.security.authorization.jacc.web.resources.JaccWebAuthorizationMessages");
    private StringBuffer newURLPattern;
    private Map<String, MethodConstraint> mapMethod = null;
    private Map<String, MethodConstraint> mapMethodOmission = null;
    private Map<String, MethodConstraint> mapAllMethods = null;
    private List<String> unchkResourceForOmissionList = null;
    private List<String> excludedForOmissionList = null;
    static String ALL_METHODS = "AllMethods";
    private static final int UNCHECKED = 1;
    private static final int EXCLUDED = 2;
    private static final int ROLE = 4;
    private static final int ROLE_NO_CHECK = 16;
    private static final int USERDATA = 8;
    private static final int EXCLUDED_OR_ROLE = 256;
    private static final int EXCLUDED_AND_ROLE = 512;
    private static final int EXCLUDED_OR_UNCHECKED = 1024;
    private static final int EXCLUDED_OR_UNCHECKED_NO_ROLE = 2048;
    private static final int UD_CONFIDENTIAL_OR_INTEGRAL_NON_NONE = 12289;
    private static final int UD_CONFIDENTIAL_OR_INTEGRAL_NO_EX_CHECK = 12290;
    private static final int UD_NONE = 16384;
    private static final int UD_NONE_AND_NON_CONF_INTEG_NO_EX_CHECK = 16385;
    private static final int UD_NONE_NO_EX_CHECK = 32770;
    private static final int EXCLUDED_OR_UD_NON_NONE = 32772;
    public static final int METHODS_NORMAL = 1;
    public static final int METHODS_OMISSION = 2;
    public static final int METHODS_ALL = 3;
    static final long serialVersionUID = 180533470366270597L;

    public URLMap(String url) {
        this.newURLPattern = url != null ? new StringBuffer(url) : new StringBuffer();
    }

    public void appendURLPattern(String urlPattern) {
        if (urlPattern != null && urlPattern.length() != 0) {
            this.newURLPattern.append(":" + urlPattern);
        }
    }

    public String getURLPattern() {
        return this.newURLPattern.toString();
    }

    public void setExcludedSet(List<String> mList) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Setting excluded methods", (Object[])new Object[0]);
        }
        this.setMethodsAttribute(mList, false, 2, null);
    }

    public void setExcludedSet(List<String> mList, boolean omission) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Setting excluded methods with omission", (Object[])new Object[0]);
        }
        this.setMethodsAttribute(mList, omission, 2, null);
        if (omission) {
            this.excludedForOmissionList = this.updateList(this.excludedForOmissionList, mList);
        }
    }

    public void setUncheckedSet(List<String> mList) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Setting unchecked methods", (Object[])new Object[0]);
        }
        this.setMethodsAttribute(mList, false, 1, null);
    }

    public void setUncheckedSet(List<String> mList, boolean omission) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Setting unchecked methods with omission", (Object[])new Object[0]);
        }
        this.setMethodsAttribute(mList, omission, 1, null);
    }

    public void setRoleMap(String roleName, List<String> mList) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Setting rolemap", (Object[])new Object[0]);
        }
        this.setMethodsAttribute(mList, false, 4, roleName);
    }

    public void setRoleMap(String roleName, List<String> mList, boolean omission) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Setting rolemap with omission", (Object[])new Object[0]);
        }
        this.setMethodsAttribute(mList, omission, 4, roleName);
        if (omission) {
            this.unchkResourceForOmissionList = this.updateList(this.unchkResourceForOmissionList, mList);
        }
    }

    public void setUserDataMap(String constraintType, List<String> mList) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Setting userdata", (Object[])new Object[0]);
        }
        this.setMethodsAttribute(mList, false, 8, constraintType);
    }

    public void setUserDataMap(String constraintType, List<String> mList, boolean omission) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Setting userdata with omission", (Object[])new Object[0]);
        }
        this.setMethodsAttribute(mList, omission, 8, constraintType);
    }

    public ActionString getExcludedString() {
        if (this.mapAllMethods != null) {
            if (this.getMethod(this.mapAllMethods, 2, true) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"all methods - excluded (1)", (Object[])new Object[0]);
                }
                return new ActionString();
            }
            return null;
        }
        Map<String, MethodConstraint> outputNormal = null;
        Map<String, MethodConstraint> outputOmission = null;
        if (this.mapMethod != null) {
            outputNormal = this.getMethod(this.mapMethod, 2, true);
        }
        if (this.mapMethodOmission != null && (outputOmission = this.getMethod(this.mapMethodOmission, 2, true)) != null && (outputOmission = this.getMethod(this.mapMethodOmission, this.excludedForOmissionList)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"all methods - excluded (1)", (Object[])new Object[0]);
            }
            return new ActionString();
        }
        if (outputNormal != null && outputNormal.size() > 0 || outputOmission != null && outputOmission.size() > 0) {
            ActionString output = this.getMergedMethod(outputNormal, outputOmission, false);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getExcludedMethod : " + output), (Object[])new Object[0]);
            }
            return output;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"no method - excluded (2)", (Object[])new Object[0]);
        }
        return null;
    }

    public ActionString getUncheckedString() {
        if (this.mapAllMethods != null) {
            if (this.getMethod(this.mapAllMethods, 1, true) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getUncheckedMethod : all methods", (Object[])new Object[0]);
                }
                return new ActionString();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getUncheckedMethod : no match in all methods", (Object[])new Object[0]);
            }
            return null;
        }
        Map<String, MethodConstraint> outputNormal = null;
        Map<String, MethodConstraint> outputOmission = null;
        if (this.mapMethod != null) {
            outputNormal = this.getMethod(this.mapMethod, 256, true);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("outputNormal: " + outputNormal), (Object[])new Object[0]);
        }
        if (this.mapMethodOmission != null) {
            outputOmission = this.getMethod(this.mapMethodOmission, 2, true);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("outputOmission(EXCLUDED): " + outputOmission), (Object[])new Object[0]);
            }
            if (outputOmission != null) {
                if (this.existMethod(this.mapMethodOmission, 16, true)) {
                    outputOmission = this.getMethod(this.mapMethodOmission, this.unchkResourceForOmissionList);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("outputOmission(uncheckResource): " + outputOmission), (Object[])new Object[0]);
                    }
                    outputOmission = this.getMethod(outputOmission, 512, true);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("outputOmission(EXCLUDED_AND_ROLE): " + outputOmission), (Object[])new Object[0]);
                    }
                }
            } else {
                outputOmission = this.getMethod(this.mapMethodOmission, 1, true);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("outputOmission(UNCHECKED): " + outputOmission), (Object[])new Object[0]);
                }
                if (outputOmission == null) {
                    outputOmission = this.getMethod(this.mapMethodOmission, this.unchkResourceForOmissionList);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("outputOmission(unchkResource): " + outputOmission), (Object[])new Object[0]);
                    }
                } else {
                    if (outputNormal != null) {
                        Map<String, MethodConstraint> roleOnly = this.getMethod(this.mapMethodOmission, 4, true);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("roleOnly: " + roleOnly), (Object[])new Object[0]);
                        }
                        if (roleOnly != null) {
                            String method = null;
                            for (Map.Entry<String, MethodConstraint> e : roleOnly.entrySet()) {
                                method = e.getKey();
                                if (outputOmission.containsKey(method)) continue;
                                outputNormal.remove(method);
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug((TraceComponent)tc, (String)("removed from outputNormal : " + method), (Object[])new Object[0]);
                            }
                        }
                    }
                    outputOmission = null;
                }
            }
        }
        if (outputNormal != null && outputNormal.size() > 0 || outputOmission != null && outputOmission.size() > 0) {
            ActionString output = this.getMergedMethod(outputNormal, outputOmission, true);
            if (output != null && output.getActions() == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"all methods are returned, reset to null", (Object[])new Object[0]);
                }
                output = null;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getUncheckedMethod : " + output), (Object[])new Object[0]);
            }
            return output;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getUncheckedMethod : no match", (Object[])new Object[0]);
        }
        return null;
    }

    public ActionString getUserDataString(String value) {
        if (value == null) {
            return null;
        }
        ActionString output = null;
        output = this.mapAllMethods != null ? this.getUserDataStringFromAllMap(this.mapAllMethods, value) : this.getUserDataStringFromMethodsMap(value);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getUserDataString output: " + output), (Object[])new Object[0]);
        }
        return output;
    }

    public Map<String, String> getRoleMap() {
        if (this.mapAllMethods != null) {
            return this.getRoleMapFromAllMap();
        }
        Map<String, List<String>> outputRTMNormal = null;
        Map<String, List<String>> outputRTMOmission = null;
        if (this.mapMethod != null) {
            outputRTMNormal = this.getRoleToMethodMap(this.getMethod(this.mapMethod, 4, true));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("outputRTMNormal: " + outputRTMNormal), (Object[])new Object[0]);
            }
        }
        if (this.mapMethodOmission != null) {
            Map<String, MethodConstraint> omissionRole = this.getMethod(this.mapMethodOmission, 16, true);
            Map<String, MethodConstraint> validRole = this.getMethod(this.mapMethodOmission, 2048, true);
            Map<String, MethodConstraint> uncheckedOrExcluded = this.getMethod(this.mapMethodOmission, 1024, true);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("omissionRole: " + omissionRole + " validRole : " + validRole + " uncheckedOrExcluded : " + uncheckedOrExcluded), (Object[])new Object[0]);
            }
            if (omissionRole != null && (uncheckedOrExcluded != null && validRole != null || uncheckedOrExcluded == null)) {
                outputRTMOmission = this.getRoleToMethodMap(omissionRole);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("outputRTMOmission: " + outputRTMOmission), (Object[])new Object[0]);
                }
            }
        }
        Map<String, String> output = this.mergeRTM(outputRTMNormal, outputRTMOmission);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getRoleMap: output: " + output), (Object[])new Object[0]);
        }
        return output;
    }

    private void setMethodsAttribute(List<String> mList, boolean omission, int attribute, String value) {
        Map<String, MethodConstraint> mapWork = null;
        if (mList == null || mList.isEmpty()) {
            mList = new ArrayList<String>();
            mList.add(ALL_METHODS);
            if (this.mapAllMethods == null) {
                this.mapAllMethods = new HashMap<String, MethodConstraint>();
            }
            mapWork = this.mapAllMethods;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"all methods", (Object[])new Object[0]);
            }
        } else if (!omission) {
            if (this.mapMethod == null) {
                this.mapMethod = new HashMap<String, MethodConstraint>();
            }
            mapWork = this.mapMethod;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"http methods", (Object[])new Object[0]);
            }
        } else {
            if (this.mapMethodOmission == null) {
                this.mapMethodOmission = new HashMap<String, MethodConstraint>();
            }
            mapWork = this.mapMethodOmission;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"http methods omission", (Object[])new Object[0]);
            }
        }
        for (String httpMethod : mList) {
            httpMethod = httpMethod.toUpperCase();
            MethodConstraint mc = null;
            if (mapWork.containsKey(httpMethod)) {
                mc = mapWork.get(httpMethod);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("method exists : " + httpMethod), (Object[])new Object[0]);
                }
            } else {
                mc = new MethodConstraint();
                mapWork.put(httpMethod, mc);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("method created : " + httpMethod), (Object[])new Object[0]);
                }
            }
            switch (attribute) {
                case 1: {
                    mc.setUnchecked();
                    break;
                }
                case 2: {
                    mc.setExcluded();
                    break;
                }
                case 4: {
                    mc.setRole(value);
                    break;
                }
                case 8: {
                    mc.setUserData(value);
                    break;
                }
            }
        }
    }

    private List<String> updateList(List<String> list, List<String> newItems) {
        block4: {
            block3: {
                if (newItems == null) {
                    return list;
                }
                if (list != null && list.size() != 0) break block3;
                list = new ArrayList<String>();
                for (String newItem : newItems) {
                    list.add(newItem);
                }
                break block4;
            }
            if (newItems.size() <= 0) break block4;
            for (int i = list.size() - 1; i >= 0; --i) {
                String method = list.get(i);
                if (newItems.contains(method)) continue;
                list.remove(i);
            }
        }
        return list;
    }

    private boolean existMethod(Map<String, MethodConstraint> methodMap, int attribute, boolean condition) {
        if (methodMap == null) {
            return false;
        }
        MethodConstraint mc = null;
        boolean result = false;
        boolean output = false;
        for (Map.Entry<String, MethodConstraint> e : methodMap.entrySet()) {
            mc = e.getValue();
            result = false;
            switch (attribute) {
                case 2: {
                    result = mc.isExcluded();
                    break;
                }
                case 16: {
                    if (mc.isRoleSetEmpty()) break;
                    result = true;
                    break;
                }
                case 1: {
                    result = mc.isUnchecked();
                    break;
                }
                case 16384: {
                    if (mc.isExcluded()) break;
                    String ud = mc.getUserData();
                    result = ud == null || mc.isUserDataNone();
                    break;
                }
                case 12290: {
                    String ud = mc.getUserData();
                    result = ud != null && (ud.equalsIgnoreCase("CONFIDENTIAL") || ud.equalsIgnoreCase("INTEGRAL"));
                    break;
                }
            }
            if (result != condition) continue;
            output = true;
            break;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("existMethod : " + output), (Object[])new Object[0]);
        }
        return output;
    }

    private Map<String, MethodConstraint> getMethod(Map<String, MethodConstraint> methodMap, int attribute, boolean condition) {
        if (methodMap == null) {
            return null;
        }
        HashMap<String, MethodConstraint> output = new HashMap<String, MethodConstraint>();
        MethodConstraint mc = null;
        String method = null;
        boolean result = false;
        String ud = null;
        for (Map.Entry<String, MethodConstraint> e : methodMap.entrySet()) {
            result = false;
            method = e.getKey();
            mc = e.getValue();
            switch (attribute) {
                case 4: {
                    if (mc.isExcluded() || mc.isUnchecked() || mc.isRoleSetEmpty()) break;
                    result = true;
                    break;
                }
                case 16: {
                    if (mc.isRoleSetEmpty()) break;
                    result = true;
                    break;
                }
                case 1: {
                    result = mc.isUnchecked();
                    break;
                }
                case 2: {
                    result = mc.isExcluded();
                    break;
                }
                case 256: {
                    result = mc.isExcluded() || !mc.isUnchecked() && !mc.isRoleSetEmpty();
                    break;
                }
                case 512: {
                    result = mc.isExcluded() && !mc.isRoleSetEmpty();
                    break;
                }
                case 1024: {
                    result = mc.isExcluded() || mc.isUnchecked();
                    break;
                }
                case 2048: {
                    result = (mc.isExcluded() || mc.isUnchecked()) && mc.isRoleSetEmpty();
                    break;
                }
                case 12289: {
                    if (mc.isExcluded() || mc.isUserDataNone()) break;
                    ud = mc.getUserData();
                    result = ud != null && (ud.equalsIgnoreCase("CONFIDENTIAL") || ud.equalsIgnoreCase("INTEGRAL"));
                    break;
                }
                case 12290: {
                    ud = mc.getUserData();
                    result = ud != null && (ud.equalsIgnoreCase("CONFIDENTIAL") || ud.equalsIgnoreCase("INTEGRAL"));
                    break;
                }
                case 16384: {
                    if (mc.isExcluded()) break;
                    result = mc.isUserDataNone();
                    break;
                }
                case 16385: {
                    if (mc.isExcluded()) break;
                    ud = mc.getUserData();
                    result = mc.isUserDataNone() && (ud == null || !ud.equalsIgnoreCase("CONFIDENTIAL") && !ud.equalsIgnoreCase("INTEGRAL"));
                    break;
                }
                case 32772: {
                    if (mc.isExcluded()) {
                        result = true;
                        break;
                    }
                    if (mc.isUserDataNone()) break;
                    ud = mc.getUserData();
                    result = ud != null && (ud.equalsIgnoreCase("CONFIDENTIAL") || ud.equalsIgnoreCase("INTEGRAL"));
                    break;
                }
                case 32770: {
                    result = mc.isUserDataNone();
                    break;
                }
                default: {
                    return null;
                }
            }
            if (result != condition) continue;
            output.put(method, mc);
        }
        if (output.size() == 0) {
            output = null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getMethod : attribute : " + attribute + " value : " + output), (Object[])new Object[0]);
        }
        return output;
    }

    private ActionString getMergedMethod(Map<String, MethodConstraint> outputNormal, Map<String, MethodConstraint> outputOmission, boolean negative) {
        Set<String> set;
        StringBuffer outputSB = new StringBuffer();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getMergedMethod : Normal :" + outputNormal + " Omission : " + outputOmission + " flag : " + negative), (Object[])new Object[0]);
        }
        if (outputNormal != null && outputOmission == null && outputNormal.size() > 0) {
            set = outputNormal.keySet();
            Iterator<String> iterator = set.iterator();
            boolean first = true;
            while (iterator.hasNext()) {
                if (first) {
                    first = false;
                    if (negative) {
                        outputSB.append("!");
                    }
                } else {
                    outputSB.append(",");
                }
                outputSB.append(iterator.next());
            }
        } else if (outputNormal == null && outputOmission != null && outputOmission.size() > 0) {
            set = outputOmission.keySet();
            Iterator<String> iterator = set.iterator();
            boolean first = true;
            while (iterator.hasNext()) {
                if (first) {
                    first = false;
                    if (!negative) {
                        outputSB.append("!");
                    }
                } else {
                    outputSB.append(",");
                }
                outputSB.append(iterator.next());
            }
        } else if (outputNormal != null && outputNormal.size() > 0 && outputOmission != null && outputOmission.size() > 0) {
            set = outputOmission.keySet();
            Iterator<String> iterator = set.iterator();
            boolean found = false;
            while (iterator.hasNext()) {
                String method = iterator.next();
                if (outputNormal.containsKey(method)) continue;
                if (!found) {
                    found = true;
                    if (!negative) {
                        outputSB.append("!");
                    }
                } else {
                    outputSB.append(",");
                }
                outputSB.append(method);
            }
            if (!found) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getMergedMethod : all methods", (Object[])new Object[0]);
                }
                return new ActionString();
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getMergedMethod : no output.", (Object[])new Object[0]);
            }
            return null;
        }
        String output = outputSB.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getMergedMethod : " + output), (Object[])new Object[0]);
        }
        return new ActionString(output);
    }

    private ActionString getUserDataStringFromMethodsMap(String value) {
        if (value == null) {
            return null;
        }
        int attribute = 0;
        boolean negative = false;
        boolean excluded = this.existMethod(this.mapMethodOmission, 2, true);
        Map<String, MethodConstraint> mapMethodOmissionNoExcluded = null;
        Map<String, MethodConstraint> outputNormal = null;
        Map<String, MethodConstraint> outputOmission = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("excluded : " + excluded + "\nexcludedForOmissionList: " + this.excludedForOmissionList + "\nmapMethodOmission: " + this.mapMethodOmission), (Object[])new Object[0]);
        }
        if (excluded) {
            if (this.excludedForOmissionList == null || this.excludedForOmissionList.size() == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getUserDataStringFromMethodsMap (" + value + ") everthing is excluded"), (Object[])new Object[0]);
                }
                return null;
            }
            mapMethodOmissionNoExcluded = this.getMethod(this.mapMethodOmission, this.excludedForOmissionList);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("mapMethodOmissionNoExcluded: " + mapMethodOmissionNoExcluded), (Object[])new Object[0]);
            }
        }
        if (this.mapMethod != null) {
            if (value.equals("REST")) {
                attribute = 32772;
                negative = true;
            } else {
                attribute = 12289;
            }
            outputNormal = this.getMethod(this.mapMethod, attribute, true);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("outputNormal: " + outputNormal), (Object[])new Object[0]);
            }
        }
        if (this.mapMethodOmission != null) {
            boolean noneExist = this.existMethod(this.mapMethodOmission, 16384, true);
            boolean putNormal = false;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("noneExist: " + noneExist), (Object[])new Object[0]);
            }
            if (value.equals("REST")) {
                if (noneExist) {
                    if (this.existMethod(this.mapMethodOmission, 12290, true)) {
                        putNormal = true;
                        outputOmission = mapMethodOmissionNoExcluded != null ? this.getMethod(mapMethodOmissionNoExcluded, 16385, true) : this.getMethod(this.mapMethodOmission, 16385, true);
                    } else {
                        outputOmission = mapMethodOmissionNoExcluded != null ? this.getMethod(mapMethodOmissionNoExcluded, 32770, true) : null;
                    }
                } else {
                    outputOmission = mapMethodOmissionNoExcluded != null ? this.getMethod(mapMethodOmissionNoExcluded, 32772, true) : this.getMethod(this.mapMethodOmission, 32772, true);
                }
                negative = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("outputOmission(REST) : " + outputOmission), (Object[])new Object[0]);
                }
            } else {
                if (mapMethodOmissionNoExcluded == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("set mapMethodOmissionNoExcluded :" + this.mapMethodOmission), (Object[])new Object[0]);
                    }
                    mapMethodOmissionNoExcluded = this.mapMethodOmission;
                }
                if (noneExist) {
                    if (this.existMethod(this.mapMethodOmission, 12290, true)) {
                        putNormal = true;
                        outputOmission = this.getMethod(mapMethodOmissionNoExcluded, 16385, true);
                    } else {
                        outputOmission = null;
                    }
                } else {
                    outputOmission = this.getMethod(mapMethodOmissionNoExcluded, 12289, true);
                }
                negative = false;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("outputOmission(CONF) : " + outputOmission), (Object[])new Object[0]);
                }
            }
            if (putNormal) {
                if (outputNormal != null && outputNormal.size() > 0) {
                    if (outputOmission != null) {
                        outputNormal.putAll(outputOmission);
                    }
                } else {
                    outputNormal = outputOmission;
                }
                outputOmission = null;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("putNormal outputNormal : " + outputNormal), (Object[])new Object[0]);
                }
            }
        }
        if (outputNormal != null && outputNormal.size() > 0 || outputOmission != null && outputOmission.size() > 0) {
            ActionString actionString = this.getMergedMethod(outputNormal, outputOmission, negative);
            String output = null;
            if (actionString != null) {
                if (!value.equals("REST")) {
                    output = actionString.getActions() == null ? ":CONFIDENTIAL" : actionString.getActions() + ":CONFIDENTIAL";
                } else {
                    output = actionString.getActions();
                    if (output == null) {
                        return null;
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getUserDataStringFromMethodsMap (" + value + ") : " + output), (Object[])new Object[0]);
            }
            return new ActionString(output);
        }
        if (value.equals("REST")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getUserDataStringFromMethodsMap (" + value + ") return all method."), (Object[])new Object[0]);
            }
            return new ActionString(":NONE");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getUserDataStringFromMethodsMap (" + value + ") No match."), (Object[])new Object[0]);
        }
        return null;
    }

    private Map<String, MethodConstraint> getMethod(Map<String, MethodConstraint> allMap, List<String> methods) {
        HashMap<String, MethodConstraint> output = null;
        if (methods != null && methods.size() > 0 && allMap != null) {
            output = new HashMap<String, MethodConstraint>();
            for (String method : methods) {
                MethodConstraint mc = allMap.get(method);
                if (mc == null) continue;
                output.put(method, mc);
            }
            if (output.size() == 0) {
                output = null;
            }
        }
        return output;
    }

    protected ActionString getUserDataStringFromAllMap(Map<String, MethodConstraint> allMap, String value) {
        if (value == null || allMap == null) {
            return null;
        }
        boolean isRest = "REST".equals(value);
        String output = null;
        boolean done = false;
        if (isRest && this.getMethod(allMap, 2, true) != null) {
            return null;
        }
        Map<String, MethodConstraint> methodMap = this.getMethod(allMap, 2, false);
        if (methodMap != null) {
            for (Map.Entry<String, MethodConstraint> e : methodMap.entrySet()) {
                MethodConstraint mc = e.getValue();
                String userDataConstraint = mc.getUserData();
                if (userDataConstraint != null) {
                    if (!userDataConstraint.equals("CONFIDENTIAL") && !userDataConstraint.equals("INTEGRAL")) continue;
                    if ("CONFIDENTIAL_OR_INTEGRAL".equalsIgnoreCase(value)) {
                        output = ":CONFIDENTIAL";
                        done = true;
                        continue;
                    }
                    if (userDataConstraint.equalsIgnoreCase(value)) {
                        output = ":" + value;
                        done = true;
                        continue;
                    }
                    if (!isRest) continue;
                    return null;
                }
                if (isRest) {
                    done = true;
                    continue;
                }
                return null;
            }
            if (!done) {
                return null;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getUserDataStringFromAllMap(HashMap output: " + output), (Object[])new Object[0]);
            }
            return new ActionString(output);
        }
        return null;
    }

    private Map<String, List<String>> getRoleToMethodMap(Map<String, MethodConstraint> input) {
        if (input == null || input.size() == 0) {
            return null;
        }
        HashMap<String, List<String>> output = new HashMap<String, List<String>>();
        String method = null;
        for (Map.Entry<String, MethodConstraint> e : input.entrySet()) {
            method = e.getKey();
            MethodConstraint mc = e.getValue();
            List<String> roleList = mc.getRoleList();
            ArrayList<String> methodList = null;
            for (String role : roleList) {
                methodList = (ArrayList<String>)output.get(role);
                if (methodList == null) {
                    methodList = new ArrayList<String>();
                    output.put(role, methodList);
                }
                methodList.add(method);
            }
        }
        if (output.size() == 0) {
            output = null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getRoleToMethodMap : " + output), (Object[])new Object[0]);
        }
        return output;
    }

    private Map<String, String> getRoleMapFromAllMap() {
        if (this.mapAllMethods != null) {
            Set<String> set;
            Iterator<String> iterator;
            Map<String, MethodConstraint> methodMap = this.getMethod(this.mapAllMethods, 4, true);
            HashMap<String, String> output = new HashMap<String, String>();
            if (methodMap != null && (iterator = (set = methodMap.keySet()).iterator()).hasNext()) {
                MethodConstraint mc = methodMap.get(iterator.next());
                List<String> roleList = mc.getRoleList();
                for (String role : roleList) {
                    output.put(role, null);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("all methods - role : " + output), (Object[])new Object[0]);
                }
                return output;
            }
        }
        return null;
    }

    private Map<String, String> mergeRTM(Map<String, List<String>> RTMNormal, Map<String, List<String>> RTMOmission) {
        boolean isOmission;
        boolean isNormal = RTMNormal != null && RTMNormal.size() > 0;
        boolean bl = isOmission = RTMOmission != null && RTMOmission.size() > 0;
        if (isNormal && !isOmission) {
            return this.convertRTM(RTMNormal, false);
        }
        if (!isNormal && isOmission) {
            return this.convertRTM(RTMOmission, true);
        }
        if (isNormal && isOmission) {
            return this.convertRTM(RTMNormal, RTMOmission);
        }
        return null;
    }

    private String convertMethod(List<String> methodList, boolean negative) {
        boolean first = true;
        StringBuffer methodSB = new StringBuffer();
        for (String method : methodList) {
            if (first) {
                first = false;
                if (negative) {
                    methodSB.append("!");
                }
            } else {
                methodSB.append(",");
            }
            methodSB.append(method);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("convertMethod : " + methodSB.toString()), (Object[])new Object[0]);
        }
        return methodSB.toString();
    }

    private Map<String, String> convertRTM(Map<String, List<String>> input, boolean negative) {
        HashMap<String, String> output = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> e : input.entrySet()) {
            String role = e.getKey();
            String methodString = this.convertMethod(e.getValue(), negative);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("role: " + role + " method: " + methodString), (Object[])new Object[0]);
            }
            output.put(role, methodString);
        }
        if (output.size() == 0) {
            output = null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("convertRTM(Map, boolean) : " + output), (Object[])new Object[0]);
        }
        return output;
    }

    private Map<String, String> convertRTM(Map<String, List<String>> RTMNormal, Map<String, List<String>> RTMOmission) {
        List<String> methodList;
        List<String> methodListOmission;
        String role;
        HashMap<String, String> output = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> e : RTMOmission.entrySet()) {
            role = e.getKey();
            methodListOmission = e.getValue();
            if (this.listEquals(methodListOmission, methodList = RTMNormal.get(role))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("role: " + role + " allmethods"), (Object[])new Object[0]);
                }
                output.put(role, null);
                continue;
            }
            List<String> methodListMergedOmission = this.mergeMethodList(methodListOmission, methodList);
            String methodString = this.convertMethod(methodListMergedOmission, true);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("role: " + role + " method: " + methodString), (Object[])new Object[0]);
            }
            output.put(role, methodString);
        }
        for (Map.Entry<String, List<String>> e : RTMNormal.entrySet()) {
            role = e.getKey();
            methodListOmission = RTMOmission.get(role);
            if (methodListOmission != null) continue;
            methodList = e.getValue();
            String methodString = this.convertMethod(methodList, false);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("role: " + role + " method: " + methodString), (Object[])new Object[0]);
            }
            output.put(role, methodString);
        }
        if (output.size() == 0) {
            output = null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("convertRTM(Map, Map) : " + output), (Object[])new Object[0]);
        }
        return output;
    }

    private List<String> mergeMethodList(List<String> methodListOmission, List<String> methodList) {
        ArrayList<String> output = new ArrayList<String>();
        for (int i = 0; i < methodListOmission.size(); ++i) {
            String method = methodListOmission.get(i);
            if (methodList != null && methodList.contains(method)) continue;
            output.add(method);
        }
        if (output.size() == 0) {
            output = null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("mergeMethodList : " + output), (Object[])new Object[0]);
        }
        return output;
    }

    private boolean listEquals(List list1, List list2) {
        if (list1 != null && list2 != null) {
            return new HashSet(list1).equals(new HashSet(list2));
        }
        return list1 == null && list2 == null;
    }

    private Map<String, MethodConstraint> getMethodSet(int table, int attribute) {
        Map<String, MethodConstraint> map = null;
        switch (table) {
            case 1: {
                map = this.mapMethod;
                break;
            }
            case 2: {
                map = this.mapMethodOmission;
                break;
            }
            case 3: {
                map = this.mapAllMethods;
                break;
            }
        }
        return this.getMethod(map, attribute, true);
    }

    public List<String> getExcludedSet(int table) {
        Map<String, MethodConstraint> mMap;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Getting excluded methods", (Object[])new Object[0]);
        }
        if ((mMap = this.getMethodSet(table, 2)) != null) {
            return new ArrayList<String>(mMap.keySet());
        }
        return null;
    }

    public List<String> getUncheckedSet(int table) {
        Map<String, MethodConstraint> mMap;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Getting unchecked methods", (Object[])new Object[0]);
        }
        if ((mMap = this.getMethodSet(table, 1)) != null) {
            return new ArrayList<String>(mMap.keySet());
        }
        return null;
    }

    public Map<String, MethodConstraint> getRoleMap(int table) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Getting role methods map", (Object[])new Object[0]);
        }
        return this.getMethodSet(table, 16);
    }

    public Map<String, MethodConstraint> getUserDataMap(int table) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Getting user data map of which attribute is either confidential or integral", (Object[])new Object[0]);
        }
        return this.getMethodSet(table, 12290);
    }

    public Map<String, MethodConstraint> getUserDataMapNone(int table) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Getting role methods map of which attribute is none", (Object[])new Object[0]);
        }
        return this.getMethodSet(table, 32770);
    }
}

