/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.mp.jwt.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.mp.jwt.MpConfigProxyService;
import com.ibm.ws.webcontainer.srt.SRTServletRequest;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.webcontainer.webapp.IWebAppDispatcherContext;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.servlet.http.HttpServletRequest;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class MpConfigUtil {
    private static TraceComponent tc = Tr.register(MpConfigUtil.class, (String)"MPJWT", (String)"com.ibm.ws.security.mp.jwt.resources.MicroProfileJwtMessages");
    private final AtomicServiceReference<MpConfigProxyService> mpConfigProxyServiceRef;
    static final long serialVersionUID = -4587617601914216267L;

    public MpConfigUtil(AtomicServiceReference<MpConfigProxyService> mpConfigProxyServiceRef) {
        this.mpConfigProxyServiceRef = mpConfigProxyServiceRef;
    }

    public Map<String, String> getMpConfig(HttpServletRequest req) {
        HashMap<String, String> map = new HashMap<String, String>();
        MpConfigProxyService service = (MpConfigProxyService)this.mpConfigProxyServiceRef.getService();
        if (service != null) {
            return this.getMpConfigMap(service, this.getApplicationClassloader(req), map);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"mpJwt-1.1 feature is not enabled.", (Object[])new Object[0]);
        }
        return map;
    }

    protected ClassLoader getApplicationClassloader(HttpServletRequest req) {
        SRTServletRequest servletRequest;
        IWebAppDispatcherContext webAppDispatchContext;
        WebApp webApp;
        ClassLoader cl = null;
        if (req instanceof SRTServletRequest && (webApp = (webAppDispatchContext = (servletRequest = (SRTServletRequest)req).getWebAppDispatcherContext()).getWebApp()) != null) {
            cl = webApp.getClassLoader();
        }
        return cl;
    }

    protected Map<String, String> getMpConfigMap(MpConfigProxyService service, ClassLoader cl, Map<String, String> map) {
        Arrays.asList("mp.jwt.verify.issuer", "mp.jwt.verify.publickey", "mp.jwt.verify.publickey.location").forEach(s -> this.getMpConfig(service, cl, (String)s, map));
        return map;
    }

    @FFDCIgnore(value={NoSuchElementException.class})
    protected Map<String, String> getMpConfig(MpConfigProxyService service, ClassLoader cl, String propertyName, Map<String, String> map) {
        block5: {
            try {
                String value = service.getConfigValue(cl, propertyName, String.class).trim();
                if (!value.isEmpty()) {
                    map.put(propertyName, value);
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(propertyName + " is empty. Ignore it."), (Object[])new Object[0]);
                }
            }
            catch (NoSuchElementException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)(propertyName + " is not in mpConfig."), (Object[])new Object[0]);
            }
        }
        return map;
    }
}

