/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.helpers;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.cxf.common.util.SystemPropertyAction;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class JavaUtils {
    static final char KEYWORD_PREFIX = '_';
    private static final Set<String> KEYWORDS;
    private static boolean isJava11Compatible;
    private static boolean isJava9Compatible;
    private static boolean isJava8Before161;
    static final long serialVersionUID = 5564940173910393061L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @FFDCIgnore(value={NumberFormatException.class})
    private static boolean determineIsJava8Before161(String version) {
        try {
            return version != null && version.startsWith("1.8.0_") && Integer.parseInt(version.substring(6)) < 161;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private JavaUtils() {
    }

    public static boolean isJavaKeyword(String keyword) {
        return KEYWORDS.contains(keyword);
    }

    public static String makeNonJavaKeyword(String keyword) {
        return '_' + keyword;
    }

    public static boolean isJava9Compatible() {
        return isJava9Compatible;
    }

    public static boolean isJava11Compatible() {
        return isJava11Compatible;
    }

    private static void setJava9Compatible(boolean java9Compatible) {
        isJava9Compatible = java9Compatible;
    }

    private static void setJava11Compatible(boolean java11Compatible) {
        isJava11Compatible = java11Compatible;
    }

    public static boolean isJava8Before161() {
        return isJava8Before161;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.apache.cxf.helpers.JavaUtils", JavaUtils.class, null, null);
        KEYWORDS = new HashSet<String>(Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"));
        String version = SystemPropertyAction.getProperty("java.version");
        isJava8Before161 = JavaUtils.determineIsJava8Before161(version);
        if (version.indexOf(46) > 0) {
            version = version.substring(0, version.indexOf(46));
        }
        if (version.indexOf("-") > 0) {
            version = version.substring(0, version.indexOf("-"));
        }
        JavaUtils.setJava9Compatible(Integer.valueOf(version) >= 9);
        JavaUtils.setJava11Compatible(Integer.valueOf(version) >= 11);
    }
}

