/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.wsdl11;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.ServiceImpl;
import org.apache.cxf.service.factory.AbstractServiceFactoryBean;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.cxf.wsdl11.PartialWSDLProcessor;
import org.apache.cxf.wsdl11.WSDLServiceBuilder;
import org.apache.ws.commons.schema.XmlSchemaException;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class WSDLServiceFactory
extends AbstractServiceFactoryBean {
    private static final Logger LOG = LogUtils.getL7dLogger(WSDLServiceFactory.class);
    private URL wsdlUrl;
    private QName serviceName;
    private QName endpointName;
    private Definition definition;
    private boolean allowRefs;
    static final long serialVersionUID = 1813037739130782402L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSDLServiceFactory(Bus b, Definition d) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceFactory", "<init>", new Object[]{b, d});
        }
        this.setBus(b);
        this.definition = d;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceFactory", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSDLServiceFactory(Bus b, Definition d, QName sn) {
        this(b, d);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceFactory", "<init>", new Object[]{b, d, sn});
        }
        this.serviceName = sn;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceFactory", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSDLServiceFactory(Bus b, URL url) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceFactory", "<init>", new Object[]{b, url});
        }
        this.setBus(b);
        this.wsdlUrl = url;
        try {
            this.definition = ((WSDLManager)this.getBus().getExtension(WSDLManager.class)).getDefinition(this.wsdlUrl);
        }
        catch (WSDLException ex) {
            throw new ServiceConstructionException(new Message("SERVICE_CREATION_MSG", LOG, new Object[0]), ex);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceFactory", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSDLServiceFactory(Bus b, String url) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceFactory", "<init>", new Object[]{b, url});
        }
        this.setBus(b);
        try {
            this.definition = ((WSDLManager)this.getBus().getExtension(WSDLManager.class)).getDefinition(url);
        }
        catch (WSDLException ex) {
            throw new ServiceConstructionException(new Message("SERVICE_CREATION_MSG", LOG, new Object[0]), ex);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceFactory", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSDLServiceFactory(Bus b, URL url, QName sn) {
        this(b, url);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceFactory", "<init>", new Object[]{b, url, sn});
        }
        this.serviceName = sn;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceFactory", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSDLServiceFactory(Bus b, String url, QName sn) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceFactory", "<init>", new Object[]{b, url, sn});
        }
        this.setBus(b);
        try {
            this.definition = ((WSDLManager)this.getBus().getExtension(WSDLManager.class)).getDefinition(url);
        }
        catch (WSDLException ex) {
            throw new ServiceConstructionException(new Message("SERVICE_CREATION_MSG", LOG, new Object[0]), ex);
        }
        this.serviceName = sn;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceFactory", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setAllowElementRefs(boolean b) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceFactory", "setAllowElementRefs", new Object[]{b});
        }
        this.allowRefs = b;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceFactory", "setAllowElementRefs");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setEndpointName(QName qn) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceFactory", "setEndpointName", new Object[]{qn});
        }
        this.endpointName = qn;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceFactory", "setEndpointName");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Definition getDefinition() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceFactory", "getDefinition", new Object[0]);
        }
        Definition definition = this.definition;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            definition = definition;
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceFactory", "getDefinition", definition);
        }
        return definition;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Service create() {
        List<ServiceInfo> services;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLServiceFactory", "create", new Object[0]);
        }
        if (this.serviceName == null) {
            try {
                WSDLServiceBuilder builder = new WSDLServiceBuilder(this.getBus());
                builder.setAllowElementRefs(this.allowRefs);
                services = builder.buildServices(this.definition);
            }
            catch (XmlSchemaException ex) {
                throw new ServiceConstructionException(new Message("SERVICE_CREATION_MSG", LOG, new Object[0]), ex);
            }
            if (services.size() == 0) {
                throw new ServiceConstructionException(new Message("NO_SERVICE_EXC", LOG, new Object[0]));
            }
            this.serviceName = services.get(0).getName();
            Iterator<ServiceInfo> it = services.iterator();
            while (it.hasNext()) {
                if (it.next().getName().equals(this.serviceName)) continue;
                it.remove();
            }
        } else {
            javax.wsdl.Service wsdlService = this.definition.getService(this.serviceName);
            if (wsdlService == null) {
                if (!PartialWSDLProcessor.isServiceExisted(this.definition, this.serviceName) && !PartialWSDLProcessor.isBindingExisted(this.definition, this.serviceName) && PartialWSDLProcessor.isPortTypeExisted(this.definition, this.serviceName)) {
                    try {
                        Map portTypes = CastUtils.cast((Map)this.definition.getPortTypes());
                        String existPortName = null;
                        PortType portType = null;
                        for (QName existPortQName : portTypes.keySet()) {
                            existPortName = existPortQName.getLocalPart();
                            if (!this.serviceName.getLocalPart().contains(existPortName)) continue;
                            portType = (PortType)portTypes.get(existPortQName);
                            break;
                        }
                        WSDLFactory factory = WSDLFactory.newInstance();
                        ExtensionRegistry extReg = factory.newPopulatedExtensionRegistry();
                        Binding binding = PartialWSDLProcessor.doAppendBinding(this.definition, existPortName, portType, extReg);
                        this.definition.addBinding(binding);
                        wsdlService = PartialWSDLProcessor.doAppendService(this.definition, existPortName, extReg, binding);
                        this.definition.addService(wsdlService);
                    }
                    catch (Exception e) {
                        throw new ServiceConstructionException(new Message("NO_SUCH_SERVICE_EXC", LOG, new Object[]{this.serviceName}));
                    }
                } else {
                    throw new ServiceConstructionException(new Message("NO_SUCH_SERVICE_EXC", LOG, new Object[]{this.serviceName}));
                }
            }
            try {
                services = new WSDLServiceBuilder(this.getBus()).buildServices(this.definition, wsdlService, this.endpointName);
                if (services.size() == 0) {
                    throw new ServiceConstructionException(new Message("NO_SUCH_ENDPOINT_EXC", LOG, new Object[]{this.endpointName}));
                }
            }
            catch (XmlSchemaException ex) {
                throw new ServiceConstructionException(new Message("SERVICE_CREATION_MSG", LOG, new Object[0]), ex);
            }
        }
        ServiceImpl service = new ServiceImpl(services);
        this.setService((Service)service);
        ServiceImpl serviceImpl = service;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            serviceImpl = serviceImpl;
            LOG.exiting("org.apache.cxf.wsdl11.WSDLServiceFactory", "create", serviceImpl);
        }
        return serviceImpl;
    }
}

