/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal;

import com.ibm.websphere.config.ConfigParserException;
import com.ibm.websphere.config.ConfigUpdateException;
import com.ibm.websphere.config.ConfigValidationException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.config.xml.internal.BaseConfiguration;
import com.ibm.ws.config.xml.internal.ConfigMergeException;
import com.ibm.ws.config.xml.internal.ConfigVariableRegistry;
import com.ibm.ws.config.xml.internal.ErrorHandler;
import com.ibm.ws.config.xml.internal.ServerXMLConfiguration;
import com.ibm.ws.config.xml.internal.SimpleElement;
import com.ibm.ws.config.xml.internal.XMLConfigParser;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class DefaultConfiguration {
    private final Map<Bundle, BaseConfiguration> defaultConfigurationMap = new ConcurrentHashMap<Bundle, BaseConfiguration>();
    private final Map<String, BaseConfiguration> runtimeDefaultConfigurationMap = new ConcurrentHashMap<String, BaseConfiguration>();
    private final XMLConfigParser parser;
    static final TraceComponent tc = Tr.register(DefaultConfiguration.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    static final long serialVersionUID = 2945655170810837866L;

    public DefaultConfiguration(XMLConfigParser xmlParser) {
        this.parser = xmlParser;
    }

    /*
     * WARNING - void declaration
     */
    public BaseConfiguration load(Bundle bundle, ServerXMLConfiguration serverXMLConfig, ConfigVariableRegistry variableRegistry) throws ConfigValidationException, ConfigUpdateException {
        BaseConfiguration bundleDefaultConfiguration = null;
        Collection<Object> defaultConfigFiles = Collections.emptyList();
        try {
            defaultConfigFiles = this.getDefaultConfigurationFiles(bundle);
        }
        catch (BundleException bundleException) {
            void e1;
            FFDCFilter.processException((Throwable)bundleException, (String)"com.ibm.ws.config.xml.internal.DefaultConfiguration", (String)"78", (Object)this, (Object[])new Object[]{bundle, serverXMLConfig, variableRegistry});
            throw new ConfigUpdateException((Exception)e1);
        }
        if (!defaultConfigFiles.isEmpty()) {
            bundleDefaultConfiguration = new BaseConfiguration();
            for (DefaultConfigFile defaultConfigFile : defaultConfigFiles) {
                try {
                    BaseConfiguration configuration = this.parser.parseDefaultConfiguration(defaultConfigFile);
                    bundleDefaultConfiguration.append(configuration);
                }
                catch (ConfigParserException configuration) {
                    void e;
                    FFDCFilter.processException((Throwable)configuration, (String)"com.ibm.ws.config.xml.internal.DefaultConfiguration", (String)"87", (Object)this, (Object[])new Object[]{bundle, serverXMLConfig, variableRegistry});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Exception while loading default configuration.  Message=" + e.getMessage()), (Object[])new Object[0]);
                    }
                    this.parser.handleParseError((ConfigParserException)e, bundle);
                    if (!ErrorHandler.INSTANCE.fail()) continue;
                    throw new ConfigUpdateException((Exception)e);
                }
            }
            BaseConfiguration defaultConfiguration = serverXMLConfig.getDefaultConfiguration();
            defaultConfiguration.remove(this.defaultConfigurationMap.get(bundle));
            defaultConfiguration.add(bundleDefaultConfiguration);
            this.defaultConfigurationMap.put(bundle, bundleDefaultConfiguration);
            variableRegistry.setDefaultVariables(defaultConfiguration.getVariables());
        }
        return bundleDefaultConfiguration;
    }

    /*
     * WARNING - void declaration
     */
    public BaseConfiguration add(InputStream defaultConfig, ServerXMLConfiguration serverXMLConfig, ConfigVariableRegistry variableRegistry) throws ConfigValidationException, ConfigUpdateException {
        BaseConfiguration configuration = new BaseConfiguration();
        try {
            if (!this.parser.parseServerConfiguration(defaultConfig, "runtimeDefaultConfig", configuration, XMLConfigParser.MergeBehavior.MERGE)) {
                configuration = null;
            } else {
                for (String name : configuration.getConfigurationNames()) {
                    BaseConfiguration newConfig = this.runtimeDefaultConfigurationMap.get(name);
                    if (newConfig == null) {
                        newConfig = new BaseConfiguration();
                        this.runtimeDefaultConfigurationMap.put(name, newConfig);
                    }
                    newConfig.getConfigurationList(name).add(configuration.getConfigurationList(name));
                }
                BaseConfiguration defaultConfiguration = serverXMLConfig.getDefaultConfiguration();
                defaultConfiguration.add(configuration);
                variableRegistry.setDefaultVariables(defaultConfiguration.getVariables());
            }
            return configuration;
        }
        catch (ConfigParserException defaultConfiguration) {
            void e;
            FFDCFilter.processException((Throwable)defaultConfiguration, (String)"com.ibm.ws.config.xml.internal.DefaultConfiguration", (String)"139", (Object)this, (Object[])new Object[]{defaultConfig, serverXMLConfig, variableRegistry});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception while loading default configuration.  Message=" + e.getMessage()), (Object[])new Object[0]);
            }
            this.parser.handleParseError((ConfigParserException)e, null);
            if (ErrorHandler.INSTANCE.fail()) {
                throw new ConfigUpdateException((Exception)e);
            }
            return configuration;
        }
    }

    public BaseConfiguration add(String pid, Dictionary<String, String> props, ServerXMLConfiguration serverXMLConfig, ConfigVariableRegistry variableRegistry) throws ConfigMergeException {
        SimpleElement element = new SimpleElement(pid);
        element.setDocumentLocation("runtimeDefaultConfiguration");
        Enumeration<String> keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            element.addAttribute(key, props.get(key));
            if (!"id".equals(key)) continue;
            element.setId(props.get(key));
        }
        BaseConfiguration newConfig = this.runtimeDefaultConfigurationMap.get(pid);
        if (newConfig == null) {
            newConfig = new BaseConfiguration();
            this.runtimeDefaultConfigurationMap.put(pid, newConfig);
        }
        newConfig.addConfigElement(element);
        BaseConfiguration defaultConfiguration = serverXMLConfig.getDefaultConfiguration();
        defaultConfiguration.add(newConfig);
        variableRegistry.setDefaultVariables(defaultConfiguration.getVariables());
        return newConfig;
    }

    public BaseConfiguration getRuntimeDefaultConfiguration(String pid) {
        return this.runtimeDefaultConfigurationMap.get(pid);
    }

    public BaseConfiguration remove(Bundle bundle) {
        return this.defaultConfigurationMap.remove(bundle);
    }

    private Collection<DefaultConfigFile> getDefaultConfigurationFiles(Bundle bundle) throws BundleException {
        ManifestElement[] elements;
        Dictionary headers = bundle.getHeaders("");
        if (headers == null) {
            return Collections.emptySet();
        }
        String defaultConfigHeader = (String)headers.get("IBM-Default-Config");
        if (defaultConfigHeader == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<DefaultConfigFile> configurationFiles = new LinkedHashSet<DefaultConfigFile>();
        for (ManifestElement element : elements = ManifestElement.parseHeader((String)"IBM-Default-Config", (String)defaultConfigHeader)) {
            String requireDoesNotExistStr;
            boolean requireExisting = false;
            boolean requireNotExisting = false;
            String requireExistingStr = element.getAttribute("requireExisting");
            if (requireExistingStr != null) {
                requireExisting = Boolean.valueOf(requireExistingStr);
            }
            if ((requireDoesNotExistStr = element.getAttribute("addIfMissing")) != null) {
                requireNotExisting = Boolean.valueOf(requireDoesNotExistStr);
            }
            if (requireExisting && requireNotExisting) continue;
            String fileFilter = element.getValue();
            if (fileFilter.contains("*")) {
                String filePattern;
                String path;
                int pos = fileFilter.lastIndexOf(47);
                if (pos < 0) {
                    path = "/";
                    filePattern = fileFilter;
                } else {
                    path = fileFilter.substring(0, pos + 1);
                    filePattern = fileFilter.substring(pos + 1);
                }
                Enumeration entries = bundle.findEntries(path, filePattern, false);
                if (entries == null) continue;
                while (entries.hasMoreElements()) {
                    DefaultConfigFile file = new DefaultConfigFile((URL)entries.nextElement(), requireExisting, requireNotExisting);
                    configurationFiles.add(file);
                }
                continue;
            }
            DefaultConfigFile file = new DefaultConfigFile(bundle.getEntry(fileFilter), requireExisting, requireNotExisting);
            if (file.fileURL == null) {
                throw new NullPointerException("Bundle: " + bundle + " specifies default config at " + fileFilter + " which is missing");
            }
            configurationFiles.add(file);
        }
        return configurationFiles;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected class DefaultConfigFile {
        final URL fileURL;
        final XMLConfigParser.MergeBehavior behavior;
        static final long serialVersionUID = -4984284391663671838L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public DefaultConfigFile(URL url, boolean requireExisting, boolean requireNotExisting) {
            this.fileURL = url;
            this.behavior = requireExisting ? XMLConfigParser.MergeBehavior.MERGE_WHEN_EXISTS : (requireNotExisting ? XMLConfigParser.MergeBehavior.MERGE_WHEN_MISSING : XMLConfigParser.MergeBehavior.MERGE);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.config.xml.internal.DefaultConfiguration$DefaultConfigFile", DefaultConfigFile.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
        }
    }
}

