/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.ws.impl;

import com.ibm.jbatch.container.exception.BatchIllegalJobStatusTransitionException;
import com.ibm.jbatch.container.exception.ExecutionAssignedToServerException;
import com.ibm.jbatch.container.persistence.jpa.JobInstanceEntity;
import com.ibm.jbatch.container.services.IJPAQueryHelper;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.ws.InstanceState;
import com.ibm.jbatch.container.ws.RemotablePartitionState;
import com.ibm.jbatch.container.ws.WSBatchAuthService;
import com.ibm.jbatch.container.ws.WSJobExecution;
import com.ibm.jbatch.container.ws.WSJobInstance;
import com.ibm.jbatch.container.ws.WSJobRepository;
import com.ibm.jbatch.container.ws.WSRemotablePartitionExecution;
import com.ibm.jbatch.container.ws.WSStepThreadExecutionAggregate;
import com.ibm.jbatch.spi.BatchSecurityHelper;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import javax.batch.operations.JobSecurityException;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.operations.NoSuchJobInstanceException;
import javax.batch.runtime.BatchStatus;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class WSJobRepositoryImpl
implements WSJobRepository {
    private static final String CLASSNAME = WSJobRepositoryImpl.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    private static final TraceComponent tc = Tr.register(WSJobRepositoryImpl.class, null, null);
    private IPersistenceManagerService persistenceManagerService;
    private WSBatchAuthService authService;
    private BatchSecurityHelper batchSecurityHelper = null;
    static final long serialVersionUID = 2806547155585331553L;

    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    protected void setIPersistenceManagerService(IPersistenceManagerService pms) {
        this.persistenceManagerService = pms;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setWSBatchAuthService(WSBatchAuthService bas) {
        this.authService = bas;
    }

    protected void unsetWSBatchAuthService(WSBatchAuthService bas) {
        if (this.authService == bas) {
            this.authService = null;
        }
    }

    protected void unsetIPersistenceManagerService(IPersistenceManagerService ref) {
        if (this.persistenceManagerService == ref) {
            this.persistenceManagerService = null;
        }
    }

    @Reference
    protected void setBatchSecurityHelper(BatchSecurityHelper batchSecurityHelper) {
        this.batchSecurityHelper = batchSecurityHelper;
    }

    protected void unsetBatchSecurityHelper(BatchSecurityHelper batchSecurityHelper) {
        if (this.batchSecurityHelper == batchSecurityHelper) {
            this.batchSecurityHelper = null;
        }
    }

    @Override
    public WSJobInstance getJobInstanceFromExecution(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        long instanceId = this.persistenceManagerService.getJobInstanceIdFromExecutionId(this.authorizedExecutionRead(executionId));
        return this.persistenceManagerService.getJobInstance(instanceId);
    }

    @Override
    public WSJobExecution getJobExecution(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        return this.persistenceManagerService.getJobExecution(this.authorizedExecutionRead(executionId));
    }

    @Override
    public WSJobExecution createJobExecution(long jobInstanceId, Properties jobParameters) {
        return this.persistenceManagerService.createJobExecution(jobInstanceId, jobParameters, new Date());
    }

    public List<WSStepThreadExecutionAggregate> getStepExecutionsFromJobExecution(long jobExecutionId) throws NoSuchJobExecutionException, JobSecurityException {
        return this.persistenceManagerService.getStepExecutionAggregatesFromJobExecutionId(this.authorizedExecutionRead(jobExecutionId));
    }

    @Override
    public List<WSJobInstance> getJobInstances(IJPAQueryHelper queryHelper, int page, int pageSize) throws NoSuchJobExecutionException, JobSecurityException {
        if (this.authService == null || this.authService.isAdmin() || this.authService.isMonitor()) {
            return new ArrayList<WSJobInstance>(this.persistenceManagerService.getJobInstances(queryHelper, page, pageSize));
        }
        if (this.authService.isGroupAdmin() || this.authService.isGroupMonitor()) {
            queryHelper.setGroups(this.authService.getGroupsForSubject());
            queryHelper.setQueryIssuer(this.authService.getRunAsUser());
            return new ArrayList<WSJobInstance>(this.persistenceManagerService.getJobInstances(queryHelper, page, pageSize));
        }
        if (this.authService.isSubmitter()) {
            queryHelper.setQueryIssuer(this.authService.getRunAsUser());
            return new ArrayList<WSJobInstance>(this.persistenceManagerService.getJobInstances(queryHelper, page, pageSize));
        }
        throw new JobSecurityException("The current user " + this.batchSecurityHelper.getRunAsUser() + " is not authorized to perform any batch operations.");
    }

    @Override
    public WSJobInstance getJobInstance(long instanceId) throws NoSuchJobExecutionException, JobSecurityException {
        return this.persistenceManagerService.getJobInstance(this.authorizedInstanceRead(instanceId));
    }

    @Override
    public List<WSJobExecution> getJobExecutionsFromInstance(long instanceId) throws NoSuchJobInstanceException, JobSecurityException {
        return new ArrayList<WSJobExecution>(this.persistenceManagerService.getJobExecutionsFromJobInstanceId(this.authorizedInstanceRead(instanceId)));
    }

    @Override
    public String getBatchAppNameFromExecution(long executionId) throws NoSuchJobInstanceException, JobSecurityException {
        return this.persistenceManagerService.getJobInstanceAppNameFromExecutionId(this.authorizedExecutionRead(executionId));
    }

    @Override
    public String getBatchAppNameFromInstance(long instanceId) throws NoSuchJobInstanceException, JobSecurityException {
        return this.persistenceManagerService.getJobInstanceAppName(this.authorizedInstanceRead(instanceId));
    }

    @Override
    public WSJobExecution getMostRecentJobExecutionFromInstance(long instanceId) throws NoSuchJobInstanceException, JobSecurityException {
        return this.persistenceManagerService.getJobExecutionMostRecent(this.authorizedInstanceRead(instanceId));
    }

    private long authorizedInstanceRead(long instanceId) throws NoSuchJobInstanceException, JobSecurityException {
        if (this.authService != null) {
            this.authService.authorizedInstanceRead(instanceId);
        }
        return instanceId;
    }

    private long authorizedExecutionRead(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        if (this.authService != null) {
            this.authService.authorizedExecutionRead(executionId);
        }
        return executionId;
    }

    @Override
    public Set<String> getJobNames() {
        if (this.authService == null || this.authService.isAdmin() || this.authService.isMonitor()) {
            return this.persistenceManagerService.getJobNamesSet();
        }
        if (this.authService.isSubmitter()) {
            return this.persistenceManagerService.getJobNamesSet(this.authService.getRunAsUser());
        }
        throw new JobSecurityException("The current user " + this.authService.getRunAsUser() + " is not authorized to perform any batch operations.");
    }

    @Override
    public boolean isJobInstancePurgeable(long jobInstanceId) throws NoSuchJobInstanceException, JobSecurityException {
        if (this.authService != null) {
            this.authService.authorizedInstanceRead(jobInstanceId);
        }
        return this.persistenceManagerService.isJobInstancePurgeable(jobInstanceId);
    }

    @Override
    public WSJobInstance updateJobInstanceState(long instanceId, InstanceState state) {
        return this.persistenceManagerService.updateJobInstanceWithInstanceState(instanceId, state, new Date());
    }

    @Override
    public WSJobInstance updateJobInstanceStateOnRestart(long instanceId) {
        return (WSJobInstance)this.persistenceManagerService.updateJobInstanceOnRestart(instanceId, new Date());
    }

    @Override
    public WSJobInstance updateJobInstanceStateOnConsumed(long instanceId) throws BatchIllegalJobStatusTransitionException {
        return (WSJobInstance)this.persistenceManagerService.updateJobInstanceStateOnConsumed(instanceId);
    }

    @Override
    public WSJobInstance updateJobInstanceStateOnQueued(long instanceId) throws BatchIllegalJobStatusTransitionException {
        return (WSJobInstance)this.persistenceManagerService.updateJobInstanceStateOnQueued(instanceId);
    }

    @Override
    public WSJobInstance updateJobInstanceAndExecutionWithInstanceStateAndBatchStatus(long instanceId, long executionId, InstanceState state, BatchStatus batchStatus) {
        JobInstanceEntity retMe = null;
        retMe = (JobInstanceEntity)this.persistenceManagerService.updateJobInstanceWithInstanceStateAndBatchStatus(instanceId, state, batchStatus, new Date());
        this.persistenceManagerService.updateJobExecutionAndInstanceOnStatusChange(executionId, batchStatus, new Date());
        return retMe;
    }

    @Override
    public List<WSStepThreadExecutionAggregate> getStepExecutionAggregatesFromJobExecution(long jobExecutionId) throws NoSuchJobExecutionException, JobSecurityException {
        if (this.authService != null) {
            this.authService.authorizedExecutionRead(jobExecutionId);
        }
        return this.persistenceManagerService.getStepExecutionAggregatesFromJobExecutionId(jobExecutionId);
    }

    @Override
    public WSStepThreadExecutionAggregate getStepExecutionAggregateFromJobExecution(long jobExecutionId, String stepName) throws NoSuchJobExecutionException, JobSecurityException {
        if (this.authService != null) {
            this.authService.authorizedExecutionRead(jobExecutionId);
        }
        return this.persistenceManagerService.getStepExecutionAggregateFromJobExecutionId(jobExecutionId, stepName);
    }

    @Override
    public WSStepThreadExecutionAggregate getStepExecutionAggregate(long topLevelStepExecutionId) throws IllegalArgumentException, JobSecurityException {
        if (this.authService != null) {
            this.authService.authorizedStepExecutionRead(topLevelStepExecutionId);
        }
        return this.persistenceManagerService.getStepExecutionAggregate(topLevelStepExecutionId);
    }

    @Override
    public WSStepThreadExecutionAggregate getStepExecutionAggregateFromJobExecutionNumberAndStepName(long jobInstanceId, short jobExecNum, String stepName) throws NoSuchJobExecutionException, JobSecurityException {
        if (this.authService != null) {
            this.authService.authorizedInstanceRead(jobInstanceId);
        }
        return this.persistenceManagerService.getStepExecutionAggregateFromJobExecutionNumberAndStepName(jobInstanceId, jobExecNum, stepName);
    }

    @Override
    public WSJobExecution getJobExecutionFromJobExecNum(long jobInstanceId, int jobExecNum) throws NoSuchJobExecutionException, JobSecurityException {
        if (this.authService != null) {
            this.authService.authorizedInstanceRead(jobInstanceId);
        }
        return this.persistenceManagerService.getJobExecutionFromJobExecNum(jobInstanceId, jobExecNum);
    }

    @Override
    public WSJobInstance updateJobInstanceWithInstanceStateAndBatchStatus(long instanceId, InstanceState state, BatchStatus batchStatus) {
        return (WSJobInstance)this.persistenceManagerService.updateJobInstanceWithInstanceStateAndBatchStatus(instanceId, state, batchStatus, new Date());
    }

    @Override
    public WSJobExecution updateJobExecutionAndInstanceOnStatusChange(long jobExecutionId, BatchStatus status, Date date) {
        return (WSJobExecution)this.persistenceManagerService.updateJobExecutionAndInstanceOnStatusChange(jobExecutionId, status, date);
    }

    @Override
    public WSJobExecution updateJobExecutionAndInstanceNotSetToServerYet(long jobExecutionId, Date date) throws ExecutionAssignedToServerException {
        return this.updateJobExecutionAndInstanceOnStopBeforeServerAssigned(jobExecutionId, date);
    }

    @Override
    public WSJobExecution updateJobExecutionAndInstanceOnStopBeforeServerAssigned(long jobExecutionId, Date date) throws ExecutionAssignedToServerException {
        return (WSJobExecution)this.persistenceManagerService.updateJobExecutionAndInstanceOnStopBeforeServerAssigned(jobExecutionId, date);
    }

    @Override
    public WSRemotablePartitionExecution createRemotablePartition(long jobExecutionId, String stepName, int partitionNumber, RemotablePartitionState internalState) {
        return this.persistenceManagerService.createRemotablePartition(jobExecutionId, stepName, partitionNumber, internalState);
    }

    @Override
    public WSRemotablePartitionExecution updateRemotablePartitionInternalState(long jobExecutionId, String stepName, int partitionNumber, RemotablePartitionState internalState) {
        return this.persistenceManagerService.updateRemotablePartitionInternalState(jobExecutionId, stepName, partitionNumber, internalState);
    }

    @Override
    public int getJobExecutionTableVersion() throws Exception {
        return this.persistenceManagerService.getJobExecutionTableVersion();
    }

    @Override
    public int getJobInstanceTableVersion() throws Exception {
        return this.persistenceManagerService.getJobInstanceTableVersion();
    }

    @Override
    public WSJobInstance updateJobInstanceWithGroupNames(long jobInstanceId, Set<String> groupNames) {
        if (this.authService == null) {
            Tr.warning((TraceComponent)tc, (String)"BATCH_SECURITY_NOT_ACTIVE", (Object[])new Object[]{jobInstanceId});
            return this.persistenceManagerService.updateJobInstanceWithGroupNames(jobInstanceId, new HashSet<String>());
        }
        HashSet<String> normalizedNames = new HashSet();
        normalizedNames = this.authService.normalizeGroupNames(groupNames);
        return this.persistenceManagerService.updateJobInstanceWithGroupNames(jobInstanceId, normalizedNames);
    }
}

