/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.impl;

import com.ibm.jbatch.container.artifact.proxy.RetryProcessListenerProxy;
import com.ibm.jbatch.container.artifact.proxy.RetryReadListenerProxy;
import com.ibm.jbatch.container.artifact.proxy.RetryWriteListenerProxy;
import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.execution.impl.RuntimeStepExecution;
import com.ibm.jbatch.container.impl.ExceptionMatcher;
import com.ibm.jbatch.jsl.model.Chunk;
import com.ibm.jbatch.jsl.model.ExceptionClassFilter;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class RetryHandler {
    private static final String className = RetryHandler.class.getName();
    private static Logger logger = Logger.getLogger(RetryHandler.class.getPackage().getName());
    public static final String RETRY_COUNT = "retry-limit";
    public static final String RETRY_INCLUDE_EX = "include class";
    public static final String RETRY_EXCLUDE_EX = "exclude class";
    private static final int RETRY_NONE = 0;
    private static final int RETRY_READ = 1;
    private static final int RETRY_PROCESS = 2;
    private static final int RETRY_WRITE = 3;
    private int retryType;
    List<RetryProcessListenerProxy> _retryProcessListeners;
    List<RetryReadListenerProxy> _retryReadListeners;
    List<RetryWriteListenerProxy> _retryWriteListeners;
    private ExceptionMatcher excMatcher;
    private ExceptionMatcher noRBexcMatcher;
    private String _stepId;
    private Set<String> _retryNoRBIncludeExceptions;
    private Set<String> _retryNoRBExcludeExceptions;
    private Set<String> _retryIncludeExceptions;
    private Set<String> _retryExcludeExceptions;
    private int _retryLimit;
    private long _retryCount;
    private Exception _retryException;
    static final long serialVersionUID = 7036006953267916917L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public RetryHandler(Chunk chunk, RuntimeStepExecution runtimeStepExecution) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.RetryHandler", "<init>", new Object[]{chunk, runtimeStepExecution});
        }
        this.retryType = 0;
        this._retryProcessListeners = null;
        this._retryReadListeners = null;
        this._retryWriteListeners = null;
        this.excMatcher = null;
        this.noRBexcMatcher = null;
        this._stepId = null;
        this._retryNoRBIncludeExceptions = null;
        this._retryNoRBExcludeExceptions = null;
        this._retryIncludeExceptions = null;
        this._retryExcludeExceptions = null;
        this._retryLimit = Integer.MIN_VALUE;
        this._retryCount = 0L;
        this._retryException = null;
        this._stepId = runtimeStepExecution.getStepName();
        this.initialize(chunk);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.RetryHandler", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void addRetryProcessListener(List<RetryProcessListenerProxy> retryProcessListeners) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.RetryHandler", "addRetryProcessListener", new Object[]{retryProcessListeners});
        }
        this._retryProcessListeners = retryProcessListeners;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.RetryHandler", "addRetryProcessListener");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void addRetryReadListener(List<RetryReadListenerProxy> retryReadListeners) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.RetryHandler", "addRetryReadListener", new Object[]{retryReadListeners});
        }
        this._retryReadListeners = retryReadListeners;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.RetryHandler", "addRetryReadListener");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void addRetryWriteListener(List<RetryWriteListenerProxy> retryWriteListeners) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.RetryHandler", "addRetryWriteListener", new Object[]{retryWriteListeners});
        }
        this._retryWriteListeners = retryWriteListeners;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.RetryHandler", "addRetryWriteListener");
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void initialize(Chunk chunk) {
        List<ExceptionClassFilter.Exclude> excludes;
        List<ExceptionClassFilter.Include> includes;
        String mName = "initialize";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "initialize");
        }
        try {
            if (chunk.getRetryLimit() != null) {
                this._retryLimit = Integer.parseInt(chunk.getRetryLimit());
                if (this._retryLimit < 0) {
                    throw new IllegalArgumentException("The retry-limit attribute on a chunk cannot be a negative value");
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            void nfe;
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.jbatch.container.impl.RetryHandler", (String)"136", (Object)this, (Object[])new Object[]{chunk});
            throw new RuntimeException("NumberFormatException reading retry-limit", (Throwable)nfe);
        }
        this._retryIncludeExceptions = new HashSet<String>();
        this._retryExcludeExceptions = new HashSet<String>();
        this._retryNoRBIncludeExceptions = new HashSet<String>();
        this._retryNoRBExcludeExceptions = new HashSet<String>();
        if (chunk.getRetryableExceptionClasses() != null) {
            if (chunk.getRetryableExceptionClasses().getIncludeList() != null) {
                includes = chunk.getRetryableExceptionClasses().getIncludeList();
                for (ExceptionClassFilter.Include include : includes) {
                    this._retryIncludeExceptions.add(include.getClazz().trim());
                    logger.finer("RETRYHANDLE: include: " + include.getClazz().trim());
                }
                if (this._retryIncludeExceptions.size() == 0) {
                    logger.finer("RETRYHANDLE: include element not present");
                }
            }
            if (chunk.getRetryableExceptionClasses().getExcludeList() != null) {
                excludes = chunk.getRetryableExceptionClasses().getExcludeList();
                for (ExceptionClassFilter.Exclude exclude : excludes) {
                    this._retryExcludeExceptions.add(exclude.getClazz().trim());
                    logger.finer("SKIPHANDLE: exclude: " + exclude.getClazz().trim());
                }
                if (this._retryExcludeExceptions.size() == 0) {
                    logger.finer("SKIPHANDLE: exclude element not present");
                }
            }
        }
        if (chunk.getNoRollbackExceptionClasses() != null) {
            if (chunk.getNoRollbackExceptionClasses().getIncludeList() != null) {
                includes = chunk.getNoRollbackExceptionClasses().getIncludeList();
                for (ExceptionClassFilter.Include include : includes) {
                    this._retryNoRBIncludeExceptions.add(include.getClazz().trim());
                    logger.finer("RETRYHANDLE: include: " + include.getClazz().trim());
                }
                if (this._retryNoRBIncludeExceptions.size() == 0) {
                    logger.finer("RETRYHANDLE: include element not present");
                }
            }
            if (chunk.getNoRollbackExceptionClasses().getExcludeList() != null) {
                excludes = chunk.getNoRollbackExceptionClasses().getExcludeList();
                for (ExceptionClassFilter.Exclude exclude : excludes) {
                    this._retryNoRBExcludeExceptions.add(exclude.getClazz().trim());
                    logger.finer("SKIPHANDLE: exclude: " + exclude.getClazz().trim());
                }
                if (this._retryNoRBExcludeExceptions.size() == 0) {
                    logger.finer("SKIPHANDLE: exclude element not present");
                }
            }
        }
        this.excMatcher = new ExceptionMatcher(this._retryIncludeExceptions, this._retryExcludeExceptions);
        this.noRBexcMatcher = new ExceptionMatcher(this._retryNoRBIncludeExceptions, this._retryNoRBExcludeExceptions);
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, className, "initialize", "added include exception " + this._retryIncludeExceptions + "; added exclude exception " + this._retryExcludeExceptions);
            logger.logp(Level.FINE, className, "initialize", "added include no rollback exception " + this._retryNoRBIncludeExceptions + "; added exclude no rollback exception " + this._retryNoRBExcludeExceptions);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "initialize", this.toString());
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isRollbackException(Exception e) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.RetryHandler", "isRollbackException", new Object[]{e});
        }
        boolean bl = !this.noRBexcMatcher.isSkippableOrRetryable(e);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.impl.RetryHandler", "isRollbackException", bl);
        }
        return bl;
    }

    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleExceptionRead(Exception e) {
        String mName = "handleExceptionRead";
        logger.finer("RETRYHANDLE: in retryhandler handle exception on a read:" + e.toString());
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINE, className, "handleExceptionRead", e.getClass().getName() + "; " + this.toString());
        }
        if (!this.isRetryLimitReached() && this.excMatcher.isSkippableOrRetryable(e)) {
            this.retryType = 1;
            this._retryException = e;
            ++this._retryCount;
            this.logRetry(e);
            if (this._retryReadListeners != null) {
                for (RetryReadListenerProxy retryReadListenerProxy : this._retryReadListeners) {
                    retryReadListenerProxy.onRetryReadException(e);
                }
            }
        } else {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINE, className, "handleExceptionRead", "No retry.  Rethrow", e);
            }
            throw new BatchContainerRuntimeException(e);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "handleExceptionRead", e);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleExceptionProcess(Exception e, Object w) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.RetryHandler", "handleExceptionProcess", new Object[]{e, w});
        }
        String mName = "handleExceptionProcess";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINE, className, "handleExceptionProcess", e.getClass().getName() + "; " + this.toString());
        }
        if (!this.isRetryLimitReached() && this.excMatcher.isSkippableOrRetryable(e)) {
            this.retryType = 2;
            this._retryException = e;
            ++this._retryCount;
            this.logRetry(e);
            if (this._retryProcessListeners != null) {
                for (RetryProcessListenerProxy retryProcessListenerProxy : this._retryProcessListeners) {
                    retryProcessListenerProxy.onRetryProcessException(w, e);
                }
            }
        } else {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINE, className, "handleExceptionProcess", "No retry.  Rethrow ", e);
            }
            throw new BatchContainerRuntimeException(e);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.RetryHandler", "handleExceptionProcess");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleExceptionWrite(Exception e, List<Object> w) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.RetryHandler", "handleExceptionWrite", new Object[]{e, w});
        }
        String mName = "handleExceptionWrite";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINE, className, "handleExceptionWrite", e.getClass().getName() + "; " + this.toString());
        }
        if (!this.isRetryLimitReached() && this.excMatcher.isSkippableOrRetryable(e)) {
            this.retryType = 3;
            this._retryException = e;
            ++this._retryCount;
            this.logRetry(e);
            if (this._retryWriteListeners != null) {
                for (RetryWriteListenerProxy retryWriteListenerProxy : this._retryWriteListeners) {
                    retryWriteListenerProxy.onRetryWriteException(w, e);
                }
            }
        } else {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINE, className, "handleExceptionWrite", "No retry.  Rethrow ", e);
            }
            throw new BatchContainerRuntimeException(e);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.RetryHandler", "handleExceptionWrite");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isRetryLimitReached() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.RetryHandler", "isRetryLimitReached", new Object[0]);
        }
        if (this._retryLimit == Integer.MIN_VALUE) {
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.jbatch.container.impl.RetryHandler", "isRetryLimitReached", bl);
            }
            return bl;
        }
        boolean bl = this._retryCount >= (long)this._retryLimit;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.impl.RetryHandler", "isRetryLimitReached", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void logRetry(Exception e) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.RetryHandler", "logRetry", new Object[]{e});
        }
        Object[] details = new Object[]{this._stepId, e.getClass().getName() + ": " + e.getMessage()};
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, className, "logRetry", "Logging details: ", details);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.RetryHandler", "logRetry");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Exception getException() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.RetryHandler", "getException", new Object[0]);
        }
        Exception exception = this._retryException;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            exception = exception;
            logger.exiting("com.ibm.jbatch.container.impl.RetryHandler", "getException", exception);
        }
        return exception;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getRetryCount() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.RetryHandler", "getRetryCount", new Object[0]);
        }
        long l = this._retryCount;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.jbatch.container.impl.RetryHandler", "getRetryCount", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setRetryCount(long retryCount) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.RetryHandler", "setRetryCount", new Object[]{retryCount});
        }
        String mName = "setRetryCount";
        this._retryCount = retryCount;
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, className, "setRetryCount", "setRetryCount: " + this._retryCount);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.RetryHandler", "setRetryCount");
        }
    }

    public String toString() {
        return "RetryHandler{" + super.toString() + "}count:limit=" + this._retryCount + ":" + this._retryLimit;
    }
}

