/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.controller.impl;

import com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl;
import com.ibm.jbatch.container.controller.impl.BatchletStepControllerImpl;
import com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl;
import com.ibm.jbatch.container.controller.impl.DecisionControllerImpl;
import com.ibm.jbatch.container.controller.impl.FlowControllerImpl;
import com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl;
import com.ibm.jbatch.container.controller.impl.SplitControllerImpl;
import com.ibm.jbatch.container.execution.impl.RuntimeWorkUnitExecution;
import com.ibm.jbatch.container.ws.PartitionReplyQueue;
import com.ibm.jbatch.jsl.model.Batchlet;
import com.ibm.jbatch.jsl.model.Chunk;
import com.ibm.jbatch.jsl.model.Decision;
import com.ibm.jbatch.jsl.model.Flow;
import com.ibm.jbatch.jsl.model.Partition;
import com.ibm.jbatch.jsl.model.Split;
import com.ibm.jbatch.jsl.model.Step;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class ExecutionElementControllerFactory {
    private static final String CLASSNAME = ExecutionElementControllerFactory.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    static final long serialVersionUID = 9159655037739914440L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ExecutionElementControllerFactory() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.ExecutionElementControllerFactory", "<init>", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.ExecutionElementControllerFactory", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static BaseStepControllerImpl getStepController(RuntimeWorkUnitExecution jobExecutionImpl, Step step, long rootJobExecutionId, PartitionReplyQueue partitionReplyQueue) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.ExecutionElementControllerFactory", "getStepController", new Object[]{jobExecutionImpl, step, rootJobExecutionId, partitionReplyQueue});
        }
        String methodName = "getStepController";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASSNAME, methodName, "Get StepController for", step.getId());
        }
        if (step.getPartition() != null && ExecutionElementControllerFactory.isTruePartitionOfTopLevelStep(step)) {
            PartitionedStepControllerImpl partitionedStepControllerImpl = new PartitionedStepControllerImpl(jobExecutionImpl, step);
            if (logger != null && logger.isLoggable(Level.FINER)) {
                partitionedStepControllerImpl = partitionedStepControllerImpl;
                logger.exiting("com.ibm.jbatch.container.controller.impl.ExecutionElementControllerFactory", "getStepController", partitionedStepControllerImpl);
            }
            return partitionedStepControllerImpl;
        }
        Batchlet batchlet = step.getBatchlet();
        if (batchlet != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Found batchlet: " + batchlet + ", with ref= " + batchlet.getRef());
            }
            if (step.getChunk() != null) {
                throw new IllegalArgumentException("Step contains both a batchlet and a chunk.  Aborting.");
            }
            BaseStepControllerImpl baseStepControllerImpl = new BatchletStepControllerImpl(jobExecutionImpl, step).setPartitionReplyQueue(partitionReplyQueue);
            if (logger != null && logger.isLoggable(Level.FINER)) {
                baseStepControllerImpl = baseStepControllerImpl;
                logger.exiting("com.ibm.jbatch.container.controller.impl.ExecutionElementControllerFactory", "getStepController", baseStepControllerImpl);
            }
            return baseStepControllerImpl;
        }
        Chunk chunk = step.getChunk();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Found chunk: " + chunk);
        }
        if (chunk == null) {
            throw new IllegalArgumentException("Step does not contain either a batchlet or a chunk.  Aborting.");
        }
        BaseStepControllerImpl baseStepControllerImpl = new ChunkStepControllerImpl(jobExecutionImpl, step).setPartitionReplyQueue(partitionReplyQueue);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            baseStepControllerImpl = baseStepControllerImpl;
            logger.exiting("com.ibm.jbatch.container.controller.impl.ExecutionElementControllerFactory", "getStepController", baseStepControllerImpl);
        }
        return baseStepControllerImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static DecisionControllerImpl getDecisionController(RuntimeWorkUnitExecution jobExecutionImpl, Decision decision) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.ExecutionElementControllerFactory", "getDecisionController", new Object[]{jobExecutionImpl, decision});
        }
        DecisionControllerImpl decisionControllerImpl = new DecisionControllerImpl(jobExecutionImpl, decision);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            decisionControllerImpl = decisionControllerImpl;
            logger.exiting("com.ibm.jbatch.container.controller.impl.ExecutionElementControllerFactory", "getDecisionController", decisionControllerImpl);
        }
        return decisionControllerImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static FlowControllerImpl getFlowController(RuntimeWorkUnitExecution jobExecutionImpl, Flow flow, long rootJobExecutionId) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.ExecutionElementControllerFactory", "getFlowController", new Object[]{jobExecutionImpl, flow, rootJobExecutionId});
        }
        FlowControllerImpl flowControllerImpl = new FlowControllerImpl(jobExecutionImpl, flow, rootJobExecutionId);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            flowControllerImpl = flowControllerImpl;
            logger.exiting("com.ibm.jbatch.container.controller.impl.ExecutionElementControllerFactory", "getFlowController", flowControllerImpl);
        }
        return flowControllerImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static SplitControllerImpl getSplitController(RuntimeWorkUnitExecution jobExecutionImpl, Split split, long rootJobExecutionId) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.ExecutionElementControllerFactory", "getSplitController", new Object[]{jobExecutionImpl, split, rootJobExecutionId});
        }
        SplitControllerImpl splitControllerImpl = new SplitControllerImpl(jobExecutionImpl, split, rootJobExecutionId);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            splitControllerImpl = splitControllerImpl;
            logger.exiting("com.ibm.jbatch.container.controller.impl.ExecutionElementControllerFactory", "getSplitController", splitControllerImpl);
        }
        return splitControllerImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean isTruePartitionOfTopLevelStep(Step step) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.ExecutionElementControllerFactory", "isTruePartitionOfTopLevelStep", new Object[]{step});
        }
        Partition partition = step.getPartition();
        if (partition.getMapper() != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASSNAME, "validatePartition", "Found partitioned step with mapper", step);
            }
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.jbatch.container.controller.impl.ExecutionElementControllerFactory", "isTruePartitionOfTopLevelStep", bl);
            }
            return bl;
        }
        if (partition.getPlan() != null) {
            if (partition.getPlan().getPartitions() != null) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASSNAME, "validatePartition", "Found partitioned step with plan", step);
                }
                boolean bl = true;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    bl = bl;
                    logger.exiting("com.ibm.jbatch.container.controller.impl.ExecutionElementControllerFactory", "isTruePartitionOfTopLevelStep", bl);
                }
                return bl;
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASSNAME, "validatePartition", "Found plan with partitions stripped out.  Must be a partition on the partition work unit thread", step);
            }
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.jbatch.container.controller.impl.ExecutionElementControllerFactory", "isTruePartitionOfTopLevelStep", bl);
            }
            return bl;
        }
        throw new IllegalArgumentException("Partition does not contain either a mapper or a plan.  Aborting.");
    }
}

