/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.javaee.ddmodel.ejb;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.javaee.dd.ejb.EJBJar;
import com.ibm.ws.javaee.ddmodel.DDParser;
import com.ibm.ws.javaee.ddmodel.ejb.EJBJarType;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class EJBJarDDParser
extends DDParser {
    private final int maxVersion;
    private static final String EJBJAR_DTD_PUBLIC_ID_11 = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN";
    private static final String EJBJAR_DTD_PUBLIC_ID_20 = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN";
    static final long serialVersionUID = 156618768049653709L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public EJBJarDDParser(Container ddRootContainer, Entry ddEntry, int maxVersion) throws DDParser.ParseException {
        super(ddRootContainer, ddEntry);
        this.maxVersion = maxVersion;
    }

    EJBJar parse() throws DDParser.ParseException {
        super.parseRootElement();
        return (EJBJar)this.rootParsable;
    }

    @Override
    protected DDParser.ParsableElement createRootParsable() throws DDParser.ParseException {
        if (!"ejb-jar".equals(this.rootElementLocalName)) {
            throw new DDParser.ParseException(this.invalidRootElement());
        }
        String vers = this.getAttributeValue("", "version");
        if (vers == null) {
            if (this.namespace == null && this.dtdPublicId != null) {
                if (EJBJAR_DTD_PUBLIC_ID_11.equals(this.dtdPublicId)) {
                    this.version = 11;
                    this.eePlatformVersion = 12;
                    return new EJBJarType(this.getDeploymentDescriptorPath());
                }
                if (EJBJAR_DTD_PUBLIC_ID_20.equals(this.dtdPublicId)) {
                    this.version = 20;
                    this.eePlatformVersion = 13;
                    return new EJBJarType(this.getDeploymentDescriptorPath());
                }
            }
            throw new DDParser.ParseException(this.unknownDeploymentDescriptorVersion());
        }
        if ("2.1".equals(vers)) {
            if ("http://java.sun.com/xml/ns/j2ee".equals(this.namespace)) {
                this.version = 21;
                this.eePlatformVersion = 14;
                return new EJBJarType(this.getDeploymentDescriptorPath());
            }
        } else if ("3.0".equals(vers)) {
            if ("http://java.sun.com/xml/ns/javaee".equals(this.namespace)) {
                this.version = 30;
                this.eePlatformVersion = 50;
                return new EJBJarType(this.getDeploymentDescriptorPath());
            }
        } else if ("3.1".equals(vers)) {
            if ("http://java.sun.com/xml/ns/javaee".equals(this.namespace)) {
                this.version = 31;
                this.eePlatformVersion = 60;
                return new EJBJarType(this.getDeploymentDescriptorPath());
            }
        } else if (this.maxVersion >= 32 && "3.2".equals(vers) && "http://xmlns.jcp.org/xml/ns/javaee".equals(this.namespace)) {
            this.version = 32;
            this.eePlatformVersion = 70;
            return new EJBJarType(this.getDeploymentDescriptorPath());
        }
        throw new DDParser.ParseException(this.invalidDeploymentDescriptorNamespace(vers));
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.javaee.ddmodel.ejb.EJBJarDDParser", EJBJarDDParser.class, (String)"ddmodel", (String)"com.ibm.ws.javaee.internal.ddmodel.resources.DDModelMessages");
    }
}

