/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.jwt;

import com.ibm.oauth.core.api.attributes.Attribute;
import com.ibm.oauth.core.api.attributes.AttributeList;
import com.ibm.oauth.core.api.error.OAuthException;
import com.ibm.oauth.core.api.error.oauth20.InvalidGrantException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20Exception;
import com.ibm.oauth.core.api.oauth20.token.OAuth20Token;
import com.ibm.oauth.core.internal.oauth20.OAuth20Util;
import com.ibm.oauth.core.internal.oauth20.granttype.OAuth20GrantTypeHandler;
import com.ibm.oauth.core.internal.oauth20.token.OAuth20TokenFactory;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.oauth20.api.OAuth20Provider;
import com.ibm.ws.security.oauth20.jwt.JwtGrantTypeHandlerConfig;
import com.ibm.ws.security.oauth20.plugins.JwtGrantTypeHandlerFactory;
import com.ibm.ws.security.oauth20.util.BoundedCommonCache;
import com.ibm.ws.security.openidconnect.common.cl.BuildResponseTypeUtil;
import com.ibm.ws.security.openidconnect.common.cl.JWTVerifier;
import com.ibm.ws.security.openidconnect.server.plugins.OIDCProvidersConfig;
import com.ibm.ws.security.openidconnect.token.JWTPayload;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.registry.UserRegistry;
import com.ibm.ws.security.registry.UserRegistryService;
import com.ibm.ws.webcontainer.security.openidconnect.OidcServerConfig;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class GrantTypeCustomizedHandlerJwtImpl
implements OAuth20GrantTypeHandler,
JwtGrantTypeHandlerFactory {
    protected static final TraceComponent tc = Tr.register(GrantTypeCustomizedHandlerJwtImpl.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.oauth20.jwt.resources.JwtServerMessages");
    JwtGrantTypeHandlerConfig _jwtGrantTypeHandlerConfig = null;
    static final ArrayList<String> _emptyList = new ArrayList();
    static final long serialVersionUID = 1398300102670686608L;

    public List<String> getKeysGrantType(@Sensitive AttributeList attributeList) throws OAuthException {
        return _emptyList;
    }

    @FFDCIgnore(value={InvalidGrantException.class})
    public void validateRequestGrantType(@Sensitive AttributeList attributeList, List<OAuth20Token> tokens) throws OAuthException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            List attributes = attributeList.getAllAttributes();
            for (Attribute attribute : attributes) {
                Tr.debug((TraceComponent)tc, (String)("attrib: " + attribute.getName() + " :" + attribute.toString()), (Object[])new Object[0]);
            }
        }
        String clientId = attributeList.getAttributeValueByName("client_id");
        String client_secret = attributeList.getAttributeValueByName("client_secret");
        OidcServerConfig oidcServerConfig = this.getOidcServerConfig(attributeList);
        String tokenString = this.getTokenString(attributeList);
        long lSkewSeconds = this._jwtGrantTypeHandlerConfig.getJwtClockSkew();
        JWTVerifier jwtVerifier = null;
        try {
            jwtVerifier = this.getJwtVerifier(clientId, client_secret, tokenString, lSkewSeconds, oidcServerConfig);
            jwtVerifier.verifySignature();
        }
        catch (InvalidGrantException e) {
            throw e;
        }
        catch (Exception e) {
            Object[] objectArray = new Object[2];
            objectArray[0] = "<sensitive com.ibm.oauth.core.api.attributes.AttributeList>";
            objectArray[1] = tokens;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.oauth20.jwt.GrantTypeCustomizedHandlerJwtImpl", (String)"97", (Object)this, (Object[])objectArray);
            String message = e.getMessage();
            if (message == null || message.isEmpty()) {
                message = e.toString();
            }
            throw new InvalidGrantException(message, (Throwable)e);
        }
        this.verifyJwtContentAndAddAttrib(attributeList, jwtVerifier.getPayload(), clientId, oidcServerConfig, lSkewSeconds);
    }

    public List<OAuth20Token> buildTokensGrantType(AttributeList attributeList, OAuth20TokenFactory tokenFactory, List<OAuth20Token> tokens) {
        ArrayList<OAuth20Token> tokenList = new ArrayList<OAuth20Token>();
        String clientId = attributeList.getAttributeValueByName("client_id");
        String[] redirectUris = attributeList.getAttributeValuesByNameAndType("redirect_uri", "urn:ibm:names:body:param");
        String[] scopes = attributeList.getAttributeValuesByNameAndType("scope", "urn:ibm:names:jwt:param");
        String username = attributeList.getAttributeValueByNameAndType("sub", "urn:ibm:names:jwt:param");
        String stateId = null;
        String redirectUri = redirectUris == null ? null : (redirectUris.length > 0 ? redirectUris[0] : null);
        Map accessTokenMap = tokenFactory.buildTokenMap(clientId, username, redirectUri, stateId, scopes, (OAuth20Token)null, "urn:ietf:params:oauth:grant-type:jwt-bearer");
        OAuth20Util.populateJwtAccessTokenData((AttributeList)attributeList, (Map)accessTokenMap);
        String proxy = attributeList.getAttributeValueByName("X-Forwarded-Host");
        accessTokenMap.put("X-Forwarded-Host", new String[]{proxy});
        OAuth20Token access = tokenFactory.createAccessToken(accessTokenMap);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("access token is " + access), (Object[])new Object[0]);
        }
        if (access != null) {
            tokenList.add(access);
        }
        return tokenList;
    }

    public void buildResponseGrantType(AttributeList attributeList, List<OAuth20Token> tokens) {
        BuildResponseTypeUtil.buildResponseGrantType((AttributeList)attributeList, tokens);
    }

    protected void verifyJwtContentAndAddAttrib(@Sensitive AttributeList attributeList, JWTPayload payload, String clientId, OidcServerConfig oidcServerConfig, long lSkewSeconds) throws OAuthException {
        String issuerIdentifier = attributeList.getAttributeValueByName("issuerIdentifier");
        String[] clientRedirectUris = attributeList.getAttributeValuesByNameAndType("client_redirect_uri", "urn:ibm:names:oauth:param");
        String iss = this.getString(payload.get((Object)"iss"));
        this.verifyJwtIssuer(iss, clientRedirectUris, clientId);
        attributeList.setAttribute("iss", "urn:ibm:names:jwt:param", new String[]{iss});
        String sub = this.getString(payload.get((Object)"sub"));
        this.verifyJwtSub(sub);
        attributeList.setAttribute("sub", "urn:ibm:names:jwt:param", new String[]{sub});
        String[] aud = this.getStrings(payload.get((Object)"aud"));
        String strOidcConfigIssuerIdentifier = null;
        if (oidcServerConfig != null) {
            strOidcConfigIssuerIdentifier = oidcServerConfig.getIssuerIdentifier();
        }
        if (strOidcConfigIssuerIdentifier != null && !strOidcConfigIssuerIdentifier.isEmpty()) {
            this.verifyJwtAudience(aud, strOidcConfigIssuerIdentifier, null);
        } else {
            String strTokenEndpoint = issuerIdentifier + "/token";
            this.verifyJwtAudience(aud, issuerIdentifier, strTokenEndpoint);
        }
        attributeList.setAttribute("aud", "urn:ibm:names:jwt:param", aud);
        Date currentDate = new Date();
        Long exp = this.getLong(payload, "exp");
        this.verifyExpiredTime(exp, currentDate, lSkewSeconds);
        attributeList.setAttribute("exp", "urn:ibm:names:jwt:param", new String[]{exp.toString()});
        Long iat = this.getLong(payload, "iat");
        this.checkIatTime(iat, currentDate, lSkewSeconds);
        Long nbf = this.getLong(payload, "nbf");
        this.checkNotBeforeTime(nbf, currentDate, lSkewSeconds);
        Object jti = payload.get((Object)"jti");
        this.checkJti(jti, iss);
        String[] scopes = attributeList.getAttributeValuesByNameAndType("scope", "urn:ibm:names:oauth:param:request");
        if (scopes != null) {
            attributeList.setAttribute("scope", "urn:ibm:names:jwt:param", scopes);
        }
    }

    protected String convertToString(String[] scopes) {
        StringBuffer st = new StringBuffer("");
        boolean bFirst = true;
        for (String scope : scopes) {
            if (!bFirst) {
                st.append(" ");
            }
            st.append(scope);
            bFirst = false;
        }
        return st.toString();
    }

    protected void checkJti(Object jti, String iss) throws OAuth20Exception {
        String jtiKey;
        if (jti == null) {
            return;
        }
        String strJti = this.getString(jti);
        BoundedCommonCache<String> jtiCache = this._jwtGrantTypeHandlerConfig.getJtiCache();
        if (jtiCache.contains((Object)(jtiKey = iss + " - " + strJti))) {
            Tr.error((TraceComponent)tc, (String)"JWT_TOKEN_DUP_JTI_ERR", (Object[])new Object[]{iss, jti});
            throw new InvalidGrantException(GrantTypeCustomizedHandlerJwtImpl.formatMessage("JWT_TOKEN_DUP_JTI_ERR", iss, strJti), (Throwable)null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("adding jti key: " + jtiKey), (Object[])new Object[0]);
        }
        jtiCache.put((Object)jtiKey);
    }

    protected void checkNotBeforeTime(Long nbfSeconds, Date currentDate, long lSkew) throws OAuth20Exception {
        Date allowDate;
        if (nbfSeconds == null) {
            return;
        }
        long lNbf = nbfSeconds * 1000L;
        Date nbfDate = new Date(lNbf);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("JWT token NBF : " + nbfDate), (Object[])new Object[0]);
        }
        if (nbfDate.after(allowDate = new Date(currentDate.getTime() + lSkew * 1000L))) {
            Tr.error((TraceComponent)tc, (String)"JWT_TOKEN_TOKEN_BEFORE_NBF_ERR", (Object[])new Object[]{allowDate.toString(), nbfDate.toString()});
            throw new InvalidGrantException(GrantTypeCustomizedHandlerJwtImpl.formatMessage("JWT_TOKEN_BEFORE_ERR", nbfDate.toString()), (Throwable)null);
        }
    }

    protected void checkIatTime(Long iatSeconds, Date currentDate, long lSkewSeconds) throws OAuth20Exception {
        Date earlierDate;
        boolean bJwtIatRequired = this._jwtGrantTypeHandlerConfig.isJwtIatRequired();
        if (iatSeconds == null) {
            if (!bJwtIatRequired) {
                return;
            }
            Tr.error((TraceComponent)tc, (String)"JWT_TOKEN_IAT_NEEDED_ERR", (Object[])new Object[0]);
            throw new InvalidGrantException(GrantTypeCustomizedHandlerJwtImpl.formatMessage("JWT_TOKEN_IAT_NEEDED_ERR", new Object[0]), null);
        }
        long lMaxJwtLifetimeSecondAllowed = this._jwtGrantTypeHandlerConfig.getJwtTokenMaxLifetime();
        long lIat = iatSeconds * 1000L;
        Date iatDate = new Date(lIat);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("JWT token iat : " + iatDate), (Object[])new Object[0]);
        }
        if (iatDate.before(earlierDate = new Date(currentDate.getTime() - lMaxJwtLifetimeSecondAllowed * 1000L))) {
            Tr.error((TraceComponent)tc, (String)"JWT_TOKEN_MAX_LIFETIME_ERR", (Object[])new Object[]{iatDate.toString(), lMaxJwtLifetimeSecondAllowed});
            throw new InvalidGrantException(GrantTypeCustomizedHandlerJwtImpl.formatMessage("JWT_TOKEN_MAX_LIFETIME_ERR", iatDate.toString(), lMaxJwtLifetimeSecondAllowed), (Throwable)null);
        }
        Date currentSkewDate = new Date(currentDate.getTime() + lSkewSeconds * 1000L);
        if (iatDate.after(currentSkewDate)) {
            Tr.error((TraceComponent)tc, (String)"JWT_TOKEN_IAT_FUTURE_ERR", (Object[])new Object[]{iatDate.toString(), currentSkewDate.toString()});
            throw new InvalidGrantException(GrantTypeCustomizedHandlerJwtImpl.formatMessage("JWT_TOKEN_FUTURE_TOKEN_ERR", iatDate.toString()), (Throwable)null);
        }
    }

    protected void verifyExpiredTime(Long expSeconds, Date currentDate, long lSkew) throws OAuth20Exception {
        Date allowDate;
        if (expSeconds == null) {
            Tr.error((TraceComponent)tc, (String)"JWT_TOKEN_MISSING_REQUIRED_CLAIM_ERR", (Object[])new Object[]{"exp"});
            throw new InvalidGrantException(GrantTypeCustomizedHandlerJwtImpl.formatMessage("JWT_TOKEN_MISS_REQUIRED_CLAIM_ERR", "exp"), null);
        }
        long lExp = expSeconds * 1000L;
        Date expDate = new Date(lExp);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("JWT token exp: " + expDate + " currentDate:" + currentDate), (Object[])new Object[0]);
        }
        if (expDate.before(allowDate = new Date(currentDate.getTime() - lSkew * 1000L))) {
            Tr.error((TraceComponent)tc, (String)"JWT_TOKEN_EXPIRE_ERR", (Object[])new Object[]{expDate.toString(), allowDate.toString()});
            throw new InvalidGrantException(GrantTypeCustomizedHandlerJwtImpl.formatMessage("JWT_TOKEN_EXPIRED_ERR", expDate.toString()), (Throwable)null);
        }
    }

    protected void verifyJwtSub(String user) throws OAuth20Exception {
        if (user == null) {
            Tr.error((TraceComponent)tc, (String)"JWT_TOKEN_MISSING_REQUIRED_CLAIM_ERR", (Object[])new Object[]{"sub"});
            throw new InvalidGrantException(GrantTypeCustomizedHandlerJwtImpl.formatMessage("JWT_TOKEN_MISS_REQUIRED_CLAIM_ERR", "sub"), null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("JWT token sub : " + user), (Object[])new Object[0]);
        }
        if (!this.isInUserRegistry(user)) {
            Tr.error((TraceComponent)tc, (String)"JWT_TOKEN_SUB_NOT_FOUND_ERR", (Object[])new Object[]{user});
            throw new InvalidGrantException(GrantTypeCustomizedHandlerJwtImpl.formatMessage("JWT_TOKEN_SUB_NOT_FOUND_ERR", user), null);
        }
    }

    protected void verifyJwtIssuer(String strIssuer, String[] redirectUris, String clientId) throws OAuth20Exception {
        if (strIssuer == null) {
            Tr.error((TraceComponent)tc, (String)"JWT_TOKEN_MISSING_REQUIRED_CLAIM_ERR", (Object[])new Object[]{"iss"});
            throw new InvalidGrantException(GrantTypeCustomizedHandlerJwtImpl.formatMessage("JWT_TOKEN_MISS_REQUIRED_CLAIM_ERR", "iss"), null);
        }
        String strRedirectUri = "";
        boolean bOkIssuer = strIssuer.equals(clientId);
        if (!bOkIssuer && redirectUris != null) {
            String[] stringArray = redirectUris;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String redirectUri;
                strRedirectUri = redirectUri = stringArray[i];
                bOkIssuer = strIssuer.equals(redirectUri);
                if (bOkIssuer) break;
            }
        }
        if (!bOkIssuer) {
            if (strRedirectUri == null) {
                strRedirectUri = "NONE";
            }
            Tr.error((TraceComponent)tc, (String)"JWT_TOKEN_INVALID_ISS_ERR", (Object[])new Object[]{strIssuer, strRedirectUri, clientId});
            String msg = GrantTypeCustomizedHandlerJwtImpl.formatMessage("JWT_TOKEN_ISS_MISMATCH_ERR", strIssuer);
            throw new InvalidGrantException(msg, null);
        }
    }

    protected void verifyJwtAudience(String[] audiences, String issuerIdentifier, String strTokenEndpoint) throws OAuth20Exception {
        if (audiences == null) {
            Tr.error((TraceComponent)tc, (String)"JWT_TOKEN_MISSING_REQUIRED_CLAIM_ERR", (Object[])new Object[]{"aud"});
            throw new InvalidGrantException(GrantTypeCustomizedHandlerJwtImpl.formatMessage("JWT_TOKEN_MISS_REQUIRED_CLAIM_ERR", "aud"), null);
        }
        boolean bOk = false;
        String errAudience = null;
        for (String strAudience : audiences) {
            if (!strAudience.equalsIgnoreCase(issuerIdentifier) && !strAudience.equalsIgnoreCase(strTokenEndpoint)) continue;
            bOk = true;
            break;
        }
        if (!bOk) {
            errAudience = this.convertToString(audiences);
            if (strTokenEndpoint != null) {
                Tr.error((TraceComponent)tc, (String)"JWT_TOKEN_INVALID_AUD_ERR", (Object[])new Object[]{errAudience, issuerIdentifier, strTokenEndpoint});
            } else {
                Tr.error((TraceComponent)tc, (String)"JWT_TOKEN_INVALID_AUD_IDENTIFIER_ERR", (Object[])new Object[]{errAudience, issuerIdentifier});
            }
            throw new InvalidGrantException(GrantTypeCustomizedHandlerJwtImpl.formatMessage("JWT_TOKEN_BAD_AUD_ERR", new Object[0]), null);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isInUserRegistry(String user) throws OAuth20Exception {
        boolean isValid = false;
        try {
            SecurityService securityService = this._jwtGrantTypeHandlerConfig.getSecurityService();
            UserRegistryService userRegistryService = securityService.getUserRegistryService();
            UserRegistry userRegistry = userRegistryService.getUserRegistry();
            isValid = userRegistry.isValidUser(user);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("User " + user + " is valid " + isValid), (Object[])new Object[0]);
            }
        }
        catch (RegistryException securityService) {
            void e;
            FFDCFilter.processException((Throwable)securityService, (String)"com.ibm.ws.security.oauth20.jwt.GrantTypeCustomizedHandlerJwtImpl", (String)"465", (Object)this, (Object[])new Object[]{user});
            Tr.error((TraceComponent)tc, (String)"JWT_TOKEN_REGISTRY_EXCEPTION_ERR", (Object[])new Object[]{user, e});
            throw new InvalidGrantException(GrantTypeCustomizedHandlerJwtImpl.formatMessage("JWT_TOKEN_BAD_SUB_EXTERNAL_ERR", user), null);
        }
        return isValid;
    }

    public String getString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof String[]) {
            String[] strings = (String[])obj;
            if (strings.length > 0) {
                return strings[0];
            }
            return null;
        }
        return obj.toString();
    }

    public void setHandlerInfo(String providerId, OAuth20Provider config) {
        this._jwtGrantTypeHandlerConfig = new JwtGrantTypeHandlerConfig(providerId, config);
    }

    public OAuth20GrantTypeHandler getHandlerInstance() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("GrantTypeCustomizedHandlerJwtImpl handler:" + this + " JwtGrantTypeHandlerConfig" + this._jwtGrantTypeHandlerConfig), (Object[])new Object[0]);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    protected Long getLong(JWTPayload payload, String strClaim) throws OAuthException {
        Object objLong = payload.get((Object)strClaim);
        if (objLong == null || objLong instanceof Long) {
            return (Long)objLong;
        }
        if (objLong instanceof Integer) {
            Integer integer1 = (Integer)objLong;
            return (long)integer1;
        }
        Long lResult = null;
        try {
            String strLong = null;
            strLong = objLong instanceof String[] ? ((String[])objLong)[0] : (String)objLong;
            lResult = Long.valueOf(strLong);
        }
        catch (Exception strLong) {
            void e;
            FFDCFilter.processException((Throwable)strLong, (String)"com.ibm.ws.security.oauth20.jwt.GrantTypeCustomizedHandlerJwtImpl", (String)"529", (Object)this, (Object[])new Object[]{payload, strClaim});
            Tr.error((TraceComponent)tc, (String)"JWT_TOKEN_BAD_NUMBER_ERR", (Object[])new Object[]{strClaim, objLong});
            throw new InvalidGrantException(GrantTypeCustomizedHandlerJwtImpl.formatMessage("JWT_TOKEN_BAD_NUMBER_ERR", strClaim, objLong), (Throwable)e);
        }
        return lResult;
    }

    /*
     * WARNING - void declaration
     */
    protected OidcServerConfig getOidcServerConfig(AttributeList attributeList) throws OAuthException {
        OidcServerConfig oidcServerConfig = null;
        String requestType = attributeList.getAttributeValueByName("request_feature");
        if ("oauth2".equals(requestType)) {
            return null;
        }
        try {
            String oauth20ProviderName = this._jwtGrantTypeHandlerConfig.getProviderId();
            oidcServerConfig = OIDCProvidersConfig.getOidcServerConfigForOAuth20Provider((String)oauth20ProviderName);
        }
        catch (Exception oauth20ProviderName) {
            void e;
            FFDCFilter.processException((Throwable)oauth20ProviderName, (String)"com.ibm.ws.security.oauth20.jwt.GrantTypeCustomizedHandlerJwtImpl", (String)"549", (Object)this, (Object[])new Object[]{attributeList});
            Tr.error((TraceComponent)tc, (String)"JWT_TOKEN_UNEXPECTED_EXCEPTION", (Object[])new Object[]{"getOidcServerConfig()", e});
            throw new InvalidGrantException(GrantTypeCustomizedHandlerJwtImpl.formatMessage("JWT_UNEXPECTED_EXCEPTION_ERR", "getOidcServerConfig()", e.getMessage()), null);
        }
        return oidcServerConfig;
    }

    /*
     * WARNING - void declaration
     */
    public JWTVerifier getJwtVerifier(String clientId, String client_secret, String tokenString, long lSkewSeconds, OidcServerConfig oidcServerConfig) throws OAuthException {
        JWTVerifier jwtVerifier = null;
        JWTVerifier tmpJwtVerifier = new JWTVerifier(tokenString);
        String signatureAlgorithm = tmpJwtVerifier.getAlgHeader();
        String jwtSignatureAlgorithm = "HS256";
        if (oidcServerConfig != null) {
            String alg = oidcServerConfig.getSignatureAlgorithm();
            if ("RS256".equals(alg)) {
                jwtSignatureAlgorithm = alg;
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && "none".equals(alg)) {
                Tr.debug((TraceComponent)tc, (String)("The algorithm in openidConnectProvider configuration is : " + alg + " reset it to default value:" + "HS256"), (Object[])new Object[0]);
            }
        } else if ("RS256".equals(signatureAlgorithm)) {
            Tr.error((TraceComponent)tc, (String)"JWT_TOKEN_OAUTH_RS256_NOT_SUPPORTED_ERR", (Object[])new Object[0]);
            throw new InvalidGrantException(GrantTypeCustomizedHandlerJwtImpl.formatMessage("JWT_TOKEN_OAUTH_RS256_NOT_SUPPORTED_ERR", new Object[0]), null);
        }
        if (jwtSignatureAlgorithm.equals("HS256")) {
            jwtVerifier = new JWTVerifier(clientId, (Object)client_secret, jwtSignatureAlgorithm, tokenString, lSkewSeconds);
        } else if (jwtSignatureAlgorithm.equals("RS256")) {
            String alias = tmpJwtVerifier.getIssFromPayload();
            if (alias == null) {
                Tr.error((TraceComponent)tc, (String)"JWT_TOKEN_MISSING_REQUIRED_CLAIM_ERR", (Object[])new Object[]{"iss"});
                throw new InvalidGrantException(GrantTypeCustomizedHandlerJwtImpl.formatMessage("JWT_TOKEN_MISS_REQUIRED_CLAIM_ERR", "iss"), null);
            }
            PublicKey publicKey = null;
            try {
                publicKey = oidcServerConfig.getPublicKey(alias);
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.oauth20.jwt.GrantTypeCustomizedHandlerJwtImpl", (String)"615", (Object)this, (Object[])new Object[]{clientId, client_secret, tokenString, lSkewSeconds, oidcServerConfig});
                Tr.error((TraceComponent)tc, (String)"JWT_TOKEN_NO_PUBLIC_KEY_DETAIL_ERR", (Object[])new Object[]{e, jwtSignatureAlgorithm, oidcServerConfig.getTrustStoreRef(), alias});
                throw new InvalidGrantException(GrantTypeCustomizedHandlerJwtImpl.formatMessage("JWT_TOKEN_NO_PUBLIC_KEY_ERR", jwtSignatureAlgorithm), null);
            }
            if (publicKey != null) {
                jwtVerifier = new JWTVerifier(clientId, (Object)publicKey, jwtSignatureAlgorithm, tokenString, lSkewSeconds);
            }
        }
        if (jwtVerifier == null) {
            Tr.error((TraceComponent)tc, (String)"JWT_UNEXPECTED_ERR", (Object[])new Object[]{"can not get a JWTVerifier to verify the JWT Token. Signature algorithm is " + jwtSignatureAlgorithm});
        }
        return jwtVerifier;
    }

    protected String getTokenString(AttributeList attributeList) throws OAuthException {
        String tokenString = null;
        String[] tokenStrings = attributeList.getAttributeValuesByName("assertion");
        if (tokenStrings == null || tokenStrings.length < 1 || tokenStrings[0].isEmpty()) {
            Tr.error((TraceComponent)tc, (String)"JWT_TOKEN_NO_TOKEN_ERR", (Object[])new Object[0]);
            throw new InvalidGrantException(GrantTypeCustomizedHandlerJwtImpl.formatMessage("JWT_TOKEN_NO_TOKEN_EXTERNAL_ERR", new Object[0]), null);
        }
        if (tokenStrings.length > 1) {
            Tr.error((TraceComponent)tc, (String)"JWT_TOKEN_TOO_MANY_TOKENS_ERR", (Object[])new Object[0]);
            throw new InvalidGrantException(GrantTypeCustomizedHandlerJwtImpl.formatMessage("JWT_TOKEN_TOO_MANY_TOKENS_ERR", new Object[0]), null);
        }
        tokenString = tokenStrings[0];
        return tokenString;
    }

    protected String[] getStrings(Object obj) {
        if (obj == null || obj instanceof String[]) {
            return (String[])obj;
        }
        if (obj instanceof String) {
            return new String[]{(String)obj};
        }
        if (obj instanceof List) {
            List list = (List)obj;
            String[] result = new String[list.size()];
            int iCnt = 0;
            for (Object aObj : list) {
                result[iCnt++] = aObj.toString();
            }
            return result;
        }
        if (obj instanceof Object) {
            return new String[]{obj.toString()};
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Can not convert obj from " + obj.getClass().getName() + " to string[]"), (Object[])new Object[0]);
        }
        return new String[0];
    }

    protected static String formatMessage(String msgKey, Object ... objs) {
        return Tr.formatMessage((TraceComponent)tc, (String)msgKey, (Object[])objs);
    }
}

