/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.reactive.messaging.kafka;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class Batcher<T> {
    private static final TraceComponent tc = Tr.register(Batcher.class, (String)"REACTIVEMESSAGE", (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.resources.ReactiveMessaging");
    private final int maxBatchSize;
    private final Duration maxBatchTime;
    private final ProcessBatchAction<T> processBatchAction;
    private final ScheduledExecutorService executor;
    private boolean closed;
    private List<T> batchList;
    private Future<?> pendingBatchAction;
    static final long serialVersionUID = 576754537990526995L;

    public static <T> BatcherBuilder<T> create(Class<T> type) {
        return new BatcherBuilder();
    }

    private Batcher(int maxBatchSize, Duration maxBatchTime, ProcessBatchAction<T> processBatchAction, ScheduledExecutorService executor) {
        this.maxBatchSize = maxBatchSize;
        this.maxBatchTime = maxBatchTime;
        this.processBatchAction = processBatchAction;
        this.executor = executor;
        this.closed = false;
        this.batchList = new ArrayList<T>();
        this.pendingBatchAction = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToBatch(T item) {
        List<T> completeBatch = null;
        Batcher batcher = this;
        synchronized (batcher) {
            if (this.closed) {
                return;
            }
            this.batchList.add(item);
            if (this.maxBatchSize != -1 && this.batchList.size() >= this.maxBatchSize) {
                completeBatch = this.startNewBatch();
            } else if (this.maxBatchTime != null && this.pendingBatchAction == null) {
                this.pendingBatchAction = this.executor.schedule(this::processBatch, this.maxBatchTime.toNanos(), TimeUnit.NANOSECONDS);
            }
        }
        if (completeBatch != null) {
            this.processBatchAction.processBatch(completeBatch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Batcher batcher = this;
        synchronized (batcher) {
            this.closed = true;
            if (this.pendingBatchAction != null) {
                this.pendingBatchAction.cancel(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<T> startNewBatch() {
        Batcher batcher = this;
        synchronized (batcher) {
            if (!this.batchList.isEmpty()) {
                if (this.pendingBatchAction != null) {
                    this.pendingBatchAction.cancel(false);
                    this.pendingBatchAction = null;
                }
                List<T> oldBatch = this.batchList;
                this.batchList = new ArrayList<T>();
                return oldBatch;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBatch() {
        List<T> oldBatch = null;
        Batcher batcher = this;
        synchronized (batcher) {
            oldBatch = this.startNewBatch();
        }
        if (oldBatch != null) {
            this.processBatchAction.processBatch(oldBatch);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class BatcherBuilder<T> {
        private int maxBatchSize = -1;
        private Duration maxBatchTime;
        private ProcessBatchAction<T> processBatchAction;
        private ScheduledExecutorService executor;
        static final long serialVersionUID = 4550765020788158690L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private BatcherBuilder() {
        }

        public BatcherBuilder<T> withMaxBatchSize(int size) {
            this.maxBatchSize = size;
            return this;
        }

        public BatcherBuilder<T> withMaxBatchTime(Duration duration) {
            this.maxBatchTime = duration;
            return this;
        }

        public BatcherBuilder<T> withProcessBatchAction(ProcessBatchAction<T> processBatchAction) {
            this.processBatchAction = processBatchAction;
            return this;
        }

        public BatcherBuilder<T> withExecutor(ScheduledExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Batcher<T> build() {
            if (this.maxBatchTime != null && this.executor == null) {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"internal.kafka.connector.error.CWMRX1000E", (Object[])new Object[]{"Executor must be set if maxBatchTime is set"});
                throw new IllegalStateException(msg);
            }
            if (this.maxBatchSize == -1 && this.maxBatchTime == null) {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"internal.kafka.connector.error.CWMRX1000E", (Object[])new Object[]{"Either maxBatchSize or maxBatchTime must be set"});
                throw new IllegalStateException(msg);
            }
            if (this.processBatchAction == null) {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"internal.kafka.connector.error.CWMRX1000E", (Object[])new Object[]{"processBatchAction must be set"});
                throw new IllegalStateException(msg);
            }
            return new Batcher(this.maxBatchSize, this.maxBatchTime, this.processBatchAction, this.executor);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.reactive.messaging.kafka.Batcher$BatcherBuilder", BatcherBuilder.class, (String)"REACTIVEMESSAGE", (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.resources.ReactiveMessaging");
        }
    }

    @FunctionalInterface
    public static interface ProcessBatchAction<T> {
        public void processBatch(List<T> var1);
    }
}

