/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.parser;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.openapi.impl.parser.ResolverCache;
import com.ibm.ws.microprofile.openapi.impl.parser.core.models.AuthorizationValue;
import com.ibm.ws.microprofile.openapi.impl.parser.processors.ComponentsProcessor;
import com.ibm.ws.microprofile.openapi.impl.parser.processors.OperationProcessor;
import com.ibm.ws.microprofile.openapi.impl.parser.processors.PathsProcessor;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.List;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpenAPIResolver {
    private final OpenAPI openApi;
    private final ResolverCache cache;
    private final ComponentsProcessor componentsProcessor;
    private final PathsProcessor pathProcessor;
    private final OperationProcessor operationsProcessor;
    private Settings settings = new Settings();
    static final long serialVersionUID = 2886743052040884960L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public OpenAPIResolver(OpenAPI openApi) {
        this(openApi, null, null, null);
    }

    public OpenAPIResolver(OpenAPI openApi, List<AuthorizationValue> auths) {
        this(openApi, auths, null, null);
    }

    public OpenAPIResolver(OpenAPI openApi, List<AuthorizationValue> auths, String parentFileLocation) {
        this(openApi, auths, parentFileLocation, null);
    }

    public OpenAPIResolver(OpenAPI openApi, List<AuthorizationValue> auths, String parentFileLocation, Settings settings) {
        this.openApi = openApi;
        this.settings = settings != null ? settings : new Settings();
        this.cache = new ResolverCache(openApi, auths, parentFileLocation);
        this.componentsProcessor = new ComponentsProcessor(openApi, this.cache);
        this.pathProcessor = new PathsProcessor(this.cache, openApi, this.settings);
        this.operationsProcessor = new OperationProcessor(this.cache, openApi);
    }

    public OpenAPI resolve() {
        if (this.openApi == null) {
            return null;
        }
        this.pathProcessor.processPaths();
        this.componentsProcessor.processComponents();
        if (this.openApi.getPaths() != null) {
            for (String pathname : this.openApi.getPaths().keySet()) {
                PathItem pathItem = (PathItem)this.openApi.getPaths().get((Object)pathname);
                if (pathItem.readOperations() == null) continue;
                for (Operation operation : pathItem.readOperations()) {
                    this.operationsProcessor.processOperation(operation);
                }
            }
        }
        return this.openApi;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.openapi.impl.parser.OpenAPIResolver", OpenAPIResolver.class, (String)"MPOPENAPI", (String)"com.ibm.ws.microprofile.openapi.resources.OpenAPI");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class Settings {
        private boolean addParametersToEachOperation = true;
        static final long serialVersionUID = 3856059197198395762L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public boolean addParametersToEachOperation() {
            return this.addParametersToEachOperation;
        }

        public Settings addParametersToEachOperation(boolean addParametersToEachOperation) {
            this.addParametersToEachOperation = addParametersToEachOperation;
            return this;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.openapi.impl.parser.OpenAPIResolver$Settings", Settings.class, (String)"MPOPENAPI", (String)"com.ibm.ws.microprofile.openapi.resources.OpenAPI");
        }
    }
}

