/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.container.service.app.deploy.ApplicationClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.EARApplicationInfo;
import com.ibm.ws.container.service.app.deploy.WebModuleInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.openapi.AnnotationScanner;
import com.ibm.ws.microprofile.openapi.ConfigProcessor;
import com.ibm.ws.microprofile.openapi.OpenAPIFilter;
import com.ibm.ws.microprofile.openapi.Reader;
import com.ibm.ws.microprofile.openapi.StaticFileProcessor;
import com.ibm.ws.microprofile.openapi.impl.core.util.Json;
import com.ibm.ws.microprofile.openapi.impl.core.util.Yaml;
import com.ibm.ws.microprofile.openapi.impl.model.OpenAPIImpl;
import com.ibm.ws.microprofile.openapi.impl.model.PathsImpl;
import com.ibm.ws.microprofile.openapi.impl.model.info.InfoImpl;
import com.ibm.ws.microprofile.openapi.impl.model.servers.ServerImpl;
import com.ibm.ws.microprofile.openapi.impl.parser.OpenAPIV3Parser;
import com.ibm.ws.microprofile.openapi.impl.parser.core.models.SwaggerParseResult;
import com.ibm.ws.microprofile.openapi.impl.validation.OASValidationResult;
import com.ibm.ws.microprofile.openapi.impl.validation.OASValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidatorUtils;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIUtils;
import com.ibm.ws.microprofile.openapi.utils.ProxySupportUtil;
import com.ibm.ws.microprofile.openapi.utils.ServerInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.util.ThreadContextAccessor;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.http.VirtualHost;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.OASModelReader;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={ApplicationProcessor.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class ApplicationProcessor {
    private static final TraceComponent tc = Tr.register(ApplicationProcessor.class, (String)"MPOPENAPI", (String)"com.ibm.ws.microprofile.openapi.resources.OpenAPI");
    private static final ThreadContextAccessor THREAD_CONTEXT_ACCESSOR = (ThreadContextAccessor)AccessController.doPrivileged(ThreadContextAccessor.getPrivilegedAction());
    private static ApplicationProcessor instance;
    private OpenAPI document = null;
    private static ApplicationInfo currentApp;
    private static Map<String, ApplicationInfo> applications;
    private final ServerInfo serverInfo = new ServerInfo();
    static final long serialVersionUID = -5180649644803365728L;

    public void activate(ComponentContext cc) {
        instance = this;
        if (currentApp != null) {
            this.document = this.createBaseOpenAPIDocument();
            this.processApplication(currentApp);
        } else {
            this.document = this.createBaseOpenAPIDocument();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApplication(ApplicationInfo appInfo) {
        if (OpenAPIUtils.isEventEnabled(tc)) {
            Tr.event((TraceComponent)tc, (String)("Application Processor: Adding application started: appInfo=" + appInfo), (Object[])new Object[0]);
        }
        OpenAPI openAPI = this.document;
        synchronized (openAPI) {
            if (currentApp == null) {
                this.processApplication(appInfo);
            } else {
                applications.put(appInfo.getName(), appInfo);
            }
        }
        if (OpenAPIUtils.isEventEnabled(tc)) {
            Tr.event((TraceComponent)tc, (String)("Application Processor: Adding application ended: appInfo=" + appInfo), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private OpenAPI processWebModule(Container appContainer, WebModuleInfo moduleInfo) {
        ConfigProcessor configProcessor;
        OpenAPI newDocument;
        block55: {
            boolean validating;
            OASFilter oasFilter;
            ClassLoader appClassloader;
            block53: {
                if (OpenAPIUtils.isEventEnabled(tc)) {
                    Tr.event((TraceComponent)tc, (String)("WebModule: Processing started : deploymentName=" + moduleInfo.getApplicationInfo().getDeploymentName() + " : contextRoot=" + moduleInfo.getContextRoot()), (Object[])new Object[0]);
                }
                appClassloader = moduleInfo.getClassLoader();
                boolean isOASApp = false;
                newDocument = null;
                configProcessor = new ConfigProcessor(appClassloader);
                try {
                    HashSet<String> classNamesToScan;
                    block52: {
                        OASModelReader modelReader;
                        if (OpenAPIUtils.isEventEnabled(tc)) {
                            Tr.event((TraceComponent)tc, (String)("Retrieved configuration values : " + configProcessor), (Object[])new Object[0]);
                        }
                        if ((modelReader = OpenAPIUtils.getOASModelReader(appClassloader, configProcessor.getModelReaderClassName())) != null) {
                            try {
                                OpenAPI model = modelReader.buildModel();
                                if (model != null) {
                                    isOASApp = true;
                                    newDocument = model;
                                    if (OpenAPIUtils.isEventEnabled(tc)) {
                                        Tr.event((TraceComponent)tc, (String)"Content from model reader: ", (Object[])new Object[]{this.getSerializedJsonDocument(newDocument)});
                                    }
                                }
                            }
                            catch (Throwable model) {
                                void e;
                                FFDCFilter.processException((Throwable)model, (String)"com.ibm.ws.microprofile.openapi.ApplicationProcessor", (String)"146", (Object)this, (Object[])new Object[]{appContainer, moduleInfo});
                                if (!OpenAPIUtils.isEventEnabled(tc)) break block52;
                                Tr.event((TraceComponent)tc, (String)("Failed to construct model from the application: " + e.getMessage()), (Object[])new Object[0]);
                            }
                        }
                    }
                    String openAPIStaticFile = StaticFileProcessor.getOpenAPIFile(appContainer);
                    if (OpenAPIUtils.isEventEnabled(tc)) {
                        Tr.event((TraceComponent)tc, (String)"Content from static file: ", (Object[])new Object[]{openAPIStaticFile});
                    }
                    if (openAPIStaticFile != null) {
                        SwaggerParseResult result = new OpenAPIV3Parser().readContents(openAPIStaticFile, newDocument, null, null);
                        if (result.getOpenAPI() != null) {
                            newDocument = result.getOpenAPI();
                            isOASApp = true;
                            if (OpenAPIUtils.isEventEnabled(tc)) {
                                Tr.event((TraceComponent)tc, (String)"Document after merging contents from model reader and static file: ", (Object[])new Object[]{this.getSerializedJsonDocument(newDocument)});
                            }
                        } else {
                            Tr.error((TraceComponent)tc, (String)"OPENAPI_FILE_PARSE_ERROR", (Object[])new Object[]{moduleInfo.getApplicationInfo().getDeploymentName()});
                        }
                    }
                    AnnotationScanner scanner = OpenAPIUtils.creatAnnotationScanner(appClassloader, appContainer);
                    if (!configProcessor.isScanDisabled()) {
                        Object foundClasses;
                        classNamesToScan = new HashSet<String>();
                        if (configProcessor.getClassesToScan() != null) {
                            classNamesToScan.addAll(configProcessor.getClassesToScan());
                        }
                        if (configProcessor.getPackagesToScan() != null) {
                            foundClasses = scanner.getAnnotatedClassesNames();
                            if (OpenAPIUtils.isEventEnabled(tc)) {
                                Tr.event((TraceComponent)tc, (String)"Found annotated classes (packages to scan): ", (Object[])new Object[]{foundClasses});
                            }
                            for (String packageName : configProcessor.getPackagesToScan()) {
                                Iterator iterator = foundClasses.iterator();
                                while (iterator.hasNext()) {
                                    String className = (String)iterator.next();
                                    if (!className.startsWith(packageName)) continue;
                                    classNamesToScan.add(className);
                                }
                            }
                        }
                        if (classNamesToScan.size() == 0 && scanner.anyAnnotatedClasses()) {
                            foundClasses = scanner.getAnnotatedClassesNames();
                            if (OpenAPIUtils.isEventEnabled(tc)) {
                                Tr.event((TraceComponent)tc, (String)"Found annotated classes (any annotated classes): ", (Object[])new Object[]{foundClasses});
                            }
                            classNamesToScan.addAll((Collection<String>)foundClasses);
                        }
                        if (configProcessor.getClassesToExclude() != null) {
                            classNamesToScan.removeAll(configProcessor.getClassesToExclude());
                        }
                        if (configProcessor.getPackagesToExclude() != null) {
                            for (String string : configProcessor.getPackagesToExclude()) {
                                Iterator iterator = classNamesToScan.iterator();
                                while (iterator.hasNext()) {
                                    if (!((String)iterator.next()).startsWith(string)) continue;
                                    iterator.remove();
                                }
                            }
                        }
                        if (classNamesToScan.size() > 0) {
                            isOASApp = true;
                            HashSet classes = new HashSet();
                            if (OpenAPIUtils.isEventEnabled(tc)) {
                                Tr.event((TraceComponent)tc, (String)"Final list of class names to scan: ", (Object[])new Object[]{classNamesToScan});
                            }
                            for (String clazz : classNamesToScan) {
                                try {
                                    classes.add(appClassloader.loadClass(clazz));
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    void e;
                                    FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.microprofile.openapi.ApplicationProcessor", (String)"224", (Object)this, (Object[])new Object[]{appContainer, moduleInfo});
                                    if (!OpenAPIUtils.isEventEnabled(tc)) continue;
                                    Tr.event((TraceComponent)tc, (String)("Failed to load class: " + e.getMessage()), (Object[])new Object[0]);
                                }
                            }
                            Reader reader = new Reader(newDocument);
                            reader.setApplicationPath(scanner.getURLMapping());
                            newDocument = reader.read(classes);
                        }
                    }
                    if (isOASApp) break block53;
                    if (OpenAPIUtils.isEventEnabled(tc)) {
                        Tr.event((TraceComponent)tc, (String)("WebModule: Processing ended : Not an OAS application : deploymentName=" + moduleInfo.getApplicationInfo().getDeploymentName() + " : contextRoot=" + moduleInfo.getContextRoot()), (Object[])new Object[0]);
                    }
                    classNamesToScan = null;
                    configProcessor.close();
                    return classNamesToScan;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.microprofile.openapi.ApplicationProcessor", (String)"129", (Object)this, (Object[])new Object[]{appContainer, moduleInfo});
                    try {
                        configProcessor.close();
                    }
                    catch (Throwable throwable2) {
                        FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.microprofile.openapi.ApplicationProcessor", (String)"129", (Object)this, (Object[])new Object[]{appContainer, moduleInfo});
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            if (newDocument != null) {
                if (OpenAPIUtils.isEventEnabled(tc)) {
                    Tr.event((TraceComponent)tc, (String)"Document before handling servers: ", (Object[])new Object[]{this.getSerializedJsonDocument(newDocument)});
                }
                this.handleServers(newDocument, configProcessor);
            }
            if (OpenAPIUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)"Document before filtering: ", (Object[])new Object[]{this.getSerializedJsonDocument(newDocument)});
            }
            if ((oasFilter = OpenAPIUtils.getOASFilter(appClassloader, configProcessor.getOpenAPIFilterClassName())) != null) {
                OpenAPIFilter filter = new OpenAPIFilter(oasFilter);
                Object object = THREAD_CONTEXT_ACCESSOR.pushContextClassLoaderForUnprivileged(appClassloader);
                try {
                    filter.filter(newDocument);
                    if (OpenAPIUtils.isEventEnabled(tc)) {
                        Tr.event((TraceComponent)tc, (String)"Document after filtering: ", (Object[])new Object[]{this.getSerializedJsonDocument(newDocument)});
                    }
                }
                catch (Throwable clazz) {
                    FFDCFilter.processException((Throwable)clazz, (String)"com.ibm.ws.microprofile.openapi.ApplicationProcessor", (String)"268", (Object)this, (Object[])new Object[]{appContainer, moduleInfo});
                    if (OpenAPIUtils.isEventEnabled(tc)) {
                        void e;
                        Tr.event((TraceComponent)tc, (String)("Failed to call OASFilter: " + e.getMessage()), (Object[])new Object[0]);
                    }
                }
                finally {
                    THREAD_CONTEXT_ACCESSOR.popContextClassLoaderForUnprivileged(object);
                }
            }
            if (newDocument != null && newDocument.getInfo() == null) {
                newDocument.setInfo(new InfoImpl().title("Deployed APIs").version("1.0.0"));
            }
            if (validating = configProcessor.isValidating()) {
                try {
                    if (OpenAPIUtils.isEventEnabled(tc)) {
                        Tr.event((TraceComponent)tc, (String)"Validate document", (Object[])new Object[0]);
                    }
                    this.validateDocument(newDocument);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.microprofile.openapi.ApplicationProcessor", (String)"289", (Object)this, (Object[])new Object[]{appContainer, moduleInfo});
                    if (!OpenAPIUtils.isEventEnabled(tc)) break block55;
                    Tr.event((TraceComponent)tc, (String)("Failed to call OASValidator: " + throwable.getMessage()), (Object[])new Object[0]);
                }
            }
        }
        configProcessor.close();
        if (OpenAPIUtils.isEventEnabled(tc)) {
            Tr.event((TraceComponent)tc, (String)("WebModule: Processing ended : deploymentName=" + moduleInfo.getApplicationInfo().getDeploymentName() + " : contextRoot=" + moduleInfo.getContextRoot()), (Object[])new Object[0]);
        }
        return newDocument;
    }

    @Trivial
    private void validateDocument(OpenAPI document) {
        OASValidator validator = new OASValidator();
        OASValidationResult result = validator.validate(document);
        StringBuilder sbError = new StringBuilder();
        StringBuilder sbWarnings = new StringBuilder();
        if (result.hasEvents()) {
            String warnings;
            result.getEvents().stream().forEach(v -> {
                String message = ValidatorUtils.formatMessage("validationMessage", v.message, v.location);
                if (v.severity == OASValidationResult.ValidationEvent.Severity.ERROR) {
                    sbError.append("\n - " + message);
                } else if (v.severity == OASValidationResult.ValidationEvent.Severity.WARNING) {
                    sbWarnings.append("\n - " + message);
                }
            });
            String errors = sbError.toString();
            if (!errors.isEmpty()) {
                Tr.error((TraceComponent)tc, (String)"OPENAPI_DOCUMENT_VALIDATION_ERROR", (Object[])new Object[]{errors + "\n"});
            }
            if (!(warnings = sbWarnings.toString()).isEmpty()) {
                Tr.warning((TraceComponent)tc, (String)"OPENAPI_DOCUMENT_VALIDATION_WARNING", (Object[])new Object[]{warnings + "\n"});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={UnableToAdaptException.class})
    private void processApplication(ApplicationInfo appInfo) {
        if (OpenAPIUtils.isEventEnabled(tc)) {
            Tr.event((TraceComponent)tc, (String)("Application Processor: Processing application started: appInfo=" + appInfo), (Object[])new Object[0]);
        }
        OpenAPI openAPI = this.document;
        synchronized (openAPI) {
            if (appInfo == null) {
                if (OpenAPIUtils.isEventEnabled(tc)) {
                    Tr.event((TraceComponent)tc, (String)"Application Processor: Processing application ended: appInfo=null", (Object[])new Object[0]);
                }
                return;
            }
            Container appContainer = appInfo.getContainer();
            if (appContainer == null) {
                if (OpenAPIUtils.isEventEnabled(tc)) {
                    Tr.event((TraceComponent)tc, (String)("Application Processor: Processing application ended: appInfo=" + appInfo + ", appContainer=null"), (Object[])new Object[0]);
                }
                return;
            }
            try {
                NonPersistentCache cache = (NonPersistentCache)appContainer.adapt(NonPersistentCache.class);
                ApplicationClassesContainerInfo applicationClassesContainerInfo = (ApplicationClassesContainerInfo)cache.getFromCache(ApplicationClassesContainerInfo.class);
                if (applicationClassesContainerInfo == null) {
                    if (OpenAPIUtils.isEventEnabled(tc)) {
                        Tr.event((TraceComponent)tc, (String)("Application Processor: Processing application ended: appInfo=" + appInfo + ", applicationClassesContainerInfo=null"), (Object[])new Object[0]);
                    }
                    return;
                }
            }
            catch (UnableToAdaptException e) {
                if (OpenAPIUtils.isEventEnabled(tc)) {
                    Tr.event((TraceComponent)tc, (String)("Failed to adapt NonPersistentCache: container=" + appContainer + " : \n" + e.getMessage()), (Object[])new Object[0]);
                }
                return;
            }
            WebModuleInfo moduleInfo = null;
            if (appInfo instanceof EARApplicationInfo) {
                for (Entry entry : appContainer) {
                    try {
                        OpenAPI openAPI2;
                        WebModuleInfo wmi;
                        Container c = (Container)entry.adapt(Container.class);
                        if (c == null || (wmi = OpenAPIUtils.getWebModuleInfo(c)) == null || (openAPI2 = this.processWebModule(c, wmi)) == null) continue;
                        currentApp = appInfo;
                        this.document = openAPI2;
                        this.handleApplicationPath(openAPI2, wmi.getContextRoot());
                        this.handleUserServer(openAPI2);
                        Tr.info((TraceComponent)tc, (String)"OPENAPI_APPLICATION_PROCESSED", (Object[])new Object[]{wmi.getApplicationInfo().getDeploymentName()});
                        break;
                    }
                    catch (UnableToAdaptException e) {
                        if (!OpenAPIUtils.isEventEnabled(tc)) continue;
                        Tr.event((TraceComponent)tc, (String)("Failed to adapt entry: entry=" + entry + " : \n" + e.getMessage()), (Object[])new Object[0]);
                    }
                }
            } else {
                moduleInfo = OpenAPIUtils.getWebModuleInfo(appContainer);
            }
            if (moduleInfo == null) {
                if (OpenAPIUtils.isEventEnabled(tc)) {
                    Tr.event((TraceComponent)tc, (String)("Application Processor: Processing application ended: moduleInfo=null : appInfo=" + appInfo), (Object[])new Object[0]);
                }
                return;
            }
            OpenAPI openAPI3 = this.processWebModule(appContainer, moduleInfo);
            if (openAPI3 != null) {
                currentApp = appInfo;
                this.handleApplicationPath(openAPI3, moduleInfo.getContextRoot());
                this.handleUserServer(openAPI3);
                this.document = openAPI3;
                Tr.info((TraceComponent)tc, (String)"OPENAPI_APPLICATION_PROCESSED", (Object[])new Object[]{moduleInfo.getApplicationInfo().getDeploymentName()});
            }
            if (OpenAPIUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)("Application Processor: Processing application ended: appInfo=" + appInfo), (Object[])new Object[0]);
            }
        }
    }

    @Trivial
    private void handleApplicationPath(OpenAPI openAPI, String contextRoot) {
        Paths paths;
        if (openAPI != null && (paths = openAPI.getPaths()) != null && !paths.isEmpty() && ((String)paths.keySet().iterator().next()).startsWith(contextRoot)) {
            if (OpenAPIUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)("Path already starts with context root: " + contextRoot), (Object[])new Object[0]);
            }
            return;
        }
        if (OpenAPIUtils.isEventEnabled(tc)) {
            Tr.event((TraceComponent)tc, (String)("Add context root: " + contextRoot), (Object[])new Object[0]);
        }
        this.serverInfo.setApplicationPath(contextRoot);
    }

    @Trivial
    private void handleUserServer(OpenAPI openapi) {
        if (openapi != null && openapi.getServers() != null && openapi.getServers().size() > 0) {
            if (OpenAPIUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)"User application specifies server", (Object[])new Object[0]);
            }
            this.serverInfo.setIsUserServer(true);
        }
    }

    @Trivial
    private void handleServers(OpenAPI openapi, ConfigProcessor configProcessor) {
        Set<String> servers = configProcessor.getServers();
        if (servers != null && servers.size() > 0) {
            ArrayList<Server> configServers = new ArrayList<Server>();
            for (String server : servers) {
                configServers.add(new ServerImpl().url(server.trim()));
            }
            if (configServers.size() > 0) {
                openapi.setServers(configServers);
                if (OpenAPIUtils.isEventEnabled(tc)) {
                    Tr.event((TraceComponent)tc, (String)("Set global servers from config: servers=" + servers), (Object[])new Object[0]);
                }
            }
        }
        Map<String, Set<String>> pathServers = configProcessor.getPathsServers();
        Map<String, Set<String>> operationServers = configProcessor.getOperationsServers();
        if ((pathServers == null || pathServers.isEmpty()) && (operationServers == null || operationServers.isEmpty())) {
            if (OpenAPIUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)"Servers for paths/operations were not specified, so return", (Object[])new Object[0]);
            }
            return;
        }
        Paths paths = openapi.getPaths();
        if (paths != null && !paths.isEmpty()) {
            for (String path : paths.keySet()) {
                if (pathServers != null && pathServers.containsKey(path)) {
                    ArrayList<Server> configPathServers = new ArrayList<Server>();
                    for (String server : pathServers.get(path)) {
                        configPathServers.add(new ServerImpl().url(server.trim()));
                    }
                    if (!configPathServers.isEmpty()) {
                        ((PathItem)paths.get((Object)path)).setServers(configPathServers);
                        if (OpenAPIUtils.isEventEnabled(tc)) {
                            Tr.event((TraceComponent)tc, (String)("Set servers from config on path: path=" + path + " : servers=" + pathServers.get(path)), (Object[])new Object[0]);
                        }
                    }
                }
                if (operationServers == null) continue;
                for (Operation operation : ((PathItem)paths.get((Object)path)).readOperations()) {
                    String operationId = operation.getOperationId();
                    if (operationId == null || !operationServers.containsKey(operationId)) continue;
                    ArrayList<Server> configOperationServers = new ArrayList<Server>();
                    for (String server : operationServers.get(operationId)) {
                        configOperationServers.add(new ServerImpl().url(server.trim()));
                    }
                    if (configOperationServers.isEmpty()) continue;
                    operation.setServers(configOperationServers);
                    if (!OpenAPIUtils.isEventEnabled(tc)) continue;
                    Tr.event((TraceComponent)tc, (String)("Set servers from config on operation: operationId=" + operationId + " : path=" + path + " : servers=" + operationServers.get(operationId)), (Object[])new Object[0]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeApplication(ApplicationInfo appInfo) {
        if (OpenAPIUtils.isEventEnabled(tc)) {
            Tr.event((TraceComponent)tc, (String)("Application Processor: Removing application started: appInfo=" + appInfo), (Object[])new Object[0]);
        }
        OpenAPI openAPI = this.document;
        synchronized (openAPI) {
            if (currentApp != null && currentApp.getName().equals(appInfo.getName())) {
                currentApp = null;
                this.serverInfo.setApplicationPath(null);
                this.serverInfo.setIsUserServer(false);
                this.document = this.createBaseOpenAPIDocument();
                Iterator<Map.Entry<String, ApplicationInfo>> iterator = applications.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, ApplicationInfo> entry = iterator.next();
                    this.processApplication(entry.getValue());
                    iterator.remove();
                    if (currentApp == null) continue;
                    break;
                }
            } else {
                applications.remove(appInfo.getName());
            }
        }
        if (OpenAPIUtils.isEventEnabled(tc)) {
            Tr.event((TraceComponent)tc, (String)("Application Processor: Removing application ended: appInfo=" + appInfo), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={JsonProcessingException.class})
    public String getOpenAPIDocument(HttpServletRequest request, DocType docType) {
        String oasResult = null;
        OpenAPI openAPI = this.document;
        synchronized (openAPI) {
            block10: {
                ServerInfo reqServerInfo = null;
                ServerInfo serverInfo = this.serverInfo;
                synchronized (serverInfo) {
                    reqServerInfo = new ServerInfo(this.serverInfo);
                }
                ProxySupportUtil.processRequest(request, reqServerInfo);
                if (OpenAPIUtils.isEventEnabled(tc)) {
                    Tr.event((TraceComponent)tc, (String)("Request server info : " + reqServerInfo), (Object[])new Object[0]);
                }
                reqServerInfo.updateOpenAPIWithServers(this.document);
                try {
                    oasResult = DocType.YAML == docType ? Yaml.mapper().writeValueAsString((Object)this.document) : Json.mapper().writeValueAsString((Object)this.document);
                }
                catch (JsonProcessingException e) {
                    if (!OpenAPIUtils.isEventEnabled(tc)) break block10;
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Failed to serialize OpenAPI docuemnt: " + e.getMessage()), (Object[])new Object[0]);
                }
            }
        }
        if (OpenAPIUtils.isDebugEnabled(tc)) {
            Tr.debug((TraceComponent)tc, (String)("Serialized document=" + oasResult), (Object[])new Object[0]);
        }
        return oasResult;
    }

    @Trivial
    @FFDCIgnore(value={JsonProcessingException.class})
    private String getSerializedJsonDocument(OpenAPI openapi) {
        String oasResult;
        block2: {
            oasResult = null;
            try {
                oasResult = Json.mapper().writeValueAsString((Object)openapi);
            }
            catch (JsonProcessingException e) {
                if (!OpenAPIUtils.isEventEnabled(tc)) break block2;
                Tr.event((Object)this, (TraceComponent)tc, (String)("Failed to serialize OpenAPI docuemnt: " + e.getMessage()), (Object[])new Object[0]);
            }
        }
        return oasResult;
    }

    @Trivial
    private OpenAPI createBaseOpenAPIDocument() {
        OpenAPIImpl openAPI = new OpenAPIImpl();
        openAPI.info(new InfoImpl().title("Deployed APIs").version("1.0.0"));
        openAPI.paths((Paths)new PathsImpl());
        if (OpenAPIUtils.isEventEnabled(tc)) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"Created base OpenAPI document", (Object[])new Object[0]);
        }
        return openAPI;
    }

    @Reference(service=VirtualHost.class, target="(&(enabled=true)(id=default_host)(|(aliases=*)(httpsAlias=*)))", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)
    protected void setVirtualHost(VirtualHost vhost, Map<String, Object> props) {
        this.updateOpenAPIServer(vhost, props);
    }

    protected void updatedVirtualHost(VirtualHost vhost, Map<String, Object> props) {
        this.updateOpenAPIServer(vhost, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOpenAPIServer(VirtualHost vhost, Map<String, Object> props) {
        Object value = props.get("httpsAlias");
        if (value == null) {
            CharSequence[] aliases = (String[])props.get("aliases");
            if (OpenAPIUtils.isDebugEnabled(tc)) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("httpsAlias is null. aliases : " + String.join((CharSequence)", ", aliases)), (Object[])new Object[0]);
            }
            value = Arrays.stream(aliases).filter(a -> !a.endsWith(":-1")).findFirst().orElse(null);
            if (OpenAPIUtils.isDebugEnabled(tc)) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Found non-secure alias: " + value), (Object[])new Object[0]);
            }
        }
        String alias = String.valueOf(value);
        if (OpenAPIUtils.isEventEnabled(tc)) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Received new alias: " + alias), (Object[])new Object[0]);
        }
        ServerInfo serverInfo = this.serverInfo;
        synchronized (serverInfo) {
            this.serverInfo.setHttpPort(vhost.getHttpPort(alias));
            this.serverInfo.setHttpsPort(vhost.getSecureHttpPort(alias));
            this.serverInfo.setHost(vhost.getHostName(alias));
            this.checkVCAPHost(this.serverInfo);
        }
        if (OpenAPIUtils.isEventEnabled(tc)) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Updated server information: " + this.serverInfo), (Object[])new Object[0]);
        }
    }

    @FFDCIgnore(value={Exception.class})
    private void checkVCAPHost(ServerInfo server) {
        block5: {
            String VCAP_APPLICATION = System.getenv("VCAP_APPLICATION");
            if (VCAP_APPLICATION != null) {
                try {
                    JsonNode node = (JsonNode)Json.mapper().readValue(VCAP_APPLICATION, JsonNode.class);
                    ArrayNode uris = (ArrayNode)node.get("uris");
                    if (uris != null && uris.size() > 0 && uris.get(0) != null) {
                        server.setHost(uris.get(0).textValue());
                        if (OpenAPIUtils.isEventEnabled(tc)) {
                            Tr.event((Object)this, (TraceComponent)tc, (String)("Changed hostPort using VCAP_APPLICATION.  New value: " + server.getHost()), (Object[])new Object[0]);
                        }
                    }
                }
                catch (Exception e) {
                    if (!OpenAPIUtils.isEventEnabled(tc)) break block5;
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Exception while parsing VCAP_APPLICATION env: " + e.getMessage()), (Object[])new Object[0]);
                }
            }
        }
    }

    public static ApplicationProcessor getInstance() {
        return instance;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        currentApp = null;
        applications = new HashMap<String, ApplicationInfo>();
    }

    static enum DocType {
        JSON,
        YAML;

    }
}

