/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.util;

import com.ibm.oauth.core.internal.OAuthUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.Serializable;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class Nonce
implements Serializable {
    private static TraceComponent tc = Tr.register(Nonce.class, null, null);
    private static final long serialVersionUID = -8717898447122773693L;
    private static long dftLifetime = 300000L;
    private String nonceValue;
    private long generated;
    private long lifetime;

    private Nonce(String nonceValue, long generated, long lifetime) {
        this.nonceValue = nonceValue;
        this.generated = generated;
        this.lifetime = lifetime * 1000000L;
    }

    public boolean isValid(String nonceValue) {
        long currentTime = System.nanoTime();
        if (!this.nonceValue.equals(nonceValue)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"secrets not equal", (Object[])new Object[]{this.nonceValue, nonceValue});
            }
            return false;
        }
        if (currentTime - this.generated >= this.lifetime) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"nonce expired", (Object[])new Object[]{currentTime, this.generated, this.lifetime});
            }
            return false;
        }
        if (currentTime - this.generated < 0L) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"current time < generation time", (Object[])new Object[]{currentTime, this.generated, this.lifetime});
            }
            return false;
        }
        return true;
    }

    public boolean isExpired() {
        return System.nanoTime() - this.generated >= this.lifetime;
    }

    public static Nonce getInstance(long lifetime) {
        return new Nonce(OAuthUtil.getRandom(16), System.nanoTime(), lifetime);
    }

    public static Nonce getInstance() {
        return Nonce.getInstance(dftLifetime);
    }

    public String getValue() {
        return this.nonceValue;
    }

    public String toString() {
        return this.nonceValue;
    }
}

